/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.ex;

import com.maddyhome.idea.vim.ui.ex.ExEditorKit;
import com.maddyhome.idea.vim.ui.ex.ExFakePromptView;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExTextFieldUI;", "Ljavax/swing/plaf/basic/BasicTextFieldUI;", "editorKit", "Lcom/maddyhome/idea/vim/ui/ex/ExEditorKit;", "<init>", "(Lcom/maddyhome/idea/vim/ui/ex/ExEditorKit;)V", "getEditorKit", "tc", "Ljavax/swing/text/JTextComponent;", "installKeyboardActions", "", "setPromptCharacter", "promptCharacter", "", "clearPromptCharacter", "getParagraphView", "Ljavax/swing/text/View;", "IdeaVIM"})
public final class ExTextFieldUI
extends BasicTextFieldUI {
    @NotNull
    private final ExEditorKit editorKit;

    public ExTextFieldUI(@NotNull ExEditorKit editorKit) {
        Intrinsics.checkNotNullParameter((Object)editorKit, (String)"editorKit");
        this.editorKit = editorKit;
    }

    @Override
    @NotNull
    public ExEditorKit getEditorKit(@Nullable JTextComponent tc) {
        return this.editorKit;
    }

    @Override
    protected void installKeyboardActions() {
        this.getComponent().setKeymap(JTextComponent.getKeymap("default"));
    }

    public final void setPromptCharacter(char promptCharacter) {
        this.clearPromptCharacter();
        View paragraphView = this.getParagraphView();
        int caretOffset = this.getComponent().getCaret().getDot();
        int childViewIndex = paragraphView.getViewIndex(caretOffset, Position.Bias.Forward);
        View view = paragraphView.getView(childViewIndex);
        if (view == null) {
            return;
        }
        View childView = view;
        Element element = childView.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getElement(...)");
        ExFakePromptView promptView = new ExFakePromptView(promptCharacter, element, caretOffset);
        if (childView.getStartOffset() == caretOffset) {
            paragraphView.insert(childViewIndex, promptView);
        } else if (childView.getEndOffset() - 1 == caretOffset) {
            paragraphView.insert(childViewIndex + 1, promptView);
        } else {
            View pre = childView.createFragment(childView.getStartOffset(), caretOffset);
            View post = childView.createFragment(caretOffset, childView.getEndOffset());
            View[] viewArray = new View[]{pre, promptView, post};
            paragraphView.replace(childViewIndex, 1, viewArray);
        }
        paragraphView.preferenceChanged(paragraphView, true, false);
        this.getComponent().repaint();
    }

    public final void clearPromptCharacter() {
        View paragraphView = this.getParagraphView();
        int n = paragraphView.getViewCount();
        for (int i = 0; i < n; ++i) {
            View childView = paragraphView.getView(i);
            if (!(childView instanceof ExFakePromptView)) continue;
            if (i > 0 && i < paragraphView.getViewCount() - 1 && Intrinsics.areEqual((Object)paragraphView.getView(i - 1).getElement(), (Object)((ExFakePromptView)childView).getElement()) && Intrinsics.areEqual((Object)paragraphView.getView(i + 1).getElement(), (Object)((ExFakePromptView)childView).getElement())) {
                ViewFactory viewFactory = ((ExFakePromptView)childView).getViewFactory();
                View elementView = viewFactory.create(((ExFakePromptView)childView).getElement());
                View[] viewArray = new View[]{elementView};
                paragraphView.replace(i - 1, 3, viewArray);
            } else {
                paragraphView.remove(i);
            }
            paragraphView.preferenceChanged(paragraphView, true, false);
            this.getComponent().repaint();
            break;
        }
    }

    private final View getParagraphView() {
        View rootView = this.getRootView(this.getComponent());
        View sectionView = rootView.getView(0);
        View view = sectionView.getView(0);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getView(...)");
        return view;
    }
}

