/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions.handlers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.system.CpuArch;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.statistic.VimscriptState;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimIntKt;
import com.maddyhome.idea.vim.vimscript.model.functions.BuiltinFunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandlerBase;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/handlers/HasFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/BuiltinFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "<init>", "()V", "supportedFeatures", "", "", "doFunction", "arguments", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase$Arguments;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "Features", "IdeaVIM"})
public final class HasFunctionHandler
extends BuiltinFunctionHandler<VimInt> {
    @NotNull
    private final Set<String> supportedFeatures = Features.INSTANCE.discover();

    public HasFunctionHandler() {
        super(1, Integer.valueOf(2));
    }

    @NotNull
    protected VimInt doFunction(@NotNull FunctionHandlerBase.Arguments arguments, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        String feature = arguments.getString(0).getValue();
        if (Intrinsics.areEqual((Object)feature, (Object)"ide")) {
            VimscriptState.Util.INSTANCE.setIDESpecificConfigurationUsed(true);
        }
        return VimIntKt.asVimInt((boolean)this.supportedFeatures.contains(feature));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/handlers/HasFunctionHandler$Features;", "", "<init>", "()V", "discover", "", "", "collectOperatingSystemType", "", "result", "", "IdeaVIM"})
    private static final class Features {
        @NotNull
        public static final Features INSTANCE = new Features();

        private Features() {
        }

        @NotNull
        public final Set<String> discover() {
            Object[] objectArray = new String[]{"ide"};
            Set result = SetsKt.mutableSetOf((Object[])objectArray);
            this.collectOperatingSystemType(result);
            return result;
        }

        private final void collectOperatingSystemType(Set<String> result) {
            if (SystemInfoRt.isWindows) {
                result.add("win32");
                if (CpuArch.CURRENT.width == 64) {
                    result.add("win64");
                }
            } else if (SystemInfoRt.isLinux) {
                result.add("linux");
            } else if (SystemInfoRt.isMac) {
                result.add("mac");
                result.add("macunix");
                result.add("osx");
                result.add("osxdarwin");
            } else if (SystemInfoRt.isFreeBSD) {
                result.add("bsd");
            }
            if (SystemInfoRt.isUnix) {
                result.add("unix");
            }
        }
    }
}

