/*
 * Copyright 2003-2023 The IdeaVim authors
 *
 * Use of this source code is governed by an MIT-style
 * license that can be found in the LICENSE.txt file or at
 * https://opensource.org/licenses/MIT.
 */

package com.maddyhome.idea.vim.vimscript.model.expressions.operators.handlers.binary

import com.maddyhome.idea.vim.api.globalOptions
import com.maddyhome.idea.vim.api.injector
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType

internal abstract class BinaryOperatorHandler {
  abstract fun performOperation(left: VimDataType, right: VimDataType): VimDataType
}

internal abstract class BinaryOperatorWithIgnoreCaseOption(private val ignoreCase: Boolean?) : BinaryOperatorHandler() {
  final override fun performOperation(left: VimDataType, right: VimDataType): VimDataType {
    val shouldIgnoreCase = ignoreCase ?: injector.globalOptions().ignorecase
    return performOperation(left, right, shouldIgnoreCase)
  }

  abstract fun performOperation(left: VimDataType, right: VimDataType, ignoreCase: Boolean): VimDataType
}
