/*
 * Copyright 2003-2024 The IdeaVim authors
 *
 * Use of this source code is governed by an MIT-style
 * license that can be found in the LICENSE.txt file or at
 * https://opensource.org/licenses/MIT.
 */

package com.maddyhome.idea.vim.vimscript.model.functions.handlers.stringFunctions

import com.intellij.vim.annotations.VimscriptFunction
import com.maddyhome.idea.vim.api.ExecutionContext
import com.maddyhome.idea.vim.api.VimEditor
import com.maddyhome.idea.vim.api.injector
import com.maddyhome.idea.vim.ex.ExException
import com.maddyhome.idea.vim.vimscript.model.VimLContext
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString
import com.maddyhome.idea.vim.vimscript.model.functions.BuiltinFunctionHandler

@VimscriptFunction(name = "submatch")
internal class SubmatchFunctionHandler : BuiltinFunctionHandler<VimString>(minArity = 1, maxArity = 2) {
  var latestMatch: String = ""

  override fun doFunction(
    arguments: Arguments,
    editor: VimEditor,
    context: ExecutionContext,
    vimContext: VimLContext,
  ): VimString {
    val firstArgValue = arguments.getNumber(0)
    if (firstArgValue.value != 0 || arguments.size > 1) {
      throw ExException("Sorry, only `submatch(0)` is supported :(")
    }
    return VimString(latestMatch)
  }

  companion object {
    fun getInstance(): SubmatchFunctionHandler {
      return injector.functionService.getBuiltInFunction("submatch") as SubmatchFunctionHandler
    }
  }
}
