/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.google.common.net.HostAndPort;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.impl.DockerAgentContainerInfo;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.process.PtyBasedProcess;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0002-.B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\bH\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\bH\u0002J\b\u0010$\u001a\u00020\u0018H\u0002J\b\u0010%\u001a\u00020\u0018H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u001eH\u0016J\b\u0010)\u001a\u00020\bH\u0016J\u0018\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/docker/remote/run/runtime/DockerExecProcess;", "Lcom/intellij/remote/RemoteProcess;", "Lcom/intellij/execution/process/PtyBasedProcess;", "applicationRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "dockerHost", "", "myRemoveContainer", "", "<init>", "(Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;Ljava/lang/String;Z)V", "getApplicationRuntime", "()Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "getDockerHost", "()Ljava/lang/String;", "myOutputStream", "Ljava/io/OutputStream;", "Lorg/jetbrains/annotations/NotNull;", "myInputStream", "Ljava/io/InputStream;", "myErrorStream", "myCompleted", "Ljava/util/concurrent/CountDownLatch;", "onTerminalClosed", "", "removeContainerLater", "getOutputStream", "getInputStream", "getErrorStream", "waitFor", "", "exitValue", "destroy", "killProcessTree", "isDisconnected", "retrieveContainerExitCode", "stopContainerLater", "killContainerLater", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "remotePort", "hasPty", "setWindowSize", "columns", "rows", "Factory", "Companion", "intellij.clouds.docker.remoteRun"})
public final class DockerExecProcess
extends RemoteProcess
implements PtyBasedProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteDockerApplicationRuntime applicationRuntime;
    @NotNull
    private final String dockerHost;
    private final boolean myRemoveContainer;
    @NotNull
    private final OutputStream myOutputStream;
    @NotNull
    private final InputStream myInputStream;
    @NotNull
    private final InputStream myErrorStream;
    @NotNull
    private final CountDownLatch myCompleted;
    @NotNull
    private static final Logger LOG;

    public DockerExecProcess(@NotNull RemoteDockerApplicationRuntime applicationRuntime, @NotNull String dockerHost, boolean myRemoveContainer) {
        Intrinsics.checkNotNullParameter((Object)applicationRuntime, (String)"applicationRuntime");
        Intrinsics.checkNotNullParameter((Object)dockerHost, (String)"dockerHost");
        this.applicationRuntime = applicationRuntime;
        this.dockerHost = dockerHost;
        this.myRemoveContainer = myRemoveContainer;
        OutputStream outputStream = this.applicationRuntime.getStdin();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getStdin(...)");
        this.myOutputStream = outputStream;
        InputStream inputStream = this.applicationRuntime.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getStdout(...)");
        this.myInputStream = inputStream;
        InputStream inputStream2 = this.applicationRuntime.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getStderr(...)");
        this.myErrorStream = inputStream2;
        this.myCompleted = new CountDownLatch(1);
        BuildersKt.launch$default((CoroutineScope)this.applicationRuntime.getDockerRuntime().getAgent().getScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DockerExecProcess this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            this.this$0.getApplicationRuntime().wait4terminal();
                        }
                        finally {
                            this.this$0.onTerminalClosed();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final RemoteDockerApplicationRuntime getApplicationRuntime() {
        return this.applicationRuntime;
    }

    @NotNull
    public final String getDockerHost() {
        return this.dockerHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onTerminalClosed() {
        try {
            if (this.retrieveContainerExitCode()) {
                this.removeContainerLater();
            }
        }
        finally {
            this.myCompleted.countDown();
        }
    }

    private final void removeContainerLater() {
        if (this.myRemoveContainer) {
            BuildersKt.launch$default((CoroutineScope)this.applicationRuntime.getDockerRuntime().getAgent().getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DockerExecProcess this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.this$0.getApplicationRuntime().removeContainer();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @NotNull
    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    @NotNull
    public InputStream getInputStream() {
        return this.myInputStream;
    }

    @NotNull
    public InputStream getErrorStream() {
        return this.myErrorStream;
    }

    public int waitFor() throws InterruptedException {
        Object t = this.applicationRuntime.getExitCodePromise().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return ((Number)t).intValue();
    }

    public int exitValue() {
        if (!this.applicationRuntime.getExitCodePromise().isDone()) {
            throw new IllegalThreadStateException();
        }
        Object t = this.applicationRuntime.getExitCodePromise().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return ((Number)t).intValue();
    }

    public void destroy() {
        this.stopContainerLater();
    }

    public boolean killProcessTree() {
        this.killContainerLater();
        return true;
    }

    public boolean isDisconnected() {
        return this.myCompleted.getCount() == 0L;
    }

    private final boolean retrieveContainerExitCode() {
        try {
            Integer exitCode = (Integer)this.applicationRuntime.getExitCodePromise().get();
            if (exitCode < 0) {
                LOG.debug("Failed to retrieve exit code from " + this.applicationRuntime.getContainerId());
            } else if (this.applicationRuntime.inspect().isRunning()) {
                LOG.debug("Container " + this.applicationRuntime.getContainerId() + " has unexpected \"running\" state");
            }
            return exitCode >= 0;
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
            return false;
        }
    }

    private final void stopContainerLater() {
        BuildersKt.launch$default((CoroutineScope)this.applicationRuntime.getDockerRuntime().getAgent().getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DockerExecProcess this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            this.this$0.getApplicationRuntime().executeAgentTask(this.this$0.getApplicationRuntime().getAgentContainer().stopContainer());
                        }
                        catch (ServerRuntimeException e) {
                            DockerExecProcess.access$getLOG$cp().info(e.getMessage());
                        }
                        finally {
                            if (DockerExecProcess.access$getMyRemoveContainer$p(this.this$0)) {
                                this.this$0.getApplicationRuntime().removeContainer();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void killContainerLater() {
        BuildersKt.launch$default((CoroutineScope)this.applicationRuntime.getDockerRuntime().getAgent().getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DockerExecProcess this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            this.this$0.getApplicationRuntime().executeAgentTask(this.this$0.getApplicationRuntime().getAgentContainer().killContainer());
                        }
                        catch (ServerRuntimeException e) {
                            DockerExecProcess.access$getLOG$cp().info(e.getMessage());
                        }
                        finally {
                            if (DockerExecProcess.access$getMyRemoveContainer$p(this.this$0)) {
                                this.this$0.getApplicationRuntime().removeContainer();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return HostAndPort.fromParts((String)this.dockerHost, (int)remotePort);
    }

    public boolean hasPty() {
        Object object = this.applicationRuntime.getAgentContainer();
        return object != null && (object = object.getInfo()) != null ? Intrinsics.areEqual((Object)((DockerAgentContainerInfo)object).isTty(), (Object)true) : false;
    }

    public void setWindowSize(int columns, int rows) {
        this.applicationRuntime.setWindowSize(columns, rows);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$getMyRemoveContainer$p(DockerExecProcess $this) {
        return $this.myRemoveContainer;
    }

    static {
        Logger logger = Logger.getInstance(DockerExecProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/remote/run/runtime/DockerExecProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.clouds.docker.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/remote/run/runtime/DockerExecProcess$Factory;", "", "<init>", "()V", "startProcess", "Lcom/intellij/docker/remote/run/runtime/DockerExecProcess;", "dockerRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "config", "Lcom/intellij/docker/agent/DockerAgentDeploymentConfig;", "startProcessWithRemove", "applicationRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "newProcess", "removeContainer", "", "intellij.clouds.docker.remoteRun"})
    public static final class Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @JvmStatic
        @NotNull
        public static final DockerExecProcess startProcess(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull DockerAgentDeploymentConfig config) throws ServerRuntimeException, RemoteSdkException, IOException {
            Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
            applicationRuntime.startAndAttach();
            Intrinsics.checkNotNull((Object)applicationRuntime);
            return Factory.newProcess(applicationRuntime, false);
        }

        @JvmStatic
        @NotNull
        public static final DockerExecProcess startProcessWithRemove(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull DockerAgentDeploymentConfig config) throws ServerRuntimeException, RemoteSdkException, IOException {
            Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
            Intrinsics.checkNotNull((Object)applicationRuntime);
            return INSTANCE.startProcessWithRemove(applicationRuntime);
        }

        @NotNull
        public final DockerExecProcess startProcessWithRemove(@NotNull RemoteDockerApplicationRuntime applicationRuntime) throws ServerRuntimeException, RemoteSdkException {
            Intrinsics.checkNotNullParameter((Object)applicationRuntime, (String)"applicationRuntime");
            try {
                applicationRuntime.startAndAttach();
                return Factory.newProcess(applicationRuntime, true);
            }
            catch (ServerRuntimeException e) {
                BuildersKt.launch$default((CoroutineScope)applicationRuntime.getDockerRuntime().getAgent().getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(applicationRuntime, null){
                    int label;
                    final /* synthetic */ RemoteDockerApplicationRuntime $applicationRuntime;
                    {
                        this.$applicationRuntime = $applicationRuntime;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.$applicationRuntime.removeContainer();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                throw e;
            }
        }

        @JvmStatic
        @NotNull
        public static final DockerExecProcess newProcess(@NotNull RemoteDockerApplicationRuntime applicationRuntime, boolean removeContainer) throws RemoteSdkException {
            Intrinsics.checkNotNullParameter((Object)applicationRuntime, (String)"applicationRuntime");
            DockerCloudConfiguration account = applicationRuntime.getDockerRuntime().getAccount();
            String dockerHost = DockerUtil.getDockerHost(account);
            Intrinsics.checkNotNull((Object)dockerHost);
            return new DockerExecProcess(applicationRuntime, dockerHost, removeContainer);
        }
    }
}

