/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.codeInspection;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.psi.IgnoreEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0096\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lmobi/hsz/idea/gitignore/codeInspection/IgnoreRelativeEntryFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "entry", "Lmobi/hsz/idea/gitignore/psi/IgnoreEntry;", "<init>", "(Lmobi/hsz/idea/gitignore/psi/IgnoreEntry;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "getFixedPath", "", "path", "getText", "getFamilyName", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nIgnoreRelativeEntryFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreRelativeEntryFix.kt\nmobi/hsz/idea/gitignore/codeInspection/IgnoreRelativeEntryFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class IgnoreRelativeEntryFix
extends LocalQuickFixOnPsiElement {
    public IgnoreRelativeEntryFix(@NotNull IgnoreEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        super((PsiElement)entry);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (startElement instanceof IgnoreEntry && (document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile)) != null) {
            int start = startElement.getStartOffsetInParent();
            String text = startElement.getText();
            Intrinsics.checkNotNull((Object)text);
            String fixed = this.getFixedPath(text);
            document.replaceString(start, start + text.length(), (CharSequence)fixed);
        }
    }

    private final String getFixedPath(String path) {
        String $this$getFixedPath_u24lambda_u240 = path;
        boolean bl = false;
        CharSequence charSequence = $this$getFixedPath_u24lambda_u240;
        Regex regex = new Regex("/");
        String string = "/";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\\\\\\.");
        string = ".";
        String $this$getFixedPath_u24lambda_u241 = regex.replace(charSequence, string);
        boolean bl2 = false;
        try {
            charSequence = new URI(path).normalize().getPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            charSequence = $this$getFixedPath_u24lambda_u241;
        }
        CharSequence $this$getFixedPath_u24lambda_u242 = charSequence;
        boolean bl3 = false;
        Intrinsics.checkNotNull((Object)$this$getFixedPath_u24lambda_u242);
        charSequence = $this$getFixedPath_u24lambda_u242;
        regex = new Regex("/\\.{1,2}/");
        string = "/";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("^\\.{0,2}/");
        string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public String getText() {
        return IgnoreBundle.INSTANCE.message("quick.fix.relative.entry", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return IgnoreBundle.INSTANCE.message("codeInspection.group", new Object[0]);
    }
}

