/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.json;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ml.llm.agents.acp.config.AcpConfiguration;
import com.intellij.ml.llm.agents.acp.config.AcpConfigurationLoader;
import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.json.AcpAgentsDetectionService;
import com.intellij.ml.llm.agents.acp.json.AcpJsonBundle;
import com.intellij.ml.llm.agents.acp.json.AcpJsonEditorNotificationProviderKt;
import com.intellij.ml.llm.agents.acp.json.AcpJsonUtilKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/agents/acp/json/AcpJsonEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadCurrentConfig", "Lcom/intellij/ml/llm/agents/acp/config/AcpConfiguration;", "isAgentRegistered", "", "detected", "Lcom/intellij/ml/llm/agents/acp/json/AcpAgentsDetectionService$DetectedAgent;", "config", "createNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "unregisteredAgents", "", "addAgentsToConfig", "", "agents", "isAgentSuggestionDismissed", "dismissAgentSuggestion", "Companion", "intellij.ml.llm.agents.acp.json"})
@SourceDebugExtension(value={"SMAP\nAcpJsonEditorNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpJsonEditorNotificationProvider.kt\ncom/intellij/ml/llm/agents/acp/json/AcpJsonEditorNotificationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n774#2:197\n865#2,2:198\n1761#2,3:200\n1193#2,2:203\n1267#2,4:205\n*S KotlinDebug\n*F\n+ 1 AcpJsonEditorNotificationProvider.kt\ncom/intellij/ml/llm/agents/acp/json/AcpJsonEditorNotificationProvider\n*L\n53#1:197\n53#1:198,2\n94#1:200,3\n143#1:203,2\n143#1:205,4\n*E\n"})
public final class AcpJsonEditorNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String AGENT_SUGGESTION_DISMISSED_KEY = "acp.json.agent.suggestion.dismissed";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        void $this$filterTo$iv$iv;
        AcpConfiguration acpConfiguration;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!AcpJsonUtilKt.isAcpJsonFile(file)) {
            return null;
        }
        AcpAgentsDetectionService detectionService = AcpAgentsDetectionService.Companion.getInstance();
        List<AcpAgentsDetectionService.DetectedAgent> detectedAgents = detectionService.getDetectedAgents();
        if (detectedAgents.isEmpty()) {
            return null;
        }
        try {
            acpConfiguration = this.loadCurrentConfig();
        }
        catch (Exception exception) {
            return null;
        }
        AcpConfiguration currentConfig = acpConfiguration;
        Iterable $this$filter$iv = detectedAgents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AcpAgentsDetectionService.DetectedAgent detected = (AcpAgentsDetectionService.DetectedAgent)element$iv$iv;
            boolean bl = false;
            if (!(!this.isAgentRegistered(detected, currentConfig))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unregisteredAgents = (List)destination$iv$iv;
        if (unregisteredAgents.isEmpty()) {
            return null;
        }
        if (this.isAgentSuggestionDismissed()) {
            return null;
        }
        return arg_0 -> AcpJsonEditorNotificationProvider.collectNotificationData$lambda$1(this, project, unregisteredAgents, arg_0);
    }

    private final AcpConfiguration loadCurrentConfig() {
        Path configPath = AcpConfigurationLoader.INSTANCE.getConfigFilePath();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(configPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? AcpConfigurationLoader.INSTANCE.loadFromPath(configPath) : new AcpConfiguration(null, MapsKt.emptyMap(), null, 5, null);
    }

    private final boolean isAgentRegistered(AcpAgentsDetectionService.DetectedAgent detected, AcpConfiguration config) {
        boolean bl;
        block3: {
            String executableName = detected.getAgentInfo().getExecutableName();
            String executablePath = ((Object)detected.getExecutablePath().toAbsolutePath()).toString();
            Iterable $this$any$iv = config.getAgentServers().values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AgentServerConfig serverConfig = (AgentServerConfig)element$iv;
                    boolean bl2 = false;
                    String expandedCommand = AcpConfigurationLoader.INSTANCE.expandPath(serverConfig.getCommand());
                    if (!(Intrinsics.areEqual((Object)expandedCommand, (Object)executableName) || Intrinsics.areEqual((Object)expandedCommand, (Object)executablePath))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final EditorNotificationPanel createNotificationPanel(Project project, List<AcpAgentsDetectionService.DetectedAgent> unregisteredAgents) {
        EditorNotificationPanel panel = new EditorNotificationPanel(EditorNotificationPanel.Status.Info);
        String agentNames = CollectionsKt.joinToString$default((Iterable)unregisteredAgents, (CharSequence)", ", null, null, (int)0, null, AcpJsonEditorNotificationProvider::createNotificationPanel$lambda$0, (int)30, null);
        String messageKey = unregisteredAgents.size() == 1 ? "acp.json.agent.detected.single" : "acp.json.agent.detected.multiple";
        Object[] objectArray = new Object[]{agentNames};
        panel.setText(AcpJsonBundle.INSTANCE.message(messageKey, objectArray));
        panel.createActionLabel(AcpJsonBundle.INSTANCE.message("acp.json.agent.add.label", new Object[0]), () -> AcpJsonEditorNotificationProvider.createNotificationPanel$lambda$1(this, project, unregisteredAgents));
        panel.createActionLabel(AcpJsonBundle.INSTANCE.message("acp.json.agent.dismiss.label", new Object[0]), () -> AcpJsonEditorNotificationProvider.createNotificationPanel$lambda$2(this, project));
        return panel;
    }

    /*
     * WARNING - void declaration
     */
    private final void addAgentsToConfig(Project project, List<AcpAgentsDetectionService.DetectedAgent> agents) {
        try {
            void $this$associateTo$iv$iv;
            AcpConfiguration currentConfig = this.loadCurrentConfig();
            Iterable $this$associate$iv = agents;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                AcpAgentsDetectionService.DetectedAgent detected = (AcpAgentsDetectionService.DetectedAgent)element$iv$iv;
                boolean bl = false;
                String string = detected.getAgentInfo().getDisplayName();
                if (string == null) {
                    string = detected.getAgentInfo().getExecutableName();
                }
                String displayName = string;
                Pair pair = TuplesKt.to((Object)displayName, (Object)new AgentServerConfig(((Object)detected.getExecutablePath().toAbsolutePath()).toString(), detected.getAgentInfo().getArgs(), MapsKt.emptyMap(), null, null, null, null, 120, null));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map newAgents = destination$iv$iv;
            AcpConfiguration updatedConfig = AcpConfiguration.copy$default((AcpConfiguration)currentConfig, null, (Map)MapsKt.plus((Map)currentConfig.getAgentServers(), (Map)newAgents), null, (int)5, null);
            AcpConfigurationLoader.INSTANCE.save(updatedConfig);
            AcpJsonEditorNotificationProviderKt.access$getLogger$p().info("Added " + agents.size() + " agent(s) to ACP configuration");
            WriteAction.runAndWait(AcpJsonEditorNotificationProvider::addAgentsToConfig$lambda$1);
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        }
        catch (Exception e) {
            AcpJsonEditorNotificationProviderKt.access$getLogger$p().error("Failed to add agents to ACP configuration", (Throwable)e);
        }
    }

    private final boolean isAgentSuggestionDismissed() {
        return PropertiesComponent.getInstance().getBoolean(AGENT_SUGGESTION_DISMISSED_KEY, false);
    }

    private final void dismissAgentSuggestion(Project project) {
        PropertiesComponent.getInstance().setValue(AGENT_SUGGESTION_DISMISSED_KEY, true);
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$1(AcpJsonEditorNotificationProvider this$0, Project $project, List $unregisteredAgents, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"<unused var>");
        return this$0.createNotificationPanel($project, $unregisteredAgents);
    }

    private static final CharSequence createNotificationPanel$lambda$0(AcpAgentsDetectionService.DetectedAgent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAgentInfo().getExecutableName();
    }

    private static final void createNotificationPanel$lambda$1(AcpJsonEditorNotificationProvider this$0, Project $project, List $unregisteredAgents) {
        this$0.addAgentsToConfig($project, $unregisteredAgents);
    }

    private static final void createNotificationPanel$lambda$2(AcpJsonEditorNotificationProvider this$0, Project $project) {
        this$0.dismissAgentSuggestion($project);
    }

    private static final void addAgentsToConfig$lambda$1() {
        block0: {
            VirtualFile vFile;
            Path configPath = AcpConfigurationLoader.INSTANCE.getConfigFilePath();
            VirtualFile virtualFile = vFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(configPath);
            if (virtualFile == null) break block0;
            virtualFile.refresh(false, false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/acp/json/AcpJsonEditorNotificationProvider$Companion;", "", "<init>", "()V", "AGENT_SUGGESTION_DISMISSED_KEY", "", "intellij.ml.llm.agents.acp.json"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

