/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.json;

import com.intellij.ml.llm.agents.acp.json.AcpJsonBundle;
import com.intellij.ml.llm.agents.acp.json.AcpJsonUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/agents/acp/json/AcpJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "AcpJsonSchemaProvider", "intellij.ml.llm.agents.acp.json"})
public final class AcpJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)new AcpJsonSchemaProvider(project));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/acp/json/AcpJsonSchemaProviderFactory$AcpJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getSchemaFile", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "intellij.ml.llm.agents.acp.json"})
    private static final class AcpJsonSchemaProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project project;

        public AcpJsonSchemaProvider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return AcpJsonUtilKt.isAcpJsonFile(file);
        }

        @NotNull
        public String getName() {
            return AcpJsonBundle.INSTANCE.message("acp.json.schema.name", new Object[0]);
        }

        @Nullable
        public VirtualFile getSchemaFile() {
            return JsonSchemaProviderFactory.getResourceFile(AcpJsonSchemaProviderFactory.class, (String)"/schemas/acp.schema.json");
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }
    }
}

