/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.askai.entryPoint;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.mcpserver.McpCallInfoKt;
import com.intellij.mcpserver.McpToolset;
import com.intellij.mcpserver.annotations.McpDescription;
import com.intellij.mcpserver.annotations.McpTool;
import com.intellij.ml.llm.askai.AskAIAgentHelperForMcp;
import com.intellij.ml.llm.askai.AskAIKoogAgent;
import com.intellij.ml.llm.askai.AskAILoggerKt;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0005H\u0087@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/askai/entryPoint/AskAIMcpToolset;", "Lcom/intellij/mcpserver/McpToolset;", "<init>", "()V", "interactWithIde", "", "request", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.askai"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAskAIMcpToolset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AskAIMcpToolset.kt\ncom/intellij/ml/llm/askai/entryPoint/AskAIMcpToolset\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,41:1\n374#2:42\n*S KotlinDebug\n*F\n+ 1 AskAIMcpToolset.kt\ncom/intellij/ml/llm/askai/entryPoint/AskAIMcpToolset\n*L\n37#1:42\n*E\n"})
public final class AskAIMcpToolset
implements McpToolset {
    public static final int $stable;

    @McpTool(name="interact_with_ide")
    @McpDescription(description="\nThis is the \"AskAI\" tool that spawns a sub-agent that can run IDE actions actions and do configuration changes in the current IDE\n(settings, actions, refactoring, UI operations, etc). It can also disable itself.\n\n## When to Use This Tool\n\nUse this tool ONLY when the user's request is clearly about:\n- IDE settings and preferences (theme, editor config, keymap, etc.)\n- IDE actions and commands (navigate, project-wide refactor, run configurations, etc.)\n- IDE UI operations (open tool windows, manage panels, etc.)\n\nDO NOT use this tool for:\n- Code editing, modification, or generation\n- Reading or analyzing code content (find files, etc)\n- File system operations\n- Project-specific code changes\n\n## Decision Criteria\n\nBefore calling this tool, determine if the request is about the IDE itself or the user's project:\n- If ambiguous, do NOT use this tool\n- If the request mentions IDE-specific features (settings, actions, UI), use this tool\n- If the request is about code or project files, do NOT use this tool\n\n## Request Parameter\n\nPass the user's request as-is, or rephrase it to clearly describe the intended IDE action or setting change.\n\n## Examples\n\n### Example 1: Clear IDE setting request\nUser: \"Change color scheme to light\"\nDecision: Use this tool - clearly an IDE setting\nRequest: \"Change color scheme to light\"\n\n### Example 2: Ambiguous request\nUser: \"Find zoom settings\" (user works on an app with zoom settings)\nDecision: Do NOT use this tool - ambiguous whether IDE or application setting\n\n### Example 3: IDE-specific by context\nUser: \"Find zoom settings\" (user works on a backend service)\nDecision: Use this tool - backend services don't have zoom settings, must be IDE\nRequest: \"Find zoom settings\"\n\n### Example 4: Request about project file (even though it looks like IDE-specific).\nUser: \"Find all files related to zoom settings\" (user works on a backend service)\nDecision: Do NOT use the tool. The request mentions finding files, so this tool is unrelated (even for a backend service).\n\n### Example 5: Conditional decision\nUser: \"Change formatter options to X\"\nDecision:\n- If formatting is controlled by project files (e.g., .editorconfig): Do NOT use this tool\n- If formatting is IDE-managed: Use this tool\nRequest: \"Change formatter options to X\"\n    ")
    @Nullable
    public final Object interactWithIde(@McpDescription(description="Description of the intended action or setting change.") @NotNull String request2, @NotNull Continuation<? super String> $completion) {
        AskAILoggerKt.getLOG().debug("Calling AskAI via MCP tool with arg: " + request2);
        boolean $i$f$currentCoroutineContext = false;
        Project project = McpCallInfoKt.getProject((CoroutineContext)$completion.getContext());
        AskAIKoogAgent agent2 = new AskAIKoogAgent(project, new AskAIAgentHelperForMcp());
        return agent2.calcResult(request2, $completion);
    }
}

