/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.codex.promo;

import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.ml.llm.agents.codex.CodexLLMBundle;
import com.intellij.ml.llm.agents.codex.promo.CodexFreePromoEventKt;
import com.intellij.ml.llm.agents.codex.promo.CodexGotItProvider;
import com.intellij.ml.llm.agents.codex.promo.CodexGotItWithTryItProvider;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionVm;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.ChatModePromoGotItTooltipProvider;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.CurrentChatSessionMode;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.ml.llm.core.chat.ui.chat.notification.ChatNotificationManager;
import com.intellij.ml.llm.core.chat.ui.chat.promoEvents.ChatPromoEventImpl;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/agents/codex/promo/CodexFreePromoEvent;", "Lcom/intellij/ml/llm/core/chat/ui/chat/promoEvents/ChatPromoEventImpl;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "promoSettingsChanged", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "activationChanged", "calcChatMode", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "candidateChatMode", "preferredChatModeWasChanged", "chatMode", "reset", "focusedChatChanged", "chat", "(Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chatModeChanged", "showGotIt", "isForceFreeBadge", "mode", "overrideTooltipDescription", "Companion", "intellij.ml.llm.agents.codex"})
@SourceDebugExtension(value={"SMAP\nCodexFreePromoEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodexFreePromoEvent.kt\ncom/intellij/ml/llm/agents/codex/promo/CodexFreePromoEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n295#2,2:151\n*S KotlinDebug\n*F\n+ 1 CodexFreePromoEvent.kt\ncom/intellij/ml/llm/agents/codex/promo/CodexFreePromoEvent\n*L\n66#1:151,2\n*E\n"})
public final class CodexFreePromoEvent
extends ChatPromoEventImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    public static final String ID = "codex_free_promo";
    @NotNull
    public static final String CODEX_WAS_SET = "codex_free_promo.codex_was_set";
    @NotNull
    public static final String CODEX_CHAT_MODE_ID = "agent_codex";

    public CodexFreePromoEvent() {
        this.id = ID;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CodexFreePromoEventKt.isCodexUsingJbaiSubscription() && RegionSettings.getRegion() != Region.CHINA;
    }

    @Nullable
    public Object promoSettingsChanged(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        ChatSession chatSession = FocusedChatSessionHost.Companion.getInstance(project).getFocusedChatSession();
        if (chatSession == null) {
            return Unit.INSTANCE;
        }
        ChatSession currentChatSession = chatSession;
        this.showGotIt(currentChatSession);
        return Unit.INSTANCE;
    }

    public void activationChanged(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ChatSession chatSession = FocusedChatSessionHost.Companion.getInstance(project).getFocusedChatSession();
        if (this.isFinished() || chatSession == null) {
            return;
        }
        NewChatMode currentChatMode = (NewChatMode)chatSession.getChatMode().getCurrentChatMode().getValue();
        NewChatMode forceMode = this.calcChatMode(chatSession, currentChatMode);
        if (forceMode == null) {
            return;
        }
        CurrentChatSessionMode.setChatMode$default((CurrentChatSessionMode)chatSession.getChatMode(), (NewChatMode)forceMode, (boolean)false, (int)2, null);
    }

    @Nullable
    public NewChatMode calcChatMode(@NotNull ChatSession chatSession, @NotNull NewChatMode candidateChatMode) {
        NewChatMode.Agent codexChatMode;
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
            Intrinsics.checkNotNullParameter((Object)candidateChatMode, (String)"candidateChatMode");
            if (this.isFinished()) {
                return null;
            }
            if (!CodexFreePromoEventKt.isCodexUsingJbaiSubscription()) {
                return null;
            }
            if (Intrinsics.areEqual((Object)candidateChatMode.getId(), (Object)"agent_junie")) {
                CodexFreePromoEventKt.access$getLOG$p().debug("Junie is active + JB Auth");
                return null;
            }
            Iterable $this$firstOrNull$iv = chatSession.getChatMode().getAvailableOptions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NewChatMode it = (NewChatMode)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getId(), (Object)CODEX_CHAT_MODE_ID) && !it.isDisabled())) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        Object var4_9 = v0;
        NewChatMode.Agent agent = codexChatMode = var4_9 instanceof NewChatMode.Agent ? (NewChatMode.Agent)var4_9 : null;
        if (codexChatMode == null) {
            CodexFreePromoEventKt.access$getLOG$p().warn("Codex agent is not available. Available options: " + chatSession.getChatMode().getAvailableOptions());
            return null;
        }
        if (!Intrinsics.areEqual((Object)this.loadEvent(CODEX_WAS_SET), (Object)"true")) {
            AIAssistantChatEventLogger.logChatModeSwitchedToCodexWithPromo((ChatSession)chatSession);
        }
        ChatPromoEventImpl.saveEvent$default((ChatPromoEventImpl)this, (String)CODEX_WAS_SET, (String)"true", null, (int)4, null);
        return (NewChatMode)codexChatMode;
    }

    public void preferredChatModeWasChanged(@NotNull NewChatMode chatMode) {
        Intrinsics.checkNotNullParameter((Object)chatMode, (String)"chatMode");
        if (this.isFinished()) {
            return;
        }
        if (Intrinsics.areEqual((Object)chatMode.getId(), (Object)CODEX_CHAT_MODE_ID)) {
            ChatPromoEventImpl.saveEvent$default((ChatPromoEventImpl)this, (String)CODEX_WAS_SET, (String)"true", null, (int)4, null);
            return;
        }
        this.setFinished();
        AIAssistantChatEventLogger.logUserSwitchedChatModeAfterCodexWithPromo();
    }

    public void reset() {
        super.reset();
        this.saveEvent(CODEX_WAS_SET, "", "");
    }

    @Nullable
    public Object focusedChatChanged(@NotNull ChatSession chat, @NotNull Continuation<? super Unit> $completion) {
        this.showGotIt(chat);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object chatModeChanged(@NotNull ChatSession chatSession, @NotNull Continuation<? super Unit> $completion) {
        this.showGotIt(chatSession);
        return Unit.INSTANCE;
    }

    private final void showGotIt(ChatSession chatSession) {
        if (!CodexFreePromoEventKt.isCodexUsingJbaiSubscription()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((NewChatMode)chatSession.getChatMode().getCurrentChatMode().getValue()).getId(), (Object)CODEX_CHAT_MODE_ID)) {
            ChatNotificationManager.Companion.getInstance(chatSession.getProject()).showChatModeGotIt((ChatSessionVm)chatSession, (ChatModePromoGotItTooltipProvider)new CodexGotItWithTryItProvider());
            return;
        }
        ChatNotificationManager.Companion.getInstance(chatSession.getProject()).showChatModeGotIt((ChatSessionVm)chatSession, (ChatModePromoGotItTooltipProvider)new CodexGotItProvider());
    }

    public boolean isForceFreeBadge(@NotNull Project project, @NotNull NewChatMode mode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        if (!Intrinsics.areEqual((Object)mode.getId(), (Object)CODEX_CHAT_MODE_ID)) {
            return false;
        }
        return CodexFreePromoEventKt.isCodexUsingJbaiSubscription();
    }

    @Nullable
    public String overrideTooltipDescription(@NotNull Project project, @NotNull NewChatMode mode) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        if (!this.isForceFreeBadge(project, mode)) {
            return null;
        }
        StringBuilder $this$overrideTooltipDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$overrideTooltipDescription_u24lambda_u240.append(mode.getDescription());
        $this$overrideTooltipDescription_u24lambda_u240.append('\n');
        $this$overrideTooltipDescription_u24lambda_u240.append(CodexLLMBundle.message("chat.codex.promo.chat.mode.description", new Object[0])).append('\n');
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/codex/promo/CodexFreePromoEvent$Companion;", "", "<init>", "()V", "ID", "", "CODEX_WAS_SET", "CODEX_CHAT_MODE_ID", "intellij.ml.llm.agents.codex"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

