/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.codex.tos;

import com.intellij.ml.llm.agents.codex.CodexRegistrySettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@com.intellij.openapi.components.State(name="CodexTermsOfServiceState", storages={@Storage(value="codexTermsOfServiceState.xml", roamingType=RoamingType.DEFAULT)}, category=SettingsCategory.PLUGINS)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/agents/codex/tos/CodexTermsOfServiceManager;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/ml/llm/agents/codex/tos/CodexTermsOfServiceManager$State;", "<init>", "()V", "areTermsOfServiceAccepted", "", "getOpenAIToSUrl", "", "getJetBrainsAIPlatformToSUrl", "getApacheLicenseTosURL", "getEnterpriseCloudTosUrl", "getEnterpriseOnpremTosUrl", "markTermsOfServiceAccepted", "", "dropTermsOfServiceAccepted", "State", "Companion", "intellij.ml.llm.agents.codex"})
@SourceDebugExtension(value={"SMAP\nCodexTermsOfServiceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodexTermsOfServiceManager.kt\ncom/intellij/ml/llm/agents/codex/tos/CodexTermsOfServiceManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n13#2:67\n*S KotlinDebug\n*F\n+ 1 CodexTermsOfServiceManager.kt\ncom/intellij/ml/llm/agents/codex/tos/CodexTermsOfServiceManager\n*L\n22#1:67\n*E\n"})
public final class CodexTermsOfServiceManager
extends SimplePersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public CodexTermsOfServiceManager() {
        super((BaseState)new State());
    }

    public final boolean areTermsOfServiceAccepted() {
        if (!CodexRegistrySettings.INSTANCE.isCodexAgentEnabled()) {
            return true;
        }
        String openAIToSVersion = CodexRegistrySettings.INSTANCE.getOpenAITermsOfServiceVersion();
        return Intrinsics.areEqual((Object)((State)this.getState()).getAcceptedOpenAITermsOfServiceVersions().get(openAIToSVersion), (Object)true);
    }

    @NotNull
    public final String getOpenAIToSUrl() {
        return CodexRegistrySettings.INSTANCE.getOpenAITermsOfServiceUrl();
    }

    @NotNull
    public final String getJetBrainsAIPlatformToSUrl() {
        return CodexRegistrySettings.INSTANCE.getJetBrainsAITermsOfServiceUrl();
    }

    @NotNull
    public final String getApacheLicenseTosURL() {
        return CodexRegistrySettings.INSTANCE.getApacheLicenseToSUrl();
    }

    @NotNull
    public final String getEnterpriseCloudTosUrl() {
        return CodexRegistrySettings.INSTANCE.getEnterpriseCloudToSUrl();
    }

    @NotNull
    public final String getEnterpriseOnpremTosUrl() {
        return CodexRegistrySettings.INSTANCE.getEnterpriseOnpremToSUrl();
    }

    public final void markTermsOfServiceAccepted() {
        String openAITermsOfServiceVersion = CodexRegistrySettings.INSTANCE.getOpenAITermsOfServiceVersion();
        ((State)this.getState()).getAcceptedOpenAITermsOfServiceVersions().put(openAITermsOfServiceVersion, true);
        logger.info("OpenAI Terms of Service accepted by user for version: " + openAITermsOfServiceVersion);
    }

    public final void dropTermsOfServiceAccepted() {
        ((State)this.getState()).getAcceptedOpenAITermsOfServiceVersions().clear();
        logger.info("OpenAI Terms of Service accepted by user dropped");
    }

    @JvmStatic
    @NotNull
    public static final CodexTermsOfServiceManager getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodexTermsOfServiceManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CodexTermsOfServiceManager.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/codex/tos/CodexTermsOfServiceManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ml/llm/agents/codex/tos/CodexTermsOfServiceManager;", "intellij.ml.llm.agents.codex"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CodexTermsOfServiceManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(CodexTermsOfServiceManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (CodexTermsOfServiceManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003RC\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/agents/codex/tos/CodexTermsOfServiceManager$State;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "<set-?>", "", "", "", "acceptedOpenAITermsOfServiceVersions", "getAcceptedOpenAITermsOfServiceVersions", "()Ljava/util/Map;", "setAcceptedOpenAITermsOfServiceVersions", "(Ljava/util/Map;)V", "acceptedOpenAITermsOfServiceVersions$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.ml.llm.agents.codex"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty acceptedOpenAITermsOfServiceVersions$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

        @OptionTag(value="acceptedOpenAITermsOfServiceVersions")
        @NotNull
        public final Map<String, Boolean> getAcceptedOpenAITermsOfServiceVersions() {
            return (Map)this.acceptedOpenAITermsOfServiceVersions$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setAcceptedOpenAITermsOfServiceVersions(@NotNull Map<String, Boolean> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.acceptedOpenAITermsOfServiceVersions$delegate.setValue((Object)this, $$delegatedProperties[0], map);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "acceptedOpenAITermsOfServiceVersions", "getAcceptedOpenAITermsOfServiceVersions()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

