/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chat.session;

import ai.grazie.utils.json.JSON;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.aui.events.api.FileChange;
import com.intellij.ml.llm.aui.events.api.MessageBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ResultBlockUpdatedEvent;
import com.intellij.ml.llm.chat.history.migration.LegacyHistoryConverter;
import com.intellij.ml.llm.chat.history.migration.LegacyHistoryDetector;
import com.intellij.ml.llm.chat.session.ChatSessionCheckpointEvent;
import com.intellij.ml.llm.chat.session.RollbackService;
import com.intellij.ml.llm.chat.session.SessionHistoryStorage;
import com.intellij.ml.llm.chat.session.SessionHistoryStorageKt;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentId;
import com.intellij.ml.llm.chat.shared.ChatSessionEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionEventId;
import com.intellij.ml.llm.chat.shared.ChatSessionMessageBlockEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionMessageEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionUserPromptEvent;
import com.intellij.ml.llm.core.statistics.fus.AgentChatStatisticCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 82\u00020\u0001:\u000589:;<B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u0006J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00152\u0006\u0010\n\u001a\u00020\u0006J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u0006J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#J\u000e\u0010'\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0015\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u001dJ\u001e\u0010-\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001dJ\u0018\u0010/\u001a\n 1*\u0004\u0018\u000100002\u0006\u00102\u001a\u00020\u0006H\u0002J\u0018\u00103\u001a\n 1*\u0004\u0018\u000100002\u0006\u00102\u001a\u00020\u0006H\u0002J\u0018\u00104\u001a\n 1*\u0004\u0018\u000100002\u0006\u00102\u001a\u00020\u0006H\u0002J\u0018\u00105\u001a\n 1*\u0004\u0018\u000100002\u0006\u00102\u001a\u00020\u0006H\u0002J \u00106\u001a\n 1*\u0004\u0018\u000100002\u0006\u00102\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u001dH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage;", "", "<init>", "()V", "inMemoryHistory", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$AgentEventsHistory;", "recordEvent", "", "sessionId", "event", "Lcom/intellij/ml/llm/chat/shared/ChatSessionMessageEvent;", "recordCheckpoint", "checkpoint", "Lcom/intellij/ml/llm/chat/session/ChatSessionCheckpointEvent;", "getOrCreateHistory", "flush", "flushSafe", "flushEvents", "events", "", "flushCheckpoint", "hasEvents", "", "getEvents", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEvent;", "getCheckpoints", "getLatestAgentState", "", "rollbackResult", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$RollbackData;", "project", "Lcom/intellij/openapi/project/Project;", "eventId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEventAgentId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionAgentId;", "remove", "getLastEventId", "", "(Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;)Ljava/lang/Integer;", "getAgentSessionId", "agentId", "storeAgentSessionId", "agentSessionId", "getEventsFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "chainId", "getCheckpointsFile", "getLastIdFile", "getAgentSessionIdFile", "getSessionFile", "ext", "Companion", "AgentEventsHistory", "PersistanceId", "Rollback", "RollbackData", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nSessionHistoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHistoryStorage.kt\ncom/intellij/ml/llm/chat/session/SessionHistoryStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JSON.kt\nai/grazie/utils/json/JSON\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SessionHistoryStorage.kt\ncom/intellij/ml/llm/chat/session/SessionHistoryStorageKt\n*L\n1#1,410:1\n1#2:411\n28#3:412\n28#3:413\n70#3:433\n70#3:443\n808#4,11:414\n396#5,8:425\n404#5:434\n396#5,8:435\n404#5:444\n*S KotlinDebug\n*F\n+ 1 SessionHistoryStorage.kt\ncom/intellij/ml/llm/chat/session/SessionHistoryStorage\n*L\n87#1:412\n112#1:413\n142#1:433\n153#1:443\n167#1:414,11\n142#1:425,8\n142#1:434\n153#1:435,8\n153#1:444\n*E\n"})
public final class SessionHistoryStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<PersistanceId, AgentEventsHistory> inMemoryHistory = new ConcurrentHashMap();
    @VisibleForTesting
    @Nullable
    private static volatile Path historyDirOverride;

    public final void recordEvent(@NotNull PersistanceId sessionId, @NotNull ChatSessionMessageEvent event) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ChatSessionEventId eventId = event.getId();
        AgentEventsHistory history2 = this.getOrCreateHistory(sessionId);
        Integer index = history2.getEventIdToIndexMap().get(eventId);
        if (index != null) {
            history2.getEvents().set(index, event);
        } else {
            history2.getEvents().add(event);
            history2.getEventIdToIndexMap().put(eventId, history2.getEvents().size() - 1);
        }
    }

    public final void recordCheckpoint(@NotNull PersistanceId sessionId, @NotNull ChatSessionCheckpointEvent checkpoint) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)checkpoint, (String)"checkpoint");
        AgentEventsHistory history2 = this.getOrCreateHistory(sessionId);
        history2.setCheckpoint(checkpoint);
    }

    private final AgentEventsHistory getOrCreateHistory(PersistanceId sessionId) {
        AgentEventsHistory agentEventsHistory = this.inMemoryHistory.computeIfAbsent(sessionId, arg_0 -> SessionHistoryStorage.getOrCreateHistory$lambda$1(SessionHistoryStorage::getOrCreateHistory$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)agentEventsHistory, (String)"computeIfAbsent(...)");
        return agentEventsHistory;
    }

    public final void flush(@NotNull PersistanceId sessionId) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Object object2 = this;
            try {
                SessionHistoryStorage $this$flush_u24lambda_u240 = object2;
                boolean bl = false;
                $this$flush_u24lambda_u240.flushSafe(sessionId);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            SessionHistoryStorageKt.access$getLogger$p().error((Throwable)it);
        }
    }

    private final void flushSafe(PersistanceId sessionId) {
        AgentEventsHistory agentEventsHistory = this.inMemoryHistory.remove(sessionId);
        if (agentEventsHistory == null) {
            return;
        }
        AgentEventsHistory history2 = agentEventsHistory;
        this.flushEvents(sessionId, history2.getEvents());
        this.flushCheckpoint(sessionId, history2.getCheckpoint());
    }

    /*
     * WARNING - void declaration
     */
    private final void flushEvents(PersistanceId sessionId, List<? extends ChatSessionMessageEvent> events) {
        if (CollectionsKt.none((Iterable)events)) {
            return;
        }
        Path file = this.getEventsFile(sessionId);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean needsVersionMarker = !Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        StringBuilder builder = new StringBuilder();
        if (needsVersionMarker) {
            builder.append("AUI_EVENTS_V1").append("\n");
        }
        ChatSessionEventId lastEventId = null;
        for (ChatSessionMessageEvent openOptionArray2 : events) {
            void this_$iv;
            JSON jSON = (JSON)JSON.Default.INSTANCE;
            ChatSessionMessageEvent value$iv = openOptionArray2;
            boolean $i$f$string = false;
            String agentEventJson = this_$iv.string((SerializationStrategy)ChatSessionMessageEvent.Companion.serializer(), (Object)value$iv);
            Base64.Encoder encoder = Base64.getEncoder();
            String string = agentEventJson;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String b64 = encoder.encodeToString(byArray);
            builder.append(b64).append("\n");
            lastEventId = openOptionArray2.getId();
        }
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE};
        Files.writeString(file, (CharSequence)builder, openOptionArray);
        if (lastEventId != null) {
            Path lastIdFile = this.getLastIdFile(sessionId);
            OpenOption[] openOptionArray2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.writeString(lastIdFile, (CharSequence)String.valueOf(lastEventId.getId()), openOptionArray2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void flushCheckpoint(PersistanceId sessionId, ChatSessionCheckpointEvent checkpoint) {
        block1: {
            void this_$iv;
            Path checkpointsFile = this.getCheckpointsFile(sessionId);
            Files.createDirectories(checkpointsFile.getParent(), new FileAttribute[0]);
            ChatSessionCheckpointEvent chatSessionCheckpointEvent = checkpoint;
            if (chatSessionCheckpointEvent == null) break block1;
            ChatSessionCheckpointEvent it = chatSessionCheckpointEvent;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)checkpointsFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean needsVersionMarker = !Files.exists(checkpointsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            StringBuilder builder = new StringBuilder();
            if (needsVersionMarker) {
                builder.append("AUI_EVENTS_V1").append("\n");
            }
            JSON jSON = (JSON)JSON.Default.INSTANCE;
            ChatSessionCheckpointEvent value$iv = it;
            boolean $i$f$string = false;
            OpenOption[] checkpointEventJson = this_$iv.string((SerializationStrategy)ChatSessionCheckpointEvent.Companion.serializer(), (Object)value$iv);
            Base64.Encoder encoder = Base64.getEncoder();
            OpenOption[] openOptionArray = checkpointEventJson;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = openOptionArray.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String b64 = encoder.encodeToString(byArray);
            builder.append(b64).append("\n");
            openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE};
            Files.writeString(checkpointsFile, (CharSequence)builder, openOptionArray);
        }
    }

    public final boolean hasEvents(@NotNull PersistanceId sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        AgentEventsHistory history2 = this.inMemoryHistory.get(sessionId);
        if (history2 != null && CollectionsKt.any((Iterable)history2.getEvents())) {
            return true;
        }
        Path file = this.getEventsFile(sessionId);
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    @NotNull
    public final List<ChatSessionEvent> getEvents(@NotNull PersistanceId sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Path file = this.getEventsFile(sessionId);
        Intrinsics.checkNotNull((Object)file);
        if (LegacyHistoryDetector.INSTANCE.needsMigration(file)) {
            SessionHistoryStorageKt.access$getLogger$p().info("Migrating legacy history file: " + file);
            if (!LegacyHistoryConverter.INSTANCE.convert(file)) {
                SessionHistoryStorageKt.access$getLogger$p().warn("Failed to migrate legacy history file: " + file);
            }
        }
        List result2 = new ArrayList();
        SessionHistoryStorageKt.access$readBase64JsonFile(file, (arg_0, arg_1, arg_2) -> SessionHistoryStorage.getEvents$lambda$0(result2, arg_0, arg_1, arg_2));
        return result2;
    }

    @NotNull
    public final List<ChatSessionCheckpointEvent> getCheckpoints(@NotNull PersistanceId sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        List result2 = new ArrayList();
        Path path = this.getCheckpointsFile(sessionId);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getCheckpointsFile(...)");
        SessionHistoryStorageKt.access$readBase64JsonFile(path, (arg_0, arg_1, arg_2) -> SessionHistoryStorage.getCheckpoints$lambda$0(result2, arg_0, arg_1, arg_2));
        return result2;
    }

    @Nullable
    public final String getLatestAgentState(@NotNull PersistanceId sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        ChatSessionCheckpointEvent chatSessionCheckpointEvent = (ChatSessionCheckpointEvent)CollectionsKt.lastOrNull(this.getCheckpoints(sessionId));
        return chatSessionCheckpointEvent != null ? chatSessionCheckpointEvent.getState() : null;
    }

    @Nullable
    public final Object rollbackResult(@NotNull Project project, @NotNull PersistanceId sessionId, @NotNull ChatSessionEventId eventId, @NotNull Continuation<? super RollbackData> $completion) {
        return Rollback.INSTANCE.execute(this, project, sessionId, eventId, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ChatSessionAgentId getEventAgentId(@NotNull PersistanceId sessionId, @NotNull ChatSessionEventId eventId) {
        Object v0;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Iterable iterable = this.getEvents(sessionId);
            boolean $i$f$filterIsInstance = false;
            ListIterator listIterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ChatSessionUserPromptEvent)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            listIterator = list2.listIterator(list2.size());
            while (listIterator.hasPrevious()) {
                Object e = listIterator.previous();
                ChatSessionUserPromptEvent it = (ChatSessionUserPromptEvent)e;
                boolean bl = false;
                if (!(it.getId().compareTo(eventId) <= 0)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        ChatSessionUserPromptEvent chatSessionUserPromptEvent = v0;
        return chatSessionUserPromptEvent != null ? chatSessionUserPromptEvent.getAgentId() : null;
    }

    public final void remove(@NotNull PersistanceId sessionId) {
        block15: {
            Object object;
            Object $this$remove_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            this.inMemoryHistory.remove(sessionId);
            Path eventsFile = this.getEventsFile(sessionId);
            Intrinsics.checkNotNull((Object)eventsFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(eventsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Logger logger = SessionHistoryStorageKt.access$getLogger$p();
                try {
                    $this$remove_u24lambda_u240 = logger;
                    boolean bl = false;
                    Files.delete(eventsFile);
                    $this$remove_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$remove_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                logger = $this$remove_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)logger);
                if (throwable != null) {
                    Object it = $this$remove_u24lambda_u240 = throwable;
                    boolean bl = false;
                    SessionHistoryStorageKt.access$getLogger$p().error((Throwable)it);
                }
            }
            Path checkpointsFile = this.getCheckpointsFile(sessionId);
            Intrinsics.checkNotNull((Object)checkpointsFile);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(checkpointsFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Object $this$remove_u24lambda_u242;
                $this$remove_u24lambda_u240 = SessionHistoryStorageKt.access$getLogger$p();
                try {
                    $this$remove_u24lambda_u242 = $this$remove_u24lambda_u240;
                    boolean bl = false;
                    Files.delete(checkpointsFile);
                    $this$remove_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$remove_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                $this$remove_u24lambda_u240 = $this$remove_u24lambda_u242;
                Throwable throwable = Result.exceptionOrNull-impl((Object)$this$remove_u24lambda_u240);
                if (throwable != null) {
                    Object it = $this$remove_u24lambda_u242 = throwable;
                    boolean bl = false;
                    SessionHistoryStorageKt.access$getLogger$p().error((Throwable)it);
                }
            }
            Path lastIdFile = this.getLastIdFile(sessionId);
            Intrinsics.checkNotNull((Object)lastIdFile);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.exists(lastIdFile, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                Object object2;
                Object $this$remove_u24lambda_u242 = SessionHistoryStorageKt.access$getLogger$p();
                try {
                    Logger $this$remove_u24lambda_u244 = $this$remove_u24lambda_u242;
                    boolean bl = false;
                    Files.delete(lastIdFile);
                    object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                $this$remove_u24lambda_u242 = object2;
                Throwable throwable = Result.exceptionOrNull-impl((Object)$this$remove_u24lambda_u242);
                if (throwable != null) {
                    Object it = object2 = throwable;
                    boolean bl = false;
                    SessionHistoryStorageKt.access$getLogger$p().error((Throwable)it);
                }
            }
            Path sessionIdFile = this.getAgentSessionIdFile(sessionId);
            Intrinsics.checkNotNull((Object)sessionIdFile);
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            if (!Files.exists(sessionIdFile, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) break block15;
            Object object3 = SessionHistoryStorageKt.access$getLogger$p();
            try {
                Logger $this$remove_u24lambda_u246 = object3;
                boolean bl = false;
                Files.delete(sessionIdFile);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object3 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                SessionHistoryStorageKt.access$getLogger$p().error((Throwable)it);
            }
        }
    }

    @Nullable
    public final Integer getLastEventId(@NotNull PersistanceId sessionId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Path file = this.getLastIdFile(sessionId);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        Object object2 = this;
        try {
            SessionHistoryStorage $this$getLastEventId_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Files.readString(file, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        String string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (string == null) {
            return null;
        }
        String text2 = string;
        return StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)text2)).toString());
    }

    @Nullable
    public final String getAgentSessionId(@NotNull PersistanceId sessionId, @NotNull String agentId) {
        Object $this$getAgentSessionId_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Path file = this.getAgentSessionIdFile(sessionId);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        Object object = this;
        try {
            $this$getAgentSessionId_u24lambda_u240 = object;
            boolean bl = false;
            $this$getAgentSessionId_u24lambda_u240 = Result.constructor-impl((Object)Files.readString(file, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            $this$getAgentSessionId_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object = $this$getAgentSessionId_u24lambda_u240;
        String string = (String)(Result.isFailure-impl((Object)object) ? null : object);
        if (string == null) {
            return null;
        }
        String content2 = string;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)content2, (char)':', (int)0, (boolean)false, (int)6, null);
        if (separatorIndex == -1) {
            return null;
        }
        String string2 = content2.substring(0, separatorIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String storedAgentId = string2;
        String string3 = content2.substring(separatorIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String storedSessionId = string3;
        return Intrinsics.areEqual((Object)storedAgentId, (Object)agentId) ? storedSessionId : null;
    }

    public final void storeAgentSessionId(@NotNull PersistanceId sessionId, @NotNull String agentId, @NotNull String agentSessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)agentSessionId, (String)"agentSessionId");
        Path file = this.getAgentSessionIdFile(sessionId);
        Logger logger = SessionHistoryStorageKt.access$getLogger$p();
        try {
            Logger $this$storeAgentSessionId_u24lambda_u240 = logger;
            boolean bl = false;
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            Object object = Result.constructor-impl((Object)Files.writeString(file, (CharSequence)(agentId + ":" + agentSessionId), openOptionArray));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final Path getEventsFile(PersistanceId chainId) {
        return this.getSessionFile(chainId, "events");
    }

    private final Path getCheckpointsFile(PersistanceId chainId) {
        return this.getSessionFile(chainId, "checkpoints");
    }

    private final Path getLastIdFile(PersistanceId chainId) {
        return this.getSessionFile(chainId, "lastid");
    }

    private final Path getAgentSessionIdFile(PersistanceId chainId) {
        return this.getSessionFile(chainId, "agentsession");
    }

    private final Path getSessionFile(PersistanceId chainId, String ext) {
        return SessionHistoryStorageKt.getSessionHistoryDirectory().resolve(chainId + "." + ext);
    }

    private static final AgentEventsHistory getOrCreateHistory$lambda$0(PersistanceId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new AgentEventsHistory();
    }

    private static final AgentEventsHistory getOrCreateHistory$lambda$1(Function1 $tmp0, Object p0) {
        return (AgentEventsHistory)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean getEvents$lambda$0(List $result, String line, long l, long l2) {
        block9: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (Intrinsics.areEqual((Object)line, (Object)"AUI_EVENTS_V1")) {
                return true;
            }
            String b64Line$iv = line;
            boolean $i$f$parseBase64Json = false;
            if (((CharSequence)b64Line$iv).length() == 0) {
                object = null;
            } else {
                Object $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22;
                try {
                    boolean $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = false;
                    byte[] byArray = Base64.getDecoder().decode(b64Line$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = Result.constructor-impl((Object)new String(byArray2, charset2));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string = (String)(Result.isFailure-impl((Object)$i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22) ? null : $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22);
                if (string == null) {
                    object = null;
                } else {
                    Object object2;
                    String json$iv = string;
                    try {
                        void this_$iv$iv;
                        boolean bl = false;
                        $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = (JSON)JSON.Default.INSTANCE;
                        String value$iv$iv = json$iv;
                        boolean $i$f$parse = false;
                        object2 = Result.constructor-impl((Object)this_$iv$iv.parse((DeserializationStrategy)ChatSessionEvent.Companion.serializer(), value$iv$iv));
                    }
                    catch (Throwable this_$iv$iv) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this_$iv$iv));
                    }
                    object = Result.isFailure-impl((Object)object2) ? null : object2;
                }
            }
            ChatSessionEvent chatSessionEvent = (ChatSessionEvent)object;
            if (chatSessionEvent == null) break block9;
            ChatSessionEvent it = chatSessionEvent;
            boolean bl = false;
            $result.add(it);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean getCheckpoints$lambda$0(List $result, String line, long l, long l2) {
        block9: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (Intrinsics.areEqual((Object)line, (Object)"AUI_EVENTS_V1")) {
                return true;
            }
            String b64Line$iv = line;
            boolean $i$f$parseBase64Json = false;
            if (((CharSequence)b64Line$iv).length() == 0) {
                object = null;
            } else {
                Object $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22;
                try {
                    boolean $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = false;
                    byte[] byArray = Base64.getDecoder().decode(b64Line$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = Result.constructor-impl((Object)new String(byArray2, charset2));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string = (String)(Result.isFailure-impl((Object)$i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22) ? null : $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22);
                if (string == null) {
                    object = null;
                } else {
                    Object object2;
                    String json$iv = string;
                    try {
                        void this_$iv$iv;
                        boolean bl = false;
                        $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = (JSON)JSON.Default.INSTANCE;
                        String value$iv$iv = json$iv;
                        boolean $i$f$parse = false;
                        object2 = Result.constructor-impl((Object)this_$iv$iv.parse((DeserializationStrategy)ChatSessionCheckpointEvent.Companion.serializer(), value$iv$iv));
                    }
                    catch (Throwable this_$iv$iv) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this_$iv$iv));
                    }
                    object = Result.isFailure-impl((Object)object2) ? null : object2;
                }
            }
            ChatSessionCheckpointEvent chatSessionCheckpointEvent = (ChatSessionCheckpointEvent)object;
            if (chatSessionCheckpointEvent == null) break block9;
            ChatSessionCheckpointEvent it = chatSessionCheckpointEvent;
            boolean bl = false;
            $result.add(it);
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$AgentEventsHistory;", "", "<init>", "()V", "events", "", "Lcom/intellij/ml/llm/chat/shared/ChatSessionMessageEvent;", "getEvents", "()Ljava/util/List;", "eventIdToIndexMap", "", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "", "getEventIdToIndexMap", "()Ljava/util/Map;", "checkpoint", "Lcom/intellij/ml/llm/chat/session/ChatSessionCheckpointEvent;", "getCheckpoint", "()Lcom/intellij/ml/llm/chat/session/ChatSessionCheckpointEvent;", "setCheckpoint", "(Lcom/intellij/ml/llm/chat/session/ChatSessionCheckpointEvent;)V", "intellij.ml.llm.chat"})
    public static final class AgentEventsHistory {
        @NotNull
        private final List<ChatSessionMessageEvent> events = new ArrayList();
        @NotNull
        private final Map<ChatSessionEventId, Integer> eventIdToIndexMap = new LinkedHashMap();
        @Nullable
        private ChatSessionCheckpointEvent checkpoint;

        @NotNull
        public final List<ChatSessionMessageEvent> getEvents() {
            return this.events;
        }

        @NotNull
        public final Map<ChatSessionEventId, Integer> getEventIdToIndexMap() {
            return this.eventIdToIndexMap;
        }

        @Nullable
        public final ChatSessionCheckpointEvent getCheckpoint() {
            return this.checkpoint;
        }

        public final void setCheckpoint(@Nullable ChatSessionCheckpointEvent chatSessionCheckpointEvent) {
            this.checkpoint = chatSessionCheckpointEvent;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R \u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage;", "historyDirOverride", "Ljava/nio/file/Path;", "getHistoryDirOverride", "()Ljava/nio/file/Path;", "setHistoryDirOverride", "(Ljava/nio/file/Path;)V", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nSessionHistoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHistoryStorage.kt\ncom/intellij/ml/llm/chat/session/SessionHistoryStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,410:1\n42#2,3:411\n*S KotlinDebug\n*F\n+ 1 SessionHistoryStorage.kt\ncom/intellij/ml/llm/chat/session/SessionHistoryStorage$Companion\n*L\n29#1:411,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionHistoryStorage getInstance() {
            boolean $i$f$service = false;
            Class<SessionHistoryStorage> serviceClass$iv = SessionHistoryStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (SessionHistoryStorage)object;
        }

        @Nullable
        public final Path getHistoryDirOverride() {
            return historyDirOverride;
        }

        public final void setHistoryDirOverride(@Nullable Path path) {
            historyDirOverride = path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "toString", "component1", "copy", "equals", "", "other", "hashCode", "", "intellij.ml.llm.chat"})
    public static final class PersistanceId {
        @NotNull
        private final String id;

        public PersistanceId(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final PersistanceId copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new PersistanceId(id);
        }

        public static /* synthetic */ PersistanceId copy$default(PersistanceId persistanceId, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = persistanceId.id;
            }
            return persistanceId.copy(string);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PersistanceId)) {
                return false;
            }
            PersistanceId persistanceId = (PersistanceId)other;
            return Intrinsics.areEqual((Object)this.id, (Object)persistanceId.id);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\rH\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$Rollback;", "", "<init>", "()V", "execute", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$RollbackData;", "storage", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage;", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;", "eventId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "(Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRollbackData", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$Rollback$RollbackMetadata;", "getEventsMetadata", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$Rollback$RevertedEventsData;", "rollbackEventId", "getCheckpointTruncateOffset", "", "userPromptId", "truncateFile", "", "file", "Ljava/nio/file/Path;", "offset", "RevertedEventsData", "RollbackMetadata", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nSessionHistoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHistoryStorage.kt\ncom/intellij/ml/llm/chat/session/SessionHistoryStorage$Rollback\n+ 2 SessionHistoryStorage.kt\ncom/intellij/ml/llm/chat/session/SessionHistoryStorageKt\n+ 3 JSON.kt\nai/grazie/utils/json/JSON\n*L\n1#1,410:1\n396#2,8:411\n404#2:420\n396#2,8:421\n404#2:430\n70#3:419\n70#3:429\n*S KotlinDebug\n*F\n+ 1 SessionHistoryStorage.kt\ncom/intellij/ml/llm/chat/session/SessionHistoryStorage$Rollback\n*L\n288#1:411,8\n288#1:420\n331#1:421,8\n331#1:430\n288#1:419\n331#1:429\n*E\n"})
    private static final class Rollback {
        @NotNull
        public static final Rollback INSTANCE = new Rollback();

        private Rollback() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object execute(@NotNull SessionHistoryStorage storage, @NotNull Project project, @NotNull PersistanceId sessionId, @NotNull ChatSessionEventId eventId, @NotNull Continuation<? super RollbackData> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var8_6 = $completion;
            if ((var8_6.label & -2147483648) != 0) {
                var8_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ Rollback this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, null, null, null, (Continuation<? super RollbackData>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    rollback = this.getRollbackData(storage, sessionId, eventId);
                    $continuation.L$0 = storage;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$2 = sessionId;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)eventId);
                    $continuation.L$4 = rollback;
                    $continuation.label = 1;
                    v0 = RollbackService.Companion.getInstance(project).rollback(rollback.getFileChanges(), (Continuation<? super Unit>)$continuation);
                    if (v0 == var9_8) {
                        return var9_8;
                    }
                    ** GOTO lbl31
                }
                case 1: {
                    rollback = (RollbackMetadata)$continuation.L$4;
                    eventId = (ChatSessionEventId)$continuation.L$3;
                    sessionId = (PersistanceId)$continuation.L$2;
                    project = (Project)$continuation.L$1;
                    storage = (SessionHistoryStorage)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    $continuation.L$0 = storage;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$2 = sessionId;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)eventId);
                    $continuation.L$4 = rollback;
                    $continuation.label = 2;
                    v1 = AgentChatStatisticCollector.INSTANCE.logAgentRollback(sessionId, rollback.getTotalPrompts(), rollback.getFileChanges(), rollback.getUserPrompt().getAgentId().getId(), (Continuation<? super Unit>)$continuation);
                    if (v1 == var9_8) {
                        return var9_8;
                    }
                    ** GOTO lbl49
                }
                case 2: {
                    rollback = (RollbackMetadata)$continuation.L$4;
                    eventId = (ChatSessionEventId)$continuation.L$3;
                    sessionId = (PersistanceId)$continuation.L$2;
                    project = (Project)$continuation.L$1;
                    storage = (SessionHistoryStorage)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    v2 = SessionHistoryStorage.access$getEventsFile(storage, sessionId);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"access$getEventsFile(...)");
                    this.truncateFile(v2, rollback.getEventsTruncateOffset());
                    v3 = SessionHistoryStorage.access$getCheckpointsFile(storage, sessionId);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"access$getCheckpointsFile(...)");
                    this.truncateFile(v3, rollback.getCheckpointTruncateOffset());
                    return new RollbackData(rollback.getUserPrompt(), rollback.getFirstEventId(), rollback.getLastEventId());
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final RollbackMetadata getRollbackData(SessionHistoryStorage storage, PersistanceId sessionId, ChatSessionEventId eventId) {
            RevertedEventsData promptData = this.getEventsMetadata(storage, sessionId, eventId);
            return new RollbackMetadata(this.getCheckpointTruncateOffset(storage, sessionId, promptData.getFirstUserPrompt().getId()), promptData.getFirstUserPromptOffset(), promptData.getFirstUserPrompt().getId(), promptData.getLastEventId(), promptData.getFirstUserPrompt(), promptData.getTotalPrompts(), promptData.getFileChanges());
        }

        private final RevertedEventsData getEventsMetadata(SessionHistoryStorage storage, PersistanceId sessionId, ChatSessionEventId rollbackEventId) {
            Ref.ObjectRef firstUserPrompt = new Ref.ObjectRef();
            Ref.ObjectRef firstUserPromptOffset = new Ref.ObjectRef();
            Ref.IntRef totalPromptEvents = new Ref.IntRef();
            List fileChanges = new ArrayList();
            Ref.ObjectRef lastEventId = new Ref.ObjectRef();
            Path path = storage.getEventsFile(sessionId);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"access$getEventsFile(...)");
            SessionHistoryStorageKt.access$readBase64JsonFile(path, (arg_0, arg_1, arg_2) -> Rollback.getEventsMetadata$lambda$0(lastEventId, totalPromptEvents, rollbackEventId, firstUserPrompt, firstUserPromptOffset, fileChanges, arg_0, arg_1, arg_2));
            ChatSessionUserPromptEvent chatSessionUserPromptEvent = (ChatSessionUserPromptEvent)firstUserPrompt.element;
            if (chatSessionUserPromptEvent == null) {
                throw new IllegalStateException("Rollback: no user prompt found after checkpoint");
            }
            Long l = (Long)firstUserPromptOffset.element;
            if (l == null) {
                throw new IllegalStateException("Rollback: no events found after checkpoint");
            }
            ChatSessionEventId chatSessionEventId = (ChatSessionEventId)lastEventId.element;
            if (chatSessionEventId == null) {
                throw new IllegalStateException("Rollback: last event was not found");
            }
            return new RevertedEventsData(chatSessionUserPromptEvent, l, totalPromptEvents.element, chatSessionEventId, CollectionsKt.reversed((Iterable)fileChanges));
        }

        private final long getCheckpointTruncateOffset(SessionHistoryStorage storage, PersistanceId sessionId, ChatSessionEventId userPromptId) {
            Ref.LongRef offset = new Ref.LongRef();
            Path path = storage.getCheckpointsFile(sessionId);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"access$getCheckpointsFile(...)");
            SessionHistoryStorageKt.access$readBase64JsonFile(path, (arg_0, arg_1, arg_2) -> Rollback.getCheckpointTruncateOffset$lambda$0(userPromptId, offset, arg_0, arg_1, arg_2));
            return offset.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void truncateFile(Path file, long offset) {
            if (!Files.exists(file, new LinkOption[0])) {
                return;
            }
            if (offset >= 0L) {
                Object object = new OpenOption[]{StandardOpenOption.WRITE};
                object = FileChannel.open(file, object);
                Throwable throwable = null;
                try {
                    FileChannel it = (FileChannel)object;
                    boolean bl = false;
                    FileChannel fileChannel = it.truncate(offset);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                throw new IndexOutOfBoundsException("Rollback: truncate offset must be a non-negative number");
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean getEventsMetadata$lambda$0(Ref.ObjectRef $lastEventId, Ref.IntRef $totalPromptEvents, ChatSessionEventId $rollbackEventId, Ref.ObjectRef $firstUserPrompt, Ref.ObjectRef $firstUserPromptOffset, List $fileChanges, String line, long lineStartOffset, long l) {
            block10: {
                MessageBlockUpdatedEvent agentEvent;
                ChatSessionMessageEvent chatSessionMessageEvent;
                ChatSessionMessageEvent event;
                block9: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    String b64Line$iv22 = line;
                    boolean $i$f$parseBase64Json = false;
                    if (((CharSequence)b64Line$iv22).length() == 0) {
                        object = null;
                    } else {
                        Object $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22;
                        try {
                            boolean $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = false;
                            byte[] byArray = Base64.getDecoder().decode(b64Line$iv22);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                            byte[] byArray2 = byArray;
                            Charset charset = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                            Charset charset2 = charset;
                            $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = Result.constructor-impl((Object)new String(byArray2, charset2));
                        }
                        catch (Throwable throwable) {
                            $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        String string = (String)(Result.isFailure-impl((Object)$i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22) ? null : $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22);
                        if (string == null) {
                            object = null;
                        } else {
                            Object object2;
                            String json$iv = string;
                            try {
                                void this_$iv$iv;
                                boolean bl = false;
                                $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = (JSON)JSON.Default.INSTANCE;
                                String value$iv$iv = json$iv;
                                boolean $i$f$parse = false;
                                object2 = Result.constructor-impl((Object)this_$iv$iv.parse((DeserializationStrategy)ChatSessionMessageEvent.Companion.serializer(), value$iv$iv));
                            }
                            catch (Throwable throwable) {
                                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            object = Result.isFailure-impl((Object)object2) ? null : object2;
                        }
                    }
                    ChatSessionMessageEvent chatSessionMessageEvent2 = (ChatSessionMessageEvent)object;
                    if (chatSessionMessageEvent2 == null) {
                        return true;
                    }
                    event = chatSessionMessageEvent2;
                    $lastEventId.element = event.getId();
                    chatSessionMessageEvent = event;
                    if (!(chatSessionMessageEvent instanceof ChatSessionUserPromptEvent)) break block9;
                    int b64Line$iv22 = $totalPromptEvents.element;
                    $totalPromptEvents.element = b64Line$iv22 + 1;
                    if (((ChatSessionUserPromptEvent)event).getId().compareTo($rollbackEventId) > 0) break block10;
                    $totalPromptEvents.element = 1;
                    $firstUserPrompt.element = event;
                    $firstUserPromptOffset.element = lineStartOffset;
                    $fileChanges.clear();
                    break block10;
                }
                if (!(chatSessionMessageEvent instanceof ChatSessionMessageBlockEvent) || !((agentEvent = ((ChatSessionMessageBlockEvent)event).getEvent()) instanceof ResultBlockUpdatedEvent)) break block10;
                $fileChanges.addAll(((ResultBlockUpdatedEvent)agentEvent).getChanges());
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean getCheckpointTruncateOffset$lambda$0(ChatSessionEventId $userPromptId, Ref.LongRef $offset, String line, long l, long lineEndOffset) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            String b64Line$iv = line;
            boolean $i$f$parseBase64Json = false;
            if (((CharSequence)b64Line$iv).length() == 0) {
                object = null;
            } else {
                Object $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22;
                try {
                    boolean $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = false;
                    byte[] byArray = Base64.getDecoder().decode(b64Line$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = Result.constructor-impl((Object)new String(byArray2, charset2));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string = (String)(Result.isFailure-impl((Object)$i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22) ? null : $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22);
                if (string == null) {
                    object = null;
                } else {
                    Object object2;
                    String json$iv = string;
                    try {
                        void this_$iv$iv;
                        boolean bl = false;
                        $i$a$-runCatching-SessionHistoryStorageKt$parseBase64Json$json$1$iv22 = (JSON)JSON.Default.INSTANCE;
                        String value$iv$iv = json$iv;
                        boolean $i$f$parse = false;
                        object2 = Result.constructor-impl((Object)this_$iv$iv.parse((DeserializationStrategy)ChatSessionCheckpointEvent.Companion.serializer(), value$iv$iv));
                    }
                    catch (Throwable throwable) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object = Result.isFailure-impl((Object)object2) ? null : object2;
                }
            }
            ChatSessionCheckpointEvent chatSessionCheckpointEvent = (ChatSessionCheckpointEvent)object;
            if (chatSessionCheckpointEvent == null) {
                return true;
            }
            ChatSessionCheckpointEvent checkpoint = chatSessionCheckpointEvent;
            if (checkpoint.getEventId().compareTo($userPromptId) > 0) {
                return false;
            }
            $offset.element = lineEndOffset;
            return true;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JA\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$Rollback$RevertedEventsData;", "", "firstUserPrompt", "Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;", "firstUserPromptOffset", "", "totalPrompts", "", "lastEventId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "fileChanges", "", "Lcom/intellij/ml/llm/aui/events/api/FileChange;", "<init>", "(Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;JILcom/intellij/ml/llm/chat/shared/ChatSessionEventId;Ljava/util/List;)V", "getFirstUserPrompt", "()Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;", "getFirstUserPromptOffset", "()J", "getTotalPrompts", "()I", "getLastEventId", "()Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "getFileChanges", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.chat"})
        private static final class RevertedEventsData {
            @NotNull
            private final ChatSessionUserPromptEvent firstUserPrompt;
            private final long firstUserPromptOffset;
            private final int totalPrompts;
            @NotNull
            private final ChatSessionEventId lastEventId;
            @NotNull
            private final List<FileChange> fileChanges;

            public RevertedEventsData(@NotNull ChatSessionUserPromptEvent firstUserPrompt, long firstUserPromptOffset, int totalPrompts, @NotNull ChatSessionEventId lastEventId, @NotNull List<FileChange> fileChanges) {
                Intrinsics.checkNotNullParameter((Object)firstUserPrompt, (String)"firstUserPrompt");
                Intrinsics.checkNotNullParameter((Object)lastEventId, (String)"lastEventId");
                Intrinsics.checkNotNullParameter(fileChanges, (String)"fileChanges");
                this.firstUserPrompt = firstUserPrompt;
                this.firstUserPromptOffset = firstUserPromptOffset;
                this.totalPrompts = totalPrompts;
                this.lastEventId = lastEventId;
                this.fileChanges = fileChanges;
            }

            @NotNull
            public final ChatSessionUserPromptEvent getFirstUserPrompt() {
                return this.firstUserPrompt;
            }

            public final long getFirstUserPromptOffset() {
                return this.firstUserPromptOffset;
            }

            public final int getTotalPrompts() {
                return this.totalPrompts;
            }

            @NotNull
            public final ChatSessionEventId getLastEventId() {
                return this.lastEventId;
            }

            @NotNull
            public final List<FileChange> getFileChanges() {
                return this.fileChanges;
            }

            @NotNull
            public final ChatSessionUserPromptEvent component1() {
                return this.firstUserPrompt;
            }

            public final long component2() {
                return this.firstUserPromptOffset;
            }

            public final int component3() {
                return this.totalPrompts;
            }

            @NotNull
            public final ChatSessionEventId component4() {
                return this.lastEventId;
            }

            @NotNull
            public final List<FileChange> component5() {
                return this.fileChanges;
            }

            @NotNull
            public final RevertedEventsData copy(@NotNull ChatSessionUserPromptEvent firstUserPrompt, long firstUserPromptOffset, int totalPrompts, @NotNull ChatSessionEventId lastEventId, @NotNull List<FileChange> fileChanges) {
                Intrinsics.checkNotNullParameter((Object)firstUserPrompt, (String)"firstUserPrompt");
                Intrinsics.checkNotNullParameter((Object)lastEventId, (String)"lastEventId");
                Intrinsics.checkNotNullParameter(fileChanges, (String)"fileChanges");
                return new RevertedEventsData(firstUserPrompt, firstUserPromptOffset, totalPrompts, lastEventId, fileChanges);
            }

            public static /* synthetic */ RevertedEventsData copy$default(RevertedEventsData revertedEventsData, ChatSessionUserPromptEvent chatSessionUserPromptEvent, long l, int n, ChatSessionEventId chatSessionEventId, List list2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    chatSessionUserPromptEvent = revertedEventsData.firstUserPrompt;
                }
                if ((n2 & 2) != 0) {
                    l = revertedEventsData.firstUserPromptOffset;
                }
                if ((n2 & 4) != 0) {
                    n = revertedEventsData.totalPrompts;
                }
                if ((n2 & 8) != 0) {
                    chatSessionEventId = revertedEventsData.lastEventId;
                }
                if ((n2 & 0x10) != 0) {
                    list2 = revertedEventsData.fileChanges;
                }
                return revertedEventsData.copy(chatSessionUserPromptEvent, l, n, chatSessionEventId, list2);
            }

            @NotNull
            public String toString() {
                return "RevertedEventsData(firstUserPrompt=" + this.firstUserPrompt + ", firstUserPromptOffset=" + this.firstUserPromptOffset + ", totalPrompts=" + this.totalPrompts + ", lastEventId=" + this.lastEventId + ", fileChanges=" + this.fileChanges + ")";
            }

            public int hashCode() {
                int result2 = this.firstUserPrompt.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.firstUserPromptOffset);
                result2 = result2 * 31 + Integer.hashCode(this.totalPrompts);
                result2 = result2 * 31 + this.lastEventId.hashCode();
                result2 = result2 * 31 + ((Object)this.fileChanges).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RevertedEventsData)) {
                    return false;
                }
                RevertedEventsData revertedEventsData = (RevertedEventsData)other;
                if (!Intrinsics.areEqual((Object)this.firstUserPrompt, (Object)revertedEventsData.firstUserPrompt)) {
                    return false;
                }
                if (this.firstUserPromptOffset != revertedEventsData.firstUserPromptOffset) {
                    return false;
                }
                if (this.totalPrompts != revertedEventsData.totalPrompts) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.lastEventId, (Object)revertedEventsData.lastEventId)) {
                    return false;
                }
                return Intrinsics.areEqual(this.fileChanges, revertedEventsData.fileChanges);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003JU\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u000bH\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$Rollback$RollbackMetadata;", "", "checkpointTruncateOffset", "", "eventsTruncateOffset", "firstEventId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "lastEventId", "userPrompt", "Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;", "totalPrompts", "", "fileChanges", "", "Lcom/intellij/ml/llm/aui/events/api/FileChange;", "<init>", "(JJLcom/intellij/ml/llm/chat/shared/ChatSessionEventId;Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;ILjava/util/List;)V", "getCheckpointTruncateOffset", "()J", "getEventsTruncateOffset", "getFirstEventId", "()Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "getLastEventId", "getUserPrompt", "()Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;", "getTotalPrompts", "()I", "getFileChanges", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.chat"})
        private static final class RollbackMetadata {
            private final long checkpointTruncateOffset;
            private final long eventsTruncateOffset;
            @NotNull
            private final ChatSessionEventId firstEventId;
            @NotNull
            private final ChatSessionEventId lastEventId;
            @NotNull
            private final ChatSessionUserPromptEvent userPrompt;
            private final int totalPrompts;
            @NotNull
            private final List<FileChange> fileChanges;

            public RollbackMetadata(long checkpointTruncateOffset, long eventsTruncateOffset, @NotNull ChatSessionEventId firstEventId, @NotNull ChatSessionEventId lastEventId, @NotNull ChatSessionUserPromptEvent userPrompt, int totalPrompts, @NotNull List<FileChange> fileChanges) {
                Intrinsics.checkNotNullParameter((Object)firstEventId, (String)"firstEventId");
                Intrinsics.checkNotNullParameter((Object)lastEventId, (String)"lastEventId");
                Intrinsics.checkNotNullParameter((Object)userPrompt, (String)"userPrompt");
                Intrinsics.checkNotNullParameter(fileChanges, (String)"fileChanges");
                this.checkpointTruncateOffset = checkpointTruncateOffset;
                this.eventsTruncateOffset = eventsTruncateOffset;
                this.firstEventId = firstEventId;
                this.lastEventId = lastEventId;
                this.userPrompt = userPrompt;
                this.totalPrompts = totalPrompts;
                this.fileChanges = fileChanges;
            }

            public final long getCheckpointTruncateOffset() {
                return this.checkpointTruncateOffset;
            }

            public final long getEventsTruncateOffset() {
                return this.eventsTruncateOffset;
            }

            @NotNull
            public final ChatSessionEventId getFirstEventId() {
                return this.firstEventId;
            }

            @NotNull
            public final ChatSessionEventId getLastEventId() {
                return this.lastEventId;
            }

            @NotNull
            public final ChatSessionUserPromptEvent getUserPrompt() {
                return this.userPrompt;
            }

            public final int getTotalPrompts() {
                return this.totalPrompts;
            }

            @NotNull
            public final List<FileChange> getFileChanges() {
                return this.fileChanges;
            }

            public final long component1() {
                return this.checkpointTruncateOffset;
            }

            public final long component2() {
                return this.eventsTruncateOffset;
            }

            @NotNull
            public final ChatSessionEventId component3() {
                return this.firstEventId;
            }

            @NotNull
            public final ChatSessionEventId component4() {
                return this.lastEventId;
            }

            @NotNull
            public final ChatSessionUserPromptEvent component5() {
                return this.userPrompt;
            }

            public final int component6() {
                return this.totalPrompts;
            }

            @NotNull
            public final List<FileChange> component7() {
                return this.fileChanges;
            }

            @NotNull
            public final RollbackMetadata copy(long checkpointTruncateOffset, long eventsTruncateOffset, @NotNull ChatSessionEventId firstEventId, @NotNull ChatSessionEventId lastEventId, @NotNull ChatSessionUserPromptEvent userPrompt, int totalPrompts, @NotNull List<FileChange> fileChanges) {
                Intrinsics.checkNotNullParameter((Object)firstEventId, (String)"firstEventId");
                Intrinsics.checkNotNullParameter((Object)lastEventId, (String)"lastEventId");
                Intrinsics.checkNotNullParameter((Object)userPrompt, (String)"userPrompt");
                Intrinsics.checkNotNullParameter(fileChanges, (String)"fileChanges");
                return new RollbackMetadata(checkpointTruncateOffset, eventsTruncateOffset, firstEventId, lastEventId, userPrompt, totalPrompts, fileChanges);
            }

            public static /* synthetic */ RollbackMetadata copy$default(RollbackMetadata rollbackMetadata, long l, long l2, ChatSessionEventId chatSessionEventId, ChatSessionEventId chatSessionEventId2, ChatSessionUserPromptEvent chatSessionUserPromptEvent, int n, List list2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    l = rollbackMetadata.checkpointTruncateOffset;
                }
                if ((n2 & 2) != 0) {
                    l2 = rollbackMetadata.eventsTruncateOffset;
                }
                if ((n2 & 4) != 0) {
                    chatSessionEventId = rollbackMetadata.firstEventId;
                }
                if ((n2 & 8) != 0) {
                    chatSessionEventId2 = rollbackMetadata.lastEventId;
                }
                if ((n2 & 0x10) != 0) {
                    chatSessionUserPromptEvent = rollbackMetadata.userPrompt;
                }
                if ((n2 & 0x20) != 0) {
                    n = rollbackMetadata.totalPrompts;
                }
                if ((n2 & 0x40) != 0) {
                    list2 = rollbackMetadata.fileChanges;
                }
                return rollbackMetadata.copy(l, l2, chatSessionEventId, chatSessionEventId2, chatSessionUserPromptEvent, n, list2);
            }

            @NotNull
            public String toString() {
                return "RollbackMetadata(checkpointTruncateOffset=" + this.checkpointTruncateOffset + ", eventsTruncateOffset=" + this.eventsTruncateOffset + ", firstEventId=" + this.firstEventId + ", lastEventId=" + this.lastEventId + ", userPrompt=" + this.userPrompt + ", totalPrompts=" + this.totalPrompts + ", fileChanges=" + this.fileChanges + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.checkpointTruncateOffset);
                result2 = result2 * 31 + Long.hashCode(this.eventsTruncateOffset);
                result2 = result2 * 31 + this.firstEventId.hashCode();
                result2 = result2 * 31 + this.lastEventId.hashCode();
                result2 = result2 * 31 + this.userPrompt.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.totalPrompts);
                result2 = result2 * 31 + ((Object)this.fileChanges).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RollbackMetadata)) {
                    return false;
                }
                RollbackMetadata rollbackMetadata = (RollbackMetadata)other;
                if (this.checkpointTruncateOffset != rollbackMetadata.checkpointTruncateOffset) {
                    return false;
                }
                if (this.eventsTruncateOffset != rollbackMetadata.eventsTruncateOffset) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.firstEventId, (Object)rollbackMetadata.firstEventId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.lastEventId, (Object)rollbackMetadata.lastEventId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.userPrompt, (Object)rollbackMetadata.userPrompt)) {
                    return false;
                }
                if (this.totalPrompts != rollbackMetadata.totalPrompts) {
                    return false;
                }
                return Intrinsics.areEqual(this.fileChanges, rollbackMetadata.fileChanges);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$RollbackData;", "", "userPrompt", "Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;", "firstEventId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "lastEventId", "<init>", "(Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;)V", "getUserPrompt", "()Lcom/intellij/ml/llm/chat/shared/ChatSessionUserPromptEvent;", "getFirstEventId", "()Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "getLastEventId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
    public static final class RollbackData {
        @NotNull
        private final ChatSessionUserPromptEvent userPrompt;
        @NotNull
        private final ChatSessionEventId firstEventId;
        @NotNull
        private final ChatSessionEventId lastEventId;

        public RollbackData(@NotNull ChatSessionUserPromptEvent userPrompt, @NotNull ChatSessionEventId firstEventId, @NotNull ChatSessionEventId lastEventId) {
            Intrinsics.checkNotNullParameter((Object)userPrompt, (String)"userPrompt");
            Intrinsics.checkNotNullParameter((Object)firstEventId, (String)"firstEventId");
            Intrinsics.checkNotNullParameter((Object)lastEventId, (String)"lastEventId");
            this.userPrompt = userPrompt;
            this.firstEventId = firstEventId;
            this.lastEventId = lastEventId;
        }

        @NotNull
        public final ChatSessionUserPromptEvent getUserPrompt() {
            return this.userPrompt;
        }

        @NotNull
        public final ChatSessionEventId getFirstEventId() {
            return this.firstEventId;
        }

        @NotNull
        public final ChatSessionEventId getLastEventId() {
            return this.lastEventId;
        }

        @NotNull
        public final ChatSessionUserPromptEvent component1() {
            return this.userPrompt;
        }

        @NotNull
        public final ChatSessionEventId component2() {
            return this.firstEventId;
        }

        @NotNull
        public final ChatSessionEventId component3() {
            return this.lastEventId;
        }

        @NotNull
        public final RollbackData copy(@NotNull ChatSessionUserPromptEvent userPrompt, @NotNull ChatSessionEventId firstEventId, @NotNull ChatSessionEventId lastEventId) {
            Intrinsics.checkNotNullParameter((Object)userPrompt, (String)"userPrompt");
            Intrinsics.checkNotNullParameter((Object)firstEventId, (String)"firstEventId");
            Intrinsics.checkNotNullParameter((Object)lastEventId, (String)"lastEventId");
            return new RollbackData(userPrompt, firstEventId, lastEventId);
        }

        public static /* synthetic */ RollbackData copy$default(RollbackData rollbackData, ChatSessionUserPromptEvent chatSessionUserPromptEvent, ChatSessionEventId chatSessionEventId, ChatSessionEventId chatSessionEventId2, int n, Object object) {
            if ((n & 1) != 0) {
                chatSessionUserPromptEvent = rollbackData.userPrompt;
            }
            if ((n & 2) != 0) {
                chatSessionEventId = rollbackData.firstEventId;
            }
            if ((n & 4) != 0) {
                chatSessionEventId2 = rollbackData.lastEventId;
            }
            return rollbackData.copy(chatSessionUserPromptEvent, chatSessionEventId, chatSessionEventId2);
        }

        @NotNull
        public String toString() {
            return "RollbackData(userPrompt=" + this.userPrompt + ", firstEventId=" + this.firstEventId + ", lastEventId=" + this.lastEventId + ")";
        }

        public int hashCode() {
            int result2 = this.userPrompt.hashCode();
            result2 = result2 * 31 + this.firstEventId.hashCode();
            result2 = result2 * 31 + this.lastEventId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RollbackData)) {
                return false;
            }
            RollbackData rollbackData = (RollbackData)other;
            if (!Intrinsics.areEqual((Object)this.userPrompt, (Object)rollbackData.userPrompt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.firstEventId, (Object)rollbackData.firstEventId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastEventId, (Object)rollbackData.lastEventId);
        }
    }
}

