/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.editor;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.ui.chat.AICodeGenerationInfo;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/editor/ChatEditorActionListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "afterActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "result", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "intellij.ml.llm.chat"})
public final class ChatEditorActionListener
implements AnActionListener {
    public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        AICodeGenerationInfo codeSnippetData;
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!(action2 instanceof CopyAction)) {
            return;
        }
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        ChatSession chatSession2 = (ChatSession)dataContext2.getData(ChatSession.Companion.getCurrentSession());
        if (chatSession2 == null) {
            return;
        }
        ChatMessage chatMessage = (ChatMessage)dataContext2.getData(ChatMessage.Companion.getKey());
        if (chatMessage == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor2 = editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        AICodeGenerationInfo aICodeGenerationInfo = codeSnippetData = editor2 != null ? (AICodeGenerationInfo)editor2.getUserData(AICodeGenerationInfo.Companion.getUSER_DATA_KEY()) : null;
        if (codeSnippetData != null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            Language language = psiFile != null ? psiFile.getLanguage() : null;
            String string = editor.getSelectionModel().getSelectedText(true);
            if (string == null) {
                String string2 = editor.getDocument().getText();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            }
            String selectedText = string;
            AIAssistantChatEventLogger.logCodeCopiedEvent(project2, chatSession2, chatMessage, language, AIAssistantChatEventLogger.CodeCopiedSource.ACTION, selectedText);
        } else {
            AIAssistantChatEventLogger.logTextCopiedEvent(project2, chatSession2, chatMessage);
        }
    }
}

