/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.retrievers;

import com.intellij.ml.llm.context.RetrievalSession;
import com.intellij.ml.llm.context.interactive.InteractiveRetrievalSession;
import com.intellij.ml.llm.core.chat.context.retrievers.ChatStorageContextRequest;
import com.intellij.ml.llm.core.chat.context.retrievers.ContextRetrieverType;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ContextStorage;
import com.intellij.ml.llm.core.chat.session.HasContextStorage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/core/chat/context/retrievers/ChatSessionContextRequest;", "Lcom/intellij/ml/llm/core/chat/context/retrievers/ChatStorageContextRequest;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "<init>", "(Lcom/intellij/ml/llm/core/chat/session/ChatSession;)V", "getChatSession", "()Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "session", "Lcom/intellij/ml/llm/context/RetrievalSession;", "getSession", "()Lcom/intellij/ml/llm/context/RetrievalSession;", "chatRetrieversType", "Lcom/intellij/ml/llm/core/chat/context/retrievers/ContextRetrieverType;", "getChatRetrieversType", "()Lcom/intellij/ml/llm/core/chat/context/retrievers/ContextRetrieverType;", "contextStorage", "Lcom/intellij/ml/llm/core/chat/session/ContextStorage;", "getContextStorage", "()Lcom/intellij/ml/llm/core/chat/session/ContextStorage;", "intellij.ml.llm.chat"})
public abstract class ChatSessionContextRequest
implements ChatStorageContextRequest {
    @NotNull
    private final ChatSession chatSession;
    @NotNull
    private final ContextRetrieverType chatRetrieversType;

    public ChatSessionContextRequest(@NotNull ChatSession chatSession2) {
        Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
        this.chatSession = chatSession2;
        this.chatRetrieversType = ContextRetrieverType.ALL;
    }

    @NotNull
    public final ChatSession getChatSession() {
        return this.chatSession;
    }

    @NotNull
    public RetrievalSession getSession() {
        return (RetrievalSession)this.chatSession.getRetrievalSession();
    }

    @NotNull
    public ContextRetrieverType getChatRetrieversType() {
        return this.chatRetrieversType;
    }

    @Override
    @Nullable
    public ContextStorage getContextStorage() {
        InteractiveRetrievalSession interactiveRetrievalSession = this.chatSession.getRetrievalSession();
        HasContextStorage hasContextStorage = interactiveRetrievalSession instanceof HasContextStorage ? (HasContextStorage)interactiveRetrievalSession : null;
        return hasContextStorage != null ? hasContextStorage.getContextStorage() : null;
    }
}

