/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.uiPicker.genericTextParser;

import com.intellij.ml.llm.core.chat.context.uiPicker.genericTextParser.TextData;
import com.intellij.ml.llm.core.chat.context.uiPicker.genericTextParser.TextParserGraphics;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00a2\u00012\u00020\u0001:\u0004\u00a1\u0001\u00a2\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\"\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\"\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\"\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u001aH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J$\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010&\u001a\u00020\u000fH\u0016J(\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0016J8\u0010,\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0016J\u0012\u00101\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0012\u00104\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u000105H\u0016J\n\u00106\u001a\u0004\u0018\u000107H\u0016J8\u00108\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0016J\u0012\u0010;\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\n\u0010B\u001a\u0004\u0018\u00010=H\u0016J\n\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0012\u0010E\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0012\u0010F\u001a\u00020\u000b2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J(\u0010I\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0016J\u0018\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\u001a2\u0006\u0010L\u001a\u00020\u001aH\u0016J\u0012\u0010M\u001a\u00020\u000b2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\b\u0010P\u001a\u00020\u000bH\u0016J\n\u0010Q\u001a\u0004\u0018\u00010DH\u0016J\u0018\u0010R\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020\u001a2\u0006\u0010T\u001a\u00020\u001aH\u0016J\n\u0010U\u001a\u0004\u0018\u00010VH\u0016J\u0012\u0010W\u001a\u00020\u000b2\b\u0010X\u001a\u0004\u0018\u00010DH\u0016J\u001a\u0010Y\u001a\u00020\u000b2\u0010\u0010Z\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010[H\u0016J\b\u0010\\\u001a\u00020]H\u0016J\u0012\u0010^\u001a\u00020\u000b2\b\u0010_\u001a\u0004\u0018\u00010`H\u0016J\n\u0010a\u001a\u0004\u0018\u00010`H\u0016J\n\u0010b\u001a\u0004\u0018\u000105H\u0016J(\u0010c\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0016J\n\u0010d\u001a\u0004\u0018\u000103H\u0016J\u001c\u0010e\u001a\u00020\u000b2\b\u0010f\u001a\u0004\u0018\u00010g2\b\u0010h\u001a\u0004\u0018\u00010OH\u0016J\b\u0010i\u001a\u00020\u000bH\u0016J(\u0010j\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0016J\u0012\u0010j\u001a\u00020\u000b2\b\u0010E\u001a\u0004\u0018\u000103H\u0016J\u001a\u0010k\u001a\u00020\u000b2\u0010\u0010Z\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010[H\u0016J\b\u0010l\u001a\u00020OH\u0016J(\u0010m\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0016J\u001c\u0010n\u001a\u00020\u000b2\b\u0010f\u001a\u0004\u0018\u00010o2\b\u0010h\u001a\u0004\u0018\u00010OH\u0016J\u0012\u0010p\u001a\u00020\u000b2\b\u0010q\u001a\u0004\u0018\u000107H\u0016J(\u0010r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0016J$\u0010s\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010&\u001a\u00020\u000fH\u0016J\u0012\u0010t\u001a\u00020\u000b2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\b\u0010u\u001a\u00020HH\u0016J(\u0010v\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0016J \u0010w\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020x2\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J8\u0010y\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010z\u001a\u00020\u000f2\u0006\u0010{\u001a\u00020\u000fH\u0016J\u0012\u0010|\u001a\u00020}2\b\u0010~\u001a\u0004\u0018\u00010`H\u0016J$\u0010\u007f\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010&\u001a\u00020\u000fH\u0016J\u0014\u0010\u0080\u0001\u001a\u00020\u000b2\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010DH\u0016J!\u0010\u0082\u0001\u001a\u00020\u000b2\n\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u00012\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001H\u0016J9\u0010\u0087\u0001\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010z\u001a\u00020\u000f2\u0006\u0010{\u001a\u00020\u000fH\u0016J9\u0010\u0088\u0001\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0016J\u0018\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001H\u0016J)\u0010\u008a\u0001\u001a\u00030\u008b\u00012\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010!2\b\u00102\u001a\u0004\u0018\u0001032\b\u0010\u008d\u0001\u001a\u00030\u008b\u0001H\u0016J\u0014\u0010\u008e\u0001\u001a\u00020\u000b2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010DH\u0016J+\u0010\u0090\u0001\u001a\u00030\u008b\u00012\t\u0010f\u001a\u0005\u0018\u00010\u0091\u00012\b\u0010h\u001a\u0004\u0018\u00010O2\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016J0\u0010\u0090\u0001\u001a\u00020\u000b2\t\u0010f\u001a\u0005\u0018\u00010\u0094\u00012\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0096\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J1\u0010\u0090\u0001\u001a\u00030\u008b\u00012\t\u0010f\u001a\u0005\u0018\u00010\u0091\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016JA\u0010\u0090\u0001\u001a\u00030\u008b\u00012\t\u0010f\u001a\u0005\u0018\u00010\u0091\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\n\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016J<\u0010\u0090\u0001\u001a\u00030\u008b\u00012\t\u0010f\u001a\u0005\u0018\u00010\u0091\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010D2\n\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016JL\u0010\u0090\u0001\u001a\u00030\u008b\u00012\t\u0010f\u001a\u0005\u0018\u00010\u0091\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010D2\n\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016Ji\u0010\u0090\u0001\u001a\u00030\u008b\u00012\t\u0010f\u001a\u0005\u0018\u00010\u0091\u00012\u0007\u0010\u0099\u0001\u001a\u00020\u000f2\u0007\u0010\u009a\u0001\u001a\u00020\u000f2\u0007\u0010\u009b\u0001\u001a\u00020\u000f2\u0007\u0010\u009c\u0001\u001a\u00020\u000f2\u0007\u0010\u009d\u0001\u001a\u00020\u000f2\u0007\u0010\u009e\u0001\u001a\u00020\u000f2\u0007\u0010\u009f\u0001\u001a\u00020\u000f2\u0007\u0010\u00a0\u0001\u001a\u00020\u000f2\n\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016Jt\u0010\u0090\u0001\u001a\u00030\u008b\u00012\t\u0010f\u001a\u0005\u0018\u00010\u0091\u00012\u0007\u0010\u0099\u0001\u001a\u00020\u000f2\u0007\u0010\u009a\u0001\u001a\u00020\u000f2\u0007\u0010\u009b\u0001\u001a\u00020\u000f2\u0007\u0010\u009c\u0001\u001a\u00020\u000f2\u0007\u0010\u009d\u0001\u001a\u00020\u000f2\u0007\u0010\u009e\u0001\u001a\u00020\u000f2\u0007\u0010\u009f\u0001\u001a\u00020\u000f2\u0007\u0010\u00a0\u0001\u001a\u00020\u000f2\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010D2\n\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010<\u001a\u00020=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\b>\u0010?\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics;", "Ljava/awt/Graphics2D;", "g", "extractionData", "", "Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextData;", "location", "Ljava/awt/Point;", "<init>", "(Ljava/awt/Graphics2D;Ljava/util/List;Ljava/awt/Point;)V", "addTextData", "", "text", "", "x", "", "y", "create", "Ljava/awt/Graphics;", "drawString", "str", "", "iterator", "Ljava/text/AttributedCharacterIterator;", "translate", "tx", "", "ty", "rotation", "Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics$Rotation;", "rotate", "theta", "getClipBounds", "Ljava/awt/Rectangle;", "drawPolyline", "xPoints", "", "yPoints", "nPoints", "drawLine", "x1", "y1", "x2", "y2", "copyArea", "width", "height", "dx", "dy", "draw", "s", "Ljava/awt/Shape;", "setStroke", "Ljava/awt/Stroke;", "getComposite", "Ljava/awt/Composite;", "fillArc", "startAngle", "arcAngle", "fill", "gc", "Ljava/awt/GraphicsConfiguration;", "getGc", "()Ljava/awt/GraphicsConfiguration;", "gc$delegate", "Lkotlin/Lazy;", "getDeviceConfiguration", "getBackground", "Ljava/awt/Color;", "clip", "setPaint", "paint", "Ljava/awt/Paint;", "clipRect", "shear", "shx", "shy", "transform", "Tx", "Ljava/awt/geom/AffineTransform;", "setPaintMode", "getColor", "scale", "sx", "sy", "getFontRenderContext", "Ljava/awt/font/FontRenderContext;", "setXORMode", "c1", "addRenderingHints", "hints", "", "getRenderingHints", "Ljava/awt/RenderingHints;", "setFont", "font", "Ljava/awt/Font;", "getFont", "getStroke", "fillOval", "getClip", "drawRenderedImage", "img", "Ljava/awt/image/RenderedImage;", "xform", "dispose", "setClip", "setRenderingHints", "getTransform", "drawOval", "drawRenderableImage", "Ljava/awt/image/renderable/RenderableImage;", "setComposite", "comp", "clearRect", "drawPolygon", "setTransform", "getPaint", "fillRect", "drawGlyphVector", "Ljava/awt/font/GlyphVector;", "drawRoundRect", "arcWidth", "arcHeight", "getFontMetrics", "Ljava/awt/FontMetrics;", "f", "fillPolygon", "setColor", "c", "setRenderingHint", "hintKey", "Ljava/awt/RenderingHints$Key;", "hintValue", "", "fillRoundRect", "drawArc", "getRenderingHint", "hit", "", "rect", "onStroke", "setBackground", "color", "drawImage", "Ljava/awt/Image;", "obs", "Ljava/awt/image/ImageObserver;", "Ljava/awt/image/BufferedImage;", "op", "Ljava/awt/image/BufferedImageOp;", "observer", "bgcolor", "dx1", "dy1", "dx2", "dy2", "sx1", "sy1", "sx2", "sy2", "Rotation", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nTextParserGraphics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextParserGraphics.kt\ncom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1869#2,2:397\n*S KotlinDebug\n*F\n+ 1 TextParserGraphics.kt\ncom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics\n*L\n290#1:397,2\n*E\n"})
public final class TextParserGraphics
extends Graphics2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Graphics2D g;
    @NotNull
    private final List<TextData> extractionData;
    @NotNull
    private final Point location;
    @Nullable
    private Rotation rotation;
    @NotNull
    private final Lazy gc$delegate;
    @NotNull
    private static final List<IntRange> charRanges;
    @NotNull
    private static final Companion.cache.1 cache;

    public TextParserGraphics(@NotNull Graphics2D g, @NotNull List<TextData> extractionData, @NotNull Point location) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(extractionData, (String)"extractionData");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.g = g;
        this.extractionData = extractionData;
        this.location = location;
        this.gc$delegate = LazyKt.lazy(TextParserGraphics::gc_delegate$lambda$0);
    }

    private final void addTextData(String text2, int x, int y) {
        if (this.rotation != null) {
            return;
        }
        int width = this.g.getFontMetrics().stringWidth(text2);
        int height = this.g.getFontMetrics().getHeight();
        this.extractionData.add(new TextData(text2, new Rectangle(this.location.x + x, this.location.y + y, width, height)));
    }

    @Override
    @NotNull
    public Graphics create() {
        Graphics graphics = this.g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = this.location.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Point");
        return new TextParserGraphics(graphics2D, this.extractionData, (Point)object);
    }

    @Override
    public void drawString(@NotNull String str, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.addTextData(str, x, y);
        this.g.drawString(str, x, y);
    }

    @Override
    public void drawString(@Nullable String str, float x, float y) {
        if (str != null) {
            this.addTextData(str, (int)x, (int)y);
        }
        this.g.drawString(str, x, y);
    }

    @Override
    public void drawString(@Nullable AttributedCharacterIterator iterator, int x, int y) {
        if (iterator != null) {
            this.addTextData(iterator.toString(), x, y);
        }
        this.g.drawString(iterator, x, y);
    }

    @Override
    public void drawString(@Nullable AttributedCharacterIterator iterator, float x, float y) {
        if (iterator != null) {
            this.addTextData(iterator.toString(), (int)x, (int)y);
        }
        this.g.drawString(iterator, x, y);
    }

    @Override
    public void translate(int x, int y) {
        this.location.x += x;
        this.location.y += y;
        this.g.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.location.x += (int)tx;
        this.location.y += (int)ty;
        this.g.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.g.rotate(theta);
        this.rotation = new Rotation(theta, null, null, 6, null);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.g.rotate(theta, x, y);
        this.rotation = new Rotation(theta, x, y);
    }

    @Override
    @Nullable
    public Rectangle getClipBounds() {
        return this.g.getClipBounds();
    }

    @Override
    public void drawPolyline(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void draw(@Nullable Shape s) {
        this.g.draw(s);
    }

    @Override
    public void setStroke(@Nullable Stroke s) {
        this.g.setStroke(s);
    }

    @Override
    @Nullable
    public Composite getComposite() {
        return this.g.getComposite();
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fill(@Nullable Shape s) {
        this.g.fill(s);
    }

    private final GraphicsConfiguration getGc() {
        Lazy lazy = this.gc$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (GraphicsConfiguration)object;
    }

    @Override
    @Nullable
    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.g.getDeviceConfiguration();
        if (graphicsConfiguration == null) {
            graphicsConfiguration = this.getGc();
        }
        return graphicsConfiguration;
    }

    @Override
    @Nullable
    public Color getBackground() {
        return this.g.getBackground();
    }

    @Override
    public void clip(@Nullable Shape s) {
        this.g.clip(s);
    }

    @Override
    public void setPaint(@Nullable Paint paint) {
        this.g.setPaint(paint);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.g.clearRect(x, y, width, height);
    }

    @Override
    public void shear(double shx, double shy) {
        this.g.shear(shx, shy);
    }

    @Override
    public void transform(@Nullable AffineTransform Tx) {
        this.g.transform(Tx);
    }

    @Override
    public void setPaintMode() {
        this.g.setPaintMode();
    }

    @Override
    @Nullable
    public Color getColor() {
        return this.g.getColor();
    }

    @Override
    public void scale(double sx, double sy) {
        this.g.scale(sx, sy);
    }

    @Override
    @Nullable
    public FontRenderContext getFontRenderContext() {
        return this.g.getFontRenderContext();
    }

    @Override
    public void setXORMode(@Nullable Color c1) {
        this.g.setXORMode(c1);
    }

    @Override
    public void addRenderingHints(@Nullable Map<?, ?> hints) {
        this.g.addRenderingHints(hints);
    }

    @Override
    @NotNull
    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = this.g.getRenderingHints();
        Intrinsics.checkNotNullExpressionValue((Object)renderingHints, (String)"getRenderingHints(...)");
        return renderingHints;
    }

    @Override
    public void setFont(@Nullable Font font) {
        this.g.setFont(font);
    }

    @Override
    @Nullable
    public Font getFont() {
        return this.g.getFont();
    }

    @Override
    @Nullable
    public Stroke getStroke() {
        return this.g.getStroke();
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.g.fillOval(x, y, width, height);
    }

    @Override
    @Nullable
    public Shape getClip() {
        return this.g.getClip();
    }

    @Override
    public void drawRenderedImage(@Nullable RenderedImage img, @Nullable AffineTransform xform) {
        this.g.drawRenderedImage(img, xform);
    }

    @Override
    public void dispose() {
        this.g.dispose();
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.g.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(@Nullable Shape clip) {
    }

    @Override
    public void setRenderingHints(@Nullable Map<?, ?> hints) {
        this.g.setRenderingHints(hints);
    }

    @Override
    @NotNull
    public AffineTransform getTransform() {
        AffineTransform affineTransform = this.g.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        return affineTransform;
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
    }

    @Override
    public void drawRenderableImage(@Nullable RenderableImage img, @Nullable AffineTransform xform) {
    }

    @Override
    public void setComposite(@Nullable Composite comp) {
        this.g.setComposite(comp);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
    }

    @Override
    public void drawPolygon(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
    }

    @Override
    public void setTransform(@Nullable AffineTransform Tx) {
        this.g.setTransform(Tx);
    }

    @Override
    @NotNull
    public Paint getPaint() {
        Paint paint = this.g.getPaint();
        Intrinsics.checkNotNullExpressionValue((Object)paint, (String)"getPaint(...)");
        return paint;
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
    }

    @Override
    public void drawGlyphVector(@NotNull GlyphVector g, float x, float y) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        StringBuilder $this$drawGlyphVector_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)g.getNumGlyphs());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)font);
            Intrinsics.checkNotNull((Object)frc);
            Character c = TextParserGraphics.Companion.findCharByGlyph(font, frc, g.getGlyphCode(it));
            if (c == null) continue;
            char c2 = c.charValue();
            boolean bl3 = false;
            $this$drawGlyphVector_u24lambda_u240.append(c2);
        }
        String text2 = stringBuilder.toString();
        this.addTextData(text2, (int)x, (int)y);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics(@Nullable Font f) {
        FontMetrics fontMetrics = this.g.getFontMetrics(f);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        return fontMetrics;
    }

    @Override
    public void fillPolygon(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
    }

    @Override
    public void setColor(@Nullable Color c) {
        this.g.setColor(c);
    }

    @Override
    public void setRenderingHint(@Nullable RenderingHints.Key hintKey, @Nullable Object hintValue) {
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    @Nullable
    public Object getRenderingHint(@Nullable RenderingHints.Key hintKey) {
        return this.g.getRenderingHint(hintKey);
    }

    @Override
    public boolean hit(@Nullable Rectangle rect, @Nullable Shape s, boolean onStroke) {
        return this.g.hit(rect, s, onStroke);
    }

    @Override
    public void setBackground(@Nullable Color color) {
        this.g.setBackground(color);
    }

    @Override
    public boolean drawImage(@Nullable Image img, @Nullable AffineTransform xform, @Nullable ImageObserver obs) {
        return this.g.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(@Nullable BufferedImage img, @Nullable BufferedImageOp op, int x, int y) {
        this.g.drawImage(img, op, x, y);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, @Nullable ImageObserver observer) {
        return this.g.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, int width, int height, @Nullable ImageObserver observer) {
        return this.g.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        return this.g.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, int width, int height, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        return this.g.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable ImageObserver observer) {
        return this.g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        return this.g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    private static final GraphicsConfiguration gc_delegate$lambda$0() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getConfigurations()[0];
    }

    static {
        Object[] objectArray = new IntRange[]{new IntRange(32, 126), new IntRange(160, 255), new IntRange(256, 591), new IntRange(880, 1023), new IntRange(1024, 1216)};
        charRanges = CollectionsKt.listOf((Object[])objectArray);
        cache = new LinkedHashMap<String, Map<Integer, ? extends Character>>(){
            private final int maxCacheSize;
            {
                this.maxCacheSize = 20;
            }

            protected boolean removeEldestEntry(Map.Entry<String, ? extends Map<Integer, Character>> eldest) {
                return this.size() > this.maxCacheSize;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006*\u0001\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J'\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics$Companion;", "", "<init>", "()V", "charRanges", "", "Lkotlin/ranges/IntRange;", "createTable", "", "", "", "font", "Ljava/awt/Font;", "frc", "Ljava/awt/font/FontRenderContext;", "cache", "com/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics$Companion$cache$1", "Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics$Companion$cache$1;", "findCharByGlyph", "glyph", "(Ljava/awt/Font;Ljava/awt/font/FontRenderContext;I)Ljava/lang/Character;", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nTextParserGraphics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextParserGraphics.kt\ncom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,396:1\n1869#2:397\n1869#2,2:398\n1870#2:400\n382#3,7:401\n*S KotlinDebug\n*F\n+ 1 TextParserGraphics.kt\ncom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics$Companion\n*L\n264#1:397\n265#1:398,2\n264#1:400\n282#1:401,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<Integer, Character> createTable(Font font, FontRenderContext frc) {
            Map map2 = new LinkedHashMap();
            Iterable $this$forEach$iv = charRanges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntRange range = (IntRange)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = (Iterable)range;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.iterator();
                while (iterator.hasNext()) {
                    int element$iv2;
                    int code = element$iv2 = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    char[] cArray = new char[]{(char)code};
                    int glyph = font.createGlyphVector(frc, cArray).getGlyphCode(0);
                    map2.put(glyph, Character.valueOf((char)code));
                }
            }
            return map2;
        }

        /*
         * WARNING - void declaration
         */
        private final Character findCharByGlyph(Font font, FontRenderContext frc, int glyph) {
            Object object;
            void $this$getOrPut$iv;
            String key = font.getName() + font.getSize() + frc.getTransform();
            Map map2 = cache;
            String key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Map<Integer, Character> answer$iv = Companion.createTable(font, frc);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (Character)((Map)object).get(glyph);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics$Rotation;", "", "theta", "", "x", "y", "<init>", "(DLjava/lang/Double;Ljava/lang/Double;)V", "getTheta", "()D", "getX", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getY", "component1", "component2", "component3", "copy", "(DLjava/lang/Double;Ljava/lang/Double;)Lcom/intellij/ml/llm/core/chat/context/uiPicker/genericTextParser/TextParserGraphics$Rotation;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
    public static final class Rotation {
        private final double theta;
        @Nullable
        private final Double x;
        @Nullable
        private final Double y;

        public Rotation(double theta, @Nullable Double x, @Nullable Double y) {
            this.theta = theta;
            this.x = x;
            this.y = y;
        }

        public /* synthetic */ Rotation(double d, Double d2, Double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d2 = null;
            }
            if ((n & 4) != 0) {
                d3 = null;
            }
            this(d, d2, d3);
        }

        public final double getTheta() {
            return this.theta;
        }

        @Nullable
        public final Double getX() {
            return this.x;
        }

        @Nullable
        public final Double getY() {
            return this.y;
        }

        public final double component1() {
            return this.theta;
        }

        @Nullable
        public final Double component2() {
            return this.x;
        }

        @Nullable
        public final Double component3() {
            return this.y;
        }

        @NotNull
        public final Rotation copy(double theta, @Nullable Double x, @Nullable Double y) {
            return new Rotation(theta, x, y);
        }

        public static /* synthetic */ Rotation copy$default(Rotation rotation, double d, Double d2, Double d3, int n, Object object) {
            if ((n & 1) != 0) {
                d = rotation.theta;
            }
            if ((n & 2) != 0) {
                d2 = rotation.x;
            }
            if ((n & 4) != 0) {
                d3 = rotation.y;
            }
            return rotation.copy(d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "Rotation(theta=" + this.theta + ", x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.theta);
            result2 = result2 * 31 + (this.x == null ? 0 : ((Object)this.x).hashCode());
            result2 = result2 * 31 + (this.y == null ? 0 : ((Object)this.y).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rotation)) {
                return false;
            }
            Rotation rotation = (Rotation)other;
            if (Double.compare(this.theta, rotation.theta) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.x, (Object)rotation.x)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.y, (Object)rotation.y);
        }
    }
}

