/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.parts;

import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.parts.AbstractMessagePart;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeSnippetLanguage;
import com.intellij.ml.llm.responseParser.ResponseParser;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0014J\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/chat/parts/CodePart;", "Lcom/intellij/ml/llm/core/chat/parts/AbstractMessagePart;", "message", "Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "<init>", "(Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;)V", "getMessage", "()Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "value", "Lcom/intellij/ml/llm/core/chat/parts/CodePart$Code;", "code", "getCode", "()Lcom/intellij/ml/llm/core/chat/parts/CodePart$Code;", "lastParsedLanguageId", "", "onContentChanged", "", "content", "getParsedLanguageId", "parse", "Code", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nCodePart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodePart.kt\ncom/intellij/ml/llm/core/chat/parts/CodePart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1869#2,2:75\n*S KotlinDebug\n*F\n+ 1 CodePart.kt\ncom/intellij/ml/llm/core/chat/parts/CodePart\n*L\n43#1:75,2\n*E\n"})
public final class CodePart
extends AbstractMessagePart {
    @NotNull
    private Code code;
    @Nullable
    private String lastParsedLanguageId;

    public CodePart(@NotNull MarkdownChatMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
        this.code = new Code(CodeSnippetLanguage.Companion.initial(), "", false);
    }

    @Override
    @NotNull
    public MarkdownChatMessage getMessage() {
        ChatMessage chatMessage = super.getMessage();
        Intrinsics.checkNotNull((Object)chatMessage, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage");
        return (MarkdownChatMessage)chatMessage;
    }

    @NotNull
    public final Code getCode() {
        return this.code;
    }

    @Override
    protected void onContentChanged(@NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.code = this.parse(content2);
    }

    @Nullable
    public final String getParsedLanguageId() {
        return this.lastParsedLanguageId;
    }

    private final Code parse(String content2) {
        ResponseParser responseParser = new ResponseParser();
        String languageId = null;
        StringBuilder rootCodeBlockContents = new StringBuilder();
        boolean codeClosed = false;
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)responseParser.consume(content2), (Iterable)responseParser.finalize());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResponseParser.Event event = (ResponseParser.Event)element$iv;
            boolean bl = false;
            ResponseParser.Event event2 = event;
            if (event2 instanceof ResponseParser.RootCodeStart) {
                languageId = ((ResponseParser.RootCodeStart)event).getLanguageIdentifier();
                continue;
            }
            if (event2 instanceof ResponseParser.Text) {
                rootCodeBlockContents.append(((ResponseParser.Text)event).getPayload());
                continue;
            }
            if (!(event2 instanceof ResponseParser.RootCodeEnd)) continue;
            codeClosed = true;
        }
        CodeSnippetLanguage codeSnippetLanguage = !Intrinsics.areEqual(languageId, (Object)this.lastParsedLanguageId) ? CodeSnippetLanguage.Companion.fromLanguageId(languageId) : this.code.getCodeSnippetLanguage();
        this.lastParsedLanguageId = languageId;
        String string = rootCodeBlockContents.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Code(codeSnippetLanguage, string, codeClosed);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/chat/parts/CodePart$Code;", "", "codeSnippetLanguage", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguage;", "text", "", "isComplete", "", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguage;Ljava/lang/String;Z)V", "getCodeSnippetLanguage", "()Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguage;", "getText", "()Ljava/lang/String;", "()Z", "intellij.ml.llm.chat"})
    public static final class Code {
        @NotNull
        private final CodeSnippetLanguage codeSnippetLanguage;
        @NotNull
        private final String text;
        private final boolean isComplete;

        public Code(@NotNull CodeSnippetLanguage codeSnippetLanguage, @NotNull String text2, boolean isComplete) {
            Intrinsics.checkNotNullParameter((Object)codeSnippetLanguage, (String)"codeSnippetLanguage");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.codeSnippetLanguage = codeSnippetLanguage;
            this.text = text2;
            this.isComplete = isComplete;
        }

        @NotNull
        public final CodeSnippetLanguage getCodeSnippetLanguage() {
            return this.codeSnippetLanguage;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean isComplete() {
            return this.isComplete;
        }
    }
}

