/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.promptLibrary.views;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.chat.promptLibrary.core.modelView.AIChatPromptModelView;
import com.intellij.ml.llm.core.chat.promptLibrary.core.modelView.AILibraryPromptModelView;
import com.intellij.ml.llm.core.chat.promptLibrary.core.modelView.AISystemPromptModelView;
import com.intellij.ml.llm.core.chat.promptLibrary.views.AIAssistantVariableButtonAction;
import com.intellij.ml.llm.core.chat.promptLibrary.views.AIAssistantVariableButtonsActionGroup;
import com.intellij.ml.llm.core.chat.promptLibrary.views.PromptEditorFieldKt;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariable;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariablesService;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.util.swing.SwingBindingsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.JBColor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u001a(\u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\rH\u0002\u001a(\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0017"}, d2={"createSettingsPanel", "Ljavax/swing/JComponent;", "prompt", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/modelView/AILibraryPromptModelView;", "disposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "emptyPromptsComponent", "Ljavax/swing/JLabel;", "chatPromptPanel", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/modelView/AIChatPromptModelView;", "systemPromptPanel", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/modelView/AISystemPromptModelView;", "createVariablesToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createEditorPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "toolbar", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\npromptEditorPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 promptEditorPanel.kt\ncom/intellij/ml/llm/core/chat/promptLibrary/views/PromptEditorPanelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,241:1\n1563#2:242\n1634#2,3:243\n774#2:251\n865#2,2:252\n230#3,5:246\n*S KotlinDebug\n*F\n+ 1 promptEditorPanel.kt\ncom/intellij/ml/llm/core/chat/promptLibrary/views/PromptEditorPanelKt\n*L\n209#1:242\n209#1:243,3\n200#1:251\n200#1:252,2\n185#1:246,5\n*E\n"})
public final class PromptEditorPanelKt {
    @NotNull
    public static final JComponent createSettingsPanel(@Nullable AILibraryPromptModelView prompt2, @NotNull Disposable disposable, @NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        AILibraryPromptModelView aILibraryPromptModelView = prompt2;
        if (aILibraryPromptModelView instanceof AISystemPromptModelView) {
            jComponent = PromptEditorPanelKt.systemPromptPanel(disposable, coroutineScope, project, (AISystemPromptModelView)prompt2);
        } else if (aILibraryPromptModelView instanceof AIChatPromptModelView) {
            jComponent = PromptEditorPanelKt.chatPromptPanel(disposable, coroutineScope, project, (AIChatPromptModelView)prompt2);
        } else if (aILibraryPromptModelView == null) {
            jComponent = PromptEditorPanelKt.emptyPromptsComponent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JComponent component = jComponent;
        component.setBorder((Border)JBUI.Borders.emptyLeft((int)7));
        return component;
    }

    private static final JLabel emptyPromptsComponent() {
        HtmlChunk.Element element = HtmlChunk.tag((String)"center").addText(LLMBundle.message((String)"promptlibrary.settings.emptystate", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addText(...)");
        HtmlChunk.Element htmlElement = element;
        String string = new HtmlBuilder().append((HtmlChunk)htmlElement).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String labelText = string;
        JLabel label = new JLabel(labelText, 0);
        return label;
    }

    private static final JComponent chatPromptPanel(Disposable disposable, CoroutineScope coroutineScope, Project project, AIChatPromptModelView prompt2) {
        Editor editor = PromptEditorFieldKt.createEditor(disposable, project, prompt2.getId());
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        ExtensionsKtKt.privacySafe((Document)document, (Project)project).bindTextIn(prompt2.getContent(), coroutineScope);
        return (JComponent)BuilderKt.panel(arg_0 -> PromptEditorPanelKt.chatPromptPanel$lambda$0(editor, prompt2, coroutineScope, arg_0));
    }

    private static final JComponent systemPromptPanel(Disposable disposable, CoroutineScope coroutineScope, Project project, AISystemPromptModelView prompt2) {
        ComponentPredicate isNotDefault = ComponentPredicateKt.predicate((StateFlow)((StateFlow)prompt2.isDefault()), (CoroutineScope)coroutineScope, PromptEditorPanelKt::systemPromptPanel$lambda$0);
        Editor editor = PromptEditorFieldKt.createEditor(disposable, project, prompt2.getId());
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        ExtensionsKtKt.privacySafe((Document)document, (Project)project).bindTextIn(prompt2.getContent(), coroutineScope);
        return (JComponent)BuilderKt.panel(arg_0 -> PromptEditorPanelKt.systemPromptPanel$lambda$1(editor, prompt2, isNotDefault, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final ActionToolbar createVariablesToolbar(Editor editor, AILibraryPromptModelView prompt2) {
        Collection<AIAssistantVariableButtonAction> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<AIAssistantPromptLibraryVariable> variables = PromptEditorPanelKt.createVariablesToolbar$getToolbarVariables(prompt2);
        if (variables.isEmpty()) {
            return null;
        }
        Iterable iterable = variables;
        String string = "AIAssistantPromptEditorButtons";
        ActionManager actionManager = ActionManager.getInstance();
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AIAssistantPromptLibraryVariable aIAssistantPromptLibraryVariable = (AIAssistantPromptLibraryVariable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AIAssistantVariableButtonAction((AIAssistantPromptLibraryVariable)it));
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        Iterable $this$createVariablesToolbar_u24lambda_u242 = iterable = actionManager.createActionToolbar(string, (ActionGroup)new AIAssistantVariableButtonsActionGroup(list2), true);
        boolean bl = false;
        $this$createVariablesToolbar_u24lambda_u242.setTargetComponent(editor.getComponent());
        $this$createVariablesToolbar_u24lambda_u242.getComponent().setBackground(editor.getContentComponent().getBackground());
        $this$createVariablesToolbar_u24lambda_u242.getComponent().setBorder((Border)JBUI.Borders.empty());
        return iterable;
    }

    private static final BorderLayoutPanel createEditorPanel(Editor editor, ActionToolbar toolbar) {
        return (BorderLayoutPanel)new UiDataProvider(editor, toolbar){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
                this.setBorder(JBUI.Borders.compound((Border)JBUI.Borders.customLine((Color)JBColor.border(), (int)1), (Border)((Border)JBUI.Borders.empty((int)6, (int)8))));
                this.setBackground($editor.getContentComponent().getBackground());
                this.addToCenter($editor.getComponent());
                ActionToolbar actionToolbar = $toolbar;
                if (actionToolbar != null) {
                    ActionToolbar it = actionToolbar;
                    boolean bl = false;
                    this.addToBottom(it.getComponent());
                }
                this.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
                this.setPreferredSize((Dimension)new JBDimension(300, 300));
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                DataKey dataKey = PlatformDataKeys.EDITOR;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
                sink.set(dataKey, (Object)this.$editor);
            }
        };
    }

    private static final Unit chatPromptPanel$lambda$0(Editor $editor, AIChatPromptModelView $prompt, CoroutineScope $coroutineScope, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PromptEditorPanelKt.chatPromptPanel$lambda$0$0($editor, $prompt, arg_0), (int)1, null).bottomGap(BottomGap.SMALL);
        $this$panel.row(LLMBundle.message((String)"promptlibrary.settings.label.prompt.name", (Object[])new Object[0]), arg_0 -> PromptEditorPanelKt.chatPromptPanel$lambda$0$1($prompt, $coroutineScope, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PromptEditorPanelKt.chatPromptPanel$lambda$0$2($prompt, $coroutineScope, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PromptEditorPanelKt.chatPromptPanel$lambda$0$3($prompt, $coroutineScope, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit chatPromptPanel$lambda$0$0(Editor $editor, AIChatPromptModelView $prompt, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)PromptEditorPanelKt.createEditorPanel($editor, PromptEditorPanelKt.createVariablesToolbar($editor, $prompt))).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit chatPromptPanel$lambda$0$1(AIChatPromptModelView $prompt, CoroutineScope $coroutineScope, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SwingBindingsKt.bindTextIn((Cell)TextFieldKt.columns((Cell)$this$row.textField(), (int)18), $prompt.getName(), (CoroutineScope)$coroutineScope);
        return Unit.INSTANCE;
    }

    private static final Unit chatPromptPanel$lambda$0$2(AIChatPromptModelView $prompt, CoroutineScope $coroutineScope, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        SwingBindingsKt.bindSelected((Cell)Cell.comment$default((Cell)$this$row.checkBox(LLMBundle.message((String)"promptlibrary.settings.checkbox.waitForInput", (Object[])new Object[0])), (String)LLMBundle.message((String)"promptlibrary.settings.checkbox.waitForInput.hint", (Object[])objectArray), (int)0, null, (int)6, null), $prompt.getWaitForInput(), (CoroutineScope)$coroutineScope);
        return Unit.INSTANCE;
    }

    private static final Unit chatPromptPanel$lambda$0$3(AIChatPromptModelView $prompt, CoroutineScope $coroutineScope, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SwingBindingsKt.bindSelected((Cell)Cell.comment$default((Cell)$this$row.checkBox(LLMBundle.message((String)"promptlibrary.settings.checkbox.showInPopup", (Object[])new Object[0])), (String)LLMBundle.message((String)"promptlibrary.settings.checkbox.showInPopup.hint", (Object[])new Object[0]), (int)0, null, (int)6, null), $prompt.getShowInPopup(), (CoroutineScope)$coroutineScope);
        return Unit.INSTANCE;
    }

    private static final boolean systemPromptPanel$lambda$0(boolean it) {
        return !it;
    }

    private static final Unit systemPromptPanel$lambda$1(Editor $editor, AISystemPromptModelView $prompt, ComponentPredicate $isNotDefault, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PromptEditorPanelKt.systemPromptPanel$lambda$1$0($editor, $prompt, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PromptEditorPanelKt.systemPromptPanel$lambda$1$1($isNotDefault, $prompt, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PromptEditorPanelKt.systemPromptPanel$lambda$1$2($prompt, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit systemPromptPanel$lambda$1$0(Editor $editor, AISystemPromptModelView $prompt, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)PromptEditorPanelKt.createEditorPanel($editor, PromptEditorPanelKt.createVariablesToolbar($editor, $prompt))).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit systemPromptPanel$lambda$1$1(ComponentPredicate $isNotDefault, AISystemPromptModelView $prompt, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link(LLMBundle.message((String)"promptlibrary.settings.restore.default", (Object[])new Object[0]), arg_0 -> PromptEditorPanelKt.systemPromptPanel$lambda$1$1$0($prompt, arg_0)).visibleIf($isNotDefault);
        return Unit.INSTANCE;
    }

    private static final Unit systemPromptPanel$lambda$1$1$0(AISystemPromptModelView $prompt, ActionEvent it) {
        PSString nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MutableStateFlow<PSString> $this$update$iv = $prompt.getContent();
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            PSString it2 = (PSString)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = $prompt.getDefaultPrompt())));
        return Unit.INSTANCE;
    }

    private static final Unit systemPromptPanel$lambda$1$2(AISystemPromptModelView $prompt, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)$prompt.getDisplayDescription(), (int)0, null, (int)6, null).applyToComponent(PromptEditorPanelKt::systemPromptPanel$lambda$1$2$0);
        return Unit.INSTANCE;
    }

    private static final Unit systemPromptPanel$lambda$1$2$0(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFocusable(true);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<AIAssistantPromptLibraryVariable> createVariablesToolbar$getToolbarVariables(AILibraryPromptModelView prompt2) {
        List list2;
        AILibraryPromptModelView aILibraryPromptModelView = prompt2;
        if (aILibraryPromptModelView instanceof AISystemPromptModelView) {
            list2 = ((AISystemPromptModelView)prompt2).getVariables();
        } else if (aILibraryPromptModelView instanceof AIChatPromptModelView) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)AIAssistantPromptLibraryVariablesService.Companion.getInstance().getAll();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AIAssistantPromptLibraryVariable it = (AIAssistantPromptLibraryVariable)element$iv$iv;
                boolean bl = false;
                if (!it.getFeatured()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }
}

