/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.services;

import com.intellij.ml.llm.context.RetrievalSession;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.CustomSystemPromptAttachment;
import com.intellij.ml.llm.core.chat.context.renderer.AIAssistantChatAttachmentRenderer;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/chat/services/AIRequesterUtils;", "", "<init>", "()V", "formatMessageContent", "Lcom/intellij/ml/llm/privacy/PSString;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "message", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "formatAttachments", "visibleAttachments", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIRequesterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIRequesterUtils.kt\ncom/intellij/ml/llm/core/chat/services/AIRequesterUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,32:1\n774#2:33\n865#2,2:34\n*S KotlinDebug\n*F\n+ 1 AIRequesterUtils.kt\ncom/intellij/ml/llm/core/chat/services/AIRequesterUtils\n*L\n13#1:33\n13#1:34,2\n*E\n"})
public final class AIRequesterUtils {
    @NotNull
    public static final AIRequesterUtils INSTANCE = new AIRequesterUtils();

    private AIRequesterUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PSString formatMessageContent(@NotNull ChatSession chatSession2, @NotNull ChatMessage message) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable iterable = message.getAttachments();
        ChatSession chatSession3 = chatSession2;
        AIRequesterUtils aIRequesterUtils = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatAttachment it = (ChatAttachment)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof CustomSystemPromptAttachment))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        PSString formattedAttachments = aIRequesterUtils.formatAttachments(chatSession3, list2);
        PSString resultingText = message.getFormattedText();
        if (formattedAttachments != null) {
            resultingText = resultingText.plus(formattedAttachments);
        }
        return resultingText;
    }

    private final PSString formatAttachments(ChatSession chatSession2, List<? extends ChatAttachment> visibleAttachments) {
        if (visibleAttachments.isEmpty()) {
            return null;
        }
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{AIAssistantChatAttachmentRenderer.Companion.getRenderer().renderAll((RetrievalSession)chatSession2.getRetrievalSession(), visibleAttachments)};
        return ConstantsKt.getPrivacyConst((String)"\n          \n          \n          Don't mention code from context attachments unless it's needed\n          %s\n          ").trimIndent().format(pSStringConvertibleArray);
    }
}

