/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.session;

import ai.grazie.model.cloud.ContentType;
import ai.grazie.utils.json.JSON;
import com.intellij.ml.llm.context.interactive.InteractiveRetrievalSession;
import com.intellij.ml.llm.context.llm.entity.LlmSystemContextEntity;
import com.intellij.ml.llm.context.llm.entity.LlmTextContextEntity;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.context.ChatRetrievalSession;
import com.intellij.ml.llm.core.chat.messages.CancelledState;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.ChatMessageRating;
import com.intellij.ml.llm.core.chat.messages.ChatMessageWithMedia;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.messages.ReadyState;
import com.intellij.ml.llm.core.chat.messages.TaskMessage;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.chat.session.impl.ChatSessionImpl;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.ml.llm.core.models.api.AiChatMediaMessage;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.PrivacySafeTaskCall;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.serialization.PSStringConverter;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="ChatSessionStateTemp", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u000e\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$State;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "chatSessions", "", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "getChatSessions", "()Ljava/util/List;", "currentChatIndex", "", "getState", "loadState", "", "state", "dispose", "Companion", "ChatStatisticInformation", "SerializedChatTitle", "SerializedChat", "SerializedChatMessage", "SerializedChatMediaMessage", "ContentTypeConverter", "SerializedChatAttachment", "OurLLMChatFunctionMessage", "SerializedFunctionCall", "SerializedChatContext", "SerializedChatContextItem", "SerializedTaskCall", "State", "intellij.ml.llm.chat"})
public final class ChatSessionStorage
implements PersistentStateComponent<State>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<ChatSession> chatSessions;
    private int currentChatIndex;

    public ChatSessionStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.chatSessions = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<ChatSession> getChatSessions() {
        return this.chatSessions;
    }

    @NotNull
    public State getState() {
        State result2 = new State();
        for (ChatSession chat : this.chatSessions) {
            Companion.serializeChatMessages(chat, result2);
        }
        result2.setCurrentChatIndex(this.currentChatIndex);
        return result2;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        for (SerializedChat chat : state.getChats()) {
            this.chatSessions.add(ChatSessionImpl.Companion.load$intellij_ml_llm_chat(this, chat));
        }
    }

    public void dispose() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$ChatStatisticInformation;", "", "uid", "", "sourceActionType", "Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;", "timestamp", "", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;J)V", "getUid", "()Ljava/lang/String;", "getSourceActionType", "()Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;", "setSourceActionType", "(Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;)V", "getTimestamp", "()J", "setTimestamp", "(J)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class ChatStatisticInformation {
        @NotNull
        private final String uid;
        @NotNull
        private ChatSourceAction sourceActionType;
        private long timestamp;

        public ChatStatisticInformation(@NotNull String uid, @NotNull ChatSourceAction sourceActionType, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            Intrinsics.checkNotNullParameter((Object)sourceActionType, (String)"sourceActionType");
            this.uid = uid;
            this.sourceActionType = sourceActionType;
            this.timestamp = timestamp;
        }

        public /* synthetic */ ChatStatisticInformation(String string, ChatSourceAction chatSourceAction, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                chatSourceAction = ChatSourceAction.UNKNOWN;
            }
            if ((n & 4) != 0) {
                l = 0L;
            }
            this(string, chatSourceAction, l);
        }

        @NotNull
        public final String getUid() {
            return this.uid;
        }

        @NotNull
        public final ChatSourceAction getSourceActionType() {
            return this.sourceActionType;
        }

        public final void setSourceActionType(@NotNull ChatSourceAction chatSourceAction) {
            Intrinsics.checkNotNullParameter((Object)chatSourceAction, (String)"<set-?>");
            this.sourceActionType = chatSourceAction;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(long l) {
            this.timestamp = l;
        }

        @NotNull
        public final String component1() {
            return this.uid;
        }

        @NotNull
        public final ChatSourceAction component2() {
            return this.sourceActionType;
        }

        public final long component3() {
            return this.timestamp;
        }

        @NotNull
        public final ChatStatisticInformation copy(@NotNull String uid, @NotNull ChatSourceAction sourceActionType, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            Intrinsics.checkNotNullParameter((Object)sourceActionType, (String)"sourceActionType");
            return new ChatStatisticInformation(uid, sourceActionType, timestamp);
        }

        public static /* synthetic */ ChatStatisticInformation copy$default(ChatStatisticInformation chatStatisticInformation, String string, ChatSourceAction chatSourceAction, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = chatStatisticInformation.uid;
            }
            if ((n & 2) != 0) {
                chatSourceAction = chatStatisticInformation.sourceActionType;
            }
            if ((n & 4) != 0) {
                l = chatStatisticInformation.timestamp;
            }
            return chatStatisticInformation.copy(string, chatSourceAction, l);
        }

        @NotNull
        public String toString() {
            return "ChatStatisticInformation(uid=" + this.uid + ", sourceActionType=" + this.sourceActionType + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result2 = this.uid.hashCode();
            result2 = result2 * 31 + this.sourceActionType.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChatStatisticInformation)) {
                return false;
            }
            ChatStatisticInformation chatStatisticInformation = (ChatStatisticInformation)other;
            if (!Intrinsics.areEqual((Object)this.uid, (Object)chatStatisticInformation.uid)) {
                return false;
            }
            if (this.sourceActionType != chatStatisticInformation.sourceActionType) {
                return false;
            }
            return this.timestamp == chatStatisticInformation.timestamp;
        }

        public ChatStatisticInformation() {
            this(null, null, 0L, 7, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage;", "project", "Lcom/intellij/openapi/project/Project;", "createSerializedChatContextItem", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatContextItem;", "item", "Lcom/intellij/ml/llm/context/llm/entity/LlmTextContextEntity;", "createSerializedChatContextItem$intellij_ml_llm_chat", "createChatContextItem", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "createChatContextItem$intellij_ml_llm_chat", "serializeChatMessages", "", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "result", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$State;", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nChatSessionStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatSessionStorage.kt\ncom/intellij/ml/llm/core/chat/session/ChatSessionStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 JSON.kt\nai/grazie/utils/json/JSON\n*L\n1#1,193:1\n30#2,2:194\n1563#3:196\n1634#3,3:197\n1563#3:202\n1634#3,3:203\n808#3,11:206\n774#3:217\n865#3,2:218\n295#3,2:220\n1563#3:222\n1634#3,3:223\n1#4:200\n28#5:201\n*S KotlinDebug\n*F\n+ 1 ChatSessionStorage.kt\ncom/intellij/ml/llm/core/chat/session/ChatSessionStorage$Companion\n*L\n27#1:194,2\n39#1:196\n39#1:197,3\n47#1:202\n47#1:203,3\n66#1:206,11\n67#1:217\n67#1:218,2\n77#1:220,2\n86#1:222\n86#1:223,3\n45#1:201\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChatSessionStorage getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ChatSessionStorage> serviceClass$iv = ChatSessionStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ChatSessionStorage)object;
        }

        @NotNull
        public final SerializedChatContextItem createSerializedChatContextItem$intellij_ml_llm_chat(@NotNull LlmTextContextEntity item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return new SerializedChatContextItem(item.getText(), item.getId());
        }

        @NotNull
        public final ChatContextItem createChatContextItem$intellij_ml_llm_chat(@NotNull SerializedChatContextItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return new ChatContextItem(item.getIdentity(), item.getText(), null, 4, null);
        }

        /*
         * WARNING - void declaration
         */
        public final void serializeChatMessages(@NotNull ChatSession chat, @NotNull State result2) {
            Collection<SerializedChatContextItem> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            NewChatMode newChatMode;
            Object v10;
            Iterable $this$firstOrNull$iv;
            List list2;
            Collection<SerializedChat> collection2;
            List messages;
            block17: {
                List list3;
                Object element$iv$iv2;
                ChatRetrievalSession retrievalSession;
                SerializedTaskCall serializedTask;
                List attachment;
                Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (chat.getMessages().isEmpty()) {
                    return;
                }
                messages = new ArrayList();
                for (ChatMessage chatMessage : chat.getMessages()) {
                    List list4;
                    Object it;
                    TaskMessage taskMessage;
                    Object markupLanguageID;
                    JSON it2;
                    void $this$mapTo$iv$iv2;
                    if (!Intrinsics.areEqual((Object)chatMessage.getState(), (Object)ReadyState.INSTANCE) && !Intrinsics.areEqual((Object)chatMessage.getState(), (Object)CancelledState.INSTANCE)) continue;
                    Iterable $this$map$iv2 = chatMessage.getAttachments();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv2;
                    List<SerializedChat> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        ChatAttachment chatAttachment = (ChatAttachment)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl = false;
                        VirtualFilePointer virtualFilePointer = it2.getVirtualFilePointer();
                        collection2.add((SerializedChat)((Object)new SerializedChatAttachment(it2.getName(), it2.getText(), it2.getKind(), virtualFilePointer != null ? virtualFilePointer.getUrl() : null)));
                    }
                    attachment = destination$iv$iv;
                    Object object = chatMessage instanceof MarkdownChatMessage ? (MarkdownChatMessage)chatMessage : null;
                    if (object == null || (object = object.getMarkupLanguage()) == null || (object = object.getID()) == null) {
                        object = markupLanguageID = "";
                    }
                    if ((taskMessage = chatMessage instanceof TaskMessage ? (TaskMessage)chatMessage : null) != null && (taskMessage = taskMessage.getTask()) != null) {
                        void this_$iv;
                        it = taskMessage;
                        boolean bl = false;
                        it2 = (JSON)JSON.Default.INSTANCE;
                        TaskMessage value$iv = it;
                        boolean $i$f$string = false;
                        v3 = new SerializedTaskCall(this_$iv.string((SerializationStrategy)PrivacySafeTaskCall.Companion.serializer(), (Object)value$iv));
                    } else {
                        v3 = serializedTask = null;
                    }
                    if (chatMessage instanceof ChatMessageWithMedia) {
                        void $this$mapTo$iv$iv3;
                        Iterable $this$map$iv3 = ((ChatMessageWithMedia)chatMessage).getMedia();
                        boolean $i$f$map2 = false;
                        it = $this$map$iv3;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                            void it3;
                            AiChatMediaMessage aiChatMediaMessage = (AiChatMediaMessage)item$iv$iv;
                            collection2 = destination$iv$iv2;
                            boolean bl = false;
                            collection2.add((SerializedChat)((Object)new SerializedChatMediaMessage(it3.getContentType(), it3.getData())));
                        }
                        list4 = (List)destination$iv$iv2;
                    } else {
                        list4 = CollectionsKt.emptyList();
                    }
                    List media = list4;
                    String string = chatMessage.getUid();
                    MarkdownChatMessage markdownChatMessage = chatMessage instanceof MarkdownChatMessage ? (MarkdownChatMessage)chatMessage : null;
                    if (markdownChatMessage == null || (markdownChatMessage = markdownChatMessage.getDisplayText()) == null) {
                        markdownChatMessage = chatMessage.getText();
                    }
                    messages.add(new SerializedChatMessage(string, (PSString)markdownChatMessage, chatMessage.getText(), attachment, media, chatMessage.getAuthor(), chatMessage.getRating(), (String)markupLanguageID, serializedTask));
                }
                InteractiveRetrievalSession interactiveRetrievalSession = chat.getRetrievalSession();
                ChatRetrievalSession chatRetrievalSession = retrievalSession = interactiveRetrievalSession instanceof ChatRetrievalSession ? (ChatRetrievalSession)interactiveRetrievalSession : null;
                if (retrievalSession != null) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv;
                    attachment = retrievalSession.getContextStorage().getItems();
                    boolean $i$f$filterIsInstance = false;
                    serializedTask = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv2 instanceof LlmTextContextEntity)) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$filter = false;
                    $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        LlmTextContextEntity it = (LlmTextContextEntity)element$iv$iv2;
                        boolean bl = false;
                        if (!(it instanceof LlmSystemContextEntity)) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    list3 = (List)destination$iv$iv;
                } else {
                    list3 = CollectionsKt.emptyList();
                }
                list2 = list3;
                boolean hasSomeMessages = !((Collection)chat.getMessages()).isEmpty();
                Object object = chat instanceof ChatSessionImpl ? (ChatSessionImpl)chat : null;
                boolean hasComposeMessages = object != null && (object = ((ChatSessionImpl)object).getFrontendSession()) != null ? !object.isEmpty() : false;
                NewChatMode currentMode = chat.getCurrentChatMode();
                NewChatMode lastCompatibleMode = chat.getChatMode().getLastCompatibleChatMode();
                element$iv$iv2 = new NewChatMode[]{currentMode, lastCompatibleMode};
                element$iv$iv2 = CollectionsKt.listOfNotNull((Object[])element$iv$iv2);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NewChatMode it = (NewChatMode)element$iv;
                    boolean bl = false;
                    if (!ChatSessionImpl.Companion.isModeCompatibleWithHistory$intellij_ml_llm_chat(hasSomeMessages, hasComposeMessages, it.isComposeAgent())) continue;
                    v10 = element$iv;
                    break block17;
                }
                v10 = null;
            }
            if ((newChatMode = (NewChatMode)v10) == null) {
                newChatMode = NewChatMode.Chat.INSTANCE;
            }
            NewChatMode chatMode = newChatMode;
            SerializedChatTitle title2 = new SerializedChatTitle(chat.getTitle().getText(), chat.getTitle().isCustom());
            $this$firstOrNull$iv = list2;
            PSString pSString = null;
            List list5 = messages;
            SerializedChatTitle serializedChatTitle = title2;
            String string = chat.getUid();
            collection2 = result2.getChats();
            boolean $i$f$map = false;
            Iterator bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                LlmTextContextEntity llmTextContextEntity = (LlmTextContextEntity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.createSerializedChatContextItem$intellij_ml_llm_chat((LlmTextContextEntity)p0));
            }
            Collection<SerializedChatContextItem> collection3 = collection = (List)destination$iv$iv;
            String string2 = chatMode.getId();
            ChatStatisticInformation chatStatisticInformation = new ChatStatisticInformation(chat.getUid(), chat.getStatisticData().getSourceAction(), chat.getStatisticData().getLastTimestamp());
            long l = chat.getTimestamp();
            SerializedChatContext serializedChatContext = new SerializedChatContext((List<SerializedChatContextItem>)collection3);
            PSString pSString2 = pSString;
            List list6 = list5;
            SerializedChatTitle serializedChatTitle2 = serializedChatTitle;
            String string3 = string;
            collection2.add(new SerializedChat(string3, serializedChatTitle2, list6, pSString2, serializedChatContext, l, chatStatisticInformation, string2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$ContentTypeConverter;", "Lcom/intellij/util/xmlb/Converter;", "Lai/grazie/model/cloud/ContentType;", "<init>", "()V", "fromString", "value", "", "toString", "intellij.ml.llm.chat"})
    public static final class ContentTypeConverter
    extends Converter<ContentType> {
        private ContentTypeConverter() {
        }

        @NotNull
        public ContentType fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ContentType.Companion.parse(value);
        }

        @NotNull
        public String toString(@NotNull ContentType value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.toString();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$OurLLMChatFunctionMessage;", "", "functionName", "", "content", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFunctionName", "()Ljava/lang/String;", "setFunctionName", "(Ljava/lang/String;)V", "getContent", "setContent", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class OurLLMChatFunctionMessage {
        @NotNull
        private String functionName;
        @NotNull
        private String content;

        public OurLLMChatFunctionMessage(@NotNull String functionName, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.functionName = functionName;
            this.content = content2;
        }

        public /* synthetic */ OurLLMChatFunctionMessage(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.functionName = string;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final void setContent(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.content = string;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        @NotNull
        public final OurLLMChatFunctionMessage copy(@NotNull String functionName, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return new OurLLMChatFunctionMessage(functionName, content2);
        }

        public static /* synthetic */ OurLLMChatFunctionMessage copy$default(OurLLMChatFunctionMessage ourLLMChatFunctionMessage, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = ourLLMChatFunctionMessage.functionName;
            }
            if ((n & 2) != 0) {
                string2 = ourLLMChatFunctionMessage.content;
            }
            return ourLLMChatFunctionMessage.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "OurLLMChatFunctionMessage(functionName=" + this.functionName + ", content=" + this.content + ")";
        }

        public int hashCode() {
            int result2 = this.functionName.hashCode();
            result2 = result2 * 31 + this.content.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OurLLMChatFunctionMessage)) {
                return false;
            }
            OurLLMChatFunctionMessage ourLLMChatFunctionMessage = (OurLLMChatFunctionMessage)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)ourLLMChatFunctionMessage.functionName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.content, (Object)ourLLMChatFunctionMessage.content);
        }

        public OurLLMChatFunctionMessage() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bc\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0005H\u00c6\u0003J\u000f\u00104\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\t\u00107\u001a\u00020\u000eH\u00c6\u0003J\t\u00108\u001a\u00020\u0010H\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003Je\u0010:\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010>\u001a\u00020?H\u00d6\u0001J\t\u0010@\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0015\"\u0004\b1\u0010\u0017\u00a8\u0006A"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChat;", "", "uid", "", "title", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatTitle;", "messages", "", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatMessage;", "context", "Lcom/intellij/ml/llm/privacy/PSString;", "chatContext", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatContext;", "modifiedAt", "", "statisticInformation", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$ChatStatisticInformation;", "chatModelId", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatTitle;Ljava/util/List;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatContext;JLcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$ChatStatisticInformation;Ljava/lang/String;)V", "getUid", "()Ljava/lang/String;", "setUid", "(Ljava/lang/String;)V", "getTitle", "()Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatTitle;", "setTitle", "(Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatTitle;)V", "getMessages", "()Ljava/util/List;", "setMessages", "(Ljava/util/List;)V", "getContext", "()Lcom/intellij/ml/llm/privacy/PSString;", "setContext", "(Lcom/intellij/ml/llm/privacy/PSString;)V", "getChatContext", "()Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatContext;", "setChatContext", "(Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatContext;)V", "getModifiedAt", "()J", "setModifiedAt", "(J)V", "getStatisticInformation", "()Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$ChatStatisticInformation;", "setStatisticInformation", "(Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$ChatStatisticInformation;)V", "getChatModelId", "setChatModelId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class SerializedChat {
        @NotNull
        private String uid;
        @NotNull
        private SerializedChatTitle title;
        @NotNull
        private List<SerializedChatMessage> messages;
        @OptionTag(converter=PSStringConverter.class)
        @Nullable
        private PSString context;
        @Nullable
        private SerializedChatContext chatContext;
        private long modifiedAt;
        @NotNull
        private ChatStatisticInformation statisticInformation;
        @Nullable
        private String chatModelId;

        public SerializedChat(@NotNull String uid, @NotNull SerializedChatTitle title2, @NotNull List<SerializedChatMessage> messages, @Nullable PSString context, @Nullable SerializedChatContext chatContext, long modifiedAt, @NotNull ChatStatisticInformation statisticInformation, @Nullable String chatModelId) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter(messages, (String)"messages");
            Intrinsics.checkNotNullParameter((Object)statisticInformation, (String)"statisticInformation");
            this.uid = uid;
            this.title = title2;
            this.messages = messages;
            this.context = context;
            this.chatContext = chatContext;
            this.modifiedAt = modifiedAt;
            this.statisticInformation = statisticInformation;
            this.chatModelId = chatModelId;
        }

        public /* synthetic */ SerializedChat(String string, SerializedChatTitle serializedChatTitle, List list2, PSString pSString, SerializedChatContext serializedChatContext, long l, ChatStatisticInformation chatStatisticInformation, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                String string3 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                string = string3;
            }
            if ((n & 2) != 0) {
                serializedChatTitle = new SerializedChatTitle(null, false, 3, null);
            }
            if ((n & 4) != 0) {
                list2 = new ArrayList();
            }
            if ((n & 8) != 0) {
                pSString = null;
            }
            if ((n & 0x10) != 0) {
                serializedChatContext = null;
            }
            if ((n & 0x20) != 0) {
                l = System.currentTimeMillis();
            }
            if ((n & 0x40) != 0) {
                chatStatisticInformation = new ChatStatisticInformation(null, null, 0L, 7, null);
            }
            if ((n & 0x80) != 0) {
                string2 = null;
            }
            this(string, serializedChatTitle, list2, pSString, serializedChatContext, l, chatStatisticInformation, string2);
        }

        @NotNull
        public final String getUid() {
            return this.uid;
        }

        public final void setUid(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.uid = string;
        }

        @NotNull
        public final SerializedChatTitle getTitle() {
            return this.title;
        }

        public final void setTitle(@NotNull SerializedChatTitle serializedChatTitle) {
            Intrinsics.checkNotNullParameter((Object)serializedChatTitle, (String)"<set-?>");
            this.title = serializedChatTitle;
        }

        @NotNull
        public final List<SerializedChatMessage> getMessages() {
            return this.messages;
        }

        public final void setMessages(@NotNull List<SerializedChatMessage> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.messages = list2;
        }

        @Nullable
        public final PSString getContext() {
            return this.context;
        }

        public final void setContext(@Nullable PSString pSString) {
            this.context = pSString;
        }

        @Nullable
        public final SerializedChatContext getChatContext() {
            return this.chatContext;
        }

        public final void setChatContext(@Nullable SerializedChatContext serializedChatContext) {
            this.chatContext = serializedChatContext;
        }

        public final long getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(long l) {
            this.modifiedAt = l;
        }

        @NotNull
        public final ChatStatisticInformation getStatisticInformation() {
            return this.statisticInformation;
        }

        public final void setStatisticInformation(@NotNull ChatStatisticInformation chatStatisticInformation) {
            Intrinsics.checkNotNullParameter((Object)chatStatisticInformation, (String)"<set-?>");
            this.statisticInformation = chatStatisticInformation;
        }

        @Nullable
        public final String getChatModelId() {
            return this.chatModelId;
        }

        public final void setChatModelId(@Nullable String string) {
            this.chatModelId = string;
        }

        @NotNull
        public final String component1() {
            return this.uid;
        }

        @NotNull
        public final SerializedChatTitle component2() {
            return this.title;
        }

        @NotNull
        public final List<SerializedChatMessage> component3() {
            return this.messages;
        }

        @Nullable
        public final PSString component4() {
            return this.context;
        }

        @Nullable
        public final SerializedChatContext component5() {
            return this.chatContext;
        }

        public final long component6() {
            return this.modifiedAt;
        }

        @NotNull
        public final ChatStatisticInformation component7() {
            return this.statisticInformation;
        }

        @Nullable
        public final String component8() {
            return this.chatModelId;
        }

        @NotNull
        public final SerializedChat copy(@NotNull String uid, @NotNull SerializedChatTitle title2, @NotNull List<SerializedChatMessage> messages, @Nullable PSString context, @Nullable SerializedChatContext chatContext, long modifiedAt, @NotNull ChatStatisticInformation statisticInformation, @Nullable String chatModelId) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter(messages, (String)"messages");
            Intrinsics.checkNotNullParameter((Object)statisticInformation, (String)"statisticInformation");
            return new SerializedChat(uid, title2, messages, context, chatContext, modifiedAt, statisticInformation, chatModelId);
        }

        public static /* synthetic */ SerializedChat copy$default(SerializedChat serializedChat, String string, SerializedChatTitle serializedChatTitle, List list2, PSString pSString, SerializedChatContext serializedChatContext, long l, ChatStatisticInformation chatStatisticInformation, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = serializedChat.uid;
            }
            if ((n & 2) != 0) {
                serializedChatTitle = serializedChat.title;
            }
            if ((n & 4) != 0) {
                list2 = serializedChat.messages;
            }
            if ((n & 8) != 0) {
                pSString = serializedChat.context;
            }
            if ((n & 0x10) != 0) {
                serializedChatContext = serializedChat.chatContext;
            }
            if ((n & 0x20) != 0) {
                l = serializedChat.modifiedAt;
            }
            if ((n & 0x40) != 0) {
                chatStatisticInformation = serializedChat.statisticInformation;
            }
            if ((n & 0x80) != 0) {
                string2 = serializedChat.chatModelId;
            }
            return serializedChat.copy(string, serializedChatTitle, list2, pSString, serializedChatContext, l, chatStatisticInformation, string2);
        }

        @NotNull
        public String toString() {
            return "SerializedChat(uid=" + this.uid + ", title=" + this.title + ", messages=" + this.messages + ", context=" + this.context + ", chatContext=" + this.chatContext + ", modifiedAt=" + this.modifiedAt + ", statisticInformation=" + this.statisticInformation + ", chatModelId=" + this.chatModelId + ")";
        }

        public int hashCode() {
            int result2 = this.uid.hashCode();
            result2 = result2 * 31 + this.title.hashCode();
            result2 = result2 * 31 + ((Object)this.messages).hashCode();
            result2 = result2 * 31 + (this.context == null ? 0 : this.context.hashCode());
            result2 = result2 * 31 + (this.chatContext == null ? 0 : this.chatContext.hashCode());
            result2 = result2 * 31 + Long.hashCode(this.modifiedAt);
            result2 = result2 * 31 + this.statisticInformation.hashCode();
            result2 = result2 * 31 + (this.chatModelId == null ? 0 : this.chatModelId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedChat)) {
                return false;
            }
            SerializedChat serializedChat = (SerializedChat)other;
            if (!Intrinsics.areEqual((Object)this.uid, (Object)serializedChat.uid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)serializedChat.title)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.messages, serializedChat.messages)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.context, (Object)serializedChat.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.chatContext, (Object)serializedChat.chatContext)) {
                return false;
            }
            if (this.modifiedAt != serializedChat.modifiedAt) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.statisticInformation, (Object)serializedChat.statisticInformation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.chatModelId, (Object)serializedChat.chatModelId);
        }

        public SerializedChat() {
            this(null, null, null, null, null, 0L, null, null, 255, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\bH\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatAttachment;", "", "name", "Lcom/intellij/ml/llm/privacy/PSString;", "text", "kind", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment$Kind;", "url", "", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment$Kind;Ljava/lang/String;)V", "getName", "()Lcom/intellij/ml/llm/privacy/PSString;", "setName", "(Lcom/intellij/ml/llm/privacy/PSString;)V", "getText", "setText", "getKind", "()Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment$Kind;", "setKind", "(Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment$Kind;)V", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class SerializedChatAttachment {
        @OptionTag(converter=PSStringConverter.class)
        @NotNull
        private PSString name;
        @OptionTag(converter=PSStringConverter.class)
        @NotNull
        private PSString text;
        @NotNull
        private ChatAttachment.Kind kind;
        @Nullable
        private String url;

        public SerializedChatAttachment(@NotNull PSString name, @NotNull PSString text2, @NotNull ChatAttachment.Kind kind, @Nullable String url) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            this.name = name;
            this.text = text2;
            this.kind = kind;
            this.url = url;
        }

        public /* synthetic */ SerializedChatAttachment(PSString pSString, PSString pSString2, ChatAttachment.Kind kind, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                pSString = ConstantsKt.getPrivacyConst((String)"");
            }
            if ((n & 2) != 0) {
                pSString2 = ConstantsKt.getPrivacyConst((String)"");
            }
            if ((n & 4) != 0) {
                kind = ChatAttachment.Kind.Visible;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            this(pSString, pSString2, kind, string);
        }

        @NotNull
        public final PSString getName() {
            return this.name;
        }

        public final void setName(@NotNull PSString pSString) {
            Intrinsics.checkNotNullParameter((Object)pSString, (String)"<set-?>");
            this.name = pSString;
        }

        @NotNull
        public final PSString getText() {
            return this.text;
        }

        public final void setText(@NotNull PSString pSString) {
            Intrinsics.checkNotNullParameter((Object)pSString, (String)"<set-?>");
            this.text = pSString;
        }

        @NotNull
        public final ChatAttachment.Kind getKind() {
            return this.kind;
        }

        public final void setKind(@NotNull ChatAttachment.Kind kind) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"<set-?>");
            this.kind = kind;
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(@Nullable String string) {
            this.url = string;
        }

        @NotNull
        public final PSString component1() {
            return this.name;
        }

        @NotNull
        public final PSString component2() {
            return this.text;
        }

        @NotNull
        public final ChatAttachment.Kind component3() {
            return this.kind;
        }

        @Nullable
        public final String component4() {
            return this.url;
        }

        @NotNull
        public final SerializedChatAttachment copy(@NotNull PSString name, @NotNull PSString text2, @NotNull ChatAttachment.Kind kind, @Nullable String url) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            return new SerializedChatAttachment(name, text2, kind, url);
        }

        public static /* synthetic */ SerializedChatAttachment copy$default(SerializedChatAttachment serializedChatAttachment, PSString pSString, PSString pSString2, ChatAttachment.Kind kind, String string, int n, Object object) {
            if ((n & 1) != 0) {
                pSString = serializedChatAttachment.name;
            }
            if ((n & 2) != 0) {
                pSString2 = serializedChatAttachment.text;
            }
            if ((n & 4) != 0) {
                kind = serializedChatAttachment.kind;
            }
            if ((n & 8) != 0) {
                string = serializedChatAttachment.url;
            }
            return serializedChatAttachment.copy(pSString, pSString2, kind, string);
        }

        @NotNull
        public String toString() {
            return "SerializedChatAttachment(name=" + this.name + ", text=" + this.text + ", kind=" + this.kind + ", url=" + this.url + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.text.hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            result2 = result2 * 31 + (this.url == null ? 0 : this.url.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedChatAttachment)) {
                return false;
            }
            SerializedChatAttachment serializedChatAttachment = (SerializedChatAttachment)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)serializedChatAttachment.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)serializedChatAttachment.text)) {
                return false;
            }
            if (this.kind != serializedChatAttachment.kind) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.url, (Object)serializedChatAttachment.url);
        }

        public SerializedChatAttachment() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatContext;", "", "items", "", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatContextItem;", "<init>", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "setItems", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
    public static final class SerializedChatContext {
        @NotNull
        private List<SerializedChatContextItem> items;

        public SerializedChatContext(@NotNull List<SerializedChatContextItem> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.items = items;
        }

        public /* synthetic */ SerializedChatContext(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = new ArrayList();
            }
            this(list2);
        }

        @NotNull
        public final List<SerializedChatContextItem> getItems() {
            return this.items;
        }

        public final void setItems(@NotNull List<SerializedChatContextItem> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.items = list2;
        }

        @NotNull
        public final List<SerializedChatContextItem> component1() {
            return this.items;
        }

        @NotNull
        public final SerializedChatContext copy(@NotNull List<SerializedChatContextItem> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            return new SerializedChatContext(items);
        }

        public static /* synthetic */ SerializedChatContext copy$default(SerializedChatContext serializedChatContext, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = serializedChatContext.items;
            }
            return serializedChatContext.copy(list2);
        }

        @NotNull
        public String toString() {
            return "SerializedChatContext(items=" + this.items + ")";
        }

        public int hashCode() {
            return ((Object)this.items).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedChatContext)) {
                return false;
            }
            SerializedChatContext serializedChatContext = (SerializedChatContext)other;
            return Intrinsics.areEqual(this.items, serializedChatContext.items);
        }

        public SerializedChatContext() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatContextItem;", "", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "identity", "", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Ljava/lang/String;)V", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "setText", "(Lcom/intellij/ml/llm/privacy/PSString;)V", "getIdentity", "()Ljava/lang/String;", "setIdentity", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class SerializedChatContextItem {
        @OptionTag(converter=PSStringConverter.class)
        @NotNull
        private PSString text;
        @NotNull
        private String identity;

        public SerializedChatContextItem(@NotNull PSString text2, @NotNull String identity) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
            this.text = text2;
            this.identity = identity;
        }

        public /* synthetic */ SerializedChatContextItem(PSString pSString, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                pSString = ConstantsKt.getPrivacyConst((String)"");
            }
            if ((n & 2) != 0) {
                string = "";
            }
            this(pSString, string);
        }

        @NotNull
        public final PSString getText() {
            return this.text;
        }

        public final void setText(@NotNull PSString pSString) {
            Intrinsics.checkNotNullParameter((Object)pSString, (String)"<set-?>");
            this.text = pSString;
        }

        @NotNull
        public final String getIdentity() {
            return this.identity;
        }

        public final void setIdentity(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.identity = string;
        }

        @NotNull
        public final PSString component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.identity;
        }

        @NotNull
        public final SerializedChatContextItem copy(@NotNull PSString text2, @NotNull String identity) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
            return new SerializedChatContextItem(text2, identity);
        }

        public static /* synthetic */ SerializedChatContextItem copy$default(SerializedChatContextItem serializedChatContextItem, PSString pSString, String string, int n, Object object) {
            if ((n & 1) != 0) {
                pSString = serializedChatContextItem.text;
            }
            if ((n & 2) != 0) {
                string = serializedChatContextItem.identity;
            }
            return serializedChatContextItem.copy(pSString, string);
        }

        @NotNull
        public String toString() {
            return "SerializedChatContextItem(text=" + this.text + ", identity=" + this.identity + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.identity.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedChatContextItem)) {
                return false;
            }
            SerializedChatContextItem serializedChatContextItem = (SerializedChatContextItem)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)serializedChatContextItem.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.identity, (Object)serializedChatContextItem.identity);
        }

        public SerializedChatContextItem() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatMediaMessage;", "", "contentType", "Lai/grazie/model/cloud/ContentType;", "data", "", "<init>", "(Lai/grazie/model/cloud/ContentType;Ljava/lang/String;)V", "getContentType", "()Lai/grazie/model/cloud/ContentType;", "setContentType", "(Lai/grazie/model/cloud/ContentType;)V", "getData", "()Ljava/lang/String;", "setData", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class SerializedChatMediaMessage {
        @OptionTag(converter=ContentTypeConverter.class)
        @NotNull
        private ContentType contentType;
        @NotNull
        private String data;

        public SerializedChatMediaMessage(@NotNull ContentType contentType, @NotNull String data2) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.contentType = contentType;
            this.data = data2;
        }

        public /* synthetic */ SerializedChatMediaMessage(ContentType contentType, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                contentType = ContentType.Image.INSTANCE.getAny();
            }
            if ((n & 2) != 0) {
                string = "";
            }
            this(contentType, string);
        }

        @NotNull
        public final ContentType getContentType() {
            return this.contentType;
        }

        public final void setContentType(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"<set-?>");
            this.contentType = contentType;
        }

        @NotNull
        public final String getData() {
            return this.data;
        }

        public final void setData(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.data = string;
        }

        @NotNull
        public final ContentType component1() {
            return this.contentType;
        }

        @NotNull
        public final String component2() {
            return this.data;
        }

        @NotNull
        public final SerializedChatMediaMessage copy(@NotNull ContentType contentType, @NotNull String data2) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return new SerializedChatMediaMessage(contentType, data2);
        }

        public static /* synthetic */ SerializedChatMediaMessage copy$default(SerializedChatMediaMessage serializedChatMediaMessage, ContentType contentType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                contentType = serializedChatMediaMessage.contentType;
            }
            if ((n & 2) != 0) {
                string = serializedChatMediaMessage.data;
            }
            return serializedChatMediaMessage.copy(contentType, string);
        }

        @NotNull
        public String toString() {
            return "SerializedChatMediaMessage(contentType=" + this.contentType + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result2 = this.contentType.hashCode();
            result2 = result2 * 31 + this.data.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedChatMediaMessage)) {
                return false;
            }
            SerializedChatMediaMessage serializedChatMediaMessage = (SerializedChatMediaMessage)other;
            if (!Intrinsics.areEqual((Object)this.contentType, (Object)serializedChatMediaMessage.contentType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.data, (Object)serializedChatMediaMessage.data);
        }

        public SerializedChatMediaMessage() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bq\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\t\u00105\u001a\u00020\u0005H\u00c6\u0003J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u0011\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\bH\u00c6\u0003J\t\u00108\u001a\u00020\rH\u00c6\u0003J\t\u00109\u001a\u00020\u000fH\u00c6\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003Js\u0010<\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00c6\u0001J\u0013\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010@\u001a\u00020AH\u00d6\u0001J\t\u0010B\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010 \"\u0004\b$\u0010\"R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0016\"\u0004\b.\u0010\u0018R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006C"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatMessage;", "", "uid", "", "displayContent", "Lcom/intellij/ml/llm/privacy/PSString;", "internalContent", "attachments", "", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatAttachment;", "media", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatMediaMessage;", "author", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;", "rating", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "markupLanguageID", "task", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedTaskCall;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Ljava/util/List;Ljava/util/List;Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedTaskCall;)V", "getUid", "()Ljava/lang/String;", "setUid", "(Ljava/lang/String;)V", "getDisplayContent", "()Lcom/intellij/ml/llm/privacy/PSString;", "setDisplayContent", "(Lcom/intellij/ml/llm/privacy/PSString;)V", "getInternalContent", "setInternalContent", "getAttachments", "()Ljava/util/List;", "setAttachments", "(Ljava/util/List;)V", "getMedia", "setMedia", "getAuthor", "()Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;", "setAuthor", "(Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;)V", "getRating", "()Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "setRating", "(Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;)V", "getMarkupLanguageID", "setMarkupLanguageID", "getTask", "()Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedTaskCall;", "setTask", "(Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedTaskCall;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class SerializedChatMessage {
        @NotNull
        private String uid;
        @OptionTag(converter=PSStringConverter.class)
        @NotNull
        private PSString displayContent;
        @OptionTag(converter=PSStringConverter.class)
        @NotNull
        private PSString internalContent;
        @NotNull
        private List<SerializedChatAttachment> attachments;
        @NotNull
        private List<SerializedChatMediaMessage> media;
        @NotNull
        private ChatMessageAuthor author;
        @NotNull
        private ChatMessageRating rating;
        @NotNull
        private String markupLanguageID;
        @Nullable
        private SerializedTaskCall task;

        public SerializedChatMessage(@NotNull String uid, @NotNull PSString displayContent, @NotNull PSString internalContent, @NotNull List<SerializedChatAttachment> attachments, @NotNull List<SerializedChatMediaMessage> media, @NotNull ChatMessageAuthor author, @NotNull ChatMessageRating rating, @NotNull String markupLanguageID, @Nullable SerializedTaskCall task) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            Intrinsics.checkNotNullParameter((Object)displayContent, (String)"displayContent");
            Intrinsics.checkNotNullParameter((Object)internalContent, (String)"internalContent");
            Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
            Intrinsics.checkNotNullParameter(media, (String)"media");
            Intrinsics.checkNotNullParameter((Object)((Object)author), (String)"author");
            Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
            Intrinsics.checkNotNullParameter((Object)markupLanguageID, (String)"markupLanguageID");
            this.uid = uid;
            this.displayContent = displayContent;
            this.internalContent = internalContent;
            this.attachments = attachments;
            this.media = media;
            this.author = author;
            this.rating = rating;
            this.markupLanguageID = markupLanguageID;
            this.task = task;
        }

        public /* synthetic */ SerializedChatMessage(String string, PSString pSString, PSString pSString2, List list2, List list3, ChatMessageAuthor chatMessageAuthor, ChatMessageRating chatMessageRating, String string2, SerializedTaskCall serializedTaskCall, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                String string3 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                string = string3;
            }
            if ((n & 2) != 0) {
                pSString = ConstantsKt.getPrivacyConst((String)"");
            }
            if ((n & 4) != 0) {
                pSString2 = ConstantsKt.getPrivacyConst((String)"");
            }
            if ((n & 8) != 0) {
                list2 = new ArrayList();
            }
            if ((n & 0x10) != 0) {
                list3 = new ArrayList();
            }
            if ((n & 0x20) != 0) {
                chatMessageAuthor = ChatMessageAuthor.User;
            }
            if ((n & 0x40) != 0) {
                chatMessageRating = ChatMessageRating.None;
            }
            if ((n & 0x80) != 0) {
                string2 = "";
            }
            if ((n & 0x100) != 0) {
                serializedTaskCall = null;
            }
            this(string, pSString, pSString2, list2, list3, chatMessageAuthor, chatMessageRating, string2, serializedTaskCall);
        }

        @NotNull
        public final String getUid() {
            return this.uid;
        }

        public final void setUid(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.uid = string;
        }

        @NotNull
        public final PSString getDisplayContent() {
            return this.displayContent;
        }

        public final void setDisplayContent(@NotNull PSString pSString) {
            Intrinsics.checkNotNullParameter((Object)pSString, (String)"<set-?>");
            this.displayContent = pSString;
        }

        @NotNull
        public final PSString getInternalContent() {
            return this.internalContent;
        }

        public final void setInternalContent(@NotNull PSString pSString) {
            Intrinsics.checkNotNullParameter((Object)pSString, (String)"<set-?>");
            this.internalContent = pSString;
        }

        @NotNull
        public final List<SerializedChatAttachment> getAttachments() {
            return this.attachments;
        }

        public final void setAttachments(@NotNull List<SerializedChatAttachment> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.attachments = list2;
        }

        @NotNull
        public final List<SerializedChatMediaMessage> getMedia() {
            return this.media;
        }

        public final void setMedia(@NotNull List<SerializedChatMediaMessage> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.media = list2;
        }

        @NotNull
        public final ChatMessageAuthor getAuthor() {
            return this.author;
        }

        public final void setAuthor(@NotNull ChatMessageAuthor chatMessageAuthor) {
            Intrinsics.checkNotNullParameter((Object)((Object)chatMessageAuthor), (String)"<set-?>");
            this.author = chatMessageAuthor;
        }

        @NotNull
        public final ChatMessageRating getRating() {
            return this.rating;
        }

        public final void setRating(@NotNull ChatMessageRating chatMessageRating) {
            Intrinsics.checkNotNullParameter((Object)((Object)chatMessageRating), (String)"<set-?>");
            this.rating = chatMessageRating;
        }

        @NotNull
        public final String getMarkupLanguageID() {
            return this.markupLanguageID;
        }

        public final void setMarkupLanguageID(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.markupLanguageID = string;
        }

        @Nullable
        public final SerializedTaskCall getTask() {
            return this.task;
        }

        public final void setTask(@Nullable SerializedTaskCall serializedTaskCall) {
            this.task = serializedTaskCall;
        }

        @NotNull
        public final String component1() {
            return this.uid;
        }

        @NotNull
        public final PSString component2() {
            return this.displayContent;
        }

        @NotNull
        public final PSString component3() {
            return this.internalContent;
        }

        @NotNull
        public final List<SerializedChatAttachment> component4() {
            return this.attachments;
        }

        @NotNull
        public final List<SerializedChatMediaMessage> component5() {
            return this.media;
        }

        @NotNull
        public final ChatMessageAuthor component6() {
            return this.author;
        }

        @NotNull
        public final ChatMessageRating component7() {
            return this.rating;
        }

        @NotNull
        public final String component8() {
            return this.markupLanguageID;
        }

        @Nullable
        public final SerializedTaskCall component9() {
            return this.task;
        }

        @NotNull
        public final SerializedChatMessage copy(@NotNull String uid, @NotNull PSString displayContent, @NotNull PSString internalContent, @NotNull List<SerializedChatAttachment> attachments, @NotNull List<SerializedChatMediaMessage> media, @NotNull ChatMessageAuthor author, @NotNull ChatMessageRating rating, @NotNull String markupLanguageID, @Nullable SerializedTaskCall task) {
            Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
            Intrinsics.checkNotNullParameter((Object)displayContent, (String)"displayContent");
            Intrinsics.checkNotNullParameter((Object)internalContent, (String)"internalContent");
            Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
            Intrinsics.checkNotNullParameter(media, (String)"media");
            Intrinsics.checkNotNullParameter((Object)((Object)author), (String)"author");
            Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
            Intrinsics.checkNotNullParameter((Object)markupLanguageID, (String)"markupLanguageID");
            return new SerializedChatMessage(uid, displayContent, internalContent, attachments, media, author, rating, markupLanguageID, task);
        }

        public static /* synthetic */ SerializedChatMessage copy$default(SerializedChatMessage serializedChatMessage, String string, PSString pSString, PSString pSString2, List list2, List list3, ChatMessageAuthor chatMessageAuthor, ChatMessageRating chatMessageRating, String string2, SerializedTaskCall serializedTaskCall, int n, Object object) {
            if ((n & 1) != 0) {
                string = serializedChatMessage.uid;
            }
            if ((n & 2) != 0) {
                pSString = serializedChatMessage.displayContent;
            }
            if ((n & 4) != 0) {
                pSString2 = serializedChatMessage.internalContent;
            }
            if ((n & 8) != 0) {
                list2 = serializedChatMessage.attachments;
            }
            if ((n & 0x10) != 0) {
                list3 = serializedChatMessage.media;
            }
            if ((n & 0x20) != 0) {
                chatMessageAuthor = serializedChatMessage.author;
            }
            if ((n & 0x40) != 0) {
                chatMessageRating = serializedChatMessage.rating;
            }
            if ((n & 0x80) != 0) {
                string2 = serializedChatMessage.markupLanguageID;
            }
            if ((n & 0x100) != 0) {
                serializedTaskCall = serializedChatMessage.task;
            }
            return serializedChatMessage.copy(string, pSString, pSString2, list2, list3, chatMessageAuthor, chatMessageRating, string2, serializedTaskCall);
        }

        @NotNull
        public String toString() {
            return "SerializedChatMessage(uid=" + this.uid + ", displayContent=" + this.displayContent + ", internalContent=" + this.internalContent + ", attachments=" + this.attachments + ", media=" + this.media + ", author=" + this.author + ", rating=" + this.rating + ", markupLanguageID=" + this.markupLanguageID + ", task=" + this.task + ")";
        }

        public int hashCode() {
            int result2 = this.uid.hashCode();
            result2 = result2 * 31 + this.displayContent.hashCode();
            result2 = result2 * 31 + this.internalContent.hashCode();
            result2 = result2 * 31 + ((Object)this.attachments).hashCode();
            result2 = result2 * 31 + ((Object)this.media).hashCode();
            result2 = result2 * 31 + this.author.hashCode();
            result2 = result2 * 31 + this.rating.hashCode();
            result2 = result2 * 31 + this.markupLanguageID.hashCode();
            result2 = result2 * 31 + (this.task == null ? 0 : this.task.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedChatMessage)) {
                return false;
            }
            SerializedChatMessage serializedChatMessage = (SerializedChatMessage)other;
            if (!Intrinsics.areEqual((Object)this.uid, (Object)serializedChatMessage.uid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayContent, (Object)serializedChatMessage.displayContent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.internalContent, (Object)serializedChatMessage.internalContent)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.attachments, serializedChatMessage.attachments)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.media, serializedChatMessage.media)) {
                return false;
            }
            if (this.author != serializedChatMessage.author) {
                return false;
            }
            if (this.rating != serializedChatMessage.rating) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.markupLanguageID, (Object)serializedChatMessage.markupLanguageID)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.task, (Object)serializedChatMessage.task);
        }

        public SerializedChatMessage() {
            this(null, null, null, null, null, null, null, null, null, 511, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChatTitle;", "", "text", "", "isCustom", "", "<init>", "(Ljava/lang/String;Z)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "()Z", "setCustom", "(Z)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class SerializedChatTitle {
        @NotNull
        private String text;
        private boolean isCustom;

        public SerializedChatTitle(@NotNull String text2, boolean isCustom) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.isCustom = isCustom;
        }

        public /* synthetic */ SerializedChatTitle(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "New Chat";
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            this(string, bl);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.text = string;
        }

        public final boolean isCustom() {
            return this.isCustom;
        }

        public final void setCustom(boolean bl) {
            this.isCustom = bl;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final boolean component2() {
            return this.isCustom;
        }

        @NotNull
        public final SerializedChatTitle copy(@NotNull String text2, boolean isCustom) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new SerializedChatTitle(text2, isCustom);
        }

        public static /* synthetic */ SerializedChatTitle copy$default(SerializedChatTitle serializedChatTitle, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = serializedChatTitle.text;
            }
            if ((n & 2) != 0) {
                bl = serializedChatTitle.isCustom;
            }
            return serializedChatTitle.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "SerializedChatTitle(text=" + this.text + ", isCustom=" + this.isCustom + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isCustom);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedChatTitle)) {
                return false;
            }
            SerializedChatTitle serializedChatTitle = (SerializedChatTitle)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)serializedChatTitle.text)) {
                return false;
            }
            return this.isCustom == serializedChatTitle.isCustom;
        }

        public SerializedChatTitle() {
            this(null, false, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J+\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedFunctionCall;", "", "currentName", "", "currentContent", "response", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$OurLLMChatFunctionMessage;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$OurLLMChatFunctionMessage;)V", "getCurrentName", "()Ljava/lang/String;", "setCurrentName", "(Ljava/lang/String;)V", "getCurrentContent", "setCurrentContent", "getResponse", "()Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$OurLLMChatFunctionMessage;", "setResponse", "(Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$OurLLMChatFunctionMessage;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class SerializedFunctionCall {
        @Nullable
        private String currentName;
        @NotNull
        private String currentContent;
        @Nullable
        private OurLLMChatFunctionMessage response;

        public SerializedFunctionCall(@Nullable String currentName, @NotNull String currentContent, @Nullable OurLLMChatFunctionMessage response) {
            Intrinsics.checkNotNullParameter((Object)currentContent, (String)"currentContent");
            this.currentName = currentName;
            this.currentContent = currentContent;
            this.response = response;
        }

        public /* synthetic */ SerializedFunctionCall(String string, String string2, OurLLMChatFunctionMessage ourLLMChatFunctionMessage, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                ourLLMChatFunctionMessage = null;
            }
            this(string, string2, ourLLMChatFunctionMessage);
        }

        @Nullable
        public final String getCurrentName() {
            return this.currentName;
        }

        public final void setCurrentName(@Nullable String string) {
            this.currentName = string;
        }

        @NotNull
        public final String getCurrentContent() {
            return this.currentContent;
        }

        public final void setCurrentContent(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.currentContent = string;
        }

        @Nullable
        public final OurLLMChatFunctionMessage getResponse() {
            return this.response;
        }

        public final void setResponse(@Nullable OurLLMChatFunctionMessage ourLLMChatFunctionMessage) {
            this.response = ourLLMChatFunctionMessage;
        }

        @Nullable
        public final String component1() {
            return this.currentName;
        }

        @NotNull
        public final String component2() {
            return this.currentContent;
        }

        @Nullable
        public final OurLLMChatFunctionMessage component3() {
            return this.response;
        }

        @NotNull
        public final SerializedFunctionCall copy(@Nullable String currentName, @NotNull String currentContent, @Nullable OurLLMChatFunctionMessage response) {
            Intrinsics.checkNotNullParameter((Object)currentContent, (String)"currentContent");
            return new SerializedFunctionCall(currentName, currentContent, response);
        }

        public static /* synthetic */ SerializedFunctionCall copy$default(SerializedFunctionCall serializedFunctionCall, String string, String string2, OurLLMChatFunctionMessage ourLLMChatFunctionMessage, int n, Object object) {
            if ((n & 1) != 0) {
                string = serializedFunctionCall.currentName;
            }
            if ((n & 2) != 0) {
                string2 = serializedFunctionCall.currentContent;
            }
            if ((n & 4) != 0) {
                ourLLMChatFunctionMessage = serializedFunctionCall.response;
            }
            return serializedFunctionCall.copy(string, string2, ourLLMChatFunctionMessage);
        }

        @NotNull
        public String toString() {
            return "SerializedFunctionCall(currentName=" + this.currentName + ", currentContent=" + this.currentContent + ", response=" + this.response + ")";
        }

        public int hashCode() {
            int result2 = this.currentName == null ? 0 : this.currentName.hashCode();
            result2 = result2 * 31 + this.currentContent.hashCode();
            result2 = result2 * 31 + (this.response == null ? 0 : this.response.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedFunctionCall)) {
                return false;
            }
            SerializedFunctionCall serializedFunctionCall = (SerializedFunctionCall)other;
            if (!Intrinsics.areEqual((Object)this.currentName, (Object)serializedFunctionCall.currentName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.currentContent, (Object)serializedFunctionCall.currentContent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.response, (Object)serializedFunctionCall.response);
        }

        public SerializedFunctionCall() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\n\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedTaskCall;", "", "content", "", "<init>", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "setContent", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class SerializedTaskCall {
        @Nullable
        private String content;

        public SerializedTaskCall(@Nullable String content2) {
            this.content = content2;
        }

        public /* synthetic */ SerializedTaskCall(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getContent() {
            return this.content;
        }

        public final void setContent(@Nullable String string) {
            this.content = string;
        }

        @Nullable
        public final String component1() {
            return this.content;
        }

        @NotNull
        public final SerializedTaskCall copy(@Nullable String content2) {
            return new SerializedTaskCall(content2);
        }

        public static /* synthetic */ SerializedTaskCall copy$default(SerializedTaskCall serializedTaskCall, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = serializedTaskCall.content;
            }
            return serializedTaskCall.copy(string);
        }

        @NotNull
        public String toString() {
            return "SerializedTaskCall(content=" + this.content + ")";
        }

        public int hashCode() {
            return this.content == null ? 0 : this.content.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializedTaskCall)) {
                return false;
            }
            SerializedTaskCall serializedTaskCall = (SerializedTaskCall)other;
            return Intrinsics.areEqual((Object)this.content, (Object)serializedTaskCall.content);
        }

        public SerializedTaskCall() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$State;", "", "<init>", "()V", "chats", "", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionStorage$SerializedChat;", "getChats", "()Ljava/util/List;", "setChats", "(Ljava/util/List;)V", "currentChatIndex", "", "getCurrentChatIndex", "()I", "setCurrentChatIndex", "(I)V", "intellij.ml.llm.chat"})
    public static final class State {
        @NotNull
        private List<SerializedChat> chats = new ArrayList();
        private int currentChatIndex;

        @NotNull
        public final List<SerializedChat> getChats() {
            return this.chats;
        }

        public final void setChats(@NotNull List<SerializedChat> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.chats = list2;
        }

        public final int getCurrentChatIndex() {
            return this.currentChatIndex;
        }

        public final void setCurrentChatIndex(int n) {
            this.currentChatIndex = n;
        }
    }
}

