/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.session.summary;

import ai.grazie.model.llm.chat.v5.LLMChat;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.session.summary.ChatSessionMessageFormatter;
import com.intellij.ml.llm.grazie.adapters.LLMChatPrivacySafe;
import com.intellij.ml.llm.grazie.adapters.PrivacySafeLLMChatBuilder;
import com.intellij.ml.llm.grazie.adapters.PrivacySafeLLMChatBuilderKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fJ$\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/session/summary/ChatSessionSummaryPromptBuilder;", "", "<init>", "()V", "formatter", "Lcom/intellij/ml/llm/core/chat/session/summary/ChatSessionMessageFormatter;", "buildSummaryPrompt", "Lcom/intellij/ml/llm/grazie/adapters/LLMChatPrivacySafe;", "messages", "", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "summarySizeInSymbols", "", "fallbackSummary", "", "Lcom/intellij/ml/llm/privacy/PSString;", "messagesText", "buildUpdateSummaryPrompt", "newMessages", "previousSummary", "existingSummary", "getSummaryMessagesSeparator", "intellij.ml.llm.chat"})
public final class ChatSessionSummaryPromptBuilder {
    @NotNull
    private final ChatSessionMessageFormatter formatter = new ChatSessionMessageFormatter();

    @NotNull
    public final LLMChatPrivacySafe buildSummaryPrompt(@NotNull List<? extends ChatMessage> messages, int summarySizeInSymbols) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return PrivacySafeLLMChatBuilderKt.buildPrivacySafe((LLMChat.Companion)LLMChat.Companion, arg_0 -> ChatSessionSummaryPromptBuilder.buildSummaryPrompt$lambda$0(messages, this, summarySizeInSymbols, arg_0));
    }

    @NotNull
    public final String fallbackSummary(@NotNull List<? extends ChatMessage> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        List recentMessages = CollectionsKt.takeLast(messages, (int)4);
        return CollectionsKt.joinToString$default((Iterable)recentMessages, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> ChatSessionSummaryPromptBuilder.fallbackSummary$lambda$0(this, arg_0), (int)30, null);
    }

    @NotNull
    public final PSString buildSummaryPrompt(@NotNull PSString messagesText, @NotNull PSString summarySizeInSymbols) {
        Intrinsics.checkNotNullParameter((Object)messagesText, (String)"messagesText");
        Intrinsics.checkNotNullParameter((Object)summarySizeInSymbols, (String)"summarySizeInSymbols");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{summarySizeInSymbols, summarySizeInSymbols, messagesText};
        return ConstantsKt.getPrivacyConst((String)"\n     <PROMPT_INSTRUCTIONS>\n\n    <!-- \n    The primary goal of this prompt is to take a potentially long and messy chat conversation \n    and distill it into a concise, structured block of text. This summary serves as the context \n    for a follow-up AI model that has a limited context window. Accuracy, brevity, and strict \n    adherence to the format are paramount.\n    -->\n\n    <ROLE>\n        You are a \"Conversational Context Compressor,\" a specialized AI engine. Your only function is to meticulously analyze the provided chat excerpt and distill it into a highly structured, token-efficient data block. You do not engage in conversation; you only summarize.\n    </ROLE>\n\n    <CONSTRAINTS>\n        <!-- These are hard limits. They must be followed without exception. -->\n        <CONSTRAINT name=\"Character Limit\">THE TOTAL OUTPUT, INCLUDING ALL LABELS AND FORMATTING, MUST NOT EXCEED %s CHARACTERS. This is a strict and critical requirement. Be as brief as possible.</CONSTRAINT>\n        <CONSTRAINT name=\"Language\">YOU MUST ALWAYS RESPOND in the primary language used in the provided \"Chat Excerpt to Summarize\".</CONSTRAINT>\n        <CONSTRAINT name=\"Format Adherence\">YOU MUST ADHERE PERFECTLY to the `<STRICT_OUTPUT_FORMAT>`. No deviation is permitted. Do not add, remove, or rename fields. Do not add any introductory text or explanations. Your output should begin directly with \"Subject:\".</CONSTRAINT>\n    </CONSTRAINTS>\n\n    <CHAIN_OF_THOUGHT>\n        <!-- Follow this internal reasoning process before generating the final output. -->\n        1.  **Subject Identification:** Scan the entire excerpt to determine the primary technical subject. Condense this into a 1-5 word title. (e.g., \"React State Management Issue\", \"Docker Network Config\").\n        2.  **Fact & Decision Extraction:** Perform a second, detailed pass. Isolate concrete technical facts, code artifacts, error messages, and explicit decisions. These will form the `Context` bullet points. Use fragments, not full sentences.\n        3.  **Next Action Isolation:** Pinpoint the very last unresolved question, pending task, or required input. This is the most critical piece of information for continuing the conversation. This will be the `Next_Action`.\n        4.  **Keyword Generation:** Based on the subject and context, generate a list of relevant technical keywords.\n        5.  **Synthesis & Validation:** Assemble the extracted information into the `<STRICT_OUTPUT_FORMAT>`. Before finalizing, verify that the total length is under the %s-character limit. If it is over, shorten the points in the `Context` and `Next_Action` fields further.\n    </CHAIN_OF_THOUGHT>\n\n    <STRICT_OUTPUT_FORMAT>\n        <!-- This is the only format you are allowed to output. -->\n        Subject: [1-5 word summary of the main topic]\n        Context:\n        - [Key technical fact, data point, or error 1]\n        - [Key technical fact, data point, or decision 2]\n        - [Key technical fact, data point, or decision 3]\n        Next_Action: [The single most important open question or required next action]\n        Keywords: [comma-separated keywords]\n    </STRICT_OUTPUT_FORMAT>\n\n    <WHAT_NOT_TO_DO>\n        -   NEVER write a narrative or paragraph-style summary.\n        -   DO NOT use conversational language (e.g., \"The user asked about...\", \"The assistant provided...\").\n        -   AVOID writing long, verbose bullet points. USE FRAGMENTS. For example, instead of \"The user confirmed that their budget for the project is $5,000,\" write \"Budget confirmed: $5,000.\"\n        -   DO NOT include pleasantries, greetings, or conversational filler.\n    </WHAT_NOT_TO_DO>\n\n    <EXAMPLES>\n        <!-- These examples demonstrate the correct input-to-output transformation. -->\n\n        <EXAMPLE name=\"API Refactoring Request\">\n            <INPUT_CHAT_EXCERPT>\n                User: My Python function for fetching data from the '/products' endpoint is using the `requests` library and it's a bit messy with nested `if` statements for error handling. Can you refactor it?\n                Assistant: Of course. I would suggest using a `try...except` block to handle potential `requests.exceptions.RequestException`. This will clean it up nicely. Here is a refactored version.\n                User: This looks much better, thanks. But now, how can I specifically handle a 404 Not Found status code to return `None` instead of raising a generic exception?\n            </INPUT_CHAT_EXCERPT>\n            <CORRECT_OUTPUT>\n                Subject: Python API Function Refactor\n                Context:\n                - Fetching from '/products' endpoint with `requests` library.\n                - Original code had messy nested `if`s.\n                - Refactored by AI to use `try...except` block.\n                Next_Action: User wants to handle HTTP 404 status specifically to return `None`.\n                Keywords: python, refactoring, api, requests, error handling, 404\n            </CORRECT_OUTPUT>\n        </EXAMPLE>\n\n        <EXAMPLE name=\"Docker Container Networking Issue\">\n            <INPUT_CHAT_EXCERPT>\n                User: My Node.js application in a Docker container can't connect to my Postgres database, which is in another container. I'm getting a `ECONNREFUSED 127.0.0.1:5432`.\n                Assistant: That error suggests your app is trying to connect to `localhost`. Inside a container, `localhost` refers to the container itself, not the host machine or other containers. Are you using `docker-compose`?\n                User: No, I'm just using `docker run` commands. My connection string is `postgres://user:pass@localhost:5432/mydb`.\n            </INPUT_CHAT_EXCERPT>\n            <CORRECT_OUTPUT>\n                Subject: Docker Container Connection Error\n                Context:\n                - Node.js container cannot connect to Postgres container.\n                - Error is `ECONNREFUSED 127.0.0.1:5432`.\n                - User is using `docker run`, not `docker-compose`.\n                - Connection string incorrectly uses `localhost`.\n                Next_Action: Advise user to create a Docker network and use the container name as the hostname.\n                Keywords: docker, postgres, nodejs, networking, econnrefused, database\n            </CORRECT_OUTPUT>\n        </EXAMPLE>\n\n    </EXAMPLES>\n\n</PROMPT_INSTRUCTIONS>\n\n<!-- The user's chat history will be injected below -->\n<CHAT_EXCERPT_TO_SUMMARIZE>\n%s\n</CHAT_EXCERPT_TO_SUMMARIZE>\n    ").format(pSStringConvertibleArray).trimIndent();
    }

    @NotNull
    public final LLMChatPrivacySafe buildUpdateSummaryPrompt(@NotNull List<? extends ChatMessage> newMessages, @NotNull PSString previousSummary, int summarySizeInSymbols) {
        Intrinsics.checkNotNullParameter(newMessages, (String)"newMessages");
        Intrinsics.checkNotNullParameter((Object)previousSummary, (String)"previousSummary");
        PSString newMessagesFormatted = PSStringKt.joinToString$default((Iterable)newMessages, (PrivacySafe)((PrivacySafe)this.getSummaryMessagesSeparator()), null, null, (int)0, null, arg_0 -> ChatSessionSummaryPromptBuilder.buildUpdateSummaryPrompt$lambda$0(this, arg_0), (int)30, null);
        PSString summarySize = PSStringOperatorsKt.toPSString((int)summarySizeInSymbols);
        PSString prompt2 = this.buildUpdateSummaryPrompt(newMessagesFormatted, previousSummary, summarySize);
        return PrivacySafeLLMChatBuilderKt.buildPrivacySafe((LLMChat.Companion)LLMChat.Companion, arg_0 -> ChatSessionSummaryPromptBuilder.buildUpdateSummaryPrompt$lambda$1(prompt2, arg_0));
    }

    private final PSString buildUpdateSummaryPrompt(PSString newMessages, PSString existingSummary, PSString summarySizeInSymbols) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{summarySizeInSymbols, summarySizeInSymbols, existingSummary, newMessages};
        return ConstantsKt.getPrivacyConst((String)"\n     <PROMPT_INSTRUCTIONS>\n\n    <!-- \n    The primary goal of this prompt is to intelligently merge an existing summary (`Current Summary`) \n    with a new piece of conversation (`New Chat Segment`). The key is fusion and pruning: new information \n    is integrated, and outdated or resolved information is discarded. The output must be a complete, \n    standalone, and highly concise summary for a follow-up AI model.\n    -->\n\n    <ROLE>\n        You are a \"Dynamic Context Updater,\" a specialized AI engine. Your sole directive is to analyze a `Current Summary` and a `New Chat Segment` to produce a single, updated, and consolidated summary. You do not engage in conversation; you only process and update context.\n    </ROLE>\n\n    <CONSTRAINTS>\n        <!-- These are hard limits. They must be followed without exception. -->\n        <CONSTRAINT name=\"Character Limit\">THE TOTAL OUTPUT, INCLUDING ALL LABELS AND FORMATTING, MUST NOT EXCEED %s CHARACTERS. This is a strict and critical requirement. Be as brief as possible.</CONSTRAINT>\n        <CONSTRAINT name=\"Language\">YOU MUST ALWAYS RESPOND in the primary language used in the provided chat segments.</CONSTRAINT>\n        <CONSTRAINT name=\"Format Adherence\">YOU MUST ADHERE PERFECTLY to the `<STRICT_OUTPUT_FORMAT>`. No deviation is permitted. Do not add, remove, or rename fields. Your output must begin directly with \"Subject:\".</CONSTRAINT>\n        <CONSTRAINT name=\"No Meta-Commentary\">NEVER produce an output that says \"Summary has been updated.\" The output MUST be the new summary itself.</CONSTRAINT>\n    </CONSTRAINTS>\n\n    <CHAIN_OF_THOUGHT>\n        <!-- Follow this internal reasoning process before generating the final output. -->\n        1.  **Deconstruct Inputs:** Parse the `<CURRENT_SUMMARY>` to understand the existing context, decisions, and the previous `Next_Action`. Then, parse the `<NEW_CHAT_SEGMENT>` to identify the new information.\n        2.  **Identify Obsolete Context:** Compare the new segment against the current summary. Has the previous `Next_Action` been answered or changed? Have any facts become irrelevant? Mark this information as obsolete. For example, if the old action was \"User needs to provide container name\" and the new message is \"The container name is `api-server`,\" the old action is now obsolete.\n        3.  **Extract New Information & Actions:** Identify the new key facts, decisions, or errors from the new segment. Determine the new `Next_Action` based on the very latest state of the conversation.\n        4.  **Synthesize New Summary:** FUSE the *relevant* context from the old summary (that which was not marked obsolete) with the new information. Update existing bullet points where possible to avoid redundancy.\n        5.  **Update Keywords:** Generate a new, consolidated list of keywords that reflects the entire updated context.\n        6.  **Final Assembly & Validation:** Construct the final output using the `<STRICT_OUTPUT_FORMAT>`. Before finalizing, verify that the total length is under the %s-character limit. If it is over, shorten the points aggressively.\n    </CHAIN_OF_THOUGHT>\n\n    <STRICT_OUTPUT_FORMAT>\n        <!-- This is the only format you are allowed to output. -->\n        Subject: [1-5 word summary of the main topic, carried over or refined from original]\n        Context:\n        - [Updated key fact, data point, or decision 1]\n        - [Updated key fact, data point, or decision 2]\n        - [Updated key fact, data point, or decision 3]\n        Next_Action: [The single most important NEW open question or required next action]\n        Keywords: [UPDATED comma-separated keywords]\n    </STRICT_OUTPUT_FORMAT>\n\n    <WHAT_NOT_TO_DO>\n        -   NEVER simply append new information to the old summary. You MUST integrate and discard.\n        -   DO NOT keep outdated information. If a question is answered, remove the question and add the answer as a fact.\n        -   AVOID redundancy. If the new message confirms something, update the relevant bullet point; do not add a new one that says \"User confirmed X.\"\n    </WHAT_NOT_TO_DO>\n\n    <EXAMPLES>\n        <!-- These examples demonstrate the correct update logic. -->\n\n        <EXAMPLE name=\"Resolving an Action and Asking a New Question\">\n            <CURRENT_SUMMARY>\n                Subject: Docker Container Connection Error\n                Context:\n                - Node.js container cannot connect to Postgres container.\n                - Error is `ECONNREFUSED 127.0.0.1:5432`.\n                - User is using `docker run`, not `docker-compose`.\n                - Connection string incorrectly uses `localhost`.\n                Next_Action: Advise user to create a Docker network and use the container name as the hostname.\n                Keywords: docker, postgres, nodejs, networking, econnrefused\n            </CURRENT_SUMMARY>\n            <NEW_CHAT_SEGMENT>\n                User: Okay, I created a `my-net` network and used `postgres-db` as the hostname. It connects now! Perfect. Now, how do I make the Postgres data persist even if I remove the container?\n            </NEW_CHAT_SEGMENT>\n            <CORRECT_UPDATED_OUTPUT>\n                Subject: Docker Container Setup\n                Context:\n                - Node.js app connects to Postgres in separate containers.\n                - Connection fixed using Docker network & container name.\n                - User is using `docker run` commands.\n                Next_Action: User wants to persist Postgres data after container removal.\n                Keywords: docker, postgres, nodejs, networking, persistence, volumes\n            </CORRECT_UPDATED_OUTPUT>\n        </EXAMPLE>\n\n        <EXAMPLE name=\"Changing the Requirement\">\n            <CURRENT_SUMMARY>\n                Subject: Python API Function Refactor\n                Context:\n                - Fetching from '/products' endpoint with `requests`.\n                - Refactored by AI to use `try...except` block.\n                Next_Action: User wants to handle HTTP 404 status specifically to return `None`.\n                Keywords: python, refactoring, api, requests, error handling, 404\n            </CURRENT_SUMMARY>\n            <NEW_CHAT_SEGMENT>\n                User: You know what, forget the 404 handling for now. It's more important to add a request timeout. Can you modify the code to include a 5-second timeout?\n            </NEW_CHAT_SEGMENT>\n            <CORRECT_UPDATED_OUTPUT>\n                Subject: Python API Function Refactor\n                Context:\n                - Fetching from '/products' endpoint with `requests`.\n                - Code was refactored to use `try...except`.\n                - Requirement changed from 404 handling to timeouts.\n                Next_Action: Add a 5-second request timeout to the API call.\n                Keywords: python, refactoring, api, requests, error handling, timeout\n            </CORRECT_UPDATED_OUTPUT>\n        </EXAMPLE>\n\n    </EXAMPLES>\n\n</PROMPT_INSTRUCTIONS>\n\n<!-- The previous summary and new user message will be injected below -->\n<CURRENT_SUMMARY>\n%s\n</CURRENT_SUMMARY>\n\n<NEW_CHAT_SEGMENT>\n%s\n</NEW_CHAT_SEGMENT>\n    ").format(pSStringConvertibleArray).trimIndent();
    }

    @NotNull
    public final PSString getSummaryMessagesSeparator() {
        return ConstantsKt.getPrivacyConst((String)"\n\n");
    }

    private static final Unit buildSummaryPrompt$lambda$0(List $messages, ChatSessionSummaryPromptBuilder this$0, int $summarySizeInSymbols, PrivacySafeLLMChatBuilder $this$buildPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildPrivacySafe, (String)"$this$buildPrivacySafe");
        PSString messagesText = PSStringKt.joinToString$default((Iterable)$messages, (PrivacySafe)((PrivacySafe)this$0.getSummaryMessagesSeparator()), null, null, (int)0, null, arg_0 -> ChatSessionSummaryPromptBuilder.buildSummaryPrompt$lambda$0$0(this$0, arg_0), (int)30, null);
        PSString prompt2 = this$0.buildSummaryPrompt(messagesText, PSStringOperatorsKt.toPSString((int)$summarySizeInSymbols));
        $this$buildPrivacySafe.user(prompt2);
        return Unit.INSTANCE;
    }

    private static final PrivacySafe buildSummaryPrompt$lambda$0$0(ChatSessionSummaryPromptBuilder this$0, ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PrivacySafe)this$0.formatter.formatMessage(it);
    }

    private static final CharSequence fallbackSummary$lambda$0(ChatSessionSummaryPromptBuilder this$0, ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)this$0.formatter.formatMessage(it);
    }

    private static final PrivacySafe buildUpdateSummaryPrompt$lambda$0(ChatSessionSummaryPromptBuilder this$0, ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PrivacySafe)this$0.formatter.formatMessage(it);
    }

    private static final Unit buildUpdateSummaryPrompt$lambda$1(PSString $prompt, PrivacySafeLLMChatBuilder $this$buildPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildPrivacySafe, (String)"$this$buildPrivacySafe");
        $this$buildPrivacySafe.user($prompt);
        return Unit.INSTANCE;
    }
}

