/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0013J\u0015\u0010\u001b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0082\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantDimensions;", "", "<init>", "()V", "defaultOuterInsets", "Lcom/intellij/util/ui/JBInsets;", "userOuterInsets", "userMiddleInsets", "assistantOuterInsets", "assistantMiddleInsets", "borderRadius", "", "extraUserMessageTextTopSpacing", "userAttachmentDropdownTopVerticalSpacing", "userAttachmentDropdownBottomVerticalSpacing", "spacingBetweenTextAndMoreButton", "assistantMessageTextVerticalSpacing", "inputBorderRadius", "inputFieldGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGaps;", "getInputBorderInsets", "getMessageBorderInsets", "author", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;", "getMessageBorder", "Ljavax/swing/border/Border;", "getAIMessageInserts", "plus", "other", "intellij.ml.llm.chat"})
public final class AIAssistantDimensions {
    @NotNull
    public static final AIAssistantDimensions INSTANCE = new AIAssistantDimensions();

    private AIAssistantDimensions() {
    }

    @NotNull
    public final JBInsets defaultOuterInsets() {
        JBInsets jBInsets = JBUI.insets((int)4, (int)20, (int)4, (int)16);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return jBInsets;
    }

    @NotNull
    public final JBInsets userOuterInsets() {
        JBInsets jBInsets = this.defaultOuterInsets();
        JBInsets jBInsets2 = JBUI.insets((int)4);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets2, (String)"insets(...)");
        return this.plus(jBInsets, jBInsets2);
    }

    @NotNull
    public final JBInsets userMiddleInsets() {
        JBInsets jBInsets = JBUI.insets((int)8, (int)16, (int)8, (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return jBInsets;
    }

    @NotNull
    public final JBInsets assistantOuterInsets() {
        return this.plus(this.defaultOuterInsets(), new JBInsets(8, 0, 16, 0));
    }

    @NotNull
    public final JBInsets assistantMiddleInsets() {
        JBInsets jBInsets = JBUI.insets((int)4);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return jBInsets;
    }

    public final int borderRadius() {
        return 6;
    }

    public final int extraUserMessageTextTopSpacing() {
        return 4;
    }

    public final int userAttachmentDropdownTopVerticalSpacing() {
        return 8;
    }

    public final int userAttachmentDropdownBottomVerticalSpacing() {
        return 4;
    }

    public final int spacingBetweenTextAndMoreButton() {
        return 4;
    }

    public final int assistantMessageTextVerticalSpacing() {
        return 8;
    }

    public final int inputBorderRadius() {
        return 6;
    }

    @NotNull
    public final UnscaledGaps inputFieldGaps() {
        return UnscaledGapsKt.UnscaledGaps((int)6, (int)8, (int)0, (int)8);
    }

    @NotNull
    public final JBInsets getInputBorderInsets() {
        return new JBInsets(12, 8, 6, 8);
    }

    @NotNull
    public final JBInsets getMessageBorderInsets(@NotNull ChatMessageAuthor author) {
        Intrinsics.checkNotNullParameter((Object)((Object)author), (String)"author");
        JBInsets outer = author == ChatMessageAuthor.User ? this.userOuterInsets() : this.assistantOuterInsets();
        JBInsets middle = author == ChatMessageAuthor.User ? this.userMiddleInsets() : this.assistantMiddleInsets();
        return this.plus(outer, middle);
    }

    @NotNull
    public final Border getMessageBorder(@NotNull ChatMessageAuthor author) {
        Intrinsics.checkNotNullParameter((Object)((Object)author), (String)"author");
        Border border = JBUI.Borders.empty((Insets)((Insets)this.getMessageBorderInsets(author)));
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"empty(...)");
        return border;
    }

    @NotNull
    public final UnscaledGaps getAIMessageInserts() {
        return UnscaledGapsKt.toUnscaledGaps((Insets)((Insets)this.getMessageBorderInsets(ChatMessageAuthor.Assistant)));
    }

    private final JBInsets plus(JBInsets $this$plus, JBInsets other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        return new JBInsets($this$plus.top + other.top, $this$plus.left + other.left, $this$plus.bottom + other.bottom, $this$plus.right + other.right);
    }
}

