/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/HtmlMdTransferable;", "Ljava/awt/datatransfer/Transferable;", "textContent", "", "htmlContent", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getTransferData", "", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "getTransferDataFlavors", "", "()[Ljava/awt/datatransfer/DataFlavor;", "intellij.ml.llm.chat"})
public final class HtmlMdTransferable
implements Transferable {
    @NotNull
    private final String textContent;
    @NotNull
    private final String htmlContent;

    public HtmlMdTransferable(@NotNull String textContent, @NotNull String htmlContent) {
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)htmlContent, (String)"htmlContent");
        this.textContent = textContent;
        this.htmlContent = htmlContent;
    }

    @Override
    @NotNull
    public Object getTransferData(@NotNull DataFlavor flavor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
        if (Intrinsics.areEqual((Object)flavor, (Object)DataFlavor.stringFlavor)) {
            string = this.textContent;
        } else if (Intrinsics.areEqual((Object)flavor, (Object)DataFlavor.fragmentHtmlFlavor)) {
            string = this.htmlContent;
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
        return string;
    }

    @Override
    public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
        Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
        return Intrinsics.areEqual((Object)flavor, (Object)DataFlavor.stringFlavor) || Intrinsics.areEqual((Object)flavor, (Object)DataFlavor.fragmentHtmlFlavor);
    }

    @Override
    @NotNull
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[2];
        Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.stringFlavor, (String)"stringFlavor");
        Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.fragmentHtmlFlavor, (String)"fragmentHtmlFlavor");
        return dataFlavorArray;
    }
}

