/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.codeSpan;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/codeSpan/FilePart;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/TextRange;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "toFullOffset", "", "offset", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.chat"})
final class FilePart {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final TextRange textRange;

    public FilePart(@NotNull VirtualFile file, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        this.file = file;
        this.textRange = textRange;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final TextRange getTextRange() {
        return this.textRange;
    }

    public final int toFullOffset(int offset) {
        return this.textRange.getStartOffset() + offset;
    }

    @NotNull
    public final VirtualFile component1() {
        return this.file;
    }

    @NotNull
    public final TextRange component2() {
        return this.textRange;
    }

    @NotNull
    public final FilePart copy(@NotNull VirtualFile file, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return new FilePart(file, textRange);
    }

    public static /* synthetic */ FilePart copy$default(FilePart filePart, VirtualFile virtualFile2, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            virtualFile2 = filePart.file;
        }
        if ((n & 2) != 0) {
            textRange = filePart.textRange;
        }
        return filePart.copy(virtualFile2, textRange);
    }

    @NotNull
    public String toString() {
        return "FilePart(file=" + this.file + ", textRange=" + this.textRange + ")";
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + this.textRange.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FilePart)) {
            return false;
        }
        FilePart filePart = (FilePart)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)filePart.file)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textRange, (Object)filePart.textRange);
    }
}

