/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context;

import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionVm;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentKind;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/AIChatModeUtil;", "", "<init>", "()V", "isInAgentMode", "", "project", "Lcom/intellij/openapi/project/Project;", "getCurrentChatMode", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "isSupported", "kind", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentKind;", "session", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionVm;", "intellij.ml.llm.chat"})
public final class AIChatModeUtil {
    @NotNull
    public static final AIChatModeUtil INSTANCE = new AIChatModeUtil();

    private AIChatModeUtil() {
    }

    public final boolean isInAgentMode(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ChatSession chatSession2 = FocusedChatSessionHost.Companion.getInstance(project).getFocusedChatSession();
        if (chatSession2 == null) {
            return false;
        }
        ChatSession chatSession3 = chatSession2;
        return chatSession3.getCurrentChatMode() instanceof NewChatMode.Agent;
    }

    @Nullable
    public final NewChatMode getCurrentChatMode(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ChatSession chatSession2 = FocusedChatSessionHost.Companion.getInstance(project).getFocusedChatSession();
        return chatSession2 != null ? chatSession2.getCurrentChatMode() : null;
    }

    public final boolean isSupported(@NotNull Project project, @NotNull ContextAttachmentKind kind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        ChatSession chatSession2 = FocusedChatSessionHost.Companion.getInstance(project).getFocusedChatSession();
        if (chatSession2 == null) {
            return false;
        }
        ChatSession session = chatSession2;
        return this.isSupported(session, kind);
    }

    public final boolean isSupported(@NotNull ChatSessionVm session, @NotNull ContextAttachmentKind kind) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        List<ContextAttachmentKind> supported = session.getCurrentChatMode().getAttachmentKindsProvider().getAllSupportedAttachments();
        return supported.contains((Object)kind) || supported.contains((Object)ContextAttachmentKind.ALL);
    }
}

