/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.SelectionProblemsChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010,\u001a\u00020-H\u0096@\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u001a\u0010\u001e\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0015R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0015\u00a8\u00064"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/SelectionProblemsContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "problems", "", "Lcom/intellij/ml/llm/privacy/PSString;", "chatSessionUid", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/context/ContextEntitySource;Ljava/util/List;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "getChatSessionUid", "()Ljava/lang/String;", "id", "getId", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "getHint", "text", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "setText", "(Lcom/intellij/ml/llm/privacy/PSString;)V", "popupPresentationText", "getPopupPresentationText", "icon", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Ljavax/swing/Icon;", "getIcon", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "tooltipText", "getTooltipText", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nSelectionProblemsContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionProblemsContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/SelectionProblemsContextAttachment\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,52:1\n112#2,5:53\n*S KotlinDebug\n*F\n+ 1 SelectionProblemsContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/SelectionProblemsContextAttachment\n*L\n50#1:53,5\n*E\n"})
public final class SelectionProblemsContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final List<PSString> problems;
    @Nullable
    private final String chatSessionUid;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final AtomicProperty<String> hint;
    @NotNull
    private PSString text;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final String tooltipText;
    @NotNull
    private static final String PREFIX = "Selected Problems";
    @NotNull
    public static final String ID = "CURRENT_SELECTION_PROBLEMS_VIA_RETRIEVER";

    public SelectionProblemsContextAttachment(@NotNull Project project, @NotNull VirtualFile virtualFile2, @NotNull ContextEntitySource attachedBy, @NotNull List<? extends PSString> problems, @Nullable String chatSessionUid) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        this.project = project;
        this.virtualFile = virtualFile2;
        this.attachedBy = attachedBy;
        this.problems = problems;
        this.chatSessionUid = chatSessionUid;
        this.name = new AtomicProperty((Object)PREFIX);
        this.hint = new AtomicProperty((Object)String.valueOf(this.problems.size()));
        this.text = PSStringKt.joinToString$default((Iterable)this.problems, (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null);
        this.popupPresentationText = LLMBundle.message((String)"problems.in.selected.code", (Object[])new Object[0]);
        this.tooltipText = LLMBundle.message((String)"problems.in.selected.code.tooltip", (Object[])new Object[0]);
    }

    public /* synthetic */ SelectionProblemsContextAttachment(Project project, VirtualFile virtualFile2, ContextEntitySource contextEntitySource, List list2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            contextEntitySource = ContextAttachmentSource.CurrentSelectionRetriever.INSTANCE;
        }
        this(project, virtualFile2, contextEntitySource, list2, string);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @Nullable
    public final String getChatSessionUid() {
        return this.chatSessionUid;
    }

    @NotNull
    public String getId() {
        return ID + this.virtualFile.getPath();
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @NotNull
    public AtomicProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    public void setText(@NotNull PSString pSString) {
        Intrinsics.checkNotNullParameter((Object)pSString, (String)"<set-?>");
        this.text = pSString;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @Override
    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return (ObservableProperty)new AtomicProperty((Object)AllIcons.General.InspectionsErrorEmpty);
    }

    @Override
    @NotNull
    public VirtualFile virtualFile() {
        return this.virtualFile;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new SelectionProblemsChatAttachment(this.getProject(), this.virtualFile, ConstantsKt.getPrivacyConst((String)"Errors in selection"), this.problems, this.getAttachedBy(), ChatAttachment.Kind.Visible, this.chatSessionUid);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performAction(boolean isInMessage) {
        CharSequence charSequence;
        CharSequence charSequence2;
        FileEditorManager fileEditorManager;
        String string;
        block1: {
            void $this$trimStart$iv;
            CharSequence charSequence3 = (CharSequence)PSStringKt.joinToString$default((Iterable)this.problems, (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, null, (int)0, null, (int)30, null);
            string = PREFIX;
            fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
            boolean $i$f$trimStart = false;
            int n = $this$trimStart$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$trimStart$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '\n') continue;
                charSequence2 = $this$trimStart$iv.subSequence(index$iv, $this$trimStart$iv.length());
                break block1;
            }
            charSequence2 = "";
        }
        CharSequence charSequence4 = charSequence = charSequence2;
        String string2 = string;
        fileEditorManager.openFile((VirtualFile)new LightVirtualFile(string2, charSequence4), true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/SelectionProblemsContextAttachment$Companion;", "", "<init>", "()V", "PREFIX", "", "ID", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

