/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.input;

import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInputEditorDropHandler;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInputEditorTextFieldKt;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInputListener;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.EmptySoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputEditorTextField;", "Lcom/intellij/ui/EditorTextField;", "project", "Lcom/intellij/openapi/project/Project;", "editorListeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputListener;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/util/EventDispatcher;)V", "getBackground", "Ljava/awt/Color;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "onEditorAdded", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "setupBorder", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantInputEditorTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantInputEditorTextField.kt\ncom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputEditorTextField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class AIAssistantInputEditorTextField
extends EditorTextField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventDispatcher<AIAssistantInputListener> editorListeners;
    private static final int MIN_HEIGHT = 40;
    @NotNull
    private static final Key<Boolean> AI_ASSISTANT_INPUT_EDITOR;

    public AIAssistantInputEditorTextField(@NotNull Project project, @NotNull EventDispatcher<AIAssistantInputListener> editorListeners) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(editorListeners, (String)"editorListeners");
        super(project, (FileType)FileTypes.PLAIN_TEXT);
        this.editorListeners = editorListeners;
        this.setOneLineMode(false);
        this.setFontInheritedFromLAF(true);
        this.addSettingsProvider(AIAssistantInputEditorTextField::_init_$lambda$0);
    }

    @NotNull
    public Color getBackground() {
        Object object = this.getEditor();
        if (object == null || (object = object.getColorsScheme()) == null || (object = object.getDefaultBackground()) == null) {
            Color color = super.getBackground();
            object = color;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        }
        return object;
    }

    @NotNull
    public Dimension getMinimumSize() {
        Dimension it = super.getMinimumSize();
        boolean bl = false;
        return new Dimension(it.width, Math.max(40, it.height));
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.max(preferredSize.width, JBUIScale.scale((int)500)), Math.max(40, preferredSize.height));
    }

    protected void onEditorAdded(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ((AIAssistantInputListener)this.editorListeners.getMulticaster()).editorAdded((EditorEx)editor);
    }

    @NotNull
    protected EditorEx createEditor() {
        EditorEx editorEx;
        EditorEx $this$createEditor_u24lambda_u240 = editorEx = super.createEditor();
        boolean bl = false;
        $this$createEditor_u24lambda_u240.setVerticalScrollbarVisible(true);
        this.setBorder((Border)JBUI.Borders.empty());
        $this$createEditor_u24lambda_u240.putUserData(FoldingUpdate.INJECTED_CODE_FOLDING_ENABLED, (Object)false);
        $this$createEditor_u24lambda_u240.putUserData(AI_ASSISTANT_INPUT_EDITOR, (Object)true);
        $this$createEditor_u24lambda_u240.setShowPlaceholderWhenFocused(true);
        ReadAction.run(() -> AIAssistantInputEditorTextField.createEditor$lambda$0$0($this$createEditor_u24lambda_u240));
        if ($this$createEditor_u24lambda_u240 instanceof EditorImpl) {
            ((EditorImpl)$this$createEditor_u24lambda_u240).getState().setDisableDefaultSoftWrapsCalculation(true);
        } else {
            AIAssistantInputEditorTextFieldKt.access$getLOG$p().info("The editor is not an instance of EditorImpl. Disabling the default soft-wrap calculation is not supported.");
        }
        $this$createEditor_u24lambda_u240.getScrollPane().setBorder(this.getBorder());
        $this$createEditor_u24lambda_u240.getContentComponent().setOpaque(false);
        SoftWrapModelEx softWrapModelEx = $this$createEditor_u24lambda_u240.getSoftWrapModel();
        Intrinsics.checkNotNull((Object)softWrapModelEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.SoftWrapModelImpl");
        ((SoftWrapModelImpl)softWrapModelEx).setSoftWrapPainter((SoftWrapPainter)EmptySoftWrapPainter.INSTANCE);
        EditorEx editorEx2 = editorEx;
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"apply(...)");
        EditorEx inputEditor = editorEx2;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        InlineCompletion.INSTANCE.install(inputEditor, AIAssistantServiceScope.Companion.getScope(project));
        ((EditorImpl)inputEditor).setDropHandler((EditorDropHandler)new AIAssistantInputEditorDropHandler((Editor)inputEditor));
        EditorImpl.DISABLE_REMOVE_ON_DROP.set((UserDataHolder)inputEditor, (Object)true);
        this.setupBorder(inputEditor);
        return inputEditor;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        DataKey dataKey = CommonDataKeys.HOST_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HOST_EDITOR");
        sink.set(dataKey, (Object)editor2);
        DataKey dataKey2 = PlatformCoreDataKeys.FILE_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"FILE_EDITOR");
        sink.set(dataKey2, (Object)TextEditorProvider.Companion.getInstance().getTextEditor(editor2));
    }

    protected void setupBorder(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.setBorder((Border)JBUI.Borders.empty((int)0, (int)6));
    }

    private static final void _init_$lambda$0(EditorEx it) {
        it.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)true);
        it.getColorsScheme().setLineSpacing(1.0f);
        it.getSettings().setUseSoftWraps(true);
        it.getSettings().setPaintSoftWraps(false);
        it.setEmbeddedIntoDialogWrapper(true);
        it.getContentComponent().setOpaque(false);
    }

    private static final void createEditor$lambda$0$0(EditorEx $this_apply) {
        $this_apply.getCaretModel().moveToOffset(0);
    }

    static {
        Key key = Key.create((String)"AI_ASSISTANT_INPUT_EDITOR");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        AI_ASSISTANT_INPUT_EDITOR = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputEditorTextField$Companion;", "", "<init>", "()V", "MIN_HEIGHT", "", "AI_ASSISTANT_INPUT_EDITOR", "Lcom/intellij/openapi/util/Key;", "", "isAIAssistantInputEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAIAssistantInputEditor(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return Intrinsics.areEqual((Object)editor.getUserData(AI_ASSISTANT_INPUT_EDITOR), (Object)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

