/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.input;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J8\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u001aR\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/InputHistoryNavigator;", "", "historyProvider", "Lkotlin/Function0;", "", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "historyIndex", "", "savedInputBeforeHistory", "isNavigating", "", "()Z", "navigateToPrevious", "currentText", "navigateToNext", "reset", "", "registerShortcuts", "component", "Ljavax/swing/JComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "textGetter", "textSetter", "Lkotlin/Function1;", "intellij.ml.llm.chat"})
public final class InputHistoryNavigator {
    @NotNull
    private final Function0<List<String>> historyProvider;
    private int historyIndex;
    @Nullable
    private String savedInputBeforeHistory;

    public InputHistoryNavigator(@NotNull Function0<? extends List<String>> historyProvider) {
        Intrinsics.checkNotNullParameter(historyProvider, (String)"historyProvider");
        this.historyProvider = historyProvider;
        this.historyIndex = -1;
    }

    public final boolean isNavigating() {
        return this.historyIndex != -1;
    }

    @Nullable
    public final String navigateToPrevious(@NotNull String currentText) {
        Intrinsics.checkNotNullParameter((Object)currentText, (String)"currentText");
        List history2 = (List)this.historyProvider.invoke();
        if (history2.isEmpty()) {
            return null;
        }
        if (this.historyIndex == -1) {
            this.savedInputBeforeHistory = currentText;
            this.historyIndex = history2.size();
        }
        if (this.historyIndex <= 0) {
            return null;
        }
        int n = this.historyIndex;
        this.historyIndex = n + -1;
        return (String)CollectionsKt.getOrNull((List)history2, (int)this.historyIndex);
    }

    @Nullable
    public final String navigateToNext() {
        List history2 = (List)this.historyProvider.invoke();
        if (history2.isEmpty() || this.historyIndex == -1) {
            return null;
        }
        int n = this.historyIndex;
        this.historyIndex = n + 1;
        if (this.historyIndex >= history2.size()) {
            String string = this.savedInputBeforeHistory;
            if (string == null) {
                string = "";
            }
            String savedText = string;
            this.historyIndex = -1;
            this.savedInputBeforeHistory = null;
            return savedText;
        }
        return (String)CollectionsKt.getOrNull((List)history2, (int)this.historyIndex);
    }

    public final void reset() {
        this.historyIndex = -1;
        this.savedInputBeforeHistory = null;
    }

    public final void registerShortcuts(@NotNull JComponent component, @NotNull Disposable disposable, @NotNull Function0<String> textGetter, @NotNull Function1<? super String, Unit> textSetter) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        Intrinsics.checkNotNullParameter(textSetter, (String)"textSetter");
        if (!Registry.Companion.is("llm.chat.arrow.up.message.editing")) {
            return;
        }
        Shortcut[] shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(38, 512), null)};
        CustomShortcutSet altUpShortcut = new CustomShortcutSet(shortcutArray);
        Shortcut[] shortcutArray2 = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(40, 512), null)};
        CustomShortcutSet altDownShortcut = new CustomShortcutSet(shortcutArray2);
        DumbAwareAction.create(arg_0 -> InputHistoryNavigator.registerShortcuts$lambda$1(arg_0 -> InputHistoryNavigator.registerShortcuts$lambda$0(this, textGetter, textSetter, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)altUpShortcut, component, disposable);
        DumbAwareAction.create(arg_0 -> InputHistoryNavigator.registerShortcuts$lambda$3(arg_0 -> InputHistoryNavigator.registerShortcuts$lambda$2(this, textSetter, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)altDownShortcut, component, disposable);
    }

    private static final Unit registerShortcuts$lambda$0(InputHistoryNavigator this$0, Function0 $textGetter, Function1 $textSetter, AnActionEvent it) {
        String string = this$0.navigateToPrevious((String)$textGetter.invoke());
        if (string == null) {
            return Unit.INSTANCE;
        }
        String text2 = string;
        $textSetter.invoke((Object)text2);
        return Unit.INSTANCE;
    }

    private static final void registerShortcuts$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerShortcuts$lambda$2(InputHistoryNavigator this$0, Function1 $textSetter, AnActionEvent it) {
        String string = this$0.navigateToNext();
        if (string == null) {
            return Unit.INSTANCE;
        }
        String text2 = string;
        $textSetter.invoke((Object)text2);
        return Unit.INSTANCE;
    }

    private static final void registerShortcuts$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

