/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.ml.llm.core.statistics.fus.AgentAllowedNamesProvider;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0006H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AgentChatNameValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "<init>", "()V", "acpNames", "", "", "allowedNames", "getRuleId", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "intellij.ml.llm.chat"})
public final class AgentChatNameValidator
extends CustomValidationRule {
    @NotNull
    private final Set<String> acpNames;
    @NotNull
    private final Set<String> allowedNames;

    public AgentChatNameValidator() {
        Object[] objectArray = new String[]{"auggie", "cagent", "code-assistant", "codex-acp", "cursor-agent", "goose", "grok", "kimi", "opencode", "stakpak", "vtcode"};
        this.acpNames = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"Gemini", "junie", "claude-code", "codex", "chat", "other", "embedded"};
        this.allowedNames = SetsKt.plus(this.acpNames, (Iterable)SetsKt.setOf((Object[])objectArray));
    }

    @NotNull
    public String getRuleId() {
        return "chat_agent_name";
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.allowedNames.contains(data2)) {
            return ValidationResultType.ACCEPTED;
        }
        if (AgentAllowedNamesProvider.Companion.getAllNames().contains(data2)) {
            return ValidationResultType.ACCEPTED;
        }
        return ValidationResultType.THIRD_PARTY;
    }
}

