/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.ml.llm.agents.AUIEvent;
import com.intellij.ml.llm.agents.AgentClient;
import com.intellij.ml.llm.agents.AgentClientEvent;
import com.intellij.ml.llm.aui.events.api.ActionInputResponse;
import com.intellij.ml.llm.aui.events.api.AgentEvent;
import com.intellij.ml.llm.aui.events.api.AgentFailureEvent;
import com.intellij.ml.llm.aui.events.api.AgentThoughtBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ApproveInputResponse;
import com.intellij.ml.llm.aui.events.api.AskInputResponse;
import com.intellij.ml.llm.aui.events.api.AskRequestUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ChoiceInputResponse;
import com.intellij.ml.llm.aui.events.api.ChoiceRequestUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.FileChange;
import com.intellij.ml.llm.aui.events.api.FileChangesBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.InputResponse;
import com.intellij.ml.llm.aui.events.api.LlmResponseMetadataEvent;
import com.intellij.ml.llm.aui.events.api.MarkdownBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.McpBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.MessageBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ModelUsage;
import com.intellij.ml.llm.aui.events.api.ResultBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.StepStatus;
import com.intellij.ml.llm.aui.events.api.TerminalBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.TestRunBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ToolBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ViewFilesBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.extensions.AUITaskState;
import com.intellij.ml.llm.aui.events.extensions.TaskRequestId;
import com.intellij.ml.llm.chat.session.FileChangesMergeUtil;
import com.intellij.ml.llm.chat.session.FileChangesTracker;
import com.intellij.ml.llm.chat.session.SessionHistoryStorage;
import com.intellij.ml.llm.core.statistics.fus.AgentChatEventLogger;
import com.intellij.ml.llm.core.statistics.fus.AgentChatStatisticCollectorKt;
import com.intellij.ml.llm.core.statistics.fus.FileChangeStats;
import com.intellij.ml.llm.core.statistics.fus.FileChangeStatsKt;
import com.intellij.ml.llm.core.statistics.fus.FusTaskExitStatus;
import com.intellij.ml.llm.core.statistics.fus.UserResponse;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import io.ktor.util.collections.ConcurrentSetKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J4\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010 J&\u0010!\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010#J0\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020%J\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\nJ\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020%H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\tH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector;", "", "<init>", "()V", "activities", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/aui/events/extensions/TaskRequestId;", "Lcom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector$RequestLifecycle;", "userResponses", "", "Lcom/intellij/ml/llm/aui/events/api/InputResponse;", "loggedEvents", "", "logAgentClientEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;", "taskRequestId", "agentClient", "Lcom/intellij/ml/llm/agents/AgentClient;", "event", "Lcom/intellij/ml/llm/agents/AgentClientEvent;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;Lcom/intellij/ml/llm/aui/events/extensions/TaskRequestId;Lcom/intellij/ml/llm/agents/AgentClient;Lcom/intellij/ml/llm/agents/AgentClientEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logAgentRollback", "totalPromptsRolledBack", "", "changes", "", "Lcom/intellij/ml/llm/aui/events/api/FileChange;", "agentId", "(Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;ILjava/util/List;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logSingleRollback", "change", "(Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;Lcom/intellij/ml/llm/aui/events/api/FileChange;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logAgentMessageEvent", "Lcom/intellij/ml/llm/aui/events/api/MessageBlockUpdatedEvent;", "saveUserResponse", "response", "shouldEventBeLogged", "", "resolveUserResponse", "Lcom/intellij/ml/llm/core/statistics/fus/UserResponse;", "stepId", "RequestLifecycle", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAgentChatStatisticCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentChatStatisticCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1563#2:261\n1634#2,3:262\n1563#2:265\n1634#2,3:266\n1#3:269\n*S KotlinDebug\n*F\n+ 1 AgentChatStatisticCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector\n*L\n111#1:261\n111#1:262,3\n115#1:265\n115#1:266,3\n*E\n"})
public final class AgentChatStatisticCollector {
    @NotNull
    public static final AgentChatStatisticCollector INSTANCE = new AgentChatStatisticCollector();
    @NotNull
    private static final ConcurrentHashMap<TaskRequestId, RequestLifecycle> activities = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, InputResponse> userResponses = new ConcurrentHashMap();
    @NotNull
    private static final Set<String> loggedEvents = ConcurrentSetKt.ConcurrentSet();

    private AgentChatStatisticCollector() {
    }

    @Nullable
    public final Object logAgentClientEvent(@NotNull Project project, @Nullable SessionHistoryStorage.PersistanceId sessionId, @NotNull TaskRequestId taskRequestId, @NotNull AgentClient agentClient, @NotNull AgentClientEvent event, @NotNull Continuation<? super Unit> $completion) {
        FusTaskExitStatus exitStatus;
        AgentEvent innerEvent;
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        if (!(event instanceof AUIEvent)) {
            return Unit.INSTANCE;
        }
        if (AgentChatStatisticCollectorKt.access$isTerminalState(((AUIEvent)event).getState()) && activities.get(taskRequestId) == null) {
            return Unit.INSTANCE;
        }
        RequestLifecycle requestLifecycle = activities.computeIfAbsent(taskRequestId, arg_0 -> AgentChatStatisticCollector.logAgentClientEvent$lambda$1(arg_0 -> AgentChatStatisticCollector.logAgentClientEvent$lambda$0(project, agentClient, sessionId, taskRequestId, event, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)requestLifecycle, (String)"computeIfAbsent(...)");
        RequestLifecycle requestState = requestLifecycle;
        AgentEvent agentEvent = innerEvent = ((AUIEvent)event).getEvent();
        if (agentEvent instanceof FileChangesBlockUpdatedEvent) {
            requestState.recordChanges((FileChangesBlockUpdatedEvent)innerEvent);
        } else if (agentEvent instanceof ResultBlockUpdatedEvent) {
            requestState.recordChanges((ResultBlockUpdatedEvent)innerEvent);
        } else if (agentEvent instanceof LlmResponseMetadataEvent) {
            requestState.recordTokenUsage(((LlmResponseMetadataEvent)innerEvent).getModelUsage());
        }
        AgentEvent agentEvent2 = innerEvent;
        FusTaskExitStatus fusTaskExitStatus = agentEvent2 instanceof AgentFailureEvent ? FusTaskExitStatus.FAILED : (exitStatus = agentEvent2 instanceof ResultBlockUpdatedEvent ? AgentChatStatisticCollectorKt.access$toFusExitStatus((ResultBlockUpdatedEvent)innerEvent) : null);
        if (exitStatus != null) {
            AgentChatEventLogger.INSTANCE.logGenerationFinished$intellij_ml_llm_chat(requestState.getIdeActivity(), agentClient, sessionId, taskRequestId, requestState.computeStats(), exitStatus, requestState.getInputTokens(), requestState.getOutputTokens(), requestState.getCacheInputTokens(), requestState.getCacheOutputTokens());
            activities.remove(taskRequestId);
            userResponses.clear();
            loggedEvents.clear();
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object logAgentRollback(@NotNull SessionHistoryStorage.PersistanceId sessionId, int totalPromptsRolledBack, @NotNull List<FileChange> changes, @NotNull String agentId, @NotNull Continuation<? super Unit> $completion) {
        Collection<FileChangeStats> collection;
        FileChange it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        Iterable $this$map$iv = FileChangesMergeUtil.INSTANCE.mergeFileChanges(changes);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FileChangesMergeUtil.FileChangesMerged fileChangesMerged = (FileChangesMergeUtil.FileChangesMerged)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getMergedChange());
        }
        List mergedChanges = (List)destination$iv$iv;
        $this$map$iv = mergedChanges;
        int n = totalPromptsRolledBack;
        SessionHistoryStorage.PersistanceId persistanceId = sessionId;
        object = AgentChatEventLogger.INSTANCE;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FileChange)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileChangeStatsKt.computeStats(it));
        }
        collection = (List)destination$iv$iv;
        ((AgentChatEventLogger)((Object)object)).logGenerationsRejected$intellij_ml_llm_chat(persistanceId, n, (List<FileChangeStats>)collection, agentId);
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object logSingleRollback(@NotNull SessionHistoryStorage.PersistanceId sessionId, @NotNull FileChange change, @NotNull String agentId, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        AgentChatEventLogger.INSTANCE.logRollbackFile$intellij_ml_llm_chat(sessionId, FileChangeStatsKt.computeStats(change), agentId);
        return Unit.INSTANCE;
    }

    public final void logAgentMessageEvent(@NotNull Project project, @NotNull String agentId, @Nullable SessionHistoryStorage.PersistanceId sessionId, @NotNull TaskRequestId taskRequestId, @NotNull MessageBlockUpdatedEvent event) {
        block3: {
            UserResponse userResponse;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter((Object)taskRequestId, (String)"taskRequestId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.shouldEventBeLogged(event)) {
                return;
            }
            String string = event.getStepId();
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                userResponse = this.resolveUserResponse(p0);
            } else {
                userResponse = null;
            }
            UserResponse userResponse2 = userResponse;
            AgentChatEventLogger.INSTANCE.logAgentEvent$intellij_ml_llm_chat(project, agentId, sessionId, taskRequestId, userResponse2, event);
            String string2 = event.getStepId();
            if (string2 == null) break block3;
            String it = string2;
            boolean bl = false;
            loggedEvents.add(it);
        }
    }

    public final void saveUserResponse(@NotNull InputResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ((Map)userResponses).put(response.getRequestId(), response);
    }

    private final boolean shouldEventBeLogged(MessageBlockUpdatedEvent event) {
        boolean bl;
        if (CollectionsKt.contains((Iterable)loggedEvents, (Object)event.getStepId())) {
            return false;
        }
        MessageBlockUpdatedEvent messageBlockUpdatedEvent = event;
        if (messageBlockUpdatedEvent instanceof AgentThoughtBlockUpdatedEvent) {
            bl = true;
        } else if (messageBlockUpdatedEvent instanceof FileChangesBlockUpdatedEvent) {
            bl = ((FileChangesBlockUpdatedEvent)event).getStatus() != StepStatus.IN_PROGRESS;
        } else if (messageBlockUpdatedEvent instanceof McpBlockUpdatedEvent) {
            bl = ((McpBlockUpdatedEvent)event).getStatus() != StepStatus.IN_PROGRESS;
        } else if (messageBlockUpdatedEvent instanceof TerminalBlockUpdatedEvent) {
            bl = ((TerminalBlockUpdatedEvent)event).getStatus() != StepStatus.IN_PROGRESS;
        } else if (messageBlockUpdatedEvent instanceof TestRunBlockUpdatedEvent) {
            bl = ((TestRunBlockUpdatedEvent)event).getStatus() != StepStatus.IN_PROGRESS;
        } else if (messageBlockUpdatedEvent instanceof ToolBlockUpdatedEvent) {
            bl = ((ToolBlockUpdatedEvent)event).getStatus() != StepStatus.IN_PROGRESS;
        } else if (messageBlockUpdatedEvent instanceof ViewFilesBlockUpdatedEvent) {
            bl = ((ViewFilesBlockUpdatedEvent)event).getStatus() != StepStatus.IN_PROGRESS;
        } else if (messageBlockUpdatedEvent instanceof AskRequestUpdatedEvent) {
            bl = ((AskRequestUpdatedEvent)event).getStatus() != StepStatus.IN_PROGRESS;
        } else if (messageBlockUpdatedEvent instanceof ChoiceRequestUpdatedEvent) {
            bl = ((ChoiceRequestUpdatedEvent)event).getStatus() != StepStatus.IN_PROGRESS;
        } else if (messageBlockUpdatedEvent instanceof MarkdownBlockUpdatedEvent) {
            bl = true;
        } else if (messageBlockUpdatedEvent instanceof ResultBlockUpdatedEvent) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final UserResponse resolveUserResponse(String stepId) {
        UserResponse userResponse;
        InputResponse inputResponse = userResponses.get(stepId);
        if (inputResponse == null) return null;
        InputResponse it = inputResponse;
        boolean bl = false;
        InputResponse inputResponse2 = it;
        if (inputResponse2 instanceof ActionInputResponse) {
            userResponse = UserResponse.OTHER;
            return userResponse;
        } else if (inputResponse2 instanceof ApproveInputResponse) {
            userResponse = ((ApproveInputResponse)it).getApprove() ? UserResponse.ALLOW : UserResponse.REJECT;
            return userResponse;
        } else if (inputResponse2 instanceof AskInputResponse) {
            if (Intrinsics.areEqual((Object)((AskInputResponse)it).getAuto(), (Object)true)) {
                return null;
            }
            userResponse = UserResponse.TEXT;
            return userResponse;
        } else {
            if (!(inputResponse2 instanceof ChoiceInputResponse)) throw new NoWhenBranchMatchedException();
            userResponse = UserResponse.Companion.toUserResponse(((ChoiceInputResponse)it).getOptionId());
        }
        return userResponse;
    }

    private static final RequestLifecycle logAgentClientEvent$lambda$0(Project $project, AgentClient $agentClient, SessionHistoryStorage.PersistanceId $sessionId, TaskRequestId $taskRequestId, AgentClientEvent $event, TaskRequestId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StructuredIdeActivity ideActivity = AgentChatEventLogger.INSTANCE.logGenerationStarted($project, $agentClient, $sessionId, $taskRequestId);
        return new RequestLifecycle($taskRequestId, ((AUIEvent)$event).getState(), ideActivity);
    }

    private static final RequestLifecycle logAgentClientEvent$lambda$1(Function1 $tmp0, Object p0) {
        return (RequestLifecycle)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013J\u0014\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001fJ\u0006\u0010#\u001a\u00020\u0015J\u0006\u0010$\u001a\u00020\u0015J\u0006\u0010%\u001a\u00020\u0015J\u0006\u0010&\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector$RequestLifecycle;", "", "taskRequestId", "Lcom/intellij/ml/llm/aui/events/extensions/TaskRequestId;", "state", "Lcom/intellij/ml/llm/aui/events/extensions/AUITaskState;", "ideActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "<init>", "(Lcom/intellij/ml/llm/aui/events/extensions/TaskRequestId;Lcom/intellij/ml/llm/aui/events/extensions/AUITaskState;Lcom/intellij/internal/statistic/StructuredIdeActivity;)V", "getTaskRequestId", "()Lcom/intellij/ml/llm/aui/events/extensions/TaskRequestId;", "getState", "()Lcom/intellij/ml/llm/aui/events/extensions/AUITaskState;", "getIdeActivity", "()Lcom/intellij/internal/statistic/StructuredIdeActivity;", "fileChangesTracker", "Lcom/intellij/ml/llm/chat/session/FileChangesTracker;", "resultEvent", "Lcom/intellij/ml/llm/aui/events/api/ResultBlockUpdatedEvent;", "inputTokens", "", "outputTokens", "cacheInputTokens", "cacheOutputTokens", "recordChanges", "", "event", "Lcom/intellij/ml/llm/aui/events/api/FileChangesBlockUpdatedEvent;", "recordTokenUsage", "usages", "", "Lcom/intellij/ml/llm/aui/events/api/ModelUsage;", "computeStats", "Lcom/intellij/ml/llm/core/statistics/fus/FileChangeStats;", "getInputTokens", "getOutputTokens", "getCacheInputTokens", "getCacheOutputTokens", "intellij.ml.llm.chat"})
    @SourceDebugExtension(value={"SMAP\nAgentChatStatisticCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentChatStatisticCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector$RequestLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n1869#2,2:261\n1563#2:263\n1634#2,3:264\n*S KotlinDebug\n*F\n+ 1 AgentChatStatisticCollector.kt\ncom/intellij/ml/llm/core/statistics/fus/AgentChatStatisticCollector$RequestLifecycle\n*L\n163#1:261,2\n174#1:263\n174#1:264,3\n*E\n"})
    private static final class RequestLifecycle {
        @NotNull
        private final TaskRequestId taskRequestId;
        @Nullable
        private final AUITaskState state;
        @NotNull
        private final StructuredIdeActivity ideActivity;
        @NotNull
        private final FileChangesTracker fileChangesTracker;
        @Nullable
        private ResultBlockUpdatedEvent resultEvent;
        private long inputTokens;
        private long outputTokens;
        private long cacheInputTokens;
        private long cacheOutputTokens;

        public RequestLifecycle(@NotNull TaskRequestId taskRequestId, @Nullable AUITaskState state, @NotNull StructuredIdeActivity ideActivity) {
            Intrinsics.checkNotNullParameter((Object)taskRequestId, (String)"taskRequestId");
            Intrinsics.checkNotNullParameter((Object)ideActivity, (String)"ideActivity");
            this.taskRequestId = taskRequestId;
            this.state = state;
            this.ideActivity = ideActivity;
            this.fileChangesTracker = new FileChangesTracker();
        }

        @NotNull
        public final TaskRequestId getTaskRequestId() {
            return this.taskRequestId;
        }

        @Nullable
        public final AUITaskState getState() {
            return this.state;
        }

        @NotNull
        public final StructuredIdeActivity getIdeActivity() {
            return this.ideActivity;
        }

        public final void recordChanges(@NotNull FileChangesBlockUpdatedEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.fileChangesTracker.recordChanges(event);
        }

        public final void recordChanges(@NotNull ResultBlockUpdatedEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.resultEvent = event;
        }

        public final void recordTokenUsage(@NotNull List<ModelUsage> usages) {
            Intrinsics.checkNotNullParameter(usages, (String)"usages");
            Iterable $this$forEach$iv = usages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModelUsage usage = (ModelUsage)element$iv;
                boolean bl = false;
                Long l = usage.getInputTokens();
                this.inputTokens += l != null ? l : 0L;
                Long l2 = usage.getOutputTokens();
                this.outputTokens += l2 != null ? l2 : 0L;
                Long l3 = usage.getCacheInputTokens();
                this.cacheInputTokens += l3 != null ? l3 : 0L;
                Long l4 = usage.getCacheCreateTokens();
                this.cacheOutputTokens += l4 != null ? l4 : 0L;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<FileChangeStats> computeStats() {
            void $this$mapTo$iv$iv;
            Object object = this.resultEvent;
            if (object == null || (object = object.getChanges()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object lastMomentChanges = object;
            List<FileChange> changes = this.fileChangesTracker.buildResultChanges((List<FileChange>)lastMomentChanges);
            Iterable $this$map$iv = changes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileChange fileChange = (FileChange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileChangeStatsKt.computeStats((FileChange)it));
            }
            return (List)destination$iv$iv;
        }

        public final long getInputTokens() {
            return this.inputTokens;
        }

        public final long getOutputTokens() {
            return this.outputTokens;
        }

        public final long getCacheInputTokens() {
            return this.cacheInputTokens;
        }

        public final long getCacheOutputTokens() {
            return this.cacheOutputTokens;
        }
    }
}

