/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.telemetry;

import com.intellij.ml.llm.agents.AgentClient;
import com.intellij.ml.llm.agents.AgentClientEvent;
import com.intellij.ml.llm.aui.events.api.AgentCurrentStatusUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.AgentEvent;
import com.intellij.ml.llm.aui.events.api.AgentFailureEvent;
import com.intellij.ml.llm.aui.events.api.AgentPatchCreatedEvent;
import com.intellij.ml.llm.aui.events.api.AgentPlanUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.AgentStateUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.AgentTaskNameUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.AgentThoughtBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.AskRequestUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ChoiceOption;
import com.intellij.ml.llm.aui.events.api.ChoiceRequestUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.CurrentDirectoryUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.EnvironmentVariablesUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.File;
import com.intellij.ml.llm.aui.events.api.FileChange;
import com.intellij.ml.llm.aui.events.api.FileChangesBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.LlmResponseMetadataEvent;
import com.intellij.ml.llm.aui.events.api.MarkdownBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.McpBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ModelUsage;
import com.intellij.ml.llm.aui.events.api.PlanItem;
import com.intellij.ml.llm.aui.events.api.ResultBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.StepStatus;
import com.intellij.ml.llm.aui.events.api.TerminalBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.TestResultEx;
import com.intellij.ml.llm.aui.events.api.TestRunBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ToolBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.ViewFilesBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.extensions.TaskRequestId;
import com.intellij.ml.llm.chat.session.SessionHistoryStorage;
import com.intellij.ml.llm.core.chat.OpenTelemetryUtilsKt;
import com.intellij.ml.llm.core.statistics.telemetry.AgentEventTelemetryCollector;
import com.intellij.ml.llm.core.statistics.telemetry.AgentEventTelemetryCollector$ErrorInfo$;
import com.intellij.ml.llm.core.statistics.telemetry.AgentEventTelemetryCollector$SourceEventInfo$;
import com.intellij.ml.llm.core.statistics.telemetry.AgentEventTelemetryCollectorKt;
import com.intellij.ml.llm.registry.EvaluationKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.extension.kotlin.ContextExtensionsKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 _2\u00020\u0001:\u0007YZ[\\]^_B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0015J\u0012\u0010\u001a\u001a\u00020\u0015*\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\"\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020\u0011*\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020'2\u0006\u0010\u0016\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020'2\u0006\u0010\u0016\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020'2\u0006\u0010\u0016\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020'2\u0006\u0010\u0016\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020'2\u0006\u0010\u0016\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020LH\u0002J\u0012\u0010M\u001a\u00020$2\b\u0010N\u001a\u0004\u0018\u00010OH\u0002J\u000e\u0010P\u001a\u0004\u0018\u00010Q*\u00020OH\u0002J\u0016\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020V0UH\u0002J\u0010\u0010W\u001a\u00020$2\u0006\u0010X\u001a\u00020SH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;", "taskRequestId", "Lcom/intellij/ml/llm/aui/events/extensions/TaskRequestId;", "agentClient", "Lcom/intellij/ml/llm/agents/AgentClient;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/chat/session/SessionHistoryStorage$PersistanceId;Lcom/intellij/ml/llm/aui/events/extensions/TaskRequestId;Lcom/intellij/ml/llm/agents/AgentClient;)V", "activeStreamingSpans", "", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$StreamingKey;", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$StreamingState;", "taskSpan", "Lio/opentelemetry/api/trace/Span;", "taskContext", "Lio/opentelemetry/context/Context;", "logAgentClientEvent", "", "event", "Lcom/intellij/ml/llm/agents/AgentClientEvent;", "(Lcom/intellij/ml/llm/agents/AgentClientEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logAgentTaskFinished", "report", "Lio/opentelemetry/api/trace/SpanBuilder;", "(Lio/opentelemetry/api/trace/SpanBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "completeStream", "streamingKey", "createEventSpanBuilder", "eventContext", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventContext;", "parentContext", "isStreaming", "", "addEventAttributes", "parse", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventData;", "Lcom/intellij/ml/llm/aui/events/api/AgentEvent;", "parseCurrentStatusUpdate", "Lcom/intellij/ml/llm/aui/events/api/AgentCurrentStatusUpdatedEvent;", "parseFailure", "Lcom/intellij/ml/llm/aui/events/api/AgentFailureEvent;", "parsePatchCreated", "Lcom/intellij/ml/llm/aui/events/api/AgentPatchCreatedEvent;", "parsePlanUpdate", "Lcom/intellij/ml/llm/aui/events/api/AgentPlanUpdatedEvent;", "parseStateUpdate", "Lcom/intellij/ml/llm/aui/events/api/AgentStateUpdatedEvent;", "parseAgentTaskNameUpdate", "Lcom/intellij/ml/llm/aui/events/api/AgentTaskNameUpdatedEvent;", "parseLlmResponseMetadata", "Lcom/intellij/ml/llm/aui/events/api/LlmResponseMetadataEvent;", "parseAgentThoughtUpdate", "Lcom/intellij/ml/llm/aui/events/api/AgentThoughtBlockUpdatedEvent;", "parseFileChangesUpdate", "Lcom/intellij/ml/llm/aui/events/api/FileChangesBlockUpdatedEvent;", "parseTerminalUpdate", "Lcom/intellij/ml/llm/aui/events/api/TerminalBlockUpdatedEvent;", "parseMcpUpdate", "Lcom/intellij/ml/llm/aui/events/api/McpBlockUpdatedEvent;", "parseMarkdownUpdate", "Lcom/intellij/ml/llm/aui/events/api/MarkdownBlockUpdatedEvent;", "parseTestRunUpdate", "Lcom/intellij/ml/llm/aui/events/api/TestRunBlockUpdatedEvent;", "parseToolUpdate", "Lcom/intellij/ml/llm/aui/events/api/ToolBlockUpdatedEvent;", "parseViewFilesUpdate", "Lcom/intellij/ml/llm/aui/events/api/ViewFilesBlockUpdatedEvent;", "parseAskRequestUpdate", "Lcom/intellij/ml/llm/aui/events/api/AskRequestUpdatedEvent;", "parseChoiceRequestUpdate", "Lcom/intellij/ml/llm/aui/events/api/ChoiceRequestUpdatedEvent;", "parseResultUpdate", "Lcom/intellij/ml/llm/aui/events/api/ResultBlockUpdatedEvent;", "isCompletedEvent", "eventStatus", "Lcom/intellij/ml/llm/aui/events/api/StepStatus;", "toErrorInfo", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$ErrorInfo;", "formatFileChanges", "", "changes", "", "Lcom/intellij/ml/llm/aui/events/api/FileChange;", "ignoreTaskStateForEvent", "eventClassName", "ErrorInfo", "SourceEventInfo", "EventData", "EventContext", "StreamingKey", "StreamingState", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAgentEventTelemetryCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentEventTelemetryCollector.kt\ncom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,519:1\n50#2,5:520\n87#2,2:525\n56#2,3:527\n98#2:530\n90#2,6:531\n205#3:537\n205#3:538\n205#3:545\n52#4,2:539\n29#4,3:541\n54#4:544\n*S KotlinDebug\n*F\n+ 1 AgentEventTelemetryCollector.kt\ncom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector\n*L\n190#1:520,5\n190#1:525,2\n190#1:527,3\n190#1:530\n190#1:531,6\n212#1:537\n237#1:538\n329#1:545\n330#1:539,2\n332#1:541,3\n330#1:544\n*E\n"})
public final class AgentEventTelemetryCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SessionHistoryStorage.PersistanceId sessionId;
    @NotNull
    private final TaskRequestId taskRequestId;
    @NotNull
    private final AgentClient agentClient;
    @NotNull
    private final Map<StreamingKey, StreamingState> activeStreamingSpans;
    @Nullable
    private Span taskSpan;
    @Nullable
    private Context taskContext;
    @NotNull
    private static final Set<String> immediatelyReportedEvents;

    public AgentEventTelemetryCollector(@NotNull Project project, @NotNull SessionHistoryStorage.PersistanceId sessionId, @NotNull TaskRequestId taskRequestId, @NotNull AgentClient agentClient) {
        Context context;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)taskRequestId, (String)"taskRequestId");
        Intrinsics.checkNotNullParameter((Object)agentClient, (String)"agentClient");
        this.project = project;
        this.sessionId = sessionId;
        this.taskRequestId = taskRequestId;
        this.agentClient = agentClient;
        this.activeStreamingSpans = new LinkedHashMap();
        this.taskSpan = Companion.isTelemetryEnabled() ? OpenTelemetryUtilsKt.aiOtel("Agent task").setAttribute("sessionId", this.sessionId.getId()).setAttribute("taskRequestId", this.taskRequestId.getId()).setAttribute("agentId", this.agentClient.getAgentId()).setAttribute("input", "").setAttribute("output", "").startSpan() : null;
        AgentEventTelemetryCollector agentEventTelemetryCollector = this;
        Span span = this.taskSpan;
        if (span != null) {
            Span span2 = span;
            AgentEventTelemetryCollector agentEventTelemetryCollector2 = agentEventTelemetryCollector;
            boolean bl = false;
            context = Context.current().with((ImplicitContextKeyed)this.taskSpan);
            agentEventTelemetryCollector = agentEventTelemetryCollector2;
        } else {
            context = null;
        }
        agentEventTelemetryCollector.taskContext = context;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object logAgentClientEvent(@NotNull AgentClientEvent event, @NotNull Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 6[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void logAgentTaskFinished() {
        if (!Companion.isTelemetryEnabled()) {
            return;
        }
        try {
            List incompleteStreams = CollectionsKt.toList((Iterable)this.activeStreamingSpans.keySet());
            for (StreamingKey key : incompleteStreams) {
                this.completeStream(key);
            }
        }
        catch (Throwable exn) {
            if (exn instanceof ControlFlowException) {
                throw exn;
            }
            if (exn instanceof CancellationException) {
                throw exn;
            }
            AgentEventTelemetryCollectorKt.access$getLogger$p().warn("Failed to complete event logging", exn);
        }
        Span span = this.taskSpan;
        if (span != null) {
            span.end();
        }
        this.taskSpan = null;
        this.taskContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object report(SpanBuilder $this$report, Continuation<? super Unit> $completion) {
        if (!($completion instanceof report.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ AgentEventTelemetryCollector this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AgentEventTelemetryCollector.access$report(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$useWithScope_u24default$iv = $this$report;
                context$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                $i$f$useWithScope = 0;
                v0 = $this$useWithScope_u24default$iv.startSpan();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"startSpan(...)");
                $this$useWithoutActiveScope$iv$iv = v0;
                $i$f$useWithoutActiveScope = 0;
                span$iv = $this$useWithoutActiveScope$iv$iv;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = 0;
                v1 = Context.current().with((ImplicitContextKeyed)span$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"with(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$report);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$useWithScope_u24default$iv);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)context$iv);
                $continuation.L$3 = $this$useWithoutActiveScope$iv$iv;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)span$iv);
                $continuation.I$0 = $i$f$useWithScope;
                $continuation.I$1 = $i$f$useWithoutActiveScope;
                $continuation.I$2 = $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)context$iv.plus(ContextExtensionsKt.asContextElement((Context)v1)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(span$iv, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Span $span;
                    {
                        this.$span = $span;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$withContext;
                                ResultKt.throwOnFailure((Object)$result);
                                Continuation continuation = (Continuation)this;
                                Span span = this.$span;
                                void $this$report_u24lambda_u240 = $this$withContext;
                                boolean bl = false;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var14_5) goto lbl37
lbl36:
                // 1 sources

                return var14_5;
lbl37:
                // 1 sources

                ** GOTO lbl52
            }
            case 1: {
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = $continuation.I$2;
                $i$f$useWithoutActiveScope = $continuation.I$1;
                $i$f$useWithScope = $continuation.I$0;
                span$iv = (Span)$continuation.L$4;
                $this$useWithoutActiveScope$iv$iv = (Span)$continuation.L$3;
                context$iv = (CoroutineContext)$continuation.L$2;
                $this$useWithScope_u24default$iv = (SpanBuilder)$continuation.L$1;
                $this$report = (SpanBuilder)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl52:
                    // 2 sources

                    var10_19 = v2;
                    ** GOTO lbl65
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
            }
            catch (Throwable var11_22) {
                throw var11_22;
            }
            {
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
lbl65:
                // 1 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void completeStream(StreamingKey streamingKey) {
        block0: {
            StreamingState streamingState = this.activeStreamingSpans.remove(streamingKey);
            StreamingState streamingState2 = streamingState;
            if (streamingState2 == null || (streamingState2 = streamingState2.getSpan()) == null || (streamingState2 = this.addEventAttributes((Span)streamingState2, streamingState.getLastEvent())) == null) break block0;
            streamingState2.end();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SpanBuilder createEventSpanBuilder(EventContext eventContext, Context parentContext, boolean isStreaming) {
        void this_$iv;
        EventData eventData = eventContext.getEventData();
        SpanBuilder spanBuilder = OpenTelemetryUtilsKt.aiOtel(eventData.getSpanName()).setAttribute("streaming", isStreaming).setAttribute("sessionId", this.sessionId.getId()).setAttribute("taskRequestId", this.taskRequestId.getId()).setAttribute("agentId", this.agentClient.getAgentId()).setAttribute("stepId", eventData.getStepId());
        Json json = (Json)Json.Default;
        SourceEventInfo value$iv = eventContext.getSourceEvent();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        SpanBuilder spanBuilder2 = spanBuilder.setAttribute("event", this_$iv.encodeToString((SerializationStrategy)SourceEventInfo.Companion.serializer(), (Object)value$iv)).setAttribute("input", eventData.getInput()).setAttribute("output", eventData.getOutput());
        ErrorInfo errorInfo = eventData.getErrorInfo();
        if (errorInfo != null) {
            spanBuilder2.setAttribute("error.type", errorInfo.getType());
            spanBuilder2.setAttribute("error.message", errorInfo.getMessage());
        }
        if (parentContext != null) {
            spanBuilder2.setParent(parentContext);
        }
        Intrinsics.checkNotNull((Object)spanBuilder2);
        return spanBuilder2;
    }

    /*
     * WARNING - void declaration
     */
    private final Span addEventAttributes(Span $this$addEventAttributes, EventContext eventContext) {
        void this_$iv;
        EventData eventData = eventContext.getEventData();
        Span span = $this$addEventAttributes.setAttribute("streaming", false).setAttribute("sessionId", this.sessionId.getId()).setAttribute("taskRequestId", this.taskRequestId.getId()).setAttribute("agentId", this.agentClient.getAgentId()).setAttribute("stepId", eventData.getStepId());
        Json json = (Json)Json.Default;
        SourceEventInfo value$iv = eventContext.getSourceEvent();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        Span span2 = span.setAttribute("event", this_$iv.encodeToString((SerializationStrategy)SourceEventInfo.Companion.serializer(), (Object)value$iv));
        String string = eventData.getInput();
        if (string == null) {
            string = "";
        }
        Span span3 = span2.setAttribute("input", string);
        String string2 = eventData.getOutput();
        if (string2 == null) {
            string2 = "";
        }
        span3.setAttribute("output", string2);
        ErrorInfo errorInfo = eventData.getErrorInfo();
        if (errorInfo != null) {
            $this$addEventAttributes.setAttribute("error.type", errorInfo.getType());
            $this$addEventAttributes.setAttribute("error.message", errorInfo.getMessage());
        }
        return $this$addEventAttributes;
    }

    private final EventData parse(AgentEvent event) {
        EventData eventData;
        AgentEvent agentEvent = event;
        if (agentEvent instanceof AgentCurrentStatusUpdatedEvent) {
            eventData = this.parseCurrentStatusUpdate((AgentCurrentStatusUpdatedEvent)event);
        } else if (agentEvent instanceof AgentFailureEvent) {
            eventData = this.parseFailure((AgentFailureEvent)event);
        } else if (agentEvent instanceof AgentPatchCreatedEvent) {
            eventData = this.parsePatchCreated((AgentPatchCreatedEvent)event);
        } else if (agentEvent instanceof AgentPlanUpdatedEvent) {
            eventData = this.parsePlanUpdate((AgentPlanUpdatedEvent)event);
        } else if (agentEvent instanceof AgentStateUpdatedEvent) {
            eventData = this.parseStateUpdate((AgentStateUpdatedEvent)event);
        } else if (agentEvent instanceof AgentTaskNameUpdatedEvent) {
            eventData = this.parseAgentTaskNameUpdate((AgentTaskNameUpdatedEvent)event);
        } else if (agentEvent instanceof LlmResponseMetadataEvent) {
            eventData = this.parseLlmResponseMetadata((LlmResponseMetadataEvent)event);
        } else if (agentEvent instanceof AgentThoughtBlockUpdatedEvent) {
            eventData = this.parseAgentThoughtUpdate((AgentThoughtBlockUpdatedEvent)event);
        } else if (agentEvent instanceof FileChangesBlockUpdatedEvent) {
            eventData = this.parseFileChangesUpdate((FileChangesBlockUpdatedEvent)event);
        } else if (agentEvent instanceof McpBlockUpdatedEvent) {
            eventData = this.parseMcpUpdate((McpBlockUpdatedEvent)event);
        } else if (agentEvent instanceof TerminalBlockUpdatedEvent) {
            eventData = this.parseTerminalUpdate((TerminalBlockUpdatedEvent)event);
        } else if (agentEvent instanceof TestRunBlockUpdatedEvent) {
            eventData = this.parseTestRunUpdate((TestRunBlockUpdatedEvent)event);
        } else if (agentEvent instanceof ToolBlockUpdatedEvent) {
            eventData = this.parseToolUpdate((ToolBlockUpdatedEvent)event);
        } else if (agentEvent instanceof ViewFilesBlockUpdatedEvent) {
            eventData = this.parseViewFilesUpdate((ViewFilesBlockUpdatedEvent)event);
        } else if (agentEvent instanceof AskRequestUpdatedEvent) {
            eventData = this.parseAskRequestUpdate((AskRequestUpdatedEvent)event);
        } else if (agentEvent instanceof ChoiceRequestUpdatedEvent) {
            eventData = this.parseChoiceRequestUpdate((ChoiceRequestUpdatedEvent)event);
        } else if (agentEvent instanceof MarkdownBlockUpdatedEvent) {
            eventData = this.parseMarkdownUpdate((MarkdownBlockUpdatedEvent)event);
        } else if (agentEvent instanceof ResultBlockUpdatedEvent) {
            eventData = this.parseResultUpdate((ResultBlockUpdatedEvent)event);
        } else if (agentEvent instanceof CurrentDirectoryUpdatedEvent) {
            eventData = new EventData("", true, null, null, null, null, null, 124, null);
        } else if (agentEvent instanceof EnvironmentVariablesUpdatedEvent) {
            eventData = new EventData("", true, null, null, null, null, null, 124, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return eventData;
    }

    private final EventData parseCurrentStatusUpdate(AgentCurrentStatusUpdatedEvent event) {
        String string = event.getStatus();
        if (string == null) {
            string = "";
        }
        return new EventData("Status updated", true, null, null, string, null, null, 108, null);
    }

    private final EventData parseFailure(AgentFailureEvent event) {
        return new EventData("Reported failure", true, null, null, event.getMessage(), null, new ErrorInfo("failure", event.getMessage()), 44, null);
    }

    private final EventData parsePatchCreated(AgentPatchCreatedEvent event) {
        return new EventData("Patch created", true, null, null, event.getPatch(), null, null, 108, null);
    }

    private final EventData parsePlanUpdate(AgentPlanUpdatedEvent event) {
        return new EventData("Plan updated", true, null, null, CollectionsKt.joinToString$default((Iterable)event.getItems(), (CharSequence)"\n", null, null, (int)0, null, AgentEventTelemetryCollector::parsePlanUpdate$lambda$0, (int)30, null), null, null, 108, null);
    }

    private final EventData parseStateUpdate(AgentStateUpdatedEvent event) {
        return new EventData("State updated", true, null, null, null, null, null, 124, null);
    }

    private final EventData parseAgentTaskNameUpdate(AgentTaskNameUpdatedEvent event) {
        return new EventData("Task name updated", true, null, null, event.getName(), null, null, 108, null);
    }

    /*
     * WARNING - void declaration
     */
    private final EventData parseLlmResponseMetadata(LlmResponseMetadataEvent event) {
        void this_$iv;
        JsonArrayBuilder builder$iv;
        Json json = (Json)Json.Default;
        boolean $i$f$buildJsonArray = false;
        JsonArrayBuilder jsonArrayBuilder = builder$iv = new JsonArrayBuilder();
        String string = null;
        String string2 = null;
        boolean bl = true;
        String string3 = "Response metadata";
        boolean bl2 = false;
        for (ModelUsage usage : event.getModelUsage()) {
            void $this$parseLlmResponseMetadata_u24lambda_u240_u240;
            void $this$parseLlmResponseMetadata_u24lambda_u240;
            JsonObjectBuilder builder$iv2;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder jsonObjectBuilder = builder$iv2 = new JsonObjectBuilder();
            void var12_18 = $this$parseLlmResponseMetadata_u24lambda_u240;
            boolean bl3 = false;
            $this$parseLlmResponseMetadata_u24lambda_u240_u240.put("model", (JsonElement)JsonElementKt.JsonPrimitive((String)usage.getModel()));
            $this$parseLlmResponseMetadata_u24lambda_u240_u240.put("inputTokens", (JsonElement)JsonElementKt.JsonPrimitive((Number)usage.getInputTokens()));
            $this$parseLlmResponseMetadata_u24lambda_u240_u240.put("outputTokens", (JsonElement)JsonElementKt.JsonPrimitive((Number)usage.getOutputTokens()));
            $this$parseLlmResponseMetadata_u24lambda_u240_u240.put("cacheCreateTokens", (JsonElement)JsonElementKt.JsonPrimitive((Number)usage.getCacheCreateTokens()));
            $this$parseLlmResponseMetadata_u24lambda_u240_u240.put("cacheInputTokens", (JsonElement)JsonElementKt.JsonPrimitive((Number)usage.getCacheInputTokens()));
            $this$parseLlmResponseMetadata_u24lambda_u240_u240.put("cost", (JsonElement)JsonElementKt.JsonPrimitive((Number)usage.getCost()));
            $this$parseLlmResponseMetadata_u24lambda_u240_u240.put("time", (JsonElement)JsonElementKt.JsonPrimitive((Number)usage.getTime()));
            var12_18.add((JsonElement)builder$iv2.build());
        }
        Unit unit = Unit.INSTANCE;
        JsonArray value$iv = builder$iv.build();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 108;
        ErrorInfo errorInfo = null;
        String string4 = null;
        String string5 = this_$iv.encodeToString((SerializationStrategy)JsonArray.Companion.serializer(), (Object)value$iv);
        String string6 = string;
        String string7 = string2;
        boolean bl4 = bl;
        String string8 = string3;
        return new EventData(string8, bl4, string7, string6, string5, string4, errorInfo, n, defaultConstructorMarker);
    }

    private final EventData parseAgentThoughtUpdate(AgentThoughtBlockUpdatedEvent event) {
        return new EventData("Thinking", true, event.getStepId(), null, event.getText(), null, null, 104, null);
    }

    private final EventData parseFileChangesUpdate(FileChangesBlockUpdatedEvent event) {
        StepStatus stepStatus = event.getStatus();
        return new EventData("File changes block updated", this.isCompletedEvent(event.getStatus()), event.getStepId(), null, this.formatFileChanges(event.getChanges()), null, stepStatus != null ? this.toErrorInfo(stepStatus) : null, 40, null);
    }

    private final EventData parseTerminalUpdate(TerminalBlockUpdatedEvent event) {
        String string;
        boolean bl = this.isCompletedEvent(event.getStatus());
        String string2 = event.getStepId();
        String string3 = event.getCommand();
        if (string3 == null) {
            string3 = "";
        }
        if ((string = event.getOutput()) == null) {
            string = "";
        }
        StepStatus stepStatus = event.getStatus();
        return new EventData("Terminal command", bl, string2, string3, string, event.getDetails(), stepStatus != null ? this.toErrorInfo(stepStatus) : null);
    }

    private final EventData parseMcpUpdate(McpBlockUpdatedEvent event) {
        StepStatus stepStatus = event.getStatus();
        return new EventData("MCP tool call", this.isCompletedEvent(event.getStatus()), event.getStepId(), event.getToolName(), null, event.getDetails(), stepStatus != null ? this.toErrorInfo(stepStatus) : null, 16, null);
    }

    private final EventData parseMarkdownUpdate(MarkdownBlockUpdatedEvent event) {
        return new EventData("Text response", true, event.getStepId(), null, event.getText(), null, null, 104, null);
    }

    private final EventData parseTestRunUpdate(TestRunBlockUpdatedEvent event) {
        StringBuilder stringBuilder;
        StringBuilder $this$parseTestRunUpdate_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$parseTestRunUpdate_u24lambda_u240;
        Object object = event.getResult();
        if (object == null || (object = object.name()) == null) {
            object = "";
        }
        stringBuilder2.append("result: " + (String)object).append('\n');
        stringBuilder2 = $this$parseTestRunUpdate_u24lambda_u240;
        TestResultEx testResultEx = event.getResultEx();
        stringBuilder2.append("passed: " + (testResultEx != null ? testResultEx.getPassed() : 0)).append('\n');
        stringBuilder2 = $this$parseTestRunUpdate_u24lambda_u240;
        TestResultEx testResultEx2 = event.getResultEx();
        stringBuilder2.append("failed: " + (testResultEx2 != null ? testResultEx2.getFailed() : 0)).append('\n');
        stringBuilder2 = $this$parseTestRunUpdate_u24lambda_u240;
        TestResultEx testResultEx3 = event.getResultEx();
        stringBuilder2.append("skipped: " + (testResultEx3 != null ? testResultEx3.getSkipped() : 0)).append('\n');
        String testResult = stringBuilder.toString();
        StepStatus stepStatus = event.getStatus();
        return new EventData("Test run", this.isCompletedEvent(event.getStatus()), event.getStepId(), null, testResult, event.getDetails(), stepStatus != null ? this.toErrorInfo(stepStatus) : null, 8, null);
    }

    private final EventData parseToolUpdate(ToolBlockUpdatedEvent event) {
        boolean bl = this.isCompletedEvent(event.getStatus());
        String string = event.getStepId();
        Object object = event.getToolType();
        if (object == null || (object = object.name()) == null) {
            object = "";
        }
        StepStatus stepStatus = event.getStatus();
        return new EventData("Tool call", bl, string, (String)object, event.getText(), event.getDetails(), stepStatus != null ? this.toErrorInfo(stepStatus) : null);
    }

    private final EventData parseViewFilesUpdate(ViewFilesBlockUpdatedEvent event) {
        StepStatus stepStatus = event.getStatus();
        return new EventData("View files", this.isCompletedEvent(event.getStatus()), event.getStepId(), CollectionsKt.joinToString$default((Iterable)event.getFiles(), (CharSequence)"\n", null, null, (int)0, null, AgentEventTelemetryCollector::parseViewFilesUpdate$lambda$0, (int)30, null), null, event.getDetails(), stepStatus != null ? this.toErrorInfo(stepStatus) : null, 16, null);
    }

    private final EventData parseAskRequestUpdate(AskRequestUpdatedEvent event) {
        StringBuilder stringBuilder;
        StringBuilder $this$parseAskRequestUpdate_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$parseAskRequestUpdate_u24lambda_u240.append("title: " + event.getTitle()).append('\n');
        $this$parseAskRequestUpdate_u24lambda_u240.append("question: " + event.getAskRequest().getQuestion()).append('\n');
        String output = stringBuilder.toString();
        StepStatus stepStatus = event.getStatus();
        return new EventData("Ask request", this.isCompletedEvent(event.getStatus()), event.getStepId(), null, output, null, stepStatus != null ? this.toErrorInfo(stepStatus) : null, 40, null);
    }

    private final EventData parseChoiceRequestUpdate(ChoiceRequestUpdatedEvent event) {
        StringBuilder stringBuilder;
        StringBuilder $this$parseChoiceRequestUpdate_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$parseChoiceRequestUpdate_u24lambda_u240.append("title: " + event.getTitle()).append('\n');
        for (ChoiceOption option : event.getChoiceRequest().getOptions()) {
            $this$parseChoiceRequestUpdate_u24lambda_u240.append("option " + option.getId() + ": " + option.getDescription()).append('\n');
        }
        String output = stringBuilder.toString();
        StepStatus stepStatus = event.getStatus();
        return new EventData("Choice request updated", this.isCompletedEvent(event.getStatus()), event.getStepId(), null, output, null, stepStatus != null ? this.toErrorInfo(stepStatus) : null, 40, null);
    }

    private final EventData parseResultUpdate(ResultBlockUpdatedEvent event) {
        return new EventData("Result block updated", true, event.getStepId(), null, event.getResult(), this.formatFileChanges(event.getChanges()), null, 72, null);
    }

    private final boolean isCompletedEvent(StepStatus eventStatus) {
        return eventStatus == null || eventStatus != StepStatus.IN_PROGRESS;
    }

    private final ErrorInfo toErrorInfo(StepStatus $this$toErrorInfo) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toErrorInfo.ordinal()]) {
            case 1 -> null;
            case 2 -> null;
            case 3 -> new ErrorInfo("canceled", "Canceled by the user");
            case 4 -> new ErrorInfo("rejected", "Rejected by the user");
            case 5 -> new ErrorInfo("failed", "Execution failed with an exception");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatFileChanges(List<FileChange> changes) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatFileChanges_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (FileChange change : changes) {
            $this$formatFileChanges_u24lambda_u240.append("beforeRelativePath: " + change.getBeforeRelativePath()).append('\n');
            $this$formatFileChanges_u24lambda_u240.append("afterRelativePath: " + change.getAfterRelativePath()).append('\n');
            $this$formatFileChanges_u24lambda_u240.append('\n');
        }
        return stringBuilder.toString();
    }

    private final boolean ignoreTaskStateForEvent(String eventClassName) {
        return immediatelyReportedEvents.contains(eventClassName);
    }

    private static final CharSequence parsePlanUpdate$lambda$0(PlanItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStatus().name() + " " + it.getDescription();
    }

    private static final CharSequence parseViewFilesUpdate$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRelativePath();
    }

    @JvmStatic
    public static final boolean isTelemetryEnabled() {
        return Companion.isTelemetryEnabled();
    }

    public static final /* synthetic */ Object access$report(AgentEventTelemetryCollector $this, SpanBuilder $receiver, Continuation $completion) {
        return $this.report($receiver, (Continuation<? super Unit>)$completion);
    }

    static {
        Object[] objectArray = new String[]{"AgentPlanUpdatedEvent", "LlmResponseMetadataEvent"};
        immediatelyReportedEvents = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$Companion;", "", "<init>", "()V", "isTelemetryEnabled", "", "immediatelyReportedEvents", "", "", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isTelemetryEnabled() {
            return Registry.Companion.is("llm.chat.agent.event.telemetry.enabled") || EvaluationKt.isInEvaluationMode();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$ErrorInfo;", "", "type", "", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getType", "()Ljava/lang/String;", "getMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_chat", "$serializer", "Companion", "intellij.ml.llm.chat"})
    private static final class ErrorInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String type;
        @NotNull
        private final String message;

        public ErrorInfo(@NotNull String type, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.type = type;
            this.message = message;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final ErrorInfo copy(@NotNull String type, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new ErrorInfo(type, message);
        }

        public static /* synthetic */ ErrorInfo copy$default(ErrorInfo errorInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = errorInfo.type;
            }
            if ((n & 2) != 0) {
                string2 = errorInfo.message;
            }
            return errorInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ErrorInfo(type=" + this.type + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorInfo)) {
                return false;
            }
            ErrorInfo errorInfo = (ErrorInfo)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)errorInfo.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)errorInfo.message);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_chat(ErrorInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.type);
            output.encodeStringElement(serialDesc, 1, self.message);
        }

        public /* synthetic */ ErrorInfo(int seen0, String type, String message, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)ErrorInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.type = type;
            this.message = message;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$ErrorInfo$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$ErrorInfo;", "intellij.ml.llm.chat"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ErrorInfo> serializer() {
                return (KSerializer)ErrorInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventContext;", "", "sourceEvent", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$SourceEventInfo;", "eventData", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventData;", "<init>", "(Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$SourceEventInfo;Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventData;)V", "getSourceEvent", "()Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$SourceEventInfo;", "getEventData", "()Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventData;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
    private static final class EventContext {
        @NotNull
        private final SourceEventInfo sourceEvent;
        @NotNull
        private final EventData eventData;

        public EventContext(@NotNull SourceEventInfo sourceEvent, @NotNull EventData eventData) {
            Intrinsics.checkNotNullParameter((Object)sourceEvent, (String)"sourceEvent");
            Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
            this.sourceEvent = sourceEvent;
            this.eventData = eventData;
        }

        @NotNull
        public final SourceEventInfo getSourceEvent() {
            return this.sourceEvent;
        }

        @NotNull
        public final EventData getEventData() {
            return this.eventData;
        }

        @NotNull
        public final SourceEventInfo component1() {
            return this.sourceEvent;
        }

        @NotNull
        public final EventData component2() {
            return this.eventData;
        }

        @NotNull
        public final EventContext copy(@NotNull SourceEventInfo sourceEvent, @NotNull EventData eventData) {
            Intrinsics.checkNotNullParameter((Object)sourceEvent, (String)"sourceEvent");
            Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
            return new EventContext(sourceEvent, eventData);
        }

        public static /* synthetic */ EventContext copy$default(EventContext eventContext, SourceEventInfo sourceEventInfo, EventData eventData, int n, Object object) {
            if ((n & 1) != 0) {
                sourceEventInfo = eventContext.sourceEvent;
            }
            if ((n & 2) != 0) {
                eventData = eventContext.eventData;
            }
            return eventContext.copy(sourceEventInfo, eventData);
        }

        @NotNull
        public String toString() {
            return "EventContext(sourceEvent=" + this.sourceEvent + ", eventData=" + this.eventData + ")";
        }

        public int hashCode() {
            int result2 = this.sourceEvent.hashCode();
            result2 = result2 * 31 + this.eventData.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EventContext)) {
                return false;
            }
            EventContext eventContext = (EventContext)other;
            if (!Intrinsics.areEqual((Object)this.sourceEvent, (Object)eventContext.sourceEvent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.eventData, (Object)eventContext.eventData);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JU\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventData;", "", "spanName", "", "isCompleted", "", "stepId", "input", "output", "details", "errorInfo", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$ErrorInfo;", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$ErrorInfo;)V", "getSpanName", "()Ljava/lang/String;", "()Z", "getStepId", "getInput", "getOutput", "getDetails", "getErrorInfo", "()Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$ErrorInfo;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    private static final class EventData {
        @NotNull
        private final String spanName;
        private final boolean isCompleted;
        @Nullable
        private final String stepId;
        @NotNull
        private final String input;
        @NotNull
        private final String output;
        @Nullable
        private final String details;
        @Nullable
        private final ErrorInfo errorInfo;

        public EventData(@NotNull String spanName, boolean isCompleted, @Nullable String stepId, @NotNull String input, @NotNull String output, @Nullable String details, @Nullable ErrorInfo errorInfo) {
            Intrinsics.checkNotNullParameter((Object)spanName, (String)"spanName");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.spanName = spanName;
            this.isCompleted = isCompleted;
            this.stepId = stepId;
            this.input = input;
            this.output = output;
            this.details = details;
            this.errorInfo = errorInfo;
        }

        public /* synthetic */ EventData(String string, boolean bl, String string2, String string3, String string4, String string5, ErrorInfo errorInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = "";
            }
            if ((n & 0x10) != 0) {
                string4 = "";
            }
            if ((n & 0x20) != 0) {
                string5 = null;
            }
            if ((n & 0x40) != 0) {
                errorInfo = null;
            }
            this(string, bl, string2, string3, string4, string5, errorInfo);
        }

        @NotNull
        public final String getSpanName() {
            return this.spanName;
        }

        public final boolean isCompleted() {
            return this.isCompleted;
        }

        @Nullable
        public final String getStepId() {
            return this.stepId;
        }

        @NotNull
        public final String getInput() {
            return this.input;
        }

        @NotNull
        public final String getOutput() {
            return this.output;
        }

        @Nullable
        public final String getDetails() {
            return this.details;
        }

        @Nullable
        public final ErrorInfo getErrorInfo() {
            return this.errorInfo;
        }

        @NotNull
        public final String component1() {
            return this.spanName;
        }

        public final boolean component2() {
            return this.isCompleted;
        }

        @Nullable
        public final String component3() {
            return this.stepId;
        }

        @NotNull
        public final String component4() {
            return this.input;
        }

        @NotNull
        public final String component5() {
            return this.output;
        }

        @Nullable
        public final String component6() {
            return this.details;
        }

        @Nullable
        public final ErrorInfo component7() {
            return this.errorInfo;
        }

        @NotNull
        public final EventData copy(@NotNull String spanName, boolean isCompleted, @Nullable String stepId, @NotNull String input, @NotNull String output, @Nullable String details, @Nullable ErrorInfo errorInfo) {
            Intrinsics.checkNotNullParameter((Object)spanName, (String)"spanName");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return new EventData(spanName, isCompleted, stepId, input, output, details, errorInfo);
        }

        public static /* synthetic */ EventData copy$default(EventData eventData, String string, boolean bl, String string2, String string3, String string4, String string5, ErrorInfo errorInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string = eventData.spanName;
            }
            if ((n & 2) != 0) {
                bl = eventData.isCompleted;
            }
            if ((n & 4) != 0) {
                string2 = eventData.stepId;
            }
            if ((n & 8) != 0) {
                string3 = eventData.input;
            }
            if ((n & 0x10) != 0) {
                string4 = eventData.output;
            }
            if ((n & 0x20) != 0) {
                string5 = eventData.details;
            }
            if ((n & 0x40) != 0) {
                errorInfo = eventData.errorInfo;
            }
            return eventData.copy(string, bl, string2, string3, string4, string5, errorInfo);
        }

        @NotNull
        public String toString() {
            return "EventData(spanName=" + this.spanName + ", isCompleted=" + this.isCompleted + ", stepId=" + this.stepId + ", input=" + this.input + ", output=" + this.output + ", details=" + this.details + ", errorInfo=" + this.errorInfo + ")";
        }

        public int hashCode() {
            int result2 = this.spanName.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isCompleted);
            result2 = result2 * 31 + (this.stepId == null ? 0 : this.stepId.hashCode());
            result2 = result2 * 31 + this.input.hashCode();
            result2 = result2 * 31 + this.output.hashCode();
            result2 = result2 * 31 + (this.details == null ? 0 : this.details.hashCode());
            result2 = result2 * 31 + (this.errorInfo == null ? 0 : this.errorInfo.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EventData)) {
                return false;
            }
            EventData eventData = (EventData)other;
            if (!Intrinsics.areEqual((Object)this.spanName, (Object)eventData.spanName)) {
                return false;
            }
            if (this.isCompleted != eventData.isCompleted) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stepId, (Object)eventData.stepId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.input, (Object)eventData.input)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.output, (Object)eventData.output)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.details, (Object)eventData.details)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorInfo, (Object)eventData.errorInfo);
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 (2\u00020\u0001:\u0002'(B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tBC\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$SourceEventInfo;", "", "className", "", "type", "state", "source", "Lcom/intellij/ml/llm/aui/events/api/AgentEvent;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/aui/events/api/AgentEvent;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/aui/events/api/AgentEvent;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getClassName", "()Ljava/lang/String;", "getType", "getState", "getSource", "()Lcom/intellij/ml/llm/aui/events/api/AgentEvent;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_chat", "$serializer", "Companion", "intellij.ml.llm.chat"})
    private static final class SourceEventInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String className;
        @NotNull
        private final String type;
        @Nullable
        private final String state;
        @NotNull
        private final AgentEvent source;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public SourceEventInfo(@NotNull String className, @NotNull String type, @Nullable String state, @NotNull AgentEvent source2) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            this.className = className;
            this.type = type;
            this.state = state;
            this.source = source2;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String getState() {
            return this.state;
        }

        @NotNull
        public final AgentEvent getSource() {
            return this.source;
        }

        @NotNull
        public final String component1() {
            return this.className;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @Nullable
        public final String component3() {
            return this.state;
        }

        @NotNull
        public final AgentEvent component4() {
            return this.source;
        }

        @NotNull
        public final SourceEventInfo copy(@NotNull String className, @NotNull String type, @Nullable String state, @NotNull AgentEvent source2) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new SourceEventInfo(className, type, state, source2);
        }

        public static /* synthetic */ SourceEventInfo copy$default(SourceEventInfo sourceEventInfo, String string, String string2, String string3, AgentEvent agentEvent, int n, Object object) {
            if ((n & 1) != 0) {
                string = sourceEventInfo.className;
            }
            if ((n & 2) != 0) {
                string2 = sourceEventInfo.type;
            }
            if ((n & 4) != 0) {
                string3 = sourceEventInfo.state;
            }
            if ((n & 8) != 0) {
                agentEvent = sourceEventInfo.source;
            }
            return sourceEventInfo.copy(string, string2, string3, agentEvent);
        }

        @NotNull
        public String toString() {
            return "SourceEventInfo(className=" + this.className + ", type=" + this.type + ", state=" + this.state + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.className.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + (this.state == null ? 0 : this.state.hashCode());
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceEventInfo)) {
                return false;
            }
            SourceEventInfo sourceEventInfo = (SourceEventInfo)other;
            if (!Intrinsics.areEqual((Object)this.className, (Object)sourceEventInfo.className)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)sourceEventInfo.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.state, (Object)sourceEventInfo.state)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)sourceEventInfo.source);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_chat(SourceEventInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.className);
            output.encodeStringElement(serialDesc, 1, self.type);
            output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.state);
            output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)lazyArray[3].getValue(), (Object)self.source);
        }

        public /* synthetic */ SourceEventInfo(int seen0, String className, String type, String state, AgentEvent source2, SerializationConstructorMarker serializationConstructorMarker) {
            if (15 != (0xF & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)SourceEventInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.className = className;
            this.type = type;
            this.state = state;
            this.source = source2;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> AgentEvent.Companion.serializer())};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$SourceEventInfo$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$SourceEventInfo;", "intellij.ml.llm.chat"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<SourceEventInfo> serializer() {
                return (KSerializer)SourceEventInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$StreamingKey;", "", "eventClass", "", "stepId", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getEventClass", "()Ljava/lang/String;", "getStepId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    private static final class StreamingKey {
        @NotNull
        private final String eventClass;
        @Nullable
        private final String stepId;

        public StreamingKey(@NotNull String eventClass, @Nullable String stepId) {
            Intrinsics.checkNotNullParameter((Object)eventClass, (String)"eventClass");
            this.eventClass = eventClass;
            this.stepId = stepId;
        }

        public /* synthetic */ StreamingKey(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @NotNull
        public final String getEventClass() {
            return this.eventClass;
        }

        @Nullable
        public final String getStepId() {
            return this.stepId;
        }

        @NotNull
        public final String component1() {
            return this.eventClass;
        }

        @Nullable
        public final String component2() {
            return this.stepId;
        }

        @NotNull
        public final StreamingKey copy(@NotNull String eventClass, @Nullable String stepId) {
            Intrinsics.checkNotNullParameter((Object)eventClass, (String)"eventClass");
            return new StreamingKey(eventClass, stepId);
        }

        public static /* synthetic */ StreamingKey copy$default(StreamingKey streamingKey, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = streamingKey.eventClass;
            }
            if ((n & 2) != 0) {
                string2 = streamingKey.stepId;
            }
            return streamingKey.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "StreamingKey(eventClass=" + this.eventClass + ", stepId=" + this.stepId + ")";
        }

        public int hashCode() {
            int result2 = this.eventClass.hashCode();
            result2 = result2 * 31 + (this.stepId == null ? 0 : this.stepId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StreamingKey)) {
                return false;
            }
            StreamingKey streamingKey = (StreamingKey)other;
            if (!Intrinsics.areEqual((Object)this.eventClass, (Object)streamingKey.eventClass)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stepId, (Object)streamingKey.stepId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$StreamingState;", "", "span", "Lio/opentelemetry/api/trace/Span;", "lastEvent", "Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventContext;", "<init>", "(Lio/opentelemetry/api/trace/Span;Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventContext;)V", "getSpan", "()Lio/opentelemetry/api/trace/Span;", "getLastEvent", "()Lcom/intellij/ml/llm/core/statistics/telemetry/AgentEventTelemetryCollector$EventContext;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
    private static final class StreamingState {
        @NotNull
        private final Span span;
        @NotNull
        private final EventContext lastEvent;

        public StreamingState(@NotNull Span span, @NotNull EventContext lastEvent) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)lastEvent, (String)"lastEvent");
            this.span = span;
            this.lastEvent = lastEvent;
        }

        @NotNull
        public final Span getSpan() {
            return this.span;
        }

        @NotNull
        public final EventContext getLastEvent() {
            return this.lastEvent;
        }

        @NotNull
        public final Span component1() {
            return this.span;
        }

        @NotNull
        public final EventContext component2() {
            return this.lastEvent;
        }

        @NotNull
        public final StreamingState copy(@NotNull Span span, @NotNull EventContext lastEvent) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)lastEvent, (String)"lastEvent");
            return new StreamingState(span, lastEvent);
        }

        public static /* synthetic */ StreamingState copy$default(StreamingState streamingState, Span span, EventContext eventContext, int n, Object object) {
            if ((n & 1) != 0) {
                span = streamingState.span;
            }
            if ((n & 2) != 0) {
                eventContext = streamingState.lastEvent;
            }
            return streamingState.copy(span, eventContext);
        }

        @NotNull
        public String toString() {
            return "StreamingState(span=" + this.span + ", lastEvent=" + this.lastEvent + ")";
        }

        public int hashCode() {
            int result2 = this.span.hashCode();
            result2 = result2 * 31 + this.lastEvent.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StreamingState)) {
                return false;
            }
            StreamingState streamingState = (StreamingState)other;
            if (!Intrinsics.areEqual((Object)this.span, (Object)streamingState.span)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastEvent, (Object)streamingState.lastEvent);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StepStatus.values().length];
            try {
                nArray[StepStatus.IN_PROGRESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepStatus.COMPLETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepStatus.CANCELED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepStatus.REJECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StepStatus.FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

