/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.errorExplanation;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.promptlog.CodeSnippet;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003J=\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/errorExplanation/CodeScope;", "", "lineStart", "", "lineFinish", "code", "Lcom/intellij/ml/llm/privacy/PSString;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "language", "Lcom/intellij/lang/Language;", "<init>", "(IILcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/lang/Language;)V", "getLineStart", "()I", "getLineFinish", "getCode", "()Lcom/intellij/ml/llm/privacy/PSString;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLanguage", "()Lcom/intellij/lang/Language;", "containsLineNumber", "", "lineNumber", "createCodeSnippet", "Lcom/intellij/ml/llm/core/promptlog/CodeSnippet;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "intellij.ml.llm.chat"})
public final class CodeScope {
    private final int lineStart;
    private final int lineFinish;
    @NotNull
    private final PSString code;
    @NotNull
    private final VirtualFile virtualFile;
    @Nullable
    private final Language language;

    public CodeScope(int lineStart, int lineFinish, @NotNull PSString code, @NotNull VirtualFile virtualFile2, @Nullable Language language) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        this.lineStart = lineStart;
        this.lineFinish = lineFinish;
        this.code = code;
        this.virtualFile = virtualFile2;
        this.language = language;
    }

    public /* synthetic */ CodeScope(int n, int n2, PSString pSString, VirtualFile virtualFile2, Language language, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            language = null;
        }
        this(n, n2, pSString, virtualFile2, language);
    }

    public final int getLineStart() {
        return this.lineStart;
    }

    public final int getLineFinish() {
        return this.lineFinish;
    }

    @NotNull
    public final PSString getCode() {
        return this.code;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Nullable
    public final Language getLanguage() {
        return this.language;
    }

    public final boolean containsLineNumber(int lineNumber, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        int n = this.lineStart;
        return (lineNumber <= this.lineFinish ? n <= lineNumber : false) && Intrinsics.areEqual((Object)this.virtualFile, (Object)virtualFile2);
    }

    @NotNull
    public final CodeSnippet createCodeSnippet() {
        Language language;
        return new CodeSnippet(this.code, ExtensionsKtKt.getPrivacySafe((VirtualFile)this.virtualFile).getPath(), (language = this.language) != null && (language = ExtensionsKtKt.getPrivacySafe((Language)language)) != null ? language.getDisplayName() : null, null, 8, null);
    }

    public final int component1() {
        return this.lineStart;
    }

    public final int component2() {
        return this.lineFinish;
    }

    @NotNull
    public final PSString component3() {
        return this.code;
    }

    @NotNull
    public final VirtualFile component4() {
        return this.virtualFile;
    }

    @Nullable
    public final Language component5() {
        return this.language;
    }

    @NotNull
    public final CodeScope copy(int lineStart, int lineFinish, @NotNull PSString code, @NotNull VirtualFile virtualFile2, @Nullable Language language) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return new CodeScope(lineStart, lineFinish, code, virtualFile2, language);
    }

    public static /* synthetic */ CodeScope copy$default(CodeScope codeScope, int n, int n2, PSString pSString, VirtualFile virtualFile2, Language language, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = codeScope.lineStart;
        }
        if ((n3 & 2) != 0) {
            n2 = codeScope.lineFinish;
        }
        if ((n3 & 4) != 0) {
            pSString = codeScope.code;
        }
        if ((n3 & 8) != 0) {
            virtualFile2 = codeScope.virtualFile;
        }
        if ((n3 & 0x10) != 0) {
            language = codeScope.language;
        }
        return codeScope.copy(n, n2, pSString, virtualFile2, language);
    }

    @NotNull
    public String toString() {
        return "CodeScope(lineStart=" + this.lineStart + ", lineFinish=" + this.lineFinish + ", code=" + this.code + ", virtualFile=" + this.virtualFile + ", language=" + this.language + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.lineStart);
        result2 = result2 * 31 + Integer.hashCode(this.lineFinish);
        result2 = result2 * 31 + this.code.hashCode();
        result2 = result2 * 31 + this.virtualFile.hashCode();
        result2 = result2 * 31 + (this.language == null ? 0 : this.language.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CodeScope)) {
            return false;
        }
        CodeScope codeScope = (CodeScope)other;
        if (this.lineStart != codeScope.lineStart) {
            return false;
        }
        if (this.lineFinish != codeScope.lineFinish) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.code, (Object)codeScope.code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)codeScope.virtualFile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.language, (Object)codeScope.language);
    }
}

