/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.errorExplanation;

import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.errorExplanation.provider.ErrorExplanationProvider;
import com.intellij.ml.llm.errorExplanation.provider.RuntimeErrorExplanationProvider;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/errorExplanation/RuntimeErrorExplanationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getErrorData", "Lcom/intellij/ml/llm/errorExplanation/provider/ErrorExplanationProvider$ErrorData;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.ml.llm.chat"})
public class RuntimeErrorExplanationAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ErrorExplanationProvider.ErrorData errorData = this.getErrorData(event);
        if (errorData == null) {
            return;
        }
        ErrorExplanationProvider.ErrorData errorData2 = errorData;
        ErrorExplanationProvider.run$default(RuntimeErrorExplanationProvider.INSTANCE, project2, errorData2, false, null, 12, null);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        boolean llmExplainFiltersAreEnabled = Registry.Companion.is("llm.is.explainFiltersEnabled");
        if (!llmExplainFiltersAreEnabled) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project = event.getProject();
        if (project == null) {
            presentation2.setEnabled(false);
            return;
        }
        if (!AIAssistantUIUtil.INSTANCE.isAuthedAndAllowed(project)) {
            presentation2.setVisible(false);
        }
        if (!AIAssistantUIUtil.INSTANCE.isAssistantActive(project)) {
            presentation2.setEnabled(false);
            return;
        }
        if (!RuntimeErrorExplanationProvider.INSTANCE.hasAvailableLlmProfile()) {
            presentation2.setVisible(false);
        }
        presentation2.setEnabled(this.getErrorData(event) != null);
    }

    private final ErrorExplanationProvider.ErrorData getErrorData(AnActionEvent event) {
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        SelectionModel selectionModel = editor2.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        PSString pSString = ExtensionsKtKt.getPrivacySafe((SelectionModel)selectionModel2).getSelectedText();
        if (pSString == null) {
            return null;
        }
        PSString text2 = pSString;
        VisualPosition visualPosition = selectionModel2.getSelectionStartPosition();
        if (visualPosition == null) {
            return null;
        }
        int lineFrom = visualPosition.line;
        VisualPosition visualPosition2 = selectionModel2.getSelectionEndPosition();
        if (visualPosition2 == null) {
            return null;
        }
        int lineTo = visualPosition2.line;
        return new ErrorExplanationProvider.ErrorData(lineFrom, lineTo, editor2, text2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

