/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.conversion.converter;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.ml.llm.core.AIFirstUseKt;
import com.intellij.ml.llm.core.LLMCoroutineScope;
import com.intellij.ml.llm.core.promptlog.CodeSnippet;
import com.intellij.ml.llm.core.statistics.CommonLoggerService;
import com.intellij.ml.llm.core.statistics.CompositeStatisticsIdeActivity;
import com.intellij.ml.llm.core.statistics.FinishState;
import com.intellij.ml.llm.intentions.conversion.PasteConvertVetoer;
import com.intellij.ml.llm.intentions.conversion.data.PastePsiFileData;
import com.intellij.ml.llm.intentions.conversion.data.PasteRawTextData;
import com.intellij.ml.llm.intentions.conversion.language.LanguageDetectionMechanism;
import com.intellij.ml.llm.intentions.conversion.language.LooksLikeCodeDetectionKt;
import com.intellij.ml.llm.intentions.conversion.language.PasteConvertLanguage;
import com.intellij.ml.llm.intentions.conversion.language.PasteConvertLanguageRegistry;
import com.intellij.ml.llm.intentions.conversion.task.PasteConvertTask;
import com.intellij.ml.llm.intentions.conversion.ui.PasteConvertDialogKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.util.psi.PsiFeaturesProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.enry.JetEnry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJP\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J:\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020\u001aH\u0087@\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/intentions/conversion/converter/PasteCodeConverter;", "", "<init>", "()V", "processTransferableData", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "values", "", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "convert", "file", "Lcom/intellij/psi/PsiFile;", "activity", "Lcom/intellij/ml/llm/core/statistics/CompositeStatisticsIdeActivity;", "fileLanguage", "Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;", "pastedLanguage", "snippet", "Lcom/intellij/ml/llm/core/promptlog/CodeSnippet;", "errorsBeforeConversion", "", "isParsable", "", "text", "", "Lcom/intellij/lang/Language;", "charThreshold", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/lang/Language;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractCodeSnippet", "data", "language", "extractSnippetLanguage", "findOffset", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nPasteCodeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasteCodeConverter.kt\ncom/intellij/ml/llm/intentions/conversion/converter/PasteCodeConverter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,171:1\n1104#2,3:172\n*S KotlinDebug\n*F\n+ 1 PasteCodeConverter.kt\ncom/intellij/ml/llm/intentions/conversion/converter/PasteCodeConverter\n*L\n58#1:172,3\n*E\n"})
public final class PasteCodeConverter {
    @NotNull
    public static final PasteCodeConverter INSTANCE = new PasteCodeConverter();

    private PasteCodeConverter() {
    }

    public final void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, @NotNull List<? extends TextBlockTransferableData> values) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        TextBlockTransferableData textBlockTransferableData = (TextBlockTransferableData)CollectionsKt.firstOrNull(values);
        if (textBlockTransferableData == null) {
            return;
        }
        TextBlockTransferableData data2 = textBlockTransferableData;
        PasteConvertLanguage pasteConvertLanguage = this.extractSnippetLanguage(data2);
        if (pasteConvertLanguage == null) {
            return;
        }
        PasteConvertLanguage pastedLanguage = pasteConvertLanguage;
        CodeSnippet codeSnippet = this.extractCodeSnippet(data2, pastedLanguage);
        if (codeSnippet == null) {
            return;
        }
        CodeSnippet snippet = codeSnippet;
        int startLineOffset = editor.getDocument().getLineStartOffset(editor.getDocument().getLineNumber(bounds.getStartOffset()));
        String string = editor.getDocument().getText(new TextRange(startLineOffset, bounds.getStartOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.isBlank((CharSequence)string)) {
            return;
        }
        CharSequence $this$count$iv = snippet.getCode().unwrap();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!CharsKt.isWhitespace((char)it)) continue;
            ++count$iv;
        }
        if (count$iv < 4) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        if (file.findElementAt(bounds.getStartOffset()) instanceof PsiComment) {
            return;
        }
        PsiElement injectedElement = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(file, bounds.getStartOffset());
        BuildersKt.launch$default((CoroutineScope)LLMCoroutineScope.Companion.getScope(project), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(injectedElement, file, snippet, project, editor, pastedLanguage, bounds, null){
            int label;
            final /* synthetic */ PsiElement $injectedElement;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ CodeSnippet $snippet;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PasteConvertLanguage $pastedLanguage;
            final /* synthetic */ RangeMarker $bounds;
            {
                this.$injectedElement = $injectedElement;
                this.$file = $file;
                this.$snippet = $snippet;
                this.$project = $project;
                this.$editor = $editor;
                this.$pastedLanguage = $pastedLanguage;
                this.$bounds = $bounds;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$injectedElement != null) break;
                        if (Intrinsics.areEqual((Object)this.$file.getFileType().getDefaultExtension(), (Object)"") || this.$file.getFileType() instanceof PlainTextFileType || this.$file.getFileType() instanceof AbstractFileType) ** GOTO lbl17
                        this.label = 1;
                        v0 = PasteCodeConverter.isParsable$default(PasteCodeConverter.INSTANCE, (String)this.$snippet.getCode().unwrap(), this.$project, this.$editor, this.$file.getLanguage(), 0, (Continuation)this, 16, null);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            return Unit.INSTANCE;
                        }
lbl17:
                        // 3 sources

                        v1 = PasteConvertLanguageRegistry.INSTANCE.getFileLanguage$intellij_ml_llm_chat(this.$file);
                        ** GOTO lbl30
                    }
                }
                this.label = 2;
                v2 = PasteCodeConverter.isParsable$default(PasteCodeConverter.INSTANCE, (String)this.$snippet.getCode().unwrap(), this.$project, this.$editor, this.$injectedElement.getLanguage(), 0, (Continuation)this, 16, null);
                if (v2 == var6_2) {
                    return var6_2;
                }
                ** GOTO lbl27
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl27:
                        // 2 sources

                        if (((Boolean)v2).booleanValue()) {
                            return Unit.INSTANCE;
                        }
                        v1 = fileLanguage = PasteConvertLanguageRegistry.INSTANCE.fromIdeaId(this.$injectedElement.getLanguage().getID());
lbl30:
                        // 2 sources

                        if (fileLanguage == null || Intrinsics.areEqual((Object)this.$pastedLanguage, (Object)fileLanguage)) {
                            return Unit.INSTANCE;
                        }
                        if (!PasteConvertLanguageRegistry.INSTANCE.isLanguagePairSupported(this.$pastedLanguage, fileLanguage)) {
                            return Unit.INSTANCE;
                        }
                        if (PasteConvertVetoer.Companion.isConversionProhibited(this.$pastedLanguage, fileLanguage)) {
                            return Unit.INSTANCE;
                        }
                        v3 = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.$file)).traverse().filter((Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, invokeSuspend$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.psi.PsiElement ), (Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;)()));
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"filter(...)");
                        errors = CollectionsKt.count((Iterable)((Iterable)v3));
                        activity = CommonLoggerService.Companion.getInstance().logPasteConvertStarted(this.$project, fileLanguage, this.$pastedLanguage, (String)this.$snippet.getCode().unwrap(), LanguageDetectionMechanism.JET_ENRY);
                        if (!PluginManagerCore.isUnitTestMode && !AIFirstUseKt.prepareAiForUse((Project)this.$project)) {
                            CommonLoggerService.Companion.getInstance().logPasteConvertFinished(this.$project, activity, this.$pastedLanguage, fileLanguage, (String)this.$snippet.getCode().unwrap(), "", FinishState.NOT_AUTHENTICATED, null);
                            return Unit.INSTANCE;
                        }
                        convert = PasteConvertDialogKt.createAndAskDialog(this.$project, this.$pastedLanguage, fileLanguage);
                        if (!convert) {
                            CommonLoggerService.Companion.getInstance().logPasteConvertFinished(this.$project, activity, this.$pastedLanguage, fileLanguage, (String)this.$snippet.getCode().unwrap(), "", FinishState.CANCEL, null);
                            return Unit.INSTANCE;
                        }
                        PasteCodeConverter.access$convert(PasteCodeConverter.INSTANCE, this.$project, this.$editor, this.$file, activity, fileLanguage, this.$pastedLanguage, this.$snippet, this.$bounds, errors);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(PsiElement it) {
                return it instanceof PsiErrorElement;
            }

            private static final boolean invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        }), (int)2, null);
    }

    private final void convert(Project project, Editor editor, PsiFile file, CompositeStatisticsIdeActivity activity, PasteConvertLanguage fileLanguage, PasteConvertLanguage pastedLanguage, CodeSnippet snippet, RangeMarker bounds, int errorsBeforeConversion) {
        PasteConvertTask task = new PasteConvertTask(project, editor, file, activity, fileLanguage, pastedLanguage, snippet, bounds, errorsBeforeConversion);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task));
    }

    @VisibleForTesting
    @Nullable
    public final Object isParsable(@NotNull String text2, @NotNull Project project, @NotNull Editor editor, @Nullable Language fileLanguage, int charThreshold, @NotNull Continuation<? super Boolean> $completion) {
        PsiFile psiFile;
        String string;
        if (fileLanguage == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (text2.length() < charThreshold) {
            string = text2;
        } else {
            String string2 = text2.substring(0, charThreshold);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        String shortText = string;
        PsiFeaturesProvider provider = (PsiFeaturesProvider)PsiFeaturesProvider.Companion.getEP_NAME().forLanguage(fileLanguage);
        if (provider == null) {
            psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(fileLanguage, (CharSequence)shortText);
            if (psiFile == null) {
                return Boxing.boxBoolean((boolean)false);
            }
        } else {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            return provider.checkCodeSyntax(project, document, shortText, $completion);
        }
        PsiFile newFile = psiFile;
        return Boxing.boxBoolean((!PsiTreeUtilKt.hasErrorElementInRange((PsiFile)newFile, (TextRange)new TextRange(0, this.findOffset(newFile))) ? 1 : 0) != 0);
    }

    public static /* synthetic */ Object isParsable$default(PasteCodeConverter pasteCodeConverter, String string, Project project, Editor editor, Language language, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 1000;
        }
        return pasteCodeConverter.isParsable(string, project, editor, language, n, (Continuation<? super Boolean>)continuation);
    }

    private final CodeSnippet extractCodeSnippet(TextBlockTransferableData data2, PasteConvertLanguage language) {
        Object object;
        TextBlockTransferableData textBlockTransferableData = data2;
        if (textBlockTransferableData instanceof PastePsiFileData) {
            PSString pSString = ((PastePsiFileData)data2).getText();
            VirtualFile virtualFile2 = ((PastePsiFileData)data2).getPsiFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            object = new CodeSnippet(pSString, ExtensionsKtKt.getPrivacySafe((VirtualFile)virtualFile2).getPath(), language.getDisplayName(), null, 8, null);
        } else {
            object = textBlockTransferableData instanceof PasteRawTextData ? new CodeSnippet(((PasteRawTextData)data2).getText(), null, language.getDisplayName(), null, 10, null) : null;
        }
        return object;
    }

    private final PasteConvertLanguage extractSnippetLanguage(TextBlockTransferableData data2) {
        PSString code;
        TextBlockTransferableData textBlockTransferableData = data2;
        Object object = textBlockTransferableData instanceof PastePsiFileData ? PasteConvertLanguageRegistry.INSTANCE.getFileLanguage$intellij_ml_llm_chat((PastePsiFileData)data2) : (textBlockTransferableData instanceof PasteRawTextData ? (LooksLikeCodeDetectionKt.looksLikeCode((code = ((PasteRawTextData)data2).getText()).unwrap()) ? PasteConvertLanguageRegistry.INSTANCE.fromPredictionName(JetEnry.load().predict((String)code.unwrap())) : null) : null);
        return object;
    }

    private final int findOffset(PsiFile file) {
        PsiElement[] psiElementArray = PsiTreeUtil.collectElements((PsiElement)((PsiElement)file), PasteCodeConverter::findOffset$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"collectElements(...)");
        List psiElements = CollectionsKt.reversed((Iterable)ArraysKt.toMutableList((Object[])psiElementArray));
        for (PsiElement element : psiElements) {
            if (element instanceof PsiWhiteSpace || element instanceof PsiErrorElement || element instanceof PsiComment) continue;
            return element.getTextRange().getEndOffset() - 1;
        }
        return file.getTextRange().getEndOffset();
    }

    private static final boolean findOffset$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    public static final /* synthetic */ void access$convert(PasteCodeConverter $this, Project project, Editor editor, PsiFile file, CompositeStatisticsIdeActivity activity, PasteConvertLanguage fileLanguage, PasteConvertLanguage pastedLanguage, CodeSnippet snippet, RangeMarker bounds, int errorsBeforeConversion) {
        $this.convert(project, editor, file, activity, fileLanguage, pastedLanguage, snippet, bounds, errorsBeforeConversion);
    }
}

