/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.conversion.editor;

import com.intellij.codeInsight.generation.CommentByBlockCommentHandler;
import com.intellij.codeInsight.generation.CommentByLineCommentHandler;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.intentions.conversion.editor.ConvertTransformationsProvider;
import com.intellij.ml.llm.intentions.conversion.editor.EditorTransformations;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J(\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0010H\u0003J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J.\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u001dJ.\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/intentions/conversion/editor/EditorTransformations;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "insertLines", "", "offset", "text", "", "commentLines", "startOffset", "endOffset", "file", "Lcom/intellij/psi/PsiFile;", "createNewFileWithConvertedCode", "fileName", "extension", "response", "reformat", "", "applyConversionOnPaste", "(IILjava/lang/String;Lcom/intellij/psi/PsiFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyFileConversion", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/psi/PsiFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nEditorTransformations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTransformations.kt\ncom/intellij/ml/llm/intentions/conversion/editor/EditorTransformations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class EditorTransformations {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;

    public EditorTransformations(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.editor = editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @RequiresWriteLock
    private final int insertLines(int offset, String text2) {
        Object object = EditorTextField.detectLineSeparators((Document)this.editor.getDocument(), (String)this.editor.getDocument().getText());
        if (object == null || (object = object.getSeparatorString()) == null) {
            object = "\n";
        }
        Object lineSeparator = object;
        int endOffset = offset + text2.length() + ((String)lineSeparator).length();
        this.editor.getDocument().insertString(offset, (CharSequence)((String)lineSeparator + text2));
        return endOffset;
    }

    @RequiresWriteLock
    private final int commentLines(int startOffset, int endOffset, PsiFile file) {
        int n;
        Caret caret = this.editor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        Caret caret2 = caret;
        Object[] objectArray = new CaretState[]{new CaretState(this.editor.offsetToLogicalPosition(endOffset), this.editor.offsetToLogicalPosition(startOffset), this.editor.offsetToLogicalPosition(endOffset))};
        this.editor.getCaretModel().setCaretsAndSelections(CollectionsKt.mutableListOf((Object[])objectArray));
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file.getLanguage());
        if (commenter != null && commenter.getBlockCommentPrefix() != null && commenter.getBlockCommentSuffix() != null) {
            new CommentByBlockCommentHandler().invoke(this.project, this.editor, caret2, file);
        } else {
            CommentByLineCommentHandler handler2 = new CommentByLineCommentHandler();
            handler2.invoke(this.project, this.editor, caret2, file);
            handler2.postInvoke();
        }
        LogicalPosition logicalPosition = ((CaretState)this.editor.getCaretModel().getCaretsAndSelections().get(0)).getSelectionEnd();
        if (logicalPosition != null) {
            int it = logicalPosition.line;
            boolean bl = false;
            n = this.editor.getDocument().getLineEndOffset(it);
        } else {
            n = endOffset;
        }
        int newEndOffset = n;
        Object[] objectArray2 = new CaretState[]{new CaretState(this.editor.offsetToLogicalPosition(newEndOffset), this.editor.offsetToLogicalPosition(newEndOffset), this.editor.offsetToLogicalPosition(newEndOffset))};
        this.editor.getCaretModel().setCaretsAndSelections(CollectionsKt.mutableListOf((Object[])objectArray2));
        return newEndOffset;
    }

    @RequiresWriteLock
    private final PsiFile createNewFileWithConvertedCode(String fileName, String extension, PsiFile file, String response) {
        Object newFileName = fileName;
        int i = 1;
        while (true) {
            VirtualFile virtualFile2 = file.getVirtualFile().getParent();
            if (!new File(virtualFile2 != null ? virtualFile2.getPath() : null, (String)newFileName + "." + extension).exists()) break;
            newFileName = fileName + i;
            ++i;
        }
        PsiFile psiFile = file.getContainingDirectory().createFile((String)newFileName + "." + extension);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFile(...)");
        PsiFile newFile = psiFile;
        VirtualFile virtualFile3 = newFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
        VirtualFileUtil.writeText((VirtualFile)virtualFile3, (String)response);
        return newFile;
    }

    @RequiresWriteLock
    private final void reformat(int startOffset, int endOffset, PsiFile file) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.project);
        documentManager.doPostponedOperationsAndUnblockDocument(this.editor.getDocument());
        CodeStyleManager.getInstance((Project)this.project).reformatText(file, startOffset, endOffset);
        documentManager.commitDocument(this.editor.getDocument());
    }

    @Nullable
    public final Object applyConversionOnPaste(int startOffset, int endOffset, @NotNull String response, @NotNull PsiFile file, @NotNull Continuation<? super Unit> $completion) {
        ConvertTransformationsProvider provider = (ConvertTransformationsProvider)CollectionsKt.firstOrNull((List)ConvertTransformationsProvider.Companion.getEP_NAME().getExtensions((AreaInstance)this.project));
        if (provider != null) {
            Document document = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Object object = provider.applyConvertedCode(this.project, document, new TextRange(startOffset, endOffset), response, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.project, (String)LLMBundle.message((String)"conversion.command.name", (Object[])new Object[0]), null, () -> EditorTransformations.applyConversionOnPaste$lambda$0(this, startOffset, endOffset, file, response), (PsiFile[])new PsiFile[0]);
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object applyFileConversion(@NotNull String response, @NotNull String fileName, @NotNull String extension, @NotNull PsiFile file, @NotNull Continuation<? super PsiFile> $completion) {
        if (!($completion instanceof applyFileConversion.1)) ** GOTO lbl-1000
        var8_6 = $completion;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ EditorTransformations this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.applyFileConversion(null, null, null, null, (Continuation<? super PsiFile>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = response;
                $continuation.L$1 = fileName;
                $continuation.L$2 = extension;
                $continuation.L$3 = file;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileEditor[]>, Object>(this, file, null){
                    int label;
                    final /* synthetic */ EditorTransformations this$0;
                    final /* synthetic */ PsiFile $file;
                    {
                        this.this$0 = $receiver;
                        this.$file = $file;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CoroutinesKt.writeIntentReadAction(() -> applyFileConversion.2.invokeSuspend$lambda$0(this.this$0, this.$file), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super FileEditor[]> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final FileEditor[] invokeSuspend$lambda$0(EditorTransformations this$0, PsiFile $file) {
                        return FileEditorManager.getInstance((Project)this$0.getProject()).openFile($file.getVirtualFile(), true);
                    }
                }), (Continuation)$continuation);
                if (v0 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl28
            }
            case 1: {
                file = (PsiFile)$continuation.L$3;
                extension = (String)$continuation.L$2;
                fileName = (String)$continuation.L$1;
                response = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                convertedFile = new Ref.ObjectRef();
                convertedFile.element = file;
                WriteCommandAction.runWriteCommandAction((Project)this.project, (String)LLMBundle.message((String)"conversion.command.name", (Object[])new Object[0]), null, (Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, applyFileConversion$lambda$0(kotlin.jvm.internal.Ref$ObjectRef com.intellij.ml.llm.intentions.conversion.editor.EditorTransformations java.lang.String java.lang.String com.intellij.psi.PsiFile java.lang.String ), ()V)((Ref.ObjectRef)convertedFile, (EditorTransformations)this, (String)fileName, (String)extension, (PsiFile)file, (String)response), (PsiFile[])new PsiFile[0]);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)extension);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)file);
                $continuation.L$4 = convertedFile;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileEditor[]>, Object>(this, (Ref.ObjectRef<PsiFile>)convertedFile, null){
                    int label;
                    final /* synthetic */ EditorTransformations this$0;
                    final /* synthetic */ Ref.ObjectRef<PsiFile> $convertedFile;
                    {
                        this.this$0 = $receiver;
                        this.$convertedFile = $convertedFile;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CoroutinesKt.writeIntentReadAction(() -> applyFileConversion.4.invokeSuspend$lambda$0(this.this$0, this.$convertedFile), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super FileEditor[]> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final FileEditor[] invokeSuspend$lambda$0(EditorTransformations this$0, Ref.ObjectRef $convertedFile) {
                        return FileEditorManager.getInstance((Project)this$0.getProject()).openFile(((PsiFile)$convertedFile.element).getVirtualFile(), true);
                    }
                }), (Continuation)$continuation);
                if (v1 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl49
            }
            case 2: {
                convertedFile = (Ref.ObjectRef)$continuation.L$4;
                file = (PsiFile)$continuation.L$3;
                extension = (String)$continuation.L$2;
                fileName = (String)$continuation.L$1;
                response = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl49:
                // 2 sources

                return convertedFile.element;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void applyConversionOnPaste$lambda$0(EditorTransformations this$0, int $startOffset, int $endOffset, PsiFile $file, String $response) {
        int newStartOffset = this$0.commentLines($startOffset, $endOffset, $file);
        int newEndOffset = this$0.insertLines(newStartOffset, $response);
        this$0.reformat(newStartOffset, newEndOffset, $file);
    }

    private static final void applyFileConversion$lambda$0(Ref.ObjectRef $convertedFile, EditorTransformations this$0, String $fileName, String $extension, PsiFile $file, String $response) {
        $convertedFile.element = this$0.createNewFileWithConvertedCode($fileName, $extension, $file, $response);
        this$0.reformat(0, $response.length(), (PsiFile)$convertedFile.element);
    }
}

