/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.conversion.language;

import com.intellij.ml.llm.intentions.conversion.data.PastePsiFileData;
import com.intellij.ml.llm.intentions.conversion.language.CLang;
import com.intellij.ml.llm.intentions.conversion.language.CPPLang;
import com.intellij.ml.llm.intentions.conversion.language.CSharpLang;
import com.intellij.ml.llm.intentions.conversion.language.CoffeeScriptLang;
import com.intellij.ml.llm.intentions.conversion.language.DMLang;
import com.intellij.ml.llm.intentions.conversion.language.DartLang;
import com.intellij.ml.llm.intentions.conversion.language.ElixirLang;
import com.intellij.ml.llm.intentions.conversion.language.GoLang;
import com.intellij.ml.llm.intentions.conversion.language.GroovyLang;
import com.intellij.ml.llm.intentions.conversion.language.JavaLang;
import com.intellij.ml.llm.intentions.conversion.language.JavaScriptLang;
import com.intellij.ml.llm.intentions.conversion.language.JupyterLang;
import com.intellij.ml.llm.intentions.conversion.language.KotlinLang;
import com.intellij.ml.llm.intentions.conversion.language.ObjectiveCLang;
import com.intellij.ml.llm.intentions.conversion.language.PHPLang;
import com.intellij.ml.llm.intentions.conversion.language.PasteConvertLanguage;
import com.intellij.ml.llm.intentions.conversion.language.PerlLang;
import com.intellij.ml.llm.intentions.conversion.language.PowerShellLang;
import com.intellij.ml.llm.intentions.conversion.language.PythonLang;
import com.intellij.ml.llm.intentions.conversion.language.RubyLang;
import com.intellij.ml.llm.intentions.conversion.language.RustLang;
import com.intellij.ml.llm.intentions.conversion.language.ScalaLang;
import com.intellij.ml.llm.intentions.conversion.language.ShellLang;
import com.intellij.ml.llm.intentions.conversion.language.SwiftLang;
import com.intellij.ml.llm.intentions.conversion.language.TypeScriptLang;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.enry.JetEnry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006J\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u0006J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b\u001dJ\"\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguageRegistry;", "", "<init>", "()V", "programmingLanguages", "", "Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;", "scriptingLanguages", "registeredLanguages", "getRegisteredLanguages", "()Ljava/util/Set;", "supportedLanguagePairs", "", "fromPredictionName", "predictedName", "", "fromIdeaId", "ideaId", "fromFileExtension", "extension", "isLanguagePairSupported", "", "pastedLanguage", "fileLanguage", "getSupportedLanguages", "language", "getFileLanguage", "file", "Lcom/intellij/psi/PsiFile;", "getFileLanguage$intellij_ml_llm_chat", "data", "Lcom/intellij/ml/llm/intentions/conversion/data/PastePsiFileData;", "langId", "fileExtension", "fileText", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nPasteConvertLanguageRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasteConvertLanguageRegistry.kt\ncom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguageRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class PasteConvertLanguageRegistry {
    @NotNull
    public static final PasteConvertLanguageRegistry INSTANCE = new PasteConvertLanguageRegistry();
    @NotNull
    private static final Set<PasteConvertLanguage> programmingLanguages;
    @NotNull
    private static final Set<PasteConvertLanguage> scriptingLanguages;
    @NotNull
    private static final Set<PasteConvertLanguage> registeredLanguages;
    @NotNull
    private static final Map<PasteConvertLanguage, Set<PasteConvertLanguage>> supportedLanguagePairs;

    private PasteConvertLanguageRegistry() {
    }

    @NotNull
    public final Set<PasteConvertLanguage> getRegisteredLanguages() {
        return registeredLanguages;
    }

    @Nullable
    public final PasteConvertLanguage fromPredictionName(@Nullable String predictedName) {
        Object v0;
        block1: {
            Iterable iterable = registeredLanguages;
            for (Object t : iterable) {
                PasteConvertLanguage it = (PasteConvertLanguage)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPredictionName(), (Object)predictedName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final PasteConvertLanguage fromIdeaId(@Nullable String ideaId) {
        PasteConvertLanguage pasteConvertLanguage;
        Object v0;
        block2: {
            Iterable iterable = registeredLanguages;
            for (Object t : iterable) {
                PasteConvertLanguage it = (PasteConvertLanguage)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIdeaId(), (Object)ideaId)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((pasteConvertLanguage = (PasteConvertLanguage)v0) == null) {
            ScalaLang scalaLang;
            ScalaLang it = scalaLang = ScalaLang.INSTANCE;
            boolean bl = false;
            pasteConvertLanguage = (PasteConvertLanguage)(Intrinsics.areEqual((Object)ideaId, (Object)"Scala 3") ? scalaLang : null);
        }
        return pasteConvertLanguage;
    }

    @Nullable
    public final PasteConvertLanguage fromFileExtension(@Nullable String extension) {
        Object v0;
        block1: {
            Iterable iterable = registeredLanguages;
            for (Object t : iterable) {
                PasteConvertLanguage it = (PasteConvertLanguage)t;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)it.getExtensions(), (Object)extension)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean isLanguagePairSupported(@NotNull PasteConvertLanguage pastedLanguage, @NotNull PasteConvertLanguage fileLanguage) {
        Intrinsics.checkNotNullParameter((Object)pastedLanguage, (String)"pastedLanguage");
        Intrinsics.checkNotNullParameter((Object)fileLanguage, (String)"fileLanguage");
        Set<PasteConvertLanguage> set = supportedLanguagePairs.get(pastedLanguage);
        return set != null ? set.contains(fileLanguage) : false;
    }

    @Nullable
    public final Set<PasteConvertLanguage> getSupportedLanguages(@NotNull PasteConvertLanguage language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return supportedLanguagePairs.get(language);
    }

    @Nullable
    public final PasteConvertLanguage getFileLanguage$intellij_ml_llm_chat(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        String string2 = file.getVirtualFile().getExtension();
        String string3 = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        return this.getFileLanguage(string, string2, string3);
    }

    @Nullable
    public final PasteConvertLanguage getFileLanguage$intellij_ml_llm_chat(@NotNull PastePsiFileData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string = data2.getPsiFile().getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return this.getFileLanguage(string, data2.getPsiFile().getVirtualFile().getExtension(), (String)data2.getText().unwrap());
    }

    @Nullable
    public final PasteConvertLanguage getFileLanguage(@NotNull String langId, @Nullable String fileExtension, @NotNull String fileText) {
        Intrinsics.checkNotNullParameter((Object)langId, (String)"langId");
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        PasteConvertLanguage fileLanguage = this.fromIdeaId(langId);
        if (fileLanguage == null || Intrinsics.areEqual((Object)fileLanguage, (Object)ObjectiveCLang.INSTANCE)) {
            if (Intrinsics.areEqual((Object)fileExtension, (Object)"h")) {
                fileLanguage = this.fromPredictionName(JetEnry.load().predict(fileText));
                if (!(Intrinsics.areEqual((Object)fileLanguage, (Object)CLang.INSTANCE) || Intrinsics.areEqual((Object)fileLanguage, (Object)CPPLang.INSTANCE) || Intrinsics.areEqual((Object)fileLanguage, (Object)ObjectiveCLang.INSTANCE))) {
                    fileLanguage = (PasteConvertLanguage)CLang.INSTANCE;
                }
            } else {
                fileLanguage = this.fromFileExtension(fileExtension);
            }
        }
        return fileLanguage;
    }

    static {
        Object[] objectArray = new PasteConvertLanguage[]{CLang.INSTANCE, CSharpLang.INSTANCE, CPPLang.INSTANCE, CoffeeScriptLang.INSTANCE, DartLang.INSTANCE, DMLang.INSTANCE, ElixirLang.INSTANCE, GoLang.INSTANCE, GroovyLang.INSTANCE, JavaLang.INSTANCE, JavaScriptLang.INSTANCE, KotlinLang.INSTANCE, ObjectiveCLang.INSTANCE, PerlLang.INSTANCE, PHPLang.INSTANCE, PythonLang.INSTANCE, RubyLang.INSTANCE, RustLang.INSTANCE, ScalaLang.INSTANCE, SwiftLang.INSTANCE, TypeScriptLang.INSTANCE};
        programmingLanguages = SetsKt.setOf((Object[])objectArray);
        objectArray = new PasteConvertLanguage[]{PerlLang.INSTANCE, PowerShellLang.INSTANCE, PythonLang.INSTANCE, RubyLang.INSTANCE, ShellLang.INSTANCE};
        scriptingLanguages = SetsKt.setOf((Object[])objectArray);
        objectArray = new PasteConvertLanguage[]{CLang.INSTANCE, CSharpLang.INSTANCE, CPPLang.INSTANCE, CoffeeScriptLang.INSTANCE, DartLang.INSTANCE, DMLang.INSTANCE, ElixirLang.INSTANCE, GoLang.INSTANCE, GroovyLang.INSTANCE, JavaLang.INSTANCE, JavaScriptLang.INSTANCE, JupyterLang.INSTANCE, KotlinLang.INSTANCE, ObjectiveCLang.INSTANCE, PerlLang.INSTANCE, PHPLang.INSTANCE, PowerShellLang.INSTANCE, PythonLang.INSTANCE, RubyLang.INSTANCE, RustLang.INSTANCE, ScalaLang.INSTANCE, ShellLang.INSTANCE, SwiftLang.INSTANCE, TypeScriptLang.INSTANCE};
        registeredLanguages = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)CLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)CSharpLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)CPPLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)CoffeeScriptLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)DartLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)DMLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)ElixirLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)GoLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)GroovyLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)JavaLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)JavaScriptLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)JupyterLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)KotlinLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)ObjectiveCLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)PerlLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)PHPLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)PowerShellLang.INSTANCE, scriptingLanguages), TuplesKt.to((Object)PythonLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)RubyLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)RustLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)ScalaLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)ShellLang.INSTANCE, scriptingLanguages), TuplesKt.to((Object)SwiftLang.INSTANCE, programmingLanguages), TuplesKt.to((Object)TypeScriptLang.INSTANCE, programmingLanguages)};
        supportedLanguagePairs = MapsKt.mapOf((Pair[])objectArray);
    }
}

