/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.editor;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.AIAssistantActionKind;
import com.intellij.ml.llm.core.AIAssistantActionManager;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.intentions.AiaCustomIntention;
import com.intellij.ml.llm.intentions.IntentionsUtilsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/intentions/editor/IntentionWrapperAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ActionWithDelegate;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "intentionAction", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/codeInsight/intention/IntentionAction;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getDelegate", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIIntentionsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIIntentionsActionGroup.kt\ncom/intellij/ml/llm/intentions/editor/IntentionWrapperAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
final class IntentionWrapperAction
extends DumbAwareAction
implements ActionWithDelegate<IntentionAction> {
    @NotNull
    private final IntentionAction intentionAction;
    @NotNull
    private final Project project;
    @Nullable
    private final Editor editor;
    @Nullable
    private final PsiFile file;

    public IntentionWrapperAction(@NotNull IntentionAction intentionAction, @NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)intentionAction, (String)"intentionAction");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(intentionAction.getText());
        this.intentionAction = intentionAction;
        this.project = project;
        this.editor = editor;
        this.file = file;
    }

    public void update(@NotNull AnActionEvent e) {
        ShortcutSet shortcutSet;
        boolean bl;
        PsiFile psiFile;
        boolean bl2;
        PsiFile it;
        AiaCustomIntention aiaIntentionAction;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(AIAssistantActionManager.Companion.checkIsAllowedWithDelegation(e.getProject()) || AIAssistantUIUtil.INSTANCE.isAssistantActive(this.project));
        IntentionAction intentionAction = IntentionsUtilsKt.getDelegateChainRoot(this.intentionAction);
        AiaCustomIntention aiaCustomIntention = aiaIntentionAction = intentionAction instanceof AiaCustomIntention ? (AiaCustomIntention)intentionAction : null;
        if (aiaIntentionAction == null) {
            return;
        }
        PsiFile psiFile2 = this.file;
        if (psiFile2 != null && (psiFile2 = psiFile2.getLanguage()) != null) {
            it = psiFile2;
            boolean bl3 = false;
            bl2 = aiaIntentionAction.isNewFor((Language)it);
        } else {
            bl2 = false;
        }
        if (bl2) {
            e.getPresentation().putClientProperty(ActionUtil.SECONDARY_ICON, (Object)AllIcons.General.New_badge);
        }
        if ((psiFile = this.file) != null && (psiFile = psiFile.getLanguage()) != null) {
            it = psiFile;
            boolean bl4 = false;
            bl = aiaIntentionAction.isBetaFor((Language)it);
        } else {
            bl = false;
        }
        if (bl) {
            e.getPresentation().putClientProperty(ActionUtil.SECONDARY_ICON, (Object)AllIcons.General.Beta);
        }
        AnAction anAction = aiaIntentionAction.getAction();
        ShortcutSet shortcutSet2 = shortcutSet = anAction != null ? anAction.getShortcutSet() : null;
        boolean bl5 = shortcutSet2 != null ? shortcutSet2.hasShortcuts() : false;
        if (bl5) {
            Editor editor = this.editor;
            this.registerCustomShortcutSet(shortcutSet, editor != null ? editor.getComponent() : null);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AIAssistantActionManager.Companion.isDelegationEnabled() && AIAssistantActionManager.Companion.didPerformNoQuotaAction(this.project, AIAssistantActionKind.ONLY_ONLINE)) {
            return;
        }
        this.intentionAction.invoke(this.project, this.editor, this.file);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    public IntentionAction getDelegate() {
        return this.intentionAction;
    }
}

