/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.qa.sources;

import ai.grazie.utils.mpp.PolyfillsKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a>\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"ACTION_INSTRUCTION", "Lcom/intellij/ml/llm/privacy/PSString;", "SETTINGS_PATH_INSTRUCTION", "SHORTCUT_INSTRUCTION", "getRecentVersions", "", "Lkotlin/Pair;", "", "major", "minor", "base", "", "size", "intellij.ml.llm.chat"})
public final class IntelliJDocsSourceKt {
    @NotNull
    private static final PSString ACTION_INSTRUCTION = ConstantsKt.getPrivacyConst((String)"\n  If you want to mention an action for user, in your next steps you MUST embed action button in message with following syntax: \n  <ActionButton id=\"ACTION_ID\"/> (with ACTION_ID changed to actual id).\n  ").trimIndent();
    @NotNull
    private static final PSString SETTINGS_PATH_INSTRUCTION = ConstantsKt.getPrivacyConst((String)"\n  For ShowSettings action, you can also specify path to specific page with value attribute:\n  <ActionButton id=\"ShowSettings\" value=\"Path | To | Page\"/> (it is crucial to use pipe symbol (\"|\") for separating path pages).\n  Furthermore, you can include a search query as the last element, which will result in the highlighting of all occurrences of query on the page:\n  For example: <ActionButton id=\"ShowSettings\" value=\"Path | To | Page | query\"/>\n").trimIndent();
    @NotNull
    private static final PSString SHORTCUT_INSTRUCTION = ConstantsKt.getPrivacyConst((String)"\n  There are many nuances with the display of shortcuts. In order not to confuse them with punctuation marks, and also to clearly separate each key, you MUST use separate inline code span syntax for each key. Separate this keys by space.\n  If shortcut contain backtick (`) key, use double-backtick span for it: `` ` ``.\n  Example for \u2303\u21e7` shortcut usage: `\u2303` `\u21e7` `` ` ``\n").trimIndent();

    private static final List<Pair<String, String>> getRecentVersions(String major, String minor, int base, int size) {
        Integer n = StringsKt.toIntOrNull((String)major);
        if (n == null) {
            return CollectionsKt.listOf((Object)TuplesKt.to((Object)major, (Object)minor));
        }
        int majorInt = n;
        Integer n2 = StringsKt.toIntOrNull((String)minor);
        if (n2 == null) {
            return CollectionsKt.listOf((Object)TuplesKt.to((Object)major, (Object)minor));
        }
        int minorInt = n2;
        int minorNormalized = minorInt - 1;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)major, (Object)minor)};
        List versions = CollectionsKt.mutableListOf((Object[])objectArray);
        for (int i = 1; i < size; ++i) {
            int curMinor = PolyfillsKt.floorMod((int)(minorNormalized - i), (int)base) + 1;
            int majorDiff = (minorNormalized - i - (base - 1)) / base;
            int curMajor = majorInt + majorDiff;
            versions.add(TuplesKt.to((Object)String.valueOf(curMajor), (Object)String.valueOf(curMinor)));
        }
        return versions;
    }

    static /* synthetic */ List getRecentVersions$default(String string, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 4;
        }
        if ((n3 & 8) != 0) {
            n2 = 5;
        }
        return IntelliJDocsSourceKt.getRecentVersions(string, string2, n, n2);
    }

    public static final /* synthetic */ PSString access$getSHORTCUT_INSTRUCTION$p() {
        return SHORTCUT_INSTRUCTION;
    }

    public static final /* synthetic */ PSString access$getACTION_INSTRUCTION$p() {
        return ACTION_INSTRUCTION;
    }

    public static final /* synthetic */ PSString access$getSETTINGS_PATH_INSTRUCTION$p() {
        return SETTINGS_PATH_INSTRUCTION;
    }
}

