/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util.validation;

import ai.grazie.model.cloud.ContentType;
import com.intellij.ml.llm.core.chat.ui.AttachmentKindsProvider;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.AiChatMediaCacheServiceKt;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileContextAttachment;
import com.intellij.ml.llm.tokenizer.TokenQuota;
import com.intellij.ml.llm.util.validation.ValidationError;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/util/validation/VirtualFileValidator;", "", "<init>", "()V", "validate", "Lcom/intellij/ml/llm/util/validation/ValidationError;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "attachmentKindsProvider", "Lcom/intellij/ml/llm/core/chat/ui/AttachmentKindsProvider;", "checks", "", "Lcom/intellij/ml/llm/util/validation/VirtualFileValidator$Check;", "checkPsiElementExpired", "psiElement", "Lcom/intellij/psi/PsiElement;", "checkFileExpired", "checkFileTooLong", "checkFileType", "checkDocumentExists", "Check", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nVirtualFileValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileValidator.kt\ncom/intellij/ml/llm/util/validation/VirtualFileValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class VirtualFileValidator {
    @NotNull
    public static final VirtualFileValidator INSTANCE = new VirtualFileValidator();

    private VirtualFileValidator() {
    }

    @Nullable
    public final ValidationError validate(@NotNull VirtualFile virtualFile2, @NotNull AttachmentKindsProvider attachmentKindsProvider, @NotNull Iterable<? extends Check> checks) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)attachmentKindsProvider, (String)"attachmentKindsProvider");
        Intrinsics.checkNotNullParameter(checks, (String)"checks");
        block5: for (Check check : checks) {
            switch (WhenMappings.$EnumSwitchMapping$0[check.ordinal()]) {
                case 1: {
                    ValidationError validationError = this.checkFileExpired(virtualFile2);
                    if (validationError == null) continue block5;
                    ValidationError it = validationError;
                    boolean bl = false;
                    return it;
                }
                case 2: {
                    ValidationError validationError = this.checkFileTooLong(virtualFile2);
                    if (validationError == null) continue block5;
                    ValidationError it = validationError;
                    boolean bl = false;
                    return it;
                }
                case 3: {
                    ValidationError validationError = this.checkFileType(virtualFile2, attachmentKindsProvider);
                    if (validationError == null) continue block5;
                    ValidationError it = validationError;
                    boolean bl = false;
                    return it;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    public static /* synthetic */ ValidationError validate$default(VirtualFileValidator virtualFileValidator, VirtualFile virtualFile2, AttachmentKindsProvider attachmentKindsProvider, Iterable iterable, int n, Object object) {
        if ((n & 4) != 0) {
            iterable = Check.Companion.all();
        }
        return virtualFileValidator.validate(virtualFile2, attachmentKindsProvider, iterable);
    }

    @RequiresReadLock
    @Nullable
    public final ValidationError checkPsiElementExpired(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!psiElement.isValid()) {
            return new ValidationError.PsiElementExpired();
        }
        return null;
    }

    @RequiresReadLock
    @Nullable
    public final ValidationError checkFileExpired(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (!virtualFile2.isValid()) {
            return new ValidationError.FileExpired(virtualFile2);
        }
        return null;
    }

    @RequiresReadLock
    @Nullable
    public final ValidationError checkFileTooLong(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (virtualFile2.getLength() >= (long)TokenQuota.INSTANCE.getMaxFileSize()) {
            return new ValidationError.FileTooLong(virtualFile2);
        }
        return null;
    }

    @RequiresReadLock
    @Nullable
    public final ValidationError checkFileType(@NotNull VirtualFile virtualFile2, @NotNull AttachmentKindsProvider attachmentKindsProvider) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)attachmentKindsProvider, (String)"attachmentKindsProvider");
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFile(...)");
        FileType fileType2 = fileType;
        if (FileContextAttachment.Companion.isAllowedToAddImages() && ImageFileTypeManager.getInstance().isImage(virtualFile2)) {
            ContentType contentType;
            ContentType contentType2 = AiChatMediaCacheServiceKt.mediaContentType(virtualFile2);
            if (contentType2 == null) {
                contentType2 = ContentType.Image.INSTANCE.getJPEG();
            }
            if (Intrinsics.areEqual((Object)attachmentKindsProvider.isSupportedContentType(contentType = contentType2), (Object)false)) {
                return new ValidationError.ImagesAreNotSupportedByTheModelError();
            }
            if (VirtualFileUtil.isTooLarge((VirtualFile)virtualFile2)) {
                long maxFileSize = (long)FileSizeLimit.Companion.getContentLoadLimit(virtualFile2.getExtension()) / (long)1024 / (long)1024;
                return new ValidationError.ImagesIsToLargeError(virtualFile2, (int)maxFileSize);
            }
            return null;
        }
        if (!virtualFile2.isDirectory() && fileType2.isBinary()) {
            return new ValidationError.FileIsBinaryError(virtualFile2);
        }
        return null;
    }

    @RequiresReadLock
    @Nullable
    public final ValidationError checkDocumentExists(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return new ValidationError.DocumentNotExist(virtualFile2);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/util/validation/VirtualFileValidator$Check;", "", "<init>", "(Ljava/lang/String;I)V", "CHECK_FILE_EXPIRED", "CHECK_FILE_TOO_LONG", "CHECK_FILE_TYPE", "Companion", "intellij.ml.llm.chat"})
    public static final class Check
    extends Enum<Check> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ Check CHECK_FILE_EXPIRED;
        public static final /* enum */ Check CHECK_FILE_TOO_LONG;
        public static final /* enum */ Check CHECK_FILE_TYPE;
        private static final /* synthetic */ Check[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Check[] values() {
            return (Check[])$VALUES.clone();
        }

        public static Check valueOf(String value) {
            return Enum.valueOf(Check.class, value);
        }

        @NotNull
        public static EnumEntries<Check> getEntries() {
            return $ENTRIES;
        }

        static {
            CHECK_FILE_EXPIRED = new Check();
            CHECK_FILE_TOO_LONG = new Check();
            CHECK_FILE_TYPE = new Check();
            $VALUES = checkArray = new Check[]{Check.CHECK_FILE_EXPIRED, Check.CHECK_FILE_TOO_LONG, Check.CHECK_FILE_TYPE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/util/validation/VirtualFileValidator$Check$Companion;", "", "<init>", "()V", "all", "", "Lcom/intellij/ml/llm/util/validation/VirtualFileValidator$Check;", "allButFileTooLong", "intellij.ml.llm.chat"})
        @SourceDebugExtension(value={"SMAP\nVirtualFileValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileValidator.kt\ncom/intellij/ml/llm/util/validation/VirtualFileValidator$Check$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n774#2:115\n865#2,2:116\n*S KotlinDebug\n*F\n+ 1 VirtualFileValidator.kt\ncom/intellij/ml/llm/util/validation/VirtualFileValidator$Check$Companion\n*L\n97#1:115\n97#1:116,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Iterable<Check> all() {
                return (Iterable)Check.getEntries();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Iterable<Check> allButFileTooLong() {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)Check.getEntries();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Check it = (Check)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!(it != CHECK_FILE_TOO_LONG)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Check.values().length];
            try {
                nArray[Check.CHECK_FILE_EXPIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Check.CHECK_FILE_TOO_LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Check.CHECK_FILE_TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

