/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client;

import com.agentclientprotocol.model.ContentBlock;
import com.agentclientprotocol.model.SessionUpdate;
import com.intellij.ml.llm.agents.AUIEvent;
import com.intellij.ml.llm.agents.acp.client.AcpToAUIConverterKt;
import com.intellij.ml.llm.aui.events.api.AgentCurrentStatusUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.AgentEvent;
import com.intellij.ml.llm.aui.events.api.AgentThoughtBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.api.MarkdownBlockUpdatedEvent;
import com.intellij.ml.llm.aui.events.extensions.AUITaskState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006J\b\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/ChunkBuffer;", "", "<init>", "()V", "buffer", "", "Lcom/agentclientprotocol/model/SessionUpdate;", "processChunkableUpdate", "", "Lcom/intellij/ml/llm/agents/AUIEvent;", "sessionUpdate", "flush", "shouldAppendToBuffer", "", "peekEventFromBuffer", "mergeAndConvert", "Lcom/intellij/ml/llm/aui/events/api/AgentEvent;", "firstElement", "textBlocks", "Lcom/agentclientprotocol/model/ContentBlock$Text;", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nChunkBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkBuffer.kt\ncom/intellij/ml/llm/agents/acp/client/ChunkBuffer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1617#2,9:111\n1869#2:120\n1870#2:123\n1626#2:124\n19#3:121\n1#4:122\n*S KotlinDebug\n*F\n+ 1 ChunkBuffer.kt\ncom/intellij/ml/llm/agents/acp/client/ChunkBuffer\n*L\n87#1:111,9\n87#1:120\n87#1:123\n87#1:124\n87#1:121\n87#1:122\n*E\n"})
public final class ChunkBuffer {
    @NotNull
    private final List<SessionUpdate> buffer = new ArrayList();

    @NotNull
    public final List<AUIEvent> processChunkableUpdate(@NotNull SessionUpdate sessionUpdate) {
        List list;
        Intrinsics.checkNotNullParameter((Object)sessionUpdate, (String)"sessionUpdate");
        ContentBlock contentBlock = AcpToAUIConverterKt.getChunkContent(sessionUpdate);
        if (contentBlock == null) {
            throw new IllegalStateException("Expected chunkable update but got none".toString());
        }
        ContentBlock chunkContent = contentBlock;
        if (this.shouldAppendToBuffer(sessionUpdate)) {
            this.buffer.add(sessionUpdate);
            list = CollectionsKt.listOfNotNull((Object)this.peekEventFromBuffer());
        } else {
            AUIEvent flushEvent = this.flush();
            this.buffer.add(sessionUpdate);
            AUIEvent peekEvent = this.peekEventFromBuffer();
            Object[] objectArray = new AUIEvent[]{flushEvent, peekEvent};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        return list;
    }

    @Nullable
    public final AUIEvent flush() {
        if (this.buffer.isEmpty()) {
            return null;
        }
        AUIEvent event2 = CollectionsKt.firstOrNull(this.buffer) instanceof SessionUpdate.AgentThoughtChunk ? new AUIEvent((AgentEvent)new AgentCurrentStatusUpdatedEvent(null), null, 2, null) : null;
        this.buffer.clear();
        return event2;
    }

    private final boolean shouldAppendToBuffer(SessionUpdate sessionUpdate) {
        SessionUpdate sessionUpdate2 = (SessionUpdate)CollectionsKt.lastOrNull(this.buffer);
        if (sessionUpdate2 == null) {
            return true;
        }
        SessionUpdate lastElement = sessionUpdate2;
        return Intrinsics.areEqual(sessionUpdate.getClass(), lastElement.getClass());
    }

    /*
     * WARNING - void declaration
     */
    private final AUIEvent peekEventFromBuffer() {
        void $this$mapNotNullTo$iv$iv;
        SessionUpdate sessionUpdate = (SessionUpdate)CollectionsKt.firstOrNull(this.buffer);
        if (sessionUpdate == null) {
            return null;
        }
        SessionUpdate firstElement = sessionUpdate;
        Iterable $this$mapNotNull$iv = this.buffer;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ContentBlock.Text it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SessionUpdate it = (SessionUpdate)element$iv$iv;
            boolean bl2 = false;
            ContentBlock $this$asSafely$iv = AcpToAUIConverterKt.getChunkContent(it);
            boolean $i$f$asSafely = false;
            ContentBlock contentBlock = $this$asSafely$iv;
            if (!(contentBlock instanceof ContentBlock.Text)) {
                contentBlock = null;
            }
            if ((ContentBlock.Text)contentBlock == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List textElements = (List)destination$iv$iv;
        AgentEvent event2 = this.mergeAndConvert(firstElement, textElements);
        return new AUIEvent(event2, AUITaskState.IN_PROGRESS);
    }

    private final AgentEvent mergeAndConvert(SessionUpdate firstElement, List<ContentBlock.Text> textBlocks) {
        AgentEvent agentEvent;
        String mergedText = CollectionsKt.joinToString$default((Iterable)textBlocks, (CharSequence)"", null, null, (int)0, null, ChunkBuffer::mergeAndConvert$lambda$0, (int)30, null);
        if (firstElement instanceof SessionUpdate.AgentThoughtChunk) {
            String syntheticStepId = String.valueOf(System.identityHashCode(firstElement));
            agentEvent = (AgentEvent)new AgentThoughtBlockUpdatedEvent(syntheticStepId, null, mergedText, 2, null);
        } else {
            String syntheticStepId = String.valueOf(System.identityHashCode(firstElement));
            agentEvent = (AgentEvent)new MarkdownBlockUpdatedEvent(syntheticStepId, null, mergedText, 2, null);
        }
        return agentEvent;
    }

    private static final CharSequence mergeAndConvert$lambda$0(ContentBlock.Text it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }
}

