/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client;

import com.intellij.history.LocalHistory;
import com.intellij.ml.llm.agents.acp.client.DiffContentResolver;
import com.intellij.ml.llm.agents.acp.client.DiffContentResolverKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/DiffContentResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "resolve", "Lcom/intellij/ml/llm/agents/acp/client/DiffContentResolver$ResolvedDiff;", "path", "Ljava/nio/file/Path;", "oldText", "", "newText", "isDelete", "", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readCurrentFileContent", "localPath", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPreviousContentFromLocalHistory", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "ResolvedDiff", "Companion", "intellij.ml.llm.agents.acp"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nDiffContentResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffContentResolver.kt\ncom/intellij/ml/llm/agents/acp/client/DiffContentResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class DiffContentResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private static final long RECENT_CHANGE_WINDOW_MS = 10000L;

    public DiffContentResolver(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object resolve(@Nullable Path path, @Nullable String oldText, @NotNull String newText, boolean isDelete, @NotNull Continuation<? super ResolvedDiff> $completion) {
        if (!($completion instanceof resolve.1)) ** GOTO lbl-1000
        var10_6 = $completion;
        if ((var10_6.label & -2147483648) != 0) {
            var10_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ DiffContentResolver this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resolve(null, null, null, false, (Continuation<? super ResolvedDiff>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (path == null) {
                    return new ResolvedDiff(oldText, newText, false);
                }
                if (isDelete) {
                    return new ResolvedDiff(oldText, "", true);
                }
                if (oldText == null) {
                    return new ResolvedDiff(null, newText, true);
                }
                $continuation.L$0 = path;
                $continuation.L$1 = oldText;
                $continuation.L$2 = newText;
                $continuation.Z$0 = isDelete;
                $continuation.label = 1;
                v0 = this.readCurrentFileContent(path, (Continuation<? super String>)$continuation);
                if (v0 == var11_8) {
                    return var11_8;
                }
                ** GOTO lbl34
            }
            case 1: {
                isDelete = $continuation.Z$0;
                newText = (String)$continuation.L$2;
                oldText = (String)$continuation.L$1;
                path = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                if ((currentContent = (String)v0) == null) {
                    DiffContentResolverKt.access$getLogger$p().debug("File doesn't exist, treating as new file: " + path);
                    return new ResolvedDiff(null, newText, true);
                }
                if (Intrinsics.areEqual((Object)oldText, (Object)currentContent)) {
                    DiffContentResolverKt.access$getLogger$p().debug("oldText matches current file content - full file diff: " + path);
                    return new ResolvedDiff(oldText, newText, true);
                }
                if (Intrinsics.areEqual((Object)newText, (Object)currentContent)) {
                    DiffContentResolverKt.access$getLogger$p().debug("newText matches current file content - change already applied: " + path);
                    return new ResolvedDiff(oldText, newText, true);
                }
                $continuation.L$0 = path;
                $continuation.L$1 = oldText;
                $continuation.L$2 = newText;
                $continuation.L$3 = currentContent;
                $continuation.Z$0 = isDelete;
                $continuation.label = 2;
                v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, resolve$lambda$0(java.nio.file.Path ), ()Lcom/intellij/openapi/vfs/VirtualFile;)((Path)path), (Continuation)$continuation);
                if (v1 == var11_8) {
                    return var11_8;
                }
                ** GOTO lbl61
            }
            case 2: {
                isDelete = $continuation.Z$0;
                currentContent = (String)$continuation.L$3;
                newText = (String)$continuation.L$2;
                oldText = (String)$continuation.L$1;
                path = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl61:
                // 2 sources

                if ((vFile = (VirtualFile)v1) != null) {
                    recentHistoryContent = this.getPreviousContentFromLocalHistory(vFile);
                    if (recentHistoryContent != null && !Intrinsics.areEqual((Object)recentHistoryContent, (Object)currentContent)) {
                        DiffContentResolverKt.access$getLogger$p().debug("Using Local History content as before state: " + path);
                        return new ResolvedDiff(recentHistoryContent, currentContent, true);
                    }
                    return new ResolvedDiff(currentContent, StringsKt.replace$default((String)currentContent, (String)oldText, (String)newText, (boolean)false, (int)4, null), true);
                }
                DiffContentResolverKt.access$getLogger$p().debug("Could not resolve full content, using raw diff: " + path);
                return new ResolvedDiff(oldText, newText, false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object resolve$default(DiffContentResolver diffContentResolver, Path path, String string, String string2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return diffContentResolver.resolve(path, string, string2, bl, (Continuation<? super ResolvedDiff>)continuation);
    }

    private final Object readCurrentFileContent(Path localPath, Continuation<? super String> $completion) {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByNioFile(localPath);
        if (vFile == null || !vFile.exists() || vFile.isDirectory()) {
            return null;
        }
        vFile.refresh(false, false);
        return CoroutinesKt.readAction(() -> DiffContentResolver.readCurrentFileContent$lambda$0(vFile, this), $completion);
    }

    private final String getPreviousContentFromLocalHistory(VirtualFile vFile) {
        String string;
        try {
            String string2;
            byte[] byteContent;
            long currentTimestamp = vFile.getTimeStamp();
            if (currentTimestamp < System.currentTimeMillis() - 10000L) {
                return null;
            }
            if (byteContent != null) {
                byte[] it = byteContent = LocalHistory.Companion.getInstance().getByteContent(vFile, arg_0 -> DiffContentResolver.getPreviousContentFromLocalHistory$lambda$0(currentTimestamp, arg_0));
                boolean bl = false;
                Charset charset = vFile.getCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
                Charset charset2 = charset;
                string2 = new String(it, charset2);
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Exception e) {
            DiffContentResolverKt.access$getLogger$p().warn("Failed to get Local History content: " + vFile.getPath(), (Throwable)e);
            string = null;
        }
        return string;
    }

    private static final VirtualFile resolve$lambda$0(Path $path) {
        return LocalFileSystem.getInstance().findFileByNioFile($path);
    }

    private static final String readCurrentFileContent$lambda$0(VirtualFile $vFile, DiffContentResolver this$0) {
        Document document2 = FileDocumentManager.getInstance().getDocument($vFile, this$0.project);
        return document2 != null ? document2.getText() : null;
    }

    private static final boolean getPreviousContentFromLocalHistory$lambda$0(long $currentTimestamp, long revisionTimestamp) {
        return revisionTimestamp < $currentTimestamp;
    }

    public static final /* synthetic */ Object access$readCurrentFileContent(DiffContentResolver $this, Path localPath, Continuation $completion) {
        return $this.readCurrentFileContent(localPath, (Continuation<? super String>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/DiffContentResolver$Companion;", "", "<init>", "()V", "RECENT_CHANGE_WINDOW_MS", "", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/DiffContentResolver$ResolvedDiff;", "", "beforeContent", "", "afterContent", "isFullFile", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getBeforeContent", "()Ljava/lang/String;", "getAfterContent", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
    public static final class ResolvedDiff {
        @Nullable
        private final String beforeContent;
        @NotNull
        private final String afterContent;
        private final boolean isFullFile;

        public ResolvedDiff(@Nullable String beforeContent, @NotNull String afterContent, boolean isFullFile) {
            Intrinsics.checkNotNullParameter((Object)afterContent, (String)"afterContent");
            this.beforeContent = beforeContent;
            this.afterContent = afterContent;
            this.isFullFile = isFullFile;
        }

        @Nullable
        public final String getBeforeContent() {
            return this.beforeContent;
        }

        @NotNull
        public final String getAfterContent() {
            return this.afterContent;
        }

        public final boolean isFullFile() {
            return this.isFullFile;
        }

        @Nullable
        public final String component1() {
            return this.beforeContent;
        }

        @NotNull
        public final String component2() {
            return this.afterContent;
        }

        public final boolean component3() {
            return this.isFullFile;
        }

        @NotNull
        public final ResolvedDiff copy(@Nullable String beforeContent, @NotNull String afterContent, boolean isFullFile) {
            Intrinsics.checkNotNullParameter((Object)afterContent, (String)"afterContent");
            return new ResolvedDiff(beforeContent, afterContent, isFullFile);
        }

        public static /* synthetic */ ResolvedDiff copy$default(ResolvedDiff resolvedDiff, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = resolvedDiff.beforeContent;
            }
            if ((n & 2) != 0) {
                string2 = resolvedDiff.afterContent;
            }
            if ((n & 4) != 0) {
                bl = resolvedDiff.isFullFile;
            }
            return resolvedDiff.copy(string, string2, bl);
        }

        @NotNull
        public String toString() {
            return "ResolvedDiff(beforeContent=" + this.beforeContent + ", afterContent=" + this.afterContent + ", isFullFile=" + this.isFullFile + ")";
        }

        public int hashCode() {
            int result2 = this.beforeContent == null ? 0 : this.beforeContent.hashCode();
            result2 = result2 * 31 + this.afterContent.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isFullFile);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResolvedDiff)) {
                return false;
            }
            ResolvedDiff resolvedDiff = (ResolvedDiff)other;
            if (!Intrinsics.areEqual((Object)this.beforeContent, (Object)resolvedDiff.beforeContent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.afterContent, (Object)resolvedDiff.afterContent)) {
                return false;
            }
            return this.isFullFile == resolvedDiff.isFullFile;
        }
    }
}

