/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client.auth;

import com.agentclientprotocol.client.Client;
import com.agentclientprotocol.model.AuthMethod;
import com.agentclientprotocol.model.AuthMethodId;
import com.intellij.ml.llm.agents.acp.client.auth.ApiKeyAuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.AuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.AuthHandlerDispatcherKt;
import com.intellij.ml.llm.agents.acp.client.auth.AuthHandlerResult;
import com.intellij.ml.llm.agents.acp.client.auth.JbProxyAuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.StandardAuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.terminal.CmdTerminalAuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.terminal.PowershellTerminalAuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.terminal.ShellTerminalAuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.terminal.TerminalAuthHandler;
import com.intellij.ml.llm.agents.acp.config.LocalAcpAgentConfig;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.intellij.util.system.OS;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/auth/AuthHandlerDispatcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "handlers", "", "Lcom/intellij/ml/llm/agents/acp/client/auth/AuthHandler;", "getHandlers", "()Ljava/util/List;", "handleAuth", "Lcom/intellij/ml/llm/agents/acp/client/auth/AuthHandlerResult;", "client", "Lcom/agentclientprotocol/client/Client;", "authMethod", "Lcom/agentclientprotocol/model/AuthMethod;", "config", "Lcom/intellij/ml/llm/agents/acp/config/LocalAcpAgentConfig;", "(Lcom/agentclientprotocol/client/Client;Lcom/agentclientprotocol/model/AuthMethod;Lcom/intellij/ml/llm/agents/acp/config/LocalAcpAgentConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.agents.acp"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAuthHandlerDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthHandlerDispatcher.kt\ncom/intellij/ml/llm/agents/acp/client/auth/AuthHandlerDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n295#2,2:78\n*S KotlinDebug\n*F\n+ 1 AuthHandlerDispatcher.kt\ncom/intellij/ml/llm/agents/acp/client/auth/AuthHandlerDispatcher\n*L\n66#1:78,2\n*E\n"})
public final class AuthHandlerDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public AuthHandlerDispatcher(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final List<AuthHandler> getHandlers() {
        Object[] objectArray = new AuthHandler[]{new ApiKeyAuthHandler(), new JbProxyAuthHandler(), AuthHandlerDispatcher.Companion.createTerminalAuthHandler(this.project), new StandardAuthHandler()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final Object handleAuth(@NotNull Client client2, @NotNull AuthMethod authMethod, @NotNull LocalAcpAgentConfig config, @NotNull Continuation<? super AuthHandlerResult> $completion) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.getHandlers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AuthHandler it = (AuthHandler)element$iv;
                boolean bl = false;
                if (!it.canHandle(authMethod)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        AuthHandler handler2 = v0;
        if (handler2 == null) {
            AuthHandlerDispatcherKt.access$getLogger$p().error("No handler found for auth method: " + AuthMethodId.toString-impl((String)authMethod.getId-YMWAytM()));
            return new AuthHandlerResult.Failed("No handler available for auth method: " + authMethod.getName());
        }
        AuthHandlerDispatcherKt.access$getLogger$p().info("Using " + Reflection.getOrCreateKotlinClass(handler2.getClass()).getSimpleName() + " for auth method: " + AuthMethodId.toString-impl((String)authMethod.getId-YMWAytM()));
        return handler2.handle(client2, authMethod, config, $completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/auth/AuthHandlerDispatcher$Companion;", "", "<init>", "()V", "createTerminalAuthHandler", "Lcom/intellij/ml/llm/agents/acp/client/auth/terminal/TerminalAuthHandler;", "project", "Lcom/intellij/openapi/project/Project;", "createWindowsTerminalAuthHandler", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        private final TerminalAuthHandler createTerminalAuthHandler(Project project2) {
            return OS.CURRENT == OS.Windows ? this.createWindowsTerminalAuthHandler(project2) : (TerminalAuthHandler)new ShellTerminalAuthHandler(project2);
        }

        private final TerminalAuthHandler createWindowsTerminalAuthHandler(Project project2) {
            String shellPath = TerminalProjectOptionsProvider.Companion.getInstance(project2).getShellPath();
            String string = PathUtil.getFileName((String)shellPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String shellName = string2;
            return StringsKt.contains$default((CharSequence)shellName, (CharSequence)"powershell", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)shellName, (CharSequence)"pwsh", (boolean)false, (int)2, null) ? (TerminalAuthHandler)new PowershellTerminalAuthHandler(project2) : (TerminalAuthHandler)new CmdTerminalAuthHandler(project2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

