/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client.settings;

import com.agentclientprotocol.client.ClientSession;
import com.agentclientprotocol.model.SessionMode;
import com.agentclientprotocol.model.SessionModeId;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.agents.acp.client.settings.AcpModeManager;
import com.intellij.ml.llm.agents.acp.client.settings.AcpModesSupportKt;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.settings.AcpAgentSettingsService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager;", "", "<init>", "()V", "agentIdToModes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager$AgentCurrentMode;", "_modeChangedSignal", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "modeAnnouncedSignal", "Lkotlinx/coroutines/flow/SharedFlow;", "getModeAnnouncedSignal", "()Lkotlinx/coroutines/flow/SharedFlow;", "announceSupportedModes", "agentId", "modes", "", "Lcom/agentclientprotocol/model/SessionMode;", "proposedInitialMode", "setCurrentModeByName", "mode", "", "getAgentCurrentMode", "Companion", "AgentCurrentMode", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpModesSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpModesSupport.kt\ncom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n42#2,3:174\n42#2,3:178\n1#3:177\n*S KotlinDebug\n*F\n+ 1 AcpModesSupport.kt\ncom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager\n*L\n100#1:174,3\n132#1:178,3\n*E\n"})
public final class AcpModeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<AcpAgentId, AgentCurrentMode> agentIdToModes = new ConcurrentHashMap();
    @NotNull
    private final MutableSharedFlow<Unit> _modeChangedSignal = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)5, null);
    @NotNull
    private final SharedFlow<Unit> modeAnnouncedSignal = FlowKt.asSharedFlow(this._modeChangedSignal);

    @NotNull
    public final SharedFlow<Unit> getModeAnnouncedSignal() {
        return this.modeAnnouncedSignal;
    }

    private final void announceSupportedModes(AcpAgentId agentId, List<SessionMode> modes, SessionMode proposedInitialMode) {
        SessionMode savedMode;
        SessionMode sessionMode;
        SessionMode sessionMode2;
        String savedModeId;
        if (modes.isEmpty()) {
            AcpModesSupportKt.access$getLogger$p().warn("Agent " + agentId + " returned no supported modes");
            return;
        }
        AcpModesSupportKt.access$getLogger$p().info("Announcing supported modes for agent " + agentId + ": " + modes);
        boolean $i$f$service = false;
        Class<AcpAgentSettingsService> serviceClass$iv = AcpAgentSettingsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        AcpAgentSettingsService settingsService = (AcpAgentSettingsService)object;
        String string = savedModeId = settingsService.getAgentMode-3F7dhhE(agentId);
        if (string != null) {
            Object v2;
            block6: {
                String modeId = string;
                boolean bl = false;
                Iterable iterable = modes;
                for (Object t : iterable) {
                    SessionMode it = (SessionMode)t;
                    boolean bl2 = false;
                    if (!SessionModeId.equals-impl0((String)it.getId-kyZWFqk(), (String)modeId)) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            sessionMode2 = v2;
        } else {
            sessionMode2 = null;
        }
        if ((sessionMode = (savedMode = sessionMode2)) == null && (sessionMode = proposedInitialMode) == null) {
            sessionMode = (SessionMode)CollectionsKt.first(modes);
        }
        SessionMode initialMode = sessionMode;
        AcpModesSupportKt.access$getLogger$p().info("Agent " + agentId + " initial mode: " + initialMode.getName() + " (from " + (savedMode != null ? "saved settings" : (proposedInitialMode != null ? "agent proposal" : "default")) + ")");
        AgentCurrentMode agentCurrentMode = new AgentCurrentMode(agentId, modes, initialMode);
        this.agentIdToModes.computeIfAbsent(agentId, arg_0 -> AcpModeManager.announceSupportedModes$lambda$2(arg_0 -> AcpModeManager.announceSupportedModes$lambda$1(agentCurrentMode, arg_0), arg_0));
        this._modeChangedSignal.tryEmit((Object)Unit.INSTANCE);
    }

    public final void setCurrentModeByName(@NotNull AcpAgentId agentId, @NotNull String mode) {
        Object v0;
        AgentCurrentMode previousState;
        block4: {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            previousState = this.agentIdToModes.get(agentId);
            if (previousState == null) {
                AcpModesSupportKt.access$getLogger$p().warn("Agent " + agentId + " has no registered modes, ignore the set mode request");
                return;
            }
            Iterable iterable = previousState.getModes();
            for (Object t : iterable) {
                SessionMode it = (SessionMode)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)mode)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        SessionMode modeByName = v0;
        if (modeByName == null) {
            AcpModesSupportKt.access$getLogger$p().error("Agent " + agentId + " does not support mode " + mode + ", ignore the set mode request");
            return;
        }
        AcpModesSupportKt.access$getLogger$p().info("Agent " + agentId + " set mode to " + mode);
        ((Map)this.agentIdToModes).put(agentId, AgentCurrentMode.copy$default(previousState, null, null, modeByName, 3, null));
        boolean $i$f$service = false;
        Class<AcpAgentSettingsService> serviceClass$iv = AcpAgentSettingsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        AcpAgentSettingsService settingsService = (AcpAgentSettingsService)object;
        settingsService.setAgentMode-A4yjT48(agentId, modeByName.getId-kyZWFqk());
        this._modeChangedSignal.tryEmit((Object)Unit.INSTANCE);
    }

    @Nullable
    public final AgentCurrentMode getAgentCurrentMode(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        return this.agentIdToModes.get(agentId);
    }

    private static final AgentCurrentMode announceSupportedModes$lambda$1(AgentCurrentMode $agentCurrentMode, AcpAgentId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $agentCurrentMode;
    }

    private static final AgentCurrentMode announceSupportedModes$lambda$2(Function1 $tmp0, Object p0) {
        return (AgentCurrentMode)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager$AgentCurrentMode;", "", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "modes", "", "Lcom/agentclientprotocol/model/SessionMode;", "currentMode", "<init>", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Ljava/util/List;Lcom/agentclientprotocol/model/SessionMode;)V", "getAgentId", "()Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "getModes", "()Ljava/util/List;", "getCurrentMode", "()Lcom/agentclientprotocol/model/SessionMode;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.agents.acp"})
    public static final class AgentCurrentMode {
        @NotNull
        private final AcpAgentId agentId;
        @NotNull
        private final List<SessionMode> modes;
        @NotNull
        private final SessionMode currentMode;

        public AgentCurrentMode(@NotNull AcpAgentId agentId, @NotNull List<SessionMode> modes, @NotNull SessionMode currentMode) {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter(modes, (String)"modes");
            Intrinsics.checkNotNullParameter((Object)currentMode, (String)"currentMode");
            this.agentId = agentId;
            this.modes = modes;
            this.currentMode = currentMode;
        }

        @NotNull
        public final AcpAgentId getAgentId() {
            return this.agentId;
        }

        @NotNull
        public final List<SessionMode> getModes() {
            return this.modes;
        }

        @NotNull
        public final SessionMode getCurrentMode() {
            return this.currentMode;
        }

        @NotNull
        public final AcpAgentId component1() {
            return this.agentId;
        }

        @NotNull
        public final List<SessionMode> component2() {
            return this.modes;
        }

        @NotNull
        public final SessionMode component3() {
            return this.currentMode;
        }

        @NotNull
        public final AgentCurrentMode copy(@NotNull AcpAgentId agentId, @NotNull List<SessionMode> modes, @NotNull SessionMode currentMode) {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter(modes, (String)"modes");
            Intrinsics.checkNotNullParameter((Object)currentMode, (String)"currentMode");
            return new AgentCurrentMode(agentId, modes, currentMode);
        }

        public static /* synthetic */ AgentCurrentMode copy$default(AgentCurrentMode agentCurrentMode, AcpAgentId acpAgentId, List list, SessionMode sessionMode, int n, Object object) {
            if ((n & 1) != 0) {
                acpAgentId = agentCurrentMode.agentId;
            }
            if ((n & 2) != 0) {
                list = agentCurrentMode.modes;
            }
            if ((n & 4) != 0) {
                sessionMode = agentCurrentMode.currentMode;
            }
            return agentCurrentMode.copy(acpAgentId, list, sessionMode);
        }

        @NotNull
        public String toString() {
            return "AgentCurrentMode(agentId=" + this.agentId + ", modes=" + this.modes + ", currentMode=" + this.currentMode + ")";
        }

        public int hashCode() {
            int result2 = this.agentId.hashCode();
            result2 = result2 * 31 + ((Object)this.modes).hashCode();
            result2 = result2 * 31 + this.currentMode.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgentCurrentMode)) {
                return false;
            }
            AgentCurrentMode agentCurrentMode = (AgentCurrentMode)other;
            if (!Intrinsics.areEqual((Object)this.agentId, (Object)agentCurrentMode.agentId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.modes, agentCurrentMode.modes)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentMode, (Object)agentCurrentMode.currentMode);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager;", "project", "Lcom/intellij/openapi/project/Project;", "registerSupportedModes", "", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "clientSession", "Lcom/agentclientprotocol/client/ClientSession;", "setUpModeForClientSession", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Lcom/agentclientprotocol/client/ClientSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.agents.acp"})
    @SourceDebugExtension(value={"SMAP\nAcpModesSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpModesSupport.kt\ncom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n30#2,2:174\n1#3:176\n*S KotlinDebug\n*F\n+ 1 AcpModesSupport.kt\ncom/intellij/ml/llm/agents/acp/client/settings/AcpModeManager$Companion\n*L\n145#1:174,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpModeManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<AcpModeManager> serviceClass$iv = AcpModeManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AcpModeManager)object;
        }

        public final void registerSupportedModes(@NotNull Project project2, @NotNull AcpAgentId agentId, @NotNull ClientSession clientSession) {
            Object v0;
            List availableModes;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
                Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
                if (!clientSession.getModesSupported()) {
                    return;
                }
                availableModes = clientSession.getAvailableModes();
                String initialModeId = ((SessionModeId)clientSession.getCurrentMode().getValue()).unbox-impl();
                Iterable iterable = availableModes;
                for (Object t : iterable) {
                    SessionMode it = (SessionMode)t;
                    boolean bl = false;
                    if (!SessionModeId.equals-impl0((String)it.getId-kyZWFqk(), (String)initialModeId)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            SessionMode initialMode = v0;
            AcpModeManager acpModeManager = this.getInstance(project2);
            acpModeManager.announceSupportedModes(agentId, availableModes, initialMode);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object setUpModeForClientSession(@NotNull Project project, @NotNull AcpAgentId agentId, @NotNull ClientSession clientSession, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof setUpModeForClientSession.1)) ** GOTO lbl-1000
            var10_5 = $completion;
            if ((var10_5.label & -2147483648) != 0) {
                var10_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.setUpModeForClientSession(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    acpModeManager = this.getInstance(project);
                    v0 = acpModeManager.getAgentCurrentMode(agentId);
                    if (v0 == null || (v0 = v0.getCurrentMode()) == null) break;
                    mode = var6_10 = v0;
                    $i$a$-also-AcpModeManager$Companion$setUpModeForClientSession$2 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)agentId);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)clientSession);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)acpModeManager);
                    $continuation.L$4 = var6_10;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)mode);
                    $continuation.I$0 = $i$a$-also-AcpModeManager$Companion$setUpModeForClientSession$2;
                    $continuation.label = 1;
                    v1 = ClientSession.setMode-tFeI3nk$default((ClientSession)clientSession, (String)mode.getId-kyZWFqk(), null, (Continuation)$continuation, (int)2, null);
                    if (v1 == var11_7) {
                        return var11_7;
                    }
                    break;
                }
                case 1: {
                    $i$a$-also-AcpModeManager$Companion$setUpModeForClientSession$2 = $continuation.I$0;
                    mode = (SessionMode)$continuation.L$5;
                    var6_11 = (SessionMode)$continuation.L$4;
                    acpModeManager = (AcpModeManager)$continuation.L$3;
                    clientSession = (ClientSession)$continuation.L$2;
                    agentId = (AcpAgentId)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    break;
                }
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

