/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client.settings;

import com.agentclientprotocol.client.ClientSession;
import com.agentclientprotocol.model.ModelId;
import com.agentclientprotocol.model.ModelInfo;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.agents.acp.client.settings.AcpModelManager;
import com.intellij.ml.llm.agents.acp.client.settings.AcpModelSelectorKt;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.settings.AcpAgentSettingsService;
import com.intellij.ml.llm.core.providers.ThirdPartyLLMProfileId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager;", "", "<init>", "()V", "agentIdToModels", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager$AgentCurrentModel;", "_modelChangedSignal", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "modelAnnouncedSignal", "Lkotlinx/coroutines/flow/SharedFlow;", "getModelAnnouncedSignal", "()Lkotlinx/coroutines/flow/SharedFlow;", "announceSupportedModels", "agentId", "models", "", "Lcom/agentclientprotocol/model/ModelInfo;", "proposedInitialModel", "setCurrentModelById", "profileId", "", "getAgentCurrentModel", "Companion", "AgentCurrentModel", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpModelSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpModelSelector.kt\ncom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n42#2,3:207\n42#2,3:211\n1#3:210\n*S KotlinDebug\n*F\n+ 1 AcpModelSelector.kt\ncom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager\n*L\n127#1:207,3\n166#1:211,3\n*E\n"})
public final class AcpModelManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<AcpAgentId, AgentCurrentModel> agentIdToModels = new ConcurrentHashMap();
    @NotNull
    private final MutableSharedFlow<Unit> _modelChangedSignal = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)5, null);
    @NotNull
    private final SharedFlow<Unit> modelAnnouncedSignal = FlowKt.asSharedFlow(this._modelChangedSignal);

    @NotNull
    public final SharedFlow<Unit> getModelAnnouncedSignal() {
        return this.modelAnnouncedSignal;
    }

    private final void announceSupportedModels(AcpAgentId agentId, List<ModelInfo> models2, ModelInfo proposedInitialModel) {
        ModelInfo savedModel;
        ModelInfo modelInfo;
        ModelInfo modelInfo2;
        String savedModelId;
        if (models2.isEmpty()) {
            AcpModelSelectorKt.access$getLogger$p().warn("Agent " + agentId + " returned no supported models");
            return;
        }
        AcpModelSelectorKt.access$getLogger$p().info("Announcing supported models for agent " + agentId + ": " + models2);
        boolean $i$f$service = false;
        Class<AcpAgentSettingsService> serviceClass$iv = AcpAgentSettingsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        AcpAgentSettingsService settingsService = (AcpAgentSettingsService)object;
        String string = savedModelId = settingsService.getAgentModel-YT4DQr8(agentId);
        if (string != null) {
            Object v2;
            block6: {
                String modelId = string;
                boolean bl = false;
                Iterable iterable = models2;
                for (Object t : iterable) {
                    ModelInfo it = (ModelInfo)t;
                    boolean bl2 = false;
                    if (!ModelId.equals-impl0((String)it.getModelId-GMZLII8(), (String)modelId)) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            modelInfo2 = v2;
        } else {
            modelInfo2 = null;
        }
        if ((modelInfo = (savedModel = modelInfo2)) == null && (modelInfo = proposedInitialModel) == null) {
            modelInfo = (ModelInfo)CollectionsKt.first(models2);
        }
        ModelInfo initialModel2 = modelInfo;
        AcpModelSelectorKt.access$getLogger$p().info("Agent " + agentId + " initial model: " + initialModel2.getName() + " (from " + (savedModel != null ? "saved settings" : (proposedInitialModel != null ? "agent proposal" : "default")) + ")");
        AgentCurrentModel agentCurrentModel = new AgentCurrentModel(agentId, models2, initialModel2);
        this.agentIdToModels.computeIfAbsent(agentId, arg_0 -> AcpModelManager.announceSupportedModels$lambda$2(arg_0 -> AcpModelManager.announceSupportedModels$lambda$1(agentCurrentModel, arg_0), arg_0));
        this._modelChangedSignal.tryEmit((Object)Unit.INSTANCE);
    }

    public final void setCurrentModelById(@NotNull AcpAgentId agentId, @NotNull String profileId) {
        Object v0;
        String modelId;
        AgentCurrentModel previousState;
        block4: {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
            previousState = this.agentIdToModels.get(agentId);
            if (previousState == null) {
                AcpModelSelectorKt.access$getLogger$p().warn("Agent " + agentId + " has no registered models, ignore the set model request");
                return;
            }
            modelId = ThirdPartyLLMProfileId.Companion.isThirdPartyProfileId(profileId) ? ThirdPartyLLMProfileId.Companion.fromString(profileId).getProfileId() : profileId;
            Iterable iterable = previousState.getModels();
            for (Object t : iterable) {
                ModelInfo it = (ModelInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModelId-GMZLII8(), (Object)modelId)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        ModelInfo modelById = v0;
        if (modelById == null) {
            AcpModelSelectorKt.access$getLogger$p().error("Agent " + agentId + " does not support model " + modelId + ", ignore the set model request");
            return;
        }
        AcpModelSelectorKt.access$getLogger$p().info("Agent " + agentId + " set model to " + modelById.getName());
        ((Map)this.agentIdToModels).put(agentId, AgentCurrentModel.copy$default(previousState, null, null, modelById, 3, null));
        boolean $i$f$service = false;
        Class<AcpAgentSettingsService> serviceClass$iv = AcpAgentSettingsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        AcpAgentSettingsService settingsService = (AcpAgentSettingsService)object;
        settingsService.setAgentModel-9osuBzc(agentId, modelById.getModelId-GMZLII8());
        this._modelChangedSignal.tryEmit((Object)Unit.INSTANCE);
    }

    @Nullable
    public final AgentCurrentModel getAgentCurrentModel(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        return this.agentIdToModels.get(agentId);
    }

    private static final AgentCurrentModel announceSupportedModels$lambda$1(AgentCurrentModel $agentCurrentModel, AcpAgentId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $agentCurrentModel;
    }

    private static final AgentCurrentModel announceSupportedModels$lambda$2(Function1 $tmp0, Object p0) {
        return (AgentCurrentModel)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager$AgentCurrentModel;", "", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "models", "", "Lcom/agentclientprotocol/model/ModelInfo;", "currentModel", "<init>", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Ljava/util/List;Lcom/agentclientprotocol/model/ModelInfo;)V", "getAgentId", "()Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "getModels", "()Ljava/util/List;", "getCurrentModel", "()Lcom/agentclientprotocol/model/ModelInfo;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.agents.acp"})
    public static final class AgentCurrentModel {
        @NotNull
        private final AcpAgentId agentId;
        @NotNull
        private final List<ModelInfo> models;
        @NotNull
        private final ModelInfo currentModel;

        public AgentCurrentModel(@NotNull AcpAgentId agentId, @NotNull List<ModelInfo> models2, @NotNull ModelInfo currentModel) {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter(models2, (String)"models");
            Intrinsics.checkNotNullParameter((Object)currentModel, (String)"currentModel");
            this.agentId = agentId;
            this.models = models2;
            this.currentModel = currentModel;
        }

        @NotNull
        public final AcpAgentId getAgentId() {
            return this.agentId;
        }

        @NotNull
        public final List<ModelInfo> getModels() {
            return this.models;
        }

        @NotNull
        public final ModelInfo getCurrentModel() {
            return this.currentModel;
        }

        @NotNull
        public final AcpAgentId component1() {
            return this.agentId;
        }

        @NotNull
        public final List<ModelInfo> component2() {
            return this.models;
        }

        @NotNull
        public final ModelInfo component3() {
            return this.currentModel;
        }

        @NotNull
        public final AgentCurrentModel copy(@NotNull AcpAgentId agentId, @NotNull List<ModelInfo> models2, @NotNull ModelInfo currentModel) {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter(models2, (String)"models");
            Intrinsics.checkNotNullParameter((Object)currentModel, (String)"currentModel");
            return new AgentCurrentModel(agentId, models2, currentModel);
        }

        public static /* synthetic */ AgentCurrentModel copy$default(AgentCurrentModel agentCurrentModel, AcpAgentId acpAgentId, List list, ModelInfo modelInfo, int n, Object object) {
            if ((n & 1) != 0) {
                acpAgentId = agentCurrentModel.agentId;
            }
            if ((n & 2) != 0) {
                list = agentCurrentModel.models;
            }
            if ((n & 4) != 0) {
                modelInfo = agentCurrentModel.currentModel;
            }
            return agentCurrentModel.copy(acpAgentId, list, modelInfo);
        }

        @NotNull
        public String toString() {
            return "AgentCurrentModel(agentId=" + this.agentId + ", models=" + this.models + ", currentModel=" + this.currentModel + ")";
        }

        public int hashCode() {
            int result2 = this.agentId.hashCode();
            result2 = result2 * 31 + ((Object)this.models).hashCode();
            result2 = result2 * 31 + this.currentModel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgentCurrentModel)) {
                return false;
            }
            AgentCurrentModel agentCurrentModel = (AgentCurrentModel)other;
            if (!Intrinsics.areEqual((Object)this.agentId, (Object)agentCurrentModel.agentId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.models, agentCurrentModel.models)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentModel, (Object)agentCurrentModel.currentModel);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager;", "project", "Lcom/intellij/openapi/project/Project;", "registerSupportedModels", "", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "clientSession", "Lcom/agentclientprotocol/client/ClientSession;", "setUpModelForClientSession", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Lcom/agentclientprotocol/client/ClientSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.agents.acp"})
    @SourceDebugExtension(value={"SMAP\nAcpModelSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpModelSelector.kt\ncom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n30#2,2:207\n1#3:209\n*S KotlinDebug\n*F\n+ 1 AcpModelSelector.kt\ncom/intellij/ml/llm/agents/acp/client/settings/AcpModelManager$Companion\n*L\n179#1:207,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpModelManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<AcpModelManager> serviceClass$iv = AcpModelManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AcpModelManager)object;
        }

        public final void registerSupportedModels(@NotNull Project project2, @NotNull AcpAgentId agentId, @NotNull ClientSession clientSession) {
            Object v0;
            List availableModels;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
                Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
                if (!clientSession.getModelsSupported()) {
                    return;
                }
                availableModels = clientSession.getAvailableModels();
                String initialModelId = ((ModelId)clientSession.getCurrentModel().getValue()).unbox-impl();
                Iterable iterable = availableModels;
                for (Object t : iterable) {
                    ModelInfo it = (ModelInfo)t;
                    boolean bl = false;
                    if (!ModelId.equals-impl0((String)it.getModelId-GMZLII8(), (String)initialModelId)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            ModelInfo initialModel2 = v0;
            AcpModelManager acpModelManager = this.getInstance(project2);
            acpModelManager.announceSupportedModels(agentId, availableModels, initialModel2);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object setUpModelForClientSession(@NotNull Project project, @NotNull AcpAgentId agentId, @NotNull ClientSession clientSession, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof setUpModelForClientSession.1)) ** GOTO lbl-1000
            var10_5 = $completion;
            if ((var10_5.label & -2147483648) != 0) {
                var10_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.setUpModelForClientSession(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    acpModelManager = this.getInstance(project);
                    v0 = acpModelManager.getAgentCurrentModel(agentId);
                    if (v0 == null || (v0 = v0.getCurrentModel()) == null) break;
                    model = var6_10 = v0;
                    $i$a$-also-AcpModelManager$Companion$setUpModelForClientSession$2 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)agentId);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)clientSession);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)acpModelManager);
                    $continuation.L$4 = var6_10;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)model);
                    $continuation.I$0 = $i$a$-also-AcpModelManager$Companion$setUpModelForClientSession$2;
                    $continuation.label = 1;
                    v1 = ClientSession.setModel-BrQ11X8$default((ClientSession)clientSession, (String)model.getModelId-GMZLII8(), null, (Continuation)$continuation, (int)2, null);
                    if (v1 == var11_7) {
                        return var11_7;
                    }
                    break;
                }
                case 1: {
                    $i$a$-also-AcpModelManager$Companion$setUpModelForClientSession$2 = $continuation.I$0;
                    model = (ModelInfo)$continuation.L$5;
                    var6_11 = (ModelInfo)$continuation.L$4;
                    acpModelManager = (AcpModelManager)$continuation.L$3;
                    clientSession = (ClientSession)$continuation.L$2;
                    agentId = (AcpAgentId)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    break;
                }
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

