/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.diagnostic;

import com.intellij.ml.llm.agents.acp.diagnostic.LineBufferLogger;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/agents/acp/diagnostic/AcpLoggingInputStream;", "Ljava/io/InputStream;", "delegate", "<init>", "(Ljava/io/InputStream;)V", "lineBufferLogger", "Lcom/intellij/ml/llm/agents/acp/diagnostic/LineBufferLogger;", "read", "", "b", "", "off", "len", "close", "", "intellij.ml.llm.agents.acp"})
public final class AcpLoggingInputStream
extends InputStream {
    @NotNull
    private final InputStream delegate;
    @NotNull
    private final LineBufferLogger lineBufferLogger;

    public AcpLoggingInputStream(@NotNull InputStream delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.lineBufferLogger = new LineBufferLogger("IN: ");
    }

    @Override
    public int read() {
        int result2 = this.delegate.read();
        this.lineBufferLogger.append(result2);
        return result2;
    }

    @Override
    public int read(@Nullable byte[] b, int off, int len) {
        int result2 = this.delegate.read(b, off, len);
        if (result2 > 0 && b != null) {
            this.lineBufferLogger.append(b, off, result2);
        }
        return result2;
    }

    @Override
    public void close() {
        this.lineBufferLogger.flush();
        this.delegate.close();
    }
}

