/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.diagnostic;

import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/agents/acp/diagnostic/InMemoryLogHandler;", "Ljava/util/logging/Handler;", "maxChars", "", "<init>", "(I)V", "formatter", "Lcom/intellij/openapi/diagnostic/IdeaLogRecordFormatter;", "entries", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "totalChars", "Ljava/util/concurrent/atomic/AtomicInteger;", "publish", "", "record", "Ljava/util/logging/LogRecord;", "evict", "flush", "close", "getContent", "writeTo", "path", "Ljava/nio/file/Path;", "Companion", "intellij.ml.llm.agents.acp"})
public final class InMemoryLogHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxChars;
    @NotNull
    private final IdeaLogRecordFormatter formatter;
    @NotNull
    private final ConcurrentLinkedQueue<String> entries;
    @NotNull
    private final AtomicInteger totalChars;
    public static final int DEFAULT_MAX_CHARS = 5000000;

    public InMemoryLogHandler(int maxChars) {
        this.maxChars = maxChars;
        this.formatter = new IdeaLogRecordFormatter();
        this.entries = new ConcurrentLinkedQueue();
        this.totalChars = new AtomicInteger(0);
    }

    public /* synthetic */ InMemoryLogHandler(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 5000000;
        }
        this(n);
    }

    @Override
    public void publish(@Nullable LogRecord record) {
        if (record == null) {
            return;
        }
        String formatted = this.formatter.format(record);
        this.entries.add(formatted);
        this.totalChars.addAndGet(formatted.length());
        this.evict();
    }

    private final void evict() {
        while (this.totalChars.get() > this.maxChars && this.entries.poll() != null) {
            String removed;
            this.totalChars.addAndGet(-removed.length());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.entries.clear();
        this.totalChars.set(0);
    }

    @NotNull
    public final String getContent() {
        return CollectionsKt.joinToString$default((Iterable)this.entries, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    public final void writeTo(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String content2 = this.getContent();
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        Files.writeString(path, (CharSequence)content2, openOptionArray);
    }

    public InMemoryLogHandler() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/acp/diagnostic/InMemoryLogHandler$Companion;", "", "<init>", "()V", "DEFAULT_MAX_CHARS", "", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

