/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.process;

import com.intellij.ml.llm.agents.acp.config.AcpAgentStartConfig;
import com.intellij.ml.llm.agents.acp.config.LocalAcpAgentConfig;
import com.intellij.ml.llm.agents.acp.process.AcpCommandResolver;
import com.intellij.ml.llm.agents.acp.process.AcpProcessHandlerService;
import com.intellij.ml.llm.agents.acp.process.AcpProcessHandlerServiceKt;
import com.intellij.ml.llm.agents.acp.process.EelAcpProcessHandler;
import com.intellij.ml.llm.agents.acp.process.LocalAcpServerProcessHandler;
import com.intellij.ml.llm.agents.acp.process.ProcessKey;
import com.intellij.ml.llm.agents.acp.process.ProcessStatistics;
import com.intellij.ml.llm.agents.acp.process.ResolvedRuntimeConfig;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.platform.eel.ExecuteProcessException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J[\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!2\u0006\u0010\u0017\u001a\u00020\"H\u0002J\"\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0018\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0014J\u0016\u0010'\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0014J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010)\u001a\u00020\u001eH\u0002J\u0006\u0010*\u001a\u00020+J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140-2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "processHandlers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/process/ProcessKey;", "Lcom/intellij/ml/llm/agents/acp/process/LocalAcpServerProcessHandler;", "processHandlersLock", "Lkotlinx/coroutines/sync/Mutex;", "cleanupJob", "Lkotlinx/coroutines/Job;", "getOrCreateProcessHandler", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "agentName", "", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "config", "Lcom/intellij/ml/llm/agents/acp/config/LocalAcpAgentConfig;", "handleError", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "error", "", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lcom/intellij/ml/llm/agents/acp/config/LocalAcpAgentConfig;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateConfig", "", "Lcom/intellij/ml/llm/agents/acp/config/AcpAgentStartConfig;", "getReusableProcessHandler", "key", "chatId", "getProcessHandler", "stopProcessHandler", "stopAllForAgent", "stopAll", "getStatistics", "Lcom/intellij/ml/llm/agents/acp/process/ProcessStatistics;", "getChatIdsForAgent", "", "cleanupDeadProcesses", "dispose", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpProcessHandlerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpProcessHandlerService.kt\ncom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n1#2:364\n116#3,11:365\n774#4:376\n865#4,2:377\n1869#4,2:379\n1869#4,2:381\n1788#4,4:383\n774#4:387\n865#4,2:388\n1563#4:390\n1634#4,3:391\n774#4:394\n865#4,2:395\n1563#4:397\n1634#4,3:398\n1869#4,2:401\n*S KotlinDebug\n*F\n+ 1 AcpProcessHandlerService.kt\ncom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService\n*L\n121#1:365,11\n233#1:376\n233#1:377,2\n235#1:379,2\n260#1:381,2\n278#1:383,4\n296#1:387\n296#1:388,2\n297#1:390\n297#1:391,3\n307#1:394\n307#1:395,2\n308#1:397\n308#1:398,3\n312#1:401,2\n*E\n"})
public final class AcpProcessHandlerService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<ProcessKey, LocalAcpServerProcessHandler> processHandlers;
    @NotNull
    private final Mutex processHandlersLock;
    @NotNull
    private final Job cleanupJob;

    public AcpProcessHandlerService(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.processHandlers = new ConcurrentHashMap();
        this.processHandlersLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.cleanupJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AcpProcessHandlerService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                            if (v0 == var3_3) {
                                return var3_3;
                            }
                            ** GOTO lbl18
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        AcpProcessHandlerService.access$cleanupDeadProcesses(this.this$0);
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Initialized ConfigurableAcpProcessHandlerService for project: " + this.project.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object getOrCreateProcessHandler(@NotNull AcpAgentId agentId, @NotNull String agentName, @NotNull ChatSession chat, @NotNull LocalAcpAgentConfig config, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super String, Unit> handleError, @NotNull Continuation<? super LocalAcpServerProcessHandler> $completion) {
        if (!($completion instanceof getOrCreateProcessHandler.1)) ** GOTO lbl-1000
        var26_8 = $completion;
        if ((var26_8.label & -2147483648) != 0) {
            var26_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                Object L$14;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ AcpProcessHandlerService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getOrCreateProcessHandler(null, null, null, null, null, null, (Continuation<? super LocalAcpServerProcessHandler>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var27_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                key = new ProcessKey(agentId, chat.getUid());
                chatId = chat.getUid();
                v0 = handler = this.getReusableProcessHandler(key, agentName, chatId);
                if (v0 != null) {
                    return v0;
                }
                $continuation.L$0 = agentId;
                $continuation.L$1 = agentName;
                $continuation.L$2 = chat;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$4 = coroutineScope;
                $continuation.L$5 = handleError;
                $continuation.L$6 = key;
                $continuation.L$7 = chatId;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)handler);
                $continuation.label = 1;
                v1 = config.resolveAgentStartConfig((Continuation<? super AcpAgentStartConfig>)$continuation);
                ** if (v1 != var27_10) goto lbl32
lbl31:
                // 1 sources

                return var27_10;
lbl32:
                // 1 sources

                ** GOTO lbl47
            }
            case 1: {
                handler = (LocalAcpServerProcessHandler)$continuation.L$8;
                chatId = (String)$continuation.L$7;
                key = (ProcessKey)$continuation.L$6;
                handleError = (Function1)$continuation.L$5;
                coroutineScope = (CoroutineScope)$continuation.L$4;
                config = (LocalAcpAgentConfig)$continuation.L$3;
                chat = (ChatSession)$continuation.L$2;
                agentName = (String)$continuation.L$1;
                agentId = (AcpAgentId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl47:
                    // 2 sources

                    var12_15 = (AcpAgentStartConfig)v1;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    v2 = e.getMessage();
                    if (v2 != null) {
                        it = v2;
                        $i$a$-let-AcpProcessHandlerService$getOrCreateProcessHandler$startConfig$1 = false;
                        handleError.invoke((Object)it);
                    }
                    return null;
                }
                startConfig = var12_15;
                $continuation.L$0 = agentId;
                $continuation.L$1 = agentName;
                $continuation.L$2 = chat;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$4 = coroutineScope;
                $continuation.L$5 = handleError;
                $continuation.L$6 = key;
                $continuation.L$7 = chatId;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)handler);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)startConfig);
                $continuation.label = 2;
                v3 = AcpCommandResolver.INSTANCE.ensureRuntimeAndResolveCommand(this.project, startConfig, agentName, (Function1<? super String, Unit>)handleError, (Continuation<? super ResolvedRuntimeConfig>)$continuation);
                if (v3 == var27_10) {
                    return var27_10;
                }
                ** GOTO lbl88
            }
            case 2: {
                startConfig = (AcpAgentStartConfig)$continuation.L$9;
                handler = (LocalAcpServerProcessHandler)$continuation.L$8;
                chatId = (String)$continuation.L$7;
                key = (ProcessKey)$continuation.L$6;
                handleError = (Function1)$continuation.L$5;
                coroutineScope = (CoroutineScope)$continuation.L$4;
                config = (LocalAcpAgentConfig)$continuation.L$3;
                chat = (ChatSession)$continuation.L$2;
                agentName = (String)$continuation.L$1;
                agentId = (AcpAgentId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl88:
                // 2 sources

                v4 = (ResolvedRuntimeConfig)v3;
                if (v4 == null) {
                    return null;
                }
                resolved = v4;
                errors = this.validateConfig(resolved.getConfig());
                if (((Collection)errors).isEmpty() == false) {
                    message = "Invalid configuration for agent '" + agentName + "': " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    AcpProcessHandlerServiceKt.access$getLogger$p().warn(message);
                    handleError.invoke((Object)message);
                    return null;
                }
                v5 = ProjectUtil.guessProjectDir((Project)this.project);
                v6 = projectDir = v5 != null ? v5.toNioPath() : null;
                if (projectDir == null) {
                    message = "Cannot determine project directory for agent '" + agentName + "'";
                    AcpProcessHandlerServiceKt.access$getLogger$p().error(message);
                    handleError.invoke((Object)message);
                    return null;
                }
                $this$withLock_u24default$iv = this.processHandlersLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = agentId;
                $continuation.L$1 = agentName;
                $continuation.L$2 = chat;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$4 = coroutineScope;
                $continuation.L$5 = handleError;
                $continuation.L$6 = key;
                $continuation.L$7 = chatId;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)handler);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)startConfig);
                $continuation.L$10 = resolved;
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable(errors);
                $continuation.L$12 = projectDir;
                $continuation.L$13 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 3;
                v7 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v7 == var27_10) {
                    return var27_10;
                }
                ** GOTO lbl150
            }
            case 3: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$13;
                projectDir = (Path)$continuation.L$12;
                errors = (List<String>)$continuation.L$11;
                resolved = (ResolvedRuntimeConfig)$continuation.L$10;
                startConfig = (AcpAgentStartConfig)$continuation.L$9;
                handler = (LocalAcpServerProcessHandler)$continuation.L$8;
                chatId = (String)$continuation.L$7;
                key = (ProcessKey)$continuation.L$6;
                handleError = (Function1)$continuation.L$5;
                coroutineScope = (CoroutineScope)$continuation.L$4;
                config = (LocalAcpAgentConfig)$continuation.L$3;
                chat = (ChatSession)$continuation.L$2;
                agentName = (String)$continuation.L$1;
                agentId = (AcpAgentId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl150:
                // 3 sources

                $i$a$-withLock$default-AcpProcessHandlerService$getOrCreateProcessHandler$2 = 0;
                v8 = existing = this.getReusableProcessHandler(key, agentName, chatId);
                if (v8 == null) ** GOTO lbl159
                var24_37 = v8;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var24_37;
lbl159:
                // 3 sources

                AcpProcessHandlerServiceKt.access$getLogger$p().info("Starting new process for agent '" + agentName + "' in chat " + chatId + " with Eel");
                $continuation.L$0 = agentId;
                $continuation.L$1 = agentName;
                $continuation.L$2 = chat;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)coroutineScope);
                $continuation.L$5 = handleError;
                $continuation.L$6 = key;
                $continuation.L$7 = chatId;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)handler);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)startConfig);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)resolved);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable(errors);
                $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)projectDir);
                $continuation.L$13 = $this$withLock_u24default$iv;
                $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)existing);
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-AcpProcessHandlerService$getOrCreateProcessHandler$2;
                $continuation.label = 4;
                v9 = EelAcpProcessHandler.Companion.startProcess(agentName, resolved.getConfig(), projectDir, coroutineScope, (Function1<? super String, Unit>)handleError, resolved.getRuntimeBinDir(), resolved.getRuntimeEnv(), (Continuation<? super EelAcpProcessHandler>)$continuation);
                ** if (v9 != var27_10) goto lbl182
lbl181:
                // 1 sources

                return var27_10;
lbl182:
                // 1 sources

                ** GOTO lbl207
            }
            case 4: {
                $i$a$-withLock$default-AcpProcessHandlerService$getOrCreateProcessHandler$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                existing = (LocalAcpServerProcessHandler)$continuation.L$14;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$13;
                projectDir = (Path)$continuation.L$12;
                errors = (List)$continuation.L$11;
                resolved = (ResolvedRuntimeConfig)$continuation.L$10;
                startConfig = (AcpAgentStartConfig)$continuation.L$9;
                handler = (LocalAcpServerProcessHandler)$continuation.L$8;
                chatId = (String)$continuation.L$7;
                key = (ProcessKey)$continuation.L$6;
                handleError = (Function1)$continuation.L$5;
                coroutineScope = (CoroutineScope)$continuation.L$4;
                config = (LocalAcpAgentConfig)$continuation.L$3;
                chat = (ChatSession)$continuation.L$2;
                agentName = (String)$continuation.L$1;
                agentId = (AcpAgentId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl207:
                    // 2 sources

                    handler = (EelAcpProcessHandler)v9;
                    ((Map)this.processHandlers).put(key, handler);
                    AcpProcessHandlerServiceKt.access$getLogger$p().info("Successfully created and registered Eel process handler for agent '" + agentName + "', '" + agentId.getRawId() + "' in chat " + chatId);
                    AIAssistantChatEventLogger.logAcpAgentStarted((ChatSession)chat, (String)agentId.getRawId());
                    var20_38 = handler;
                    {
                        catch (ExecuteProcessException e) {
                            AcpProcessHandlerServiceKt.access$getLogger$p().warn("Failed to start ACP process for agent '" + agentName + "', '" + agentId.getRawId() + "' in chat " + chatId, (Throwable)e);
                            AIAssistantChatEventLogger.logAcpAgentFailed((ChatSession)chat, (String)agentId.getRawId());
                            handleError.invoke((Object)("Failed to start process: " + e.getMessage() + ". Try using absolute path for your executable."));
                            var20_38 = null;
                            ** GOTO lbl228
                        }
                        catch (Exception e) {
                            AcpProcessHandlerServiceKt.access$getLogger$p().error("Unexpected error starting ACP process for agent '" + agentName + "', '" + agentId.getRawId() + "' in chat " + chatId, (Throwable)e);
                            AIAssistantChatEventLogger.logAcpAgentFailed((ChatSession)chat, (String)agentId.getRawId());
                            handleError.invoke((Object)("Failed to start process for agent '" + agentName + "': " + e.getMessage()));
                            var20_38 = null;
                        }
                    }
lbl228:
                    // 3 sources

                    var22_41 = var20_38;
                }
                catch (Throwable var23_42) {
                    throw var23_42;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var22_41;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<String> validateConfig(AcpAgentStartConfig config) {
        Path commandPath;
        List errors = new ArrayList();
        if (StringsKt.isBlank((CharSequence)config.getCommand())) {
            errors.add("Command cannot be empty");
        }
        if (!(commandPath = Paths.get(config.getCommand(), new String[0])).isAbsolute()) {
            AcpProcessHandlerServiceKt.access$getLogger$p().debug("Command '" + config.getCommand() + "' is not absolute, will search in PATH");
        } else if (!Files.exists(commandPath, new LinkOption[0])) {
            errors.add("Command executable not found: " + config.getCommand());
        }
        return errors;
    }

    private final LocalAcpServerProcessHandler getReusableProcessHandler(ProcessKey key, String agentName, String chatId) {
        LocalAcpServerProcessHandler existing = this.processHandlers.get(key);
        if (existing == null) {
            return null;
        }
        if (existing.isRunning()) {
            AcpProcessHandlerServiceKt.access$getLogger$p().info("Reusing existing process handler for agent '" + agentName + "' in chat " + chatId);
            return existing;
        }
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Existing process handler for agent '" + agentName + "' is not running, creating new one");
        existing.stopServer();
        this.processHandlers.remove(key);
        return null;
    }

    @Nullable
    public final LocalAcpServerProcessHandler getProcessHandler(@NotNull AcpAgentId agentId, @NotNull String chatId) {
        LocalAcpServerProcessHandler localAcpServerProcessHandler;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        ProcessKey key = new ProcessKey(agentId, chatId);
        LocalAcpServerProcessHandler localAcpServerProcessHandler2 = this.processHandlers.get(key);
        if (localAcpServerProcessHandler2 != null) {
            LocalAcpServerProcessHandler localAcpServerProcessHandler3;
            LocalAcpServerProcessHandler it = localAcpServerProcessHandler3 = localAcpServerProcessHandler2;
            boolean bl = false;
            localAcpServerProcessHandler = it.isRunning() ? localAcpServerProcessHandler3 : null;
        } else {
            localAcpServerProcessHandler = null;
        }
        return localAcpServerProcessHandler;
    }

    public final void stopProcessHandler(@NotNull AcpAgentId agentId, @NotNull String chatId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        ProcessKey key = new ProcessKey(agentId, chatId);
        LocalAcpServerProcessHandler localAcpServerProcessHandler = this.processHandlers.remove(key);
        if (localAcpServerProcessHandler != null) {
            LocalAcpServerProcessHandler handler2 = localAcpServerProcessHandler;
            boolean bl = false;
            AcpProcessHandlerServiceKt.access$getLogger$p().info("Stopping process handler for agent " + agentId + " in chat " + chatId);
            try {
                handler2.stopServer();
                AcpProcessHandlerServiceKt.access$getLogger$p().info("Successfully stopped process handler for agent " + agentId + " in chat " + chatId);
            }
            catch (Exception e) {
                AcpProcessHandlerServiceKt.access$getLogger$p().error("Failed to stop process handler for agent " + agentId + " in chat " + chatId, (Throwable)e);
                throw e;
            }
        } else {
            AcpProcessHandlerService $this$stopProcessHandler_u24lambda_u241 = this;
            boolean bl = false;
            AcpProcessHandlerServiceKt.access$getLogger$p().debug("No process handler found for agent " + agentId + " in chat " + chatId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void stopAllForAgent(@NotNull AcpAgentId agentId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Set set = this.processHandlers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProcessKey it = (ProcessKey)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getAgentId(), (Object)agentId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List keysToRemove = (List)destination$iv$iv;
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Stopping all process handlers for agent " + agentId + " (" + keysToRemove.size() + " total)");
        Iterable $this$forEach$iv = keysToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessKey key = (ProcessKey)element$iv;
            boolean bl = false;
            if (this.processHandlers.remove(key) == null) continue;
            boolean bl2 = false;
            try {
                LocalAcpServerProcessHandler handler2;
                AcpProcessHandlerServiceKt.access$getLogger$p().info("Stopping process handler for agent " + agentId + " in chat " + key.getChatId());
                handler2.stopServer();
                AcpProcessHandlerServiceKt.access$getLogger$p().debug("Successfully stopped process handler for agent " + agentId + " in chat " + key.getChatId());
            }
            catch (Exception e) {
                AcpProcessHandlerServiceKt.access$getLogger$p().error("Failed to stop process handler for agent " + agentId + " in chat " + key.getChatId(), (Throwable)e);
            }
        }
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Finished stopping all process handlers for agent " + agentId);
    }

    private final void stopAll() {
        int totalHandlers = this.processHandlers.size();
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Stopping all process handlers (" + totalHandlers + " total)");
        int successCount = 0;
        int errorCount = 0;
        Collection<LocalAcpServerProcessHandler> collection = this.processHandlers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalAcpServerProcessHandler handler2 = (LocalAcpServerProcessHandler)element$iv;
            boolean bl = false;
            try {
                handler2.stopServer();
                ++successCount;
            }
            catch (Exception e) {
                ++errorCount;
                AcpProcessHandlerServiceKt.access$getLogger$p().error("Error stopping process handler", (Throwable)e);
            }
        }
        this.processHandlers.clear();
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Finished stopping all process handlers (success: " + successCount + ", errors: " + errorCount + ")");
    }

    @NotNull
    public final ProcessStatistics getStatistics() {
        int n;
        Collection<LocalAcpServerProcessHandler> collection = this.processHandlers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LocalAcpServerProcessHandler it = (LocalAcpServerProcessHandler)element$iv;
                boolean bl = false;
                if (!it.isRunning() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int running = n;
        int total = this.processHandlers.size();
        return new ProcessStatistics(total, running, total - running);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getChatIdsForAgent(@NotNull AcpAgentId agentId) {
        void $this$mapTo$iv$iv;
        ProcessKey it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Set set = this.processHandlers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProcessKey)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getAgentId(), (Object)agentId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProcessKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChatId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupDeadProcesses() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Set<Map.Entry<ProcessKey, LocalAcpServerProcessHandler>> set = this.processHandlers.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(!((LocalAcpServerProcessHandler)it.getValue()).isRunning())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ProcessKey)it.getKey());
        }
        List deadKeys = (List)destination$iv$iv;
        if (!((Collection)deadKeys).isEmpty()) {
            AcpProcessHandlerServiceKt.access$getLogger$p().info("Found " + deadKeys.size() + " dead process handler(s), cleaning up");
            Iterable $this$forEach$iv = deadKeys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProcessKey key = (ProcessKey)element$iv;
                boolean bl = false;
                if (this.processHandlers.remove(key) != null) {
                    boolean bl2 = false;
                    try {
                        LocalAcpServerProcessHandler handler2;
                        handler2.stopServer();
                        AcpProcessHandlerServiceKt.access$getLogger$p().debug("Cleaned up dead process handler for agent " + key.getAgentId() + " in chat " + key.getChatId());
                    }
                    catch (Exception e) {
                        AcpProcessHandlerServiceKt.access$getLogger$p().debug("Error stopping dead process handler for agent " + key.getAgentId(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void dispose() {
        AcpProcessHandlerServiceKt.access$getLogger$p().info("Disposing ConfigurableAcpProcessHandlerService for project: " + this.project.getName());
        Job.DefaultImpls.cancel$default((Job)this.cleanupJob, null, (int)1, null);
        this.stopAll();
        AcpProcessHandlerServiceKt.access$getLogger$p().info("ConfigurableAcpProcessHandlerService disposed successfully");
    }

    public static final /* synthetic */ void access$cleanupDeadProcesses(AcpProcessHandlerService $this) {
        $this.cleanupDeadProcesses();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/process/AcpProcessHandlerService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpProcessHandlerService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(AcpProcessHandlerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AcpProcessHandlerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

