/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.agents.acp.config.LocalAcpAgentConfig;
import com.intellij.ml.llm.agents.acp.config.LocalCommandBasedAcpAgentConfig;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentFactoryKt;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpDistributionResolver;
import com.intellij.ml.llm.agents.acp.registry.DynamicAcpChatAgent;
import com.intellij.ml.llm.agents.acp.registry.ExternalAgent;
import com.intellij.ml.llm.agents.acp.registry.LazyBinaryAcpAgentConfig;
import com.intellij.ml.llm.agents.acp.settings.AcpAgentSettingsService;
import com.intellij.ml.llm.agents.acp.settings.GlobalMcpSettings;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory;", "", "<init>", "()V", "createAgentConfig", "Lcom/intellij/ml/llm/agents/acp/config/LocalAcpAgentConfig;", "agent", "Lcom/intellij/ml/llm/agents/acp/registry/ExternalAgent;", "dist", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution;", "create", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult;", "buildAgent", "Lcom/intellij/ml/llm/agents/acp/registry/DynamicAcpChatAgent;", "agentConfig", "acpAgentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "CreateResult", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpAgentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpAgentFactory.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,112:1\n42#2,3:113\n*S KotlinDebug\n*F\n+ 1 AcpAgentFactory.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory\n*L\n42#1:113,3\n*E\n"})
public final class AcpAgentFactory {
    @NotNull
    public static final AcpAgentFactory INSTANCE = new AcpAgentFactory();

    private AcpAgentFactory() {
    }

    private final LocalAcpAgentConfig createAgentConfig(ExternalAgent agent2, AcpDistributionResolver.ResolvedDistribution dist) {
        LocalAcpAgentConfig localAcpAgentConfig;
        boolean $i$f$service = false;
        Class<AcpAgentSettingsService> serviceClass$iv = AcpAgentSettingsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        GlobalMcpSettings mcpSettings = ((AcpAgentSettingsService)object).getGlobalMcpSettings();
        AcpDistributionResolver.ResolvedDistribution resolvedDistribution = dist;
        if (resolvedDistribution instanceof AcpDistributionResolver.ResolvedDistribution.Binary) {
            String string = agent2.getName();
            boolean bl = mcpSettings.getUseIdeaMcp();
            boolean bl2 = mcpSettings.getUseCustomMcp();
            AcpAgentId acpAgentId = agent2.getId();
            localAcpAgentConfig = new LazyBinaryAcpAgentConfig(string, acpAgentId, bl, bl2, null, 16, null);
        } else if (resolvedDistribution instanceof AcpDistributionResolver.ResolvedDistribution.Package) {
            localAcpAgentConfig = new LocalCommandBasedAcpAgentConfig(agent2.getName(), AcpDistributionResolver.INSTANCE.toAgentStartConfig((AcpDistributionResolver.ResolvedDistribution.Package)dist), mcpSettings.getUseIdeaMcp(), mcpSettings.getUseCustomMcp(), null, 16, null);
        } else if (resolvedDistribution instanceof AcpDistributionResolver.ResolvedDistribution.Unavailable) {
            localAcpAgentConfig = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return localAcpAgentConfig;
    }

    @Nullable
    public final LocalAcpAgentConfig createAgentConfig(@NotNull ExternalAgent agent2) {
        Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
        return this.createAgentConfig(agent2, AcpDistributionResolver.INSTANCE.resolve(agent2));
    }

    @NotNull
    public final CreateResult create(@NotNull ExternalAgent agent2) {
        CreateResult createResult;
        Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
        AcpAgentId acpAgentId = agent2.getId();
        AcpDistributionResolver.ResolvedDistribution resolved = AcpDistributionResolver.INSTANCE.resolve(agent2);
        if (resolved instanceof AcpDistributionResolver.ResolvedDistribution.Unavailable) {
            AcpAgentFactoryKt.access$getLogger$p().info("Cannot create agent " + acpAgentId + ": " + ((AcpDistributionResolver.ResolvedDistribution.Unavailable)resolved).getReason());
            createResult = new CreateResult.Unavailable(((AcpDistributionResolver.ResolvedDistribution.Unavailable)resolved).getReason());
        } else {
            LocalAcpAgentConfig localAcpAgentConfig = this.createAgentConfig(agent2, resolved);
            if (localAcpAgentConfig == null) {
                return new CreateResult.Unavailable("Cannot create agent " + acpAgentId);
            }
            LocalAcpAgentConfig agentConfig = localAcpAgentConfig;
            DynamicAcpChatAgent chatAgent = this.buildAgent(agentConfig, acpAgentId, agent2);
            createResult = new CreateResult.Success(chatAgent);
        }
        return createResult;
    }

    private final DynamicAcpChatAgent buildAgent(LocalAcpAgentConfig agentConfig, AcpAgentId acpAgentId, ExternalAgent agent2) {
        return new DynamicAcpChatAgent(agentConfig.getName(), agentConfig, acpAgentId, agent2.getIcon(), agent2.getDescription(), agent2.getVersion(), agent2.getAuthors(), agent2.getRepository());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult;", "", "<init>", "()V", "Success", "Unavailable", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult$Success;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult$Unavailable;", "intellij.ml.llm.agents.acp"})
    public static abstract sealed class CreateResult {
        private CreateResult() {
        }

        public /* synthetic */ CreateResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult$Success;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult;", "agent", "Lcom/intellij/ml/llm/agents/acp/registry/DynamicAcpChatAgent;", "<init>", "(Lcom/intellij/ml/llm/agents/acp/registry/DynamicAcpChatAgent;)V", "getAgent", "()Lcom/intellij/ml/llm/agents/acp/registry/DynamicAcpChatAgent;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.agents.acp"})
        public static final class Success
        extends CreateResult {
            @NotNull
            private final DynamicAcpChatAgent agent;

            public Success(@NotNull DynamicAcpChatAgent agent2) {
                Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
                super(null);
                this.agent = agent2;
            }

            @NotNull
            public final DynamicAcpChatAgent getAgent() {
                return this.agent;
            }

            @NotNull
            public final DynamicAcpChatAgent component1() {
                return this.agent;
            }

            @NotNull
            public final Success copy(@NotNull DynamicAcpChatAgent agent2) {
                Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
                return new Success(agent2);
            }

            public static /* synthetic */ Success copy$default(Success success, DynamicAcpChatAgent dynamicAcpChatAgent, int n, Object object) {
                if ((n & 1) != 0) {
                    dynamicAcpChatAgent = success.agent;
                }
                return success.copy(dynamicAcpChatAgent);
            }

            @NotNull
            public String toString() {
                return "Success(agent=" + this.agent + ")";
            }

            public int hashCode() {
                return this.agent.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.agent, (Object)success.agent);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult$Unavailable;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult;", "reason", "", "<init>", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
        public static final class Unavailable
        extends CreateResult {
            @NotNull
            private final String reason;

            public Unavailable(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final Unavailable copy(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                return new Unavailable(reason);
            }

            public static /* synthetic */ Unavailable copy$default(Unavailable unavailable, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unavailable.reason;
                }
                return unavailable.copy(string);
            }

            @NotNull
            public String toString() {
                return "Unavailable(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unavailable)) {
                    return false;
                }
                Unavailable unavailable = (Unavailable)other;
                return Intrinsics.areEqual((Object)this.reason, (Object)unavailable.reason);
            }
        }
    }
}

