/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentInstallationState$InstalledAgentInfo$;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentInstallationState$StateData$;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentInstallationStateKt;
import com.intellij.ml.llm.agents.acp.registry.AcpJson;
import com.intellij.ml.llm.agents.acp.registry.AcpPaths;
import com.intellij.ml.llm.agents.acp.registry.ExternalAgent;
import com.intellij.ml.llm.agents.acp.registry.ExternalAgent$;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u000289B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001c\u001a\u00020\nJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\nJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\nJ\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010$\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\nJ\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&J\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0(J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0*2\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u001eH\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u001eH\u0002J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u0017H\u0002J\b\u00105\u001a\u00020\u0017H\u0002J\r\u00106\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b7R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState;", "", "<init>", "()V", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "agents", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState$InstalledAgentInfo;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "_installedAgentsCount", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "installedAgentsCount", "getInstalledAgentsCount", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "initialized", "", "ensureInitialized", "", "markInstalled", "agent", "Lcom/intellij/ml/llm/agents/acp/registry/ExternalAgent;", "updateLastUsed", "agentId", "getInstalledVersion", "", "getInstallationInfo", "getInstalledAgent", "isInstalled", "hasUpdate", "registryVersion", "uninstall", "getInstalledAgentIds", "", "getAllInstalledAgents", "", "getStaleAgents", "", "unusedForMillis", "", "isNewerVersion", "newVersion", "oldVersion", "normalizeVersion", "version", "getStoragePath", "Ljava/nio/file/Path;", "loadFromDisk", "saveToDisk", "resetForTesting", "resetForTesting$intellij_ml_llm_agents_acp", "InstalledAgentInfo", "StateData", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpAgentInstallationState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpAgentInstallationState.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 Json.kt\nkotlinx/serialization/json/Json\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,349:1\n774#2:350\n865#2,2:351\n1563#2:353\n1634#2,3:354\n1563#2:357\n1634#2,3:358\n1563#2:361\n1634#2,3:362\n1#3:365\n42#4,3:366\n222#5:369\n205#5:378\n126#6:370\n153#6,3:371\n126#6:374\n153#6,3:375\n*S KotlinDebug\n*F\n+ 1 AcpAgentInstallationState.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState\n*L\n241#1:350\n241#1:351,2\n242#1:353\n242#1:354,3\n254#1:357\n254#1:358,3\n255#1:361\n255#1:362,3\n294#1:366,3\n305#1:369\n326#1:378\n307#1:370\n307#1:371,3\n325#1:374\n325#1:375,3\n*E\n"})
public final class AcpAgentInstallationState {
    @NotNull
    private final ConcurrentHashMap<AcpAgentId, InstalledAgentInfo> agents = new ConcurrentHashMap();
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @NotNull
    private final MutableStateFlow<Integer> _installedAgentsCount = StateFlowKt.MutableStateFlow((Object)this.agents.size());
    @NotNull
    private final MutableStateFlow<Integer> installedAgentsCount = this._installedAgentsCount;
    private volatile boolean initialized;

    private final Json getJson() {
        return AcpJson.INSTANCE.getPretty();
    }

    @NotNull
    public final MutableStateFlow<Integer> getInstalledAgentsCount() {
        return this.installedAgentsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureInitialized() {
        if (this.initialized) {
            return;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.initialized) {
                return;
            }
            this.loadFromDisk();
            this.initialized = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markInstalled(@NotNull ExternalAgent agent2) {
        Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
        this.ensureInitialized();
        AcpAgentId agentId = agent2.getId();
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            InstalledAgentInfo existing;
            boolean bl = false;
            long now = System.currentTimeMillis();
            InstalledAgentInfo installedAgentInfo = existing = this.agents.get(agentId);
            InstalledAgentInfo info = new InstalledAgentInfo(agent2, installedAgentInfo != null ? installedAgentInfo.getInstalledAt() : now, now);
            ((Map)this.agents).put(agentId, info);
            this.saveToDisk();
            AcpAgentInstallationStateKt.access$getLogger$p().info("Marked agent as installed: " + agentId + " v" + agent2.getVersion());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateLastUsed(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        this.ensureInitialized();
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            InstalledAgentInfo installedAgentInfo = this.agents.get(agentId);
            if (installedAgentInfo != null) {
                InstalledAgentInfo existing = installedAgentInfo;
                ((Map)this.agents).put(agentId, InstalledAgentInfo.copy$default(existing, null, 0L, System.currentTimeMillis(), 3, null));
                this.saveToDisk();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Nullable
    public final String getInstalledVersion(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        this.ensureInitialized();
        InstalledAgentInfo installedAgentInfo = this.agents.get(agentId);
        return installedAgentInfo != null ? installedAgentInfo.getVersion() : null;
    }

    @Nullable
    public final InstalledAgentInfo getInstallationInfo(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        this.ensureInitialized();
        return this.agents.get(agentId);
    }

    @Nullable
    public final ExternalAgent getInstalledAgent(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        InstalledAgentInfo installedAgentInfo = this.getInstallationInfo(agentId);
        return installedAgentInfo != null ? installedAgentInfo.getAgent() : null;
    }

    public final boolean isInstalled(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        this.ensureInitialized();
        return this.agents.containsKey(agentId);
    }

    public final boolean hasUpdate(@NotNull AcpAgentId agentId, @Nullable String registryVersion) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        if (registryVersion == null) {
            return false;
        }
        String string = this.getInstalledVersion(agentId);
        if (string == null) {
            return false;
        }
        String installedVersion = string;
        return this.isNewerVersion(registryVersion, installedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean uninstall(@NotNull AcpAgentId agentId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        this.ensureInitialized();
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean removed;
            boolean bl2 = false;
            boolean bl3 = removed = this.agents.remove(agentId) != null;
            if (removed) {
                this.saveToDisk();
                AcpAgentInstallationStateKt.access$getLogger$p().info("Uninstalled agent: " + agentId);
            }
            bl = removed;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return bl;
    }

    @NotNull
    public final Set<AcpAgentId> getInstalledAgentIds() {
        this.ensureInitialized();
        Set set = this.agents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toSet((Iterable)set);
    }

    @NotNull
    public final Map<AcpAgentId, InstalledAgentInfo> getAllInstalledAgents() {
        this.ensureInitialized();
        return MapsKt.toMap((Map)this.agents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<AcpAgentId> getStaleAgents(long unusedForMillis) {
        List list;
        this.ensureInitialized();
        long cutoff = System.currentTimeMillis() - unusedForMillis;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InstalledAgentInfo it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            boolean bl = false;
            Collection<InstalledAgentInfo> collection = this.agents.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            void var9_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (InstalledAgentInfo)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getLastUsedAt() < cutoff)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (InstalledAgentInfo)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(it.getAgentId());
            }
            list = (List)destination$iv$iv;
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isNewerVersion(String newVersion, String oldVersion) {
        if (Intrinsics.areEqual((Object)newVersion, (Object)oldVersion)) {
            return false;
        }
        try {
            void $this$mapTo$iv$iv3;
            Collection collection;
            void $this$mapTo$iv$iv2;
            String[] stringArray = new String[]{"."};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)this.normalizeVersion(newVersion), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = StringsKt.toIntOrNull((String)it);
                collection.add(n != null ? n : 0);
            }
            List newParts = (List)destination$iv$iv;
            String[] $i$f$map22 = new String[]{"."};
            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)this.normalizeVersion(oldVersion), (String[])$i$f$map22, (boolean)false, (int)0, (int)6, null);
            int $i$f$map = 0;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv22;
                boolean bl2 = false;
                Integer n = StringsKt.toIntOrNull((String)it);
                collection.add(n != null ? n : 0);
            }
            List oldParts = (List)destination$iv$iv22;
            $i$f$map = newParts.size();
            int $this$mapTo$iv$iv3 = oldParts.size();
            int maxLength = Math.max($i$f$map, $this$mapTo$iv$iv3);
            for (int i = 0; i < maxLength; ++i) {
                Object object;
                Object object2;
                List destination$iv$iv22 = newParts;
                boolean bl = 0 <= i ? i < destination$iv$iv22.size() : false;
                if (bl) {
                    object2 = destination$iv$iv22.get(i);
                } else {
                    int it = i;
                    boolean bl3 = false;
                    object2 = 0;
                }
                int newPart = ((Number)object2).intValue();
                List list = oldParts;
                boolean bl4 = 0 <= i ? i < list.size() : false;
                if (bl4) {
                    object = list.get(i);
                } else {
                    int it = i;
                    boolean bl5 = false;
                    object = 0;
                }
                int oldPart = ((Number)object).intValue();
                if (newPart > oldPart) {
                    return true;
                }
                if (newPart >= oldPart) continue;
                return false;
            }
            boolean newHasSuffix = StringsKt.contains$default((CharSequence)newVersion, (CharSequence)"-", (boolean)false, (int)2, null);
            boolean oldHasSuffix = StringsKt.contains$default((CharSequence)oldVersion, (CharSequence)"-", (boolean)false, (int)2, null);
            if (!newHasSuffix && oldHasSuffix) {
                return true;
            }
            if (newHasSuffix && !oldHasSuffix) {
                return false;
            }
            return false;
        }
        catch (Exception e) {
            AcpAgentInstallationStateKt.access$getLogger$p().warn("Failed to compare versions: " + newVersion + " vs " + oldVersion, (Throwable)e);
            return newVersion.compareTo(oldVersion) > 0;
        }
    }

    private final String normalizeVersion(String version) {
        String[] stringArray = new String[]{"+"};
        CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)version, (CharSequence)"v"), (CharSequence)"V"), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        stringArray = new String[]{"-"};
        return (String)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
    }

    private final Path getStoragePath() {
        boolean $i$f$service = false;
        Class<AcpPaths> serviceClass$iv = AcpPaths.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((AcpPaths)object).getInstalledPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadFromDisk() {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map<String, InstalledAgentInfo> this_$iv;
            Path path = this.getStoragePath();
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                AcpAgentInstallationStateKt.access$getLogger$p().debug("No installed agents file found at " + path);
                return;
            }
            String content2 = PathsKt.readText$default((Path)path, null, (int)1, null);
            Json json = this.getJson();
            String string$iv = content2;
            boolean $i$f$decodeFromString22 = false;
            this_$iv.getSerializersModule();
            StateData data2 = (StateData)this_$iv.decodeFromString((DeserializationStrategy)StateData.Companion.serializer(), string$iv);
            this.agents.clear();
            this_$iv = data2.getAgents();
            Map map2 = this.agents;
            boolean $i$f$map = false;
            void $i$f$decodeFromString22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)AcpAgentId.Companion.parse((String)it.getKey()), it.getValue()));
            }
            MapsKt.putAll((Map)map2, (Iterable)((List)destination$iv$iv));
            AcpAgentInstallationStateKt.access$getLogger$p().info("Loaded " + this.agents.size() + " installed agents from disk");
        }
        catch (Exception e) {
            AcpAgentInstallationStateKt.access$getLogger$p().warn("Failed to load installed agents from disk", (Throwable)e);
        }
        finally {
            this._installedAgentsCount.setValue((Object)this.agents.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveToDisk() {
        if (!this.lock.writeLock().isHeldByCurrentThread()) {
            boolean $i$a$-check-AcpAgentInstallationState$saveToDisk$22 = false;
            String $i$a$-check-AcpAgentInstallationState$saveToDisk$22 = "saveToDisk must be called under write lock";
            throw new IllegalStateException($i$a$-check-AcpAgentInstallationState$saveToDisk$22.toString());
        }
        try {
            void this_$iv;
            void $this$mapTo$iv$iv;
            Path path = this.getStoragePath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Map $this$map$iv = this.agents;
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)((AcpAgentId)it.getKey()).getFullId(), it.getValue()));
            }
            Map map3 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            StateData data2 = new StateData(map3);
            $this$map$iv = this.getJson();
            StateData value$iv = data2;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            PathsKt.writeText$default((Path)path, (CharSequence)this_$iv.encodeToString((SerializationStrategy)StateData.Companion.serializer(), (Object)value$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
            AcpAgentInstallationStateKt.access$getLogger$p().debug("Saved " + this.agents.size() + " installed agents to disk");
        }
        catch (Exception e) {
            AcpAgentInstallationStateKt.access$getLogger$p().error("Failed to save installed agents to disk", (Throwable)e);
        }
        finally {
            this._installedAgentsCount.setValue((Object)this.agents.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetForTesting$intellij_ml_llm_agents_acp() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.agents.clear();
            this.initialized = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.ensureInitialized();
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 -2\u00020\u0001:\u0002,-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB5\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\nH\u00d6\u0001J\t\u0010#\u001a\u00020\u0018H\u00d6\u0001J%\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0001\u00a2\u0006\u0002\b+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState$InstalledAgentInfo;", "", "agent", "Lcom/intellij/ml/llm/agents/acp/registry/ExternalAgent;", "installedAt", "", "lastUsedAt", "<init>", "(Lcom/intellij/ml/llm/agents/acp/registry/ExternalAgent;JJ)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/intellij/ml/llm/agents/acp/registry/ExternalAgent;JJLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getAgent", "()Lcom/intellij/ml/llm/agents/acp/registry/ExternalAgent;", "getInstalledAt", "()J", "getLastUsedAt", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "getAgentId", "()Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "version", "", "getVersion", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_agents_acp", "$serializer", "Companion", "intellij.ml.llm.agents.acp"})
    public static final class InstalledAgentInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ExternalAgent agent;
        private final long installedAt;
        private final long lastUsedAt;

        public InstalledAgentInfo(@NotNull ExternalAgent agent2, long installedAt, long lastUsedAt) {
            Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
            this.agent = agent2;
            this.installedAt = installedAt;
            this.lastUsedAt = lastUsedAt;
        }

        public /* synthetic */ InstalledAgentInfo(ExternalAgent externalAgent, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l2 = l;
            }
            this(externalAgent, l, l2);
        }

        @NotNull
        public final ExternalAgent getAgent() {
            return this.agent;
        }

        public final long getInstalledAt() {
            return this.installedAt;
        }

        public final long getLastUsedAt() {
            return this.lastUsedAt;
        }

        @NotNull
        public final AcpAgentId getAgentId() {
            return this.agent.getId();
        }

        @NotNull
        public final String getVersion() {
            return this.agent.getVersion();
        }

        @NotNull
        public final ExternalAgent component1() {
            return this.agent;
        }

        public final long component2() {
            return this.installedAt;
        }

        public final long component3() {
            return this.lastUsedAt;
        }

        @NotNull
        public final InstalledAgentInfo copy(@NotNull ExternalAgent agent2, long installedAt, long lastUsedAt) {
            Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
            return new InstalledAgentInfo(agent2, installedAt, lastUsedAt);
        }

        public static /* synthetic */ InstalledAgentInfo copy$default(InstalledAgentInfo installedAgentInfo, ExternalAgent externalAgent, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                externalAgent = installedAgentInfo.agent;
            }
            if ((n & 2) != 0) {
                l = installedAgentInfo.installedAt;
            }
            if ((n & 4) != 0) {
                l2 = installedAgentInfo.lastUsedAt;
            }
            return installedAgentInfo.copy(externalAgent, l, l2);
        }

        @NotNull
        public String toString() {
            return "InstalledAgentInfo(agent=" + this.agent + ", installedAt=" + this.installedAt + ", lastUsedAt=" + this.lastUsedAt + ")";
        }

        public int hashCode() {
            int result2 = this.agent.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.installedAt);
            result2 = result2 * 31 + Long.hashCode(this.lastUsedAt);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstalledAgentInfo)) {
                return false;
            }
            InstalledAgentInfo installedAgentInfo = (InstalledAgentInfo)other;
            if (!Intrinsics.areEqual((Object)this.agent, (Object)installedAgentInfo.agent)) {
                return false;
            }
            if (this.installedAt != installedAgentInfo.installedAt) {
                return false;
            }
            return this.lastUsedAt == installedAgentInfo.lastUsedAt;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_agents_acp(InstalledAgentInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)ExternalAgent$.serializer.INSTANCE, (Object)self.agent);
            output.encodeLongElement(serialDesc, 1, self.installedAt);
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.lastUsedAt != self.installedAt) {
                output.encodeLongElement(serialDesc, 2, self.lastUsedAt);
            }
        }

        public /* synthetic */ InstalledAgentInfo(int seen0, ExternalAgent agent2, long installedAt, long lastUsedAt, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)InstalledAgentInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.agent = agent2;
            this.installedAt = installedAt;
            this.lastUsedAt = (seen0 & 4) == 0 ? this.installedAt : lastUsedAt;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState$InstalledAgentInfo$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState$InstalledAgentInfo;", "intellij.ml.llm.agents.acp"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<InstalledAgentInfo> serializer() {
                return (KSerializer)InstalledAgentInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B1\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState$StateData;", "", "agents", "", "", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState$InstalledAgentInfo;", "<init>", "(Ljava/util/Map;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getAgents", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_agents_acp", "$serializer", "Companion", "intellij.ml.llm.agents.acp"})
    private static final class StateData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, InstalledAgentInfo> agents;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public StateData(@NotNull Map<String, InstalledAgentInfo> agents) {
            Intrinsics.checkNotNullParameter(agents, (String)"agents");
            this.agents = agents;
        }

        public /* synthetic */ StateData(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = MapsKt.emptyMap();
            }
            this(map2);
        }

        @NotNull
        public final Map<String, InstalledAgentInfo> getAgents() {
            return this.agents;
        }

        @NotNull
        public final Map<String, InstalledAgentInfo> component1() {
            return this.agents;
        }

        @NotNull
        public final StateData copy(@NotNull Map<String, InstalledAgentInfo> agents) {
            Intrinsics.checkNotNullParameter(agents, (String)"agents");
            return new StateData(agents);
        }

        public static /* synthetic */ StateData copy$default(StateData stateData, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = stateData.agents;
            }
            return stateData.copy(map2);
        }

        @NotNull
        public String toString() {
            return "StateData(agents=" + this.agents + ")";
        }

        public int hashCode() {
            return ((Object)this.agents).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StateData)) {
                return false;
            }
            StateData stateData = (StateData)other;
            return Intrinsics.areEqual(this.agents, stateData.agents);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_agents_acp(StateData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual(self.agents, (Object)MapsKt.emptyMap())) {
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.agents);
            }
        }

        public /* synthetic */ StateData(int seen0, Map agents, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)StateData$$serializer.INSTANCE.getDescriptor());
            }
            this.agents = (seen0 & 1) == 0 ? MapsKt.emptyMap() : agents;
        }

        public StateData() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)InstalledAgentInfo$$serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState$StateData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentInstallationState$StateData;", "intellij.ml.llm.agents.acp"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<StateData> serializer() {
                return (KSerializer)StateData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

