/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ml.llm.agents.acp.AcpBundle;
import com.intellij.ml.llm.agents.acp.config.AcpAgentStartConfig;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentInstallationState;
import com.intellij.ml.llm.agents.acp.registry.AcpBinaryManager;
import com.intellij.ml.llm.agents.acp.registry.AcpBinaryManagerKt;
import com.intellij.ml.llm.agents.acp.registry.AcpDistributionResolver;
import com.intellij.ml.llm.agents.acp.registry.AcpPaths;
import com.intellij.ml.llm.agents.acp.registry.BinaryTarget;
import com.intellij.ml.llm.agents.acp.registry.ExternalAgent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.OS;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\rH\u0002J$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0086@\u00a2\u0006\u0002\u0010 J\"\u0010!\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0086@\u00a2\u0006\u0002\u0010 J\u001a\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$J2\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0086@\u00a2\u0006\u0002\u0010+J(\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020&2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0082@\u00a2\u0006\u0002\u0010/J&\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020&2\u0006\u0010.\u001a\u00020&2\u0006\u00102\u001a\u00020(H\u0082@\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020(H\u0002J\u0016\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u00109J\u0016\u0010:\u001a\u00020\u001a2\u0006\u00108\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u00109J\u0016\u0010;\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010<R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\n\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006>"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpBinaryManager;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "downloadLocks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "Lkotlinx/coroutines/sync/Mutex;", "downloadingAgents", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "kotlin.jvm.PlatformType", "", "_downloadingAgentsFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "downloadingAgentsFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getDownloadingAgentsFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "isDownloading", "agentId", "isBinaryReady", "needsBinaryDownload", "setDownloading", "", "downloading", "resolveLazyBinary", "Lcom/intellij/ml/llm/agents/acp/config/AcpAgentStartConfig;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadAgentBinaryIfNeeded", "downloadAgentBinaryInBackground", "project", "Lcom/intellij/openapi/project/Project;", "downloadAndExtract", "Ljava/nio/file/Path;", "version", "", "target", "Lcom/intellij/ml/llm/agents/acp/registry/BinaryTarget;", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Ljava/lang/String;Lcom/intellij/ml/llm/agents/acp/registry/BinaryTarget;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadArchive", "url", "targetDir", "(Ljava/lang/String;Ljava/nio/file/Path;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractArchive", "archivePath", "expectedCmd", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveExecutablePath", "baseDir", "cmd", "makeExecutable", "path", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeMacOSQuarantineAttribute", "deleteCachedAgent", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpBinaryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpBinaryManager.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpBinaryManager\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,563:1\n42#2,3:564\n42#2,3:567\n42#2,3:570\n42#2,3:573\n42#2,3:576\n42#2,3:579\n42#2,3:582\n42#2,3:585\n42#2,3:588\n42#2,3:599\n42#2,3:602\n116#3,8:591\n125#3,2:605\n*S KotlinDebug\n*F\n+ 1 AcpBinaryManager.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpBinaryManager\n*L\n91#1:564,3\n98#1:567,3\n115#1:570,3\n146#1:573,3\n179#1:576,3\n190#1:579,3\n213#1:582,3\n228#1:585,3\n314#1:588,3\n333#1:599,3\n404#1:602,3\n325#1:591,8\n325#1:605,2\n*E\n"})
public final class AcpBinaryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<AcpAgentId, Mutex> downloadLocks;
    private final ConcurrentHashMap.KeySetView<AcpAgentId, Boolean> downloadingAgents;
    @NotNull
    private final MutableStateFlow<Set<AcpAgentId>> _downloadingAgentsFlow;
    @NotNull
    private final StateFlow<Set<AcpAgentId>> downloadingAgentsFlow;
    @NotNull
    public static final String LAZY_BINARY_PREFIX = "@lazy-binary:";

    public AcpBinaryManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.downloadLocks = new ConcurrentHashMap();
        this.downloadingAgents = ConcurrentHashMap.newKeySet();
        this._downloadingAgentsFlow = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
        this.downloadingAgentsFlow = FlowKt.asStateFlow(this._downloadingAgentsFlow);
    }

    @NotNull
    public final StateFlow<Set<AcpAgentId>> getDownloadingAgentsFlow() {
        return this.downloadingAgentsFlow;
    }

    public final boolean isDownloading(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        return this.downloadingAgents.contains(agentId);
    }

    public final boolean isBinaryReady(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        boolean $i$f$service = false;
        Class<AcpAgentInstallationState> serviceClass$iv = AcpAgentInstallationState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ExternalAgent externalAgent = ((AcpAgentInstallationState)object).getInstalledAgent(agentId);
        if (externalAgent == null) {
            return true;
        }
        ExternalAgent installedAgent = externalAgent;
        AcpDistributionResolver.ResolvedDistribution resolved = AcpDistributionResolver.INSTANCE.resolve(installedAgent);
        if (!(resolved instanceof AcpDistributionResolver.ResolvedDistribution.Binary)) {
            return true;
        }
        boolean $i$f$service2 = false;
        Class<AcpPaths> serviceClass$iv2 = AcpPaths.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path agentDir = ((AcpPaths)object2).getAgentVersionDir(agentId, installedAgent.getVersion());
        Path executable = agentDir.resolve(StringsKt.removePrefix((String)((AcpDistributionResolver.ResolvedDistribution.Binary)resolved).getTarget().getCmd(), (CharSequence)"./"));
        Intrinsics.checkNotNull((Object)executable);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean exists = Files.exists(executable, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        boolean isExec = exists && Files.isExecutable(executable);
        AcpBinaryManagerKt.access$getLogger$p().debug("isBinaryReady(" + agentId + "): exists=" + exists + ", executable=" + isExec + ", path=" + executable);
        return isExec;
    }

    public final boolean needsBinaryDownload(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        boolean $i$f$service = false;
        Class<AcpAgentInstallationState> serviceClass$iv = AcpAgentInstallationState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ExternalAgent externalAgent = ((AcpAgentInstallationState)object).getInstalledAgent(agentId);
        if (externalAgent == null) {
            return false;
        }
        ExternalAgent installedAgent = externalAgent;
        AcpDistributionResolver.ResolvedDistribution resolved = AcpDistributionResolver.INSTANCE.resolve(installedAgent);
        if (!(resolved instanceof AcpDistributionResolver.ResolvedDistribution.Binary)) {
            return false;
        }
        return !this.isBinaryReady(agentId);
    }

    private final void setDownloading(AcpAgentId agentId, boolean downloading) {
        boolean bl = downloading ? this.downloadingAgents.add(agentId) : this.downloadingAgents.remove(agentId);
        ConcurrentHashMap.KeySetView<AcpAgentId, Boolean> keySetView = this.downloadingAgents;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"downloadingAgents");
        this._downloadingAgentsFlow.setValue((Object)CollectionsKt.toSet((Iterable)keySetView));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object resolveLazyBinary(@NotNull AcpAgentId agentId, @Nullable ProgressIndicator indicator, @NotNull Continuation<? super AcpAgentStartConfig> $completion) {
        if (!($completion instanceof resolveLazyBinary.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AcpBinaryManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resolveLazyBinary(null, null, (Continuation<? super AcpAgentStartConfig>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$service = false;
                serviceClass$iv = AcpAgentInstallationState.class;
                v0 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (v0 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                installedAgent = ((AcpAgentInstallationState)v0).getInstalledAgent(agentId);
                if (installedAgent == null) {
                    AcpBinaryManagerKt.access$getLogger$p().warn("Agent not installed: " + agentId);
                    return null;
                }
                resolved = AcpDistributionResolver.INSTANCE.resolve(installedAgent);
                if (!(resolved instanceof AcpDistributionResolver.ResolvedDistribution.Binary)) {
                    AcpBinaryManagerKt.access$getLogger$p().warn("Agent " + agentId + " does not have binary distribution for current platform");
                    return null;
                }
                $continuation.L$0 = agentId;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indicator);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)installedAgent);
                $continuation.L$3 = resolved;
                $continuation.label = 1;
                v1 = this.downloadAndExtract(agentId, installedAgent.getVersion(), ((AcpDistributionResolver.ResolvedDistribution.Binary)resolved).getTarget(), indicator, (Continuation<? super Path>)$continuation);
                ** if (v1 != var10_6) goto lbl35
lbl34:
                // 1 sources

                return var10_6;
lbl35:
                // 1 sources

                ** GOTO lbl45
            }
            case 1: {
                resolved = (AcpDistributionResolver.ResolvedDistribution)$continuation.L$3;
                installedAgent = (ExternalAgent)$continuation.L$2;
                indicator = (ProgressIndicator)$continuation.L$1;
                agentId = (AcpAgentId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl45:
                    // 2 sources

                    extractedPath = (Path)v1;
                    var6_9 = AcpDistributionResolver.INSTANCE.toAgentStartConfig((AcpDistributionResolver.ResolvedDistribution.Binary)resolved, extractedPath.toString());
                }
                catch (Exception e) {
                    AcpBinaryManagerKt.access$getLogger$p().warn("Failed to resolve lazy binary for " + agentId + ": " + e.getMessage(), (Throwable)e);
                    var6_9 = null;
                }
                return var6_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object resolveLazyBinary$default(AcpBinaryManager acpBinaryManager, AcpAgentId acpAgentId, ProgressIndicator progressIndicator, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return acpBinaryManager.resolveLazyBinary(acpAgentId, progressIndicator, (Continuation<? super AcpAgentStartConfig>)continuation);
    }

    @Nullable
    public final Object downloadAgentBinaryIfNeeded(@NotNull AcpAgentId agentId, @Nullable ProgressIndicator indicator, @NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$service = false;
        Class<AcpAgentInstallationState> serviceClass$iv = AcpAgentInstallationState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ExternalAgent externalAgent = ((AcpAgentInstallationState)object).getInstalledAgent(agentId);
        if (externalAgent == null) {
            AcpBinaryManager $this$downloadAgentBinaryIfNeeded_u24lambda_u240 = this;
            boolean bl = false;
            AcpBinaryManagerKt.access$getLogger$p().debug("Agent not installed: " + agentId);
            return Unit.INSTANCE;
        }
        ExternalAgent installedAgent = externalAgent;
        AcpDistributionResolver.ResolvedDistribution resolved = AcpDistributionResolver.INSTANCE.resolve(installedAgent);
        if (!(resolved instanceof AcpDistributionResolver.ResolvedDistribution.Binary)) {
            AcpBinaryManagerKt.access$getLogger$p().debug("No binary distribution for agent: " + agentId);
            return Unit.INSTANCE;
        }
        boolean $i$f$service2 = false;
        Class<AcpPaths> serviceClass$iv2 = AcpPaths.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path agentDir = ((AcpPaths)object2).getAgentVersionDir(agentId, installedAgent.getVersion());
        Path executable = agentDir.resolve(StringsKt.removePrefix((String)((AcpDistributionResolver.ResolvedDistribution.Binary)resolved).getTarget().getCmd(), (CharSequence)"./"));
        Intrinsics.checkNotNull((Object)executable);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(executable, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Files.isExecutable(executable)) {
            AcpBinaryManagerKt.access$getLogger$p().info("Binary already cached for " + agentId + " v" + installedAgent.getVersion());
            return Unit.INSTANCE;
        }
        AcpBinaryManagerKt.access$getLogger$p().info("Pre-downloading binary for " + agentId + " v" + installedAgent.getVersion());
        Object object3 = this.downloadAndExtract(agentId, installedAgent.getVersion(), ((AcpDistributionResolver.ResolvedDistribution.Binary)resolved).getTarget(), indicator, $completion);
        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object3;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object downloadAgentBinaryIfNeeded$default(AcpBinaryManager acpBinaryManager, AcpAgentId acpAgentId, ProgressIndicator progressIndicator, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return acpBinaryManager.downloadAgentBinaryIfNeeded(acpAgentId, progressIndicator, (Continuation<? super Unit>)continuation);
    }

    public final void downloadAgentBinaryInBackground(@NotNull AcpAgentId agentId, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        boolean $i$f$service = false;
        Class<AcpAgentInstallationState> serviceClass$iv = AcpAgentInstallationState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ExternalAgent externalAgent = ((AcpAgentInstallationState)object).getInstalledAgent(agentId);
        if (externalAgent == null) {
            AcpBinaryManager $this$downloadAgentBinaryInBackground_u24lambda_u240 = this;
            boolean bl = false;
            AcpBinaryManagerKt.access$getLogger$p().debug("Agent not installed: " + agentId);
            return;
        }
        ExternalAgent installedAgent = externalAgent;
        AcpDistributionResolver.ResolvedDistribution resolved = AcpDistributionResolver.INSTANCE.resolve(installedAgent);
        if (!(resolved instanceof AcpDistributionResolver.ResolvedDistribution.Binary)) {
            AcpBinaryManagerKt.access$getLogger$p().debug("No binary distribution for agent: " + agentId);
            return;
        }
        String version = installedAgent.getVersion();
        BinaryTarget target = ((AcpDistributionResolver.ResolvedDistribution.Binary)resolved).getTarget();
        boolean $i$f$service2 = false;
        Class<AcpPaths> serviceClass$iv2 = AcpPaths.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path agentDir = ((AcpPaths)object2).getAgentVersionDir(agentId, version);
        Path executable = agentDir.resolve(StringsKt.removePrefix((String)target.getCmd(), (CharSequence)"./"));
        Intrinsics.checkNotNull((Object)executable);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(executable, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            if (Files.isExecutable(executable)) {
                AcpBinaryManagerKt.access$getLogger$p().info("Binary already cached for " + agentId + " v" + version + " at " + executable);
                return;
            }
            AcpBinaryManagerKt.access$getLogger$p().info("Binary exists but not executable for " + agentId + " v" + version + " at " + executable + ", will re-download");
        } else {
            AcpBinaryManagerKt.access$getLogger$p().info("Binary not found for " + agentId + " v" + version + " at " + executable);
        }
        if (!this.downloadingAgents.add(agentId)) {
            AcpBinaryManagerKt.access$getLogger$p().debug("Binary download already in progress for " + agentId);
            return;
        }
        ConcurrentHashMap.KeySetView<AcpAgentId, Boolean> keySetView = this.downloadingAgents;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"downloadingAgents");
        this._downloadingAgentsFlow.setValue((Object)CollectionsKt.toSet((Iterable)keySetView));
        String agentName = installedAgent.getName();
        AcpBinaryManagerKt.access$getLogger$p().info("Starting background download for " + agentId + " v" + version);
        if (project2 != null) {
            BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, agentName, agentId, this, version, target, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $agentName;
                final /* synthetic */ AcpAgentId $agentId;
                final /* synthetic */ AcpBinaryManager this$0;
                final /* synthetic */ String $version;
                final /* synthetic */ BinaryTarget $target;
                {
                    this.$project = $project;
                    this.$agentName = $agentName;
                    this.$agentId = $agentId;
                    this.this$0 = $receiver;
                    this.$version = $version;
                    this.$target = $target;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var2_3 = new Object[]{this.$agentName};
                            this.label = 1;
                            v0 = TasksKt.withBackgroundProgress((Project)this.$project, (String)AcpBundle.INSTANCE.message("progress.title.downloading.agent", var2_3), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this.this$0, this.$agentId, this.$version, this.$target, null){
                                int label;
                                final /* synthetic */ AcpBinaryManager this$0;
                                final /* synthetic */ AcpAgentId $agentId;
                                final /* synthetic */ String $version;
                                final /* synthetic */ BinaryTarget $target;
                                {
                                    this.this$0 = $receiver;
                                    this.$agentId = $agentId;
                                    this.$version = $version;
                                    this.$target = $target;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = AcpBinaryManager.downloadAndExtract$default(this.this$0, this.$agentId, this.$version, this.$target, null, (Continuation)this, 8, null);
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            ** if (v0 != var3_2) goto lbl12
lbl11:
                            // 1 sources

                            return var3_2;
lbl12:
                            // 1 sources

                            ** GOTO lbl18
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl18:
                                // 2 sources

                                AcpBinaryManagerKt.access$getLogger$p().info("Background download completed for " + this.$agentId);
                            }
                            catch (Exception e) {
                                AcpBinaryManagerKt.access$getLogger$p().warn("Background download failed for " + this.$agentId + ": " + e.getMessage(), (Throwable)e);
                                ** GOTO lbl30
                            }
                            AcpBinaryManager.access$setDownloading(this.this$0, this.$agentId, false);
                            ** GOTO lbl30
                        }
                        {
                            finally {
                                AcpBinaryManager.access$setDownloading(this.this$0, this.$agentId, false);
                            }
                        }
lbl30:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            Object[] objectArray = new Object[]{agentName};
            String string = AcpBundle.INSTANCE.message("progress.title.downloading.agent", objectArray);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(agentId, this, version, target, string){
                final /* synthetic */ AcpAgentId $agentId;
                final /* synthetic */ AcpBinaryManager this$0;
                final /* synthetic */ String $version;
                final /* synthetic */ BinaryTarget $target;
                {
                    this.$agentId = $agentId;
                    this.this$0 = $receiver;
                    this.$version = $version;
                    this.$target = $target;
                    super(null, $super_call_param$1, true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    try {
                        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this.this$0, this.$agentId, this.$version, this.$target, indicator, null){
                            int label;
                            final /* synthetic */ AcpBinaryManager this$0;
                            final /* synthetic */ AcpAgentId $agentId;
                            final /* synthetic */ String $version;
                            final /* synthetic */ BinaryTarget $target;
                            final /* synthetic */ ProgressIndicator $indicator;
                            {
                                this.this$0 = $receiver;
                                this.$agentId = $agentId;
                                this.$version = $version;
                                this.$target = $target;
                                this.$indicator = $indicator;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.this$0.downloadAndExtract(this.$agentId, this.$version, this.$target, this.$indicator, (Continuation<? super Path>)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        AcpBinaryManagerKt.access$getLogger$p().info("Background download completed for " + this.$agentId);
                    }
                    catch (Exception e) {
                        AcpBinaryManagerKt.access$getLogger$p().warn("Background download failed for " + this.$agentId + ": " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        AcpBinaryManager.access$setDownloading(this.this$0, this.$agentId, false);
                    }
                }
            });
        }
    }

    public static /* synthetic */ void downloadAgentBinaryInBackground$default(AcpBinaryManager acpBinaryManager, AcpAgentId acpAgentId, Project project2, int n, Object object) {
        if ((n & 2) != 0) {
            project2 = null;
        }
        acpBinaryManager.downloadAgentBinaryInBackground(acpAgentId, project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadAndExtract(@NotNull AcpAgentId agentId, @NotNull String version, @NotNull BinaryTarget target, @Nullable ProgressIndicator indicator, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof downloadAndExtract.1)) ** GOTO lbl-1000
        var19_6 = $completion;
        if ((var19_6.label & -2147483648) != 0) {
            var19_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ AcpBinaryManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadAndExtract(null, null, null, null, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$service = false;
                serviceClass$iv = AcpPaths.class;
                v0 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (v0 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                agentDir = ((AcpPaths)v0).getAgentVersionDir(agentId, version);
                executable = this.resolveExecutablePath(agentDir, target.getCmd());
                serviceClass$iv = executable;
                if (Files.exists((Path)serviceClass$iv, Arrays.copyOf(var9_13 = new LinkOption[0], var9_13.length)) && Files.isExecutable(executable)) {
                    AcpBinaryManagerKt.access$getLogger$p().info("Using cached binary for " + agentId + " v" + version + " at " + executable);
                    return agentDir;
                }
                v1 = this.downloadLocks.computeIfAbsent(agentId, (Function<Object, Mutex>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, downloadAndExtract$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Lkotlinx/coroutines/sync/Mutex;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, downloadAndExtract$lambda$0(com.intellij.ml.llm.agents.acp.registry.AcpAgentId ), (Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;)Lkotlinx/coroutines/sync/Mutex;)()));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"computeIfAbsent(...)");
                $this$withLock_u24default$iv = lock = v1;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = agentId;
                $continuation.L$1 = version;
                $continuation.L$2 = target;
                $continuation.L$3 = indicator;
                $continuation.L$4 = agentDir;
                $continuation.L$5 = executable;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)lock);
                $continuation.L$7 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v2 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v2 == var20_8) {
                    return var20_8;
                }
                ** GOTO lbl56
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$7;
                lock = (Mutex)$continuation.L$6;
                executable = (Path)$continuation.L$5;
                agentDir = (Path)$continuation.L$4;
                indicator = (ProgressIndicator)$continuation.L$3;
                target = (BinaryTarget)$continuation.L$2;
                version = (String)$continuation.L$1;
                agentId = (AcpAgentId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl56:
                // 3 sources

                $i$a$-withLock$default-AcpBinaryManager$downloadAndExtract$2 = 0;
                v3 = new LinkOption[]{};
                if (!Files.exists(executable, Arrays.copyOf(v3, v3.length)) || !Files.isExecutable(executable)) ** GOTO lbl63
                AcpBinaryManagerKt.access$getLogger$p().info("Binary became available while waiting for lock: " + agentId + " v" + version);
                v4 = agentDir;
                ** GOTO lbl121
lbl63:
                // 1 sources

                AcpBinaryManagerKt.access$getLogger$p().info("Downloading " + agentId + " v" + version + " from " + target.getArchive());
                $i$f$service = false;
                serviceClass$iv = AcpPaths.class;
                v5 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (v5 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                downloadDir = ((AcpPaths)v5).getDownloadDir(agentId, version);
                this.setDownloading(agentId, true);
                $continuation.L$0 = agentId;
                $continuation.L$1 = version;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)target);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)indicator);
                $continuation.L$4 = agentDir;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)executable);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)lock);
                $continuation.L$7 = $this$withLock_u24default$iv;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)downloadDir);
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-AcpBinaryManager$downloadAndExtract$2;
                $continuation.label = 2;
                v6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(agentDir, downloadDir, target, indicator, agentId, this, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int I$0;
                    long J$0;
                    int label;
                    final /* synthetic */ Path $agentDir;
                    final /* synthetic */ Path $downloadDir;
                    final /* synthetic */ BinaryTarget $target;
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ AcpAgentId $agentId;
                    final /* synthetic */ AcpBinaryManager this$0;
                    {
                        this.$agentDir = $agentDir;
                        this.$downloadDir = $downloadDir;
                        this.$target = $target;
                        this.$indicator = $indicator;
                        this.$agentId = $agentId;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        block31: {
                            var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    v0 = CoroutinesKt.checkCanceled((Continuation)((Continuation)this));
                                    if (v0 == var9_2) {
                                        return var9_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    Files.createDirectories(this.$agentDir, new FileAttribute[0]);
                                    Files.createDirectories(this.$downloadDir, new FileAttribute[0]);
                                    fileName = StringsKt.substringAfterLast$default((String)this.$target.getArchive(), (String)"/", null, (int)2, null);
                                    archivePath = this.$downloadDir.resolve(fileName);
                                    Intrinsics.checkNotNull((Object)archivePath);
                                    v1 = new LinkOption[]{};
                                    v2 = needsDownload = Files.exists(archivePath, Arrays.copyOf(v1, v1.length)) == false || Files.size(archivePath) == 0L ? 1 : 0;
                                    if (needsDownload == 0) break;
                                    Files.deleteIfExists(archivePath);
                                    v3 = this.$indicator;
                                    if (v3 != null) {
                                        var6_9 = new Object[]{this.$agentId};
                                        v3.setText(AcpBundle.INSTANCE.message("progress.text.downloading.agent", var6_9));
                                    }
                                    v4 = this.$indicator;
                                    if (v4 != null) {
                                        v4.setIndeterminate(false);
                                    }
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                                    this.L$1 = archivePath;
                                    this.I$0 = needsDownload;
                                    this.label = 2;
                                    v5 = AcpBinaryManager.access$downloadArchive(this.this$0, this.$target.getArchive(), this.$downloadDir, this.$indicator, (Continuation)this);
                                    if (v5 == var9_2) {
                                        return var9_2;
                                    }
                                    break block31;
                                }
                                case 2: {
                                    needsDownload = this.I$0;
                                    archivePath = (Path)this.L$1;
                                    fileName = (String)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v5 = $result;
                                    break block31;
                                }
                            }
                            AcpBinaryManagerKt.access$getLogger$p().info("Using cached archive: " + archivePath);
                            v5 = Unit.INSTANCE;
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                        this.L$1 = archivePath;
                        this.I$0 = needsDownload;
                        this.label = 3;
                        v6 = CoroutinesKt.checkCanceled((Continuation)((Continuation)this));
                        if (v6 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl64
                        {
                            case 3: {
                                needsDownload = this.I$0;
                                archivePath = (Path)this.L$1;
                                fileName = (String)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v6 = $result;
lbl64:
                                // 2 sources

                                v7 = this.$indicator;
                                if (v7 != null) {
                                    var6_9 = new Object[]{this.$agentId};
                                    v7.setText(AcpBundle.INSTANCE.message("progress.text.extracting.agent", var6_9));
                                }
                                v8 = this.$indicator;
                                if (v8 != null) {
                                    v8.setIndeterminate(true);
                                }
                                Intrinsics.checkNotNull((Object)archivePath);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                                this.L$1 = archivePath;
                                this.I$0 = needsDownload;
                                this.label = 4;
                                v9 = AcpBinaryManager.access$extractArchive(this.this$0, archivePath, this.$agentDir, this.$target.getCmd(), (Continuation)this);
                                ** if (v9 != var9_2) goto lbl81
lbl80:
                                // 1 sources

                                return var9_2;
lbl81:
                                // 1 sources

                                ** GOTO lbl154
                            }
                            case 4: {
                                needsDownload = this.I$0;
                                archivePath = (Path)this.L$1;
                                fileName = (String)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v9 = $result;
                                    ** GOTO lbl154
                                }
                                catch (Exception e) {
                                    Intrinsics.checkNotNull((Object)archivePath);
                                    v10 = new LinkOption[]{};
                                    fileSize = Files.exists(archivePath, Arrays.copyOf(v10, v10.length)) != false ? Files.size(archivePath) : 0L;
                                    AcpBinaryManagerKt.access$getLogger$p().warn("Extraction failed (archive size: " + fileSize + " bytes), re-downloading: " + e.getMessage());
                                    Files.deleteIfExists(archivePath);
                                    v11 = new LinkOption[]{};
                                    if (Files.exists(this.$agentDir, Arrays.copyOf(v11, v11.length))) {
                                        NioFiles.deleteRecursively((Path)this.$agentDir);
                                        Files.createDirectories(this.$agentDir, new FileAttribute[0]);
                                    }
                                    v12 = this.$indicator;
                                    if (v12 != null) {
                                        var8_15 = new Object[]{this.$agentId};
                                        v12.setText(AcpBundle.INSTANCE.message("progress.text.downloading.agent", var8_15));
                                    }
                                    v13 = this.$indicator;
                                    if (v13 != null) {
                                        v13.setIndeterminate(false);
                                    }
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                                    this.L$1 = archivePath;
                                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                                    this.I$0 = needsDownload;
                                    this.J$0 = fileSize;
                                    this.label = 5;
                                    v14 = AcpBinaryManager.access$downloadArchive(this.this$0, this.$target.getArchive(), this.$downloadDir, this.$indicator, (Continuation)this);
                                    if (v14 == var9_2) {
                                        return var9_2;
                                    }
                                    ** GOTO lbl128
                                }
                            }
                            case 5: {
                                fileSize = this.J$0;
                                needsDownload = this.I$0;
                                e = (Exception)this.L$2;
                                archivePath = (Path)this.L$1;
                                fileName = (String)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v14 = $result;
lbl128:
                                // 2 sources

                                v15 = this.$indicator;
                                if (v15 != null) {
                                    var8_15 = new Object[]{this.$agentId};
                                    v15.setText(AcpBundle.INSTANCE.message("progress.text.extracting.agent", var8_15));
                                }
                                v16 = this.$indicator;
                                if (v16 != null) {
                                    v16.setIndeterminate(true);
                                }
                                Intrinsics.checkNotNull((Object)archivePath);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)archivePath);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                                this.I$0 = needsDownload;
                                this.J$0 = fileSize;
                                this.label = 6;
                                v17 = AcpBinaryManager.access$extractArchive(this.this$0, archivePath, this.$agentDir, this.$target.getCmd(), (Continuation)this);
                                if (v17 == var9_2) {
                                    return var9_2;
                                }
                                ** GOTO lbl154
                            }
                            case 6: {
                                fileSize = this.J$0;
                                needsDownload = this.I$0;
                                e = (Exception)this.L$2;
                                archivePath = (Path)this.L$1;
                                fileName = (String)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v17 = $result;
lbl154:
                                // 4 sources

                                extractedExecutable = AcpBinaryManager.access$resolveExecutablePath(this.this$0, this.$agentDir, this.$target.getCmd());
                                v18 = new LinkOption[]{};
                                if (!Files.exists(extractedExecutable, Arrays.copyOf(v18, v18.length))) ** GOTO lbl189
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)archivePath);
                                this.L$2 = extractedExecutable;
                                this.I$0 = needsDownload;
                                this.label = 7;
                                v19 = AcpBinaryManager.access$makeExecutable(this.this$0, extractedExecutable, (Continuation)this);
                                if (v19 == var9_2) {
                                    return var9_2;
                                }
                                ** GOTO lbl173
                            }
                            case 7: {
                                needsDownload = this.I$0;
                                extractedExecutable = (Path)this.L$2;
                                archivePath = (Path)this.L$1;
                                fileName = (String)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v19 = $result;
lbl173:
                                // 2 sources

                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)archivePath);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)extractedExecutable);
                                this.I$0 = needsDownload;
                                this.label = 8;
                                v20 = AcpBinaryManager.access$removeMacOSQuarantineAttribute(this.this$0, extractedExecutable, (Continuation)this);
                                if (v20 == var9_2) {
                                    return var9_2;
                                }
                                ** GOTO lbl189
                            }
                            case 8: {
                                needsDownload = this.I$0;
                                extractedExecutable = (Path)this.L$2;
                                archivePath = (Path)this.L$1;
                                fileName = (String)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v20 = $result;
lbl189:
                                // 3 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v6 != var20_8) goto lbl88
lbl87:
                // 1 sources

                return var20_8;
lbl88:
                // 1 sources

                ** GOTO lbl113
            }
            case 2: {
                $i$a$-withLock$default-AcpBinaryManager$downloadAndExtract$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                downloadDir = (Path)$continuation.L$8;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$7;
                lock = (Mutex)$continuation.L$6;
                executable = (Path)$continuation.L$5;
                agentDir = (Path)$continuation.L$4;
                indicator = (ProgressIndicator)$continuation.L$3;
                target = (BinaryTarget)$continuation.L$2;
                version = (String)$continuation.L$1;
                agentId = (AcpAgentId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                    ** GOTO lbl113
                    {
                        catch (Throwable $i$f$service) {
                            throw $i$f$service;
                        }
                    }
                    finally {
                        this.setDownloading(agentId, false);
                    }
lbl113:
                    // 2 sources

                    $i$f$service = false;
                    serviceClass$iv = AcpAgentInstallationState.class;
                    v7 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v7 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    ((AcpAgentInstallationState)v7).updateLastUsed(agentId);
                    AcpBinaryManagerKt.access$getLogger$p().info("Successfully installed " + agentId + " v" + version + " to " + agentDir);
                    v4 = agentDir;
lbl121:
                    // 2 sources

                    var16_22 = v4;
                }
                catch (Throwable var17_23) {
                    throw var17_23;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var16_22;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object downloadAndExtract$default(AcpBinaryManager acpBinaryManager, AcpAgentId acpAgentId, String string, BinaryTarget binaryTarget, ProgressIndicator progressIndicator, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            progressIndicator = null;
        }
        return acpBinaryManager.downloadAndExtract(acpAgentId, string, binaryTarget, progressIndicator, (Continuation<? super Path>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object downloadArchive(String url, Path targetDir, ProgressIndicator indicator, Continuation<? super Path> $completion) {
        if (!($completion instanceof downloadArchive.1)) ** GOTO lbl-1000
        var8_5 = $completion;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ AcpBinaryManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AcpBinaryManager.access$downloadArchive(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                fileName = StringsKt.substringAfterLast$default((String)url, (String)"/", null, (int)2, null);
                archivePath = targetDir.resolve(fileName);
                AcpBinaryManagerKt.access$getLogger$p().info("Starting download of " + fileName + " from " + url);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)targetDir);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)indicator);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                $continuation.L$4 = archivePath;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(archivePath, url, indicator, null){
                    int label;
                    final /* synthetic */ Path $archivePath;
                    final /* synthetic */ String $url;
                    final /* synthetic */ ProgressIndicator $indicator;
                    {
                        this.$archivePath = $archivePath;
                        this.$url = $url;
                        this.$indicator = $indicator;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Files.deleteIfExists(this.$archivePath);
                                HttpRequests.request((String)this.$url).userAgent("JetBrains-ACP-Agent-Manager/1.0").saveToFile(this.$archivePath, this.$indicator);
                                long downloadedSize = Files.size(this.$archivePath);
                                AcpBinaryManagerKt.access$getLogger$p().info("Download complete: " + this.$archivePath + " (" + downloadedSize / (long)1024 + " KB)");
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl33
            }
            case 1: {
                archivePath = (Path)$continuation.L$4;
                fileName = (String)$continuation.L$3;
                indicator = (ProgressIndicator)$continuation.L$2;
                targetDir = (Path)$continuation.L$1;
                url = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                Intrinsics.checkNotNull((Object)archivePath);
                return archivePath;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object extractArchive(Path archivePath, Path targetDir, String expectedCmd, Continuation<? super Unit> $completion) {
        String string = PathsKt.getName((Path)archivePath).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String fileName = string;
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(fileName, archivePath, targetDir, expectedCmd, null){
            int label;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Path $archivePath;
            final /* synthetic */ Path $targetDir;
            final /* synthetic */ String $expectedCmd;
            {
                this.$fileName = $fileName;
                this.$archivePath = $archivePath;
                this.$targetDir = $targetDir;
                this.$expectedCmd = $expectedCmd;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object;
                        ResultKt.throwOnFailure((Object)$result);
                        if (StringsKt.endsWith$default((String)this.$fileName, (String)".zip", (boolean)false, (int)2, null)) {
                            AcpBinaryManagerKt.access$getLogger$p().debug("Extracting ZIP: " + this.$archivePath);
                            new Decompressor.Zip(this.$archivePath).extract(this.$targetDir);
                            object = Unit.INSTANCE;
                        } else if (StringsKt.endsWith$default((String)this.$fileName, (String)".tar.gz", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.$fileName, (String)".tgz", (boolean)false, (int)2, null)) {
                            AcpBinaryManagerKt.access$getLogger$p().debug("Extracting TAR.GZ: " + this.$archivePath);
                            new Decompressor.Tar(this.$archivePath).extract(this.$targetDir);
                            object = Unit.INSTANCE;
                        } else if (StringsKt.endsWith$default((String)this.$fileName, (String)".tar.bz2", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.$fileName, (String)".tbz2", (boolean)false, (int)2, null)) {
                            AcpBinaryManagerKt.access$getLogger$p().debug("Extracting TAR.BZ2: " + this.$archivePath);
                            new Decompressor.Tar(this.$archivePath).extract(this.$targetDir);
                            object = Unit.INSTANCE;
                        } else {
                            AcpBinaryManagerKt.access$getLogger$p().debug("Treating as raw binary: " + this.$archivePath + " -> " + this.$expectedCmd);
                            String it = StringsKt.removePrefix((String)this.$expectedCmd, (CharSequence)"./");
                            boolean bl = false;
                            String binaryName = OS.CURRENT == OS.Windows && !StringsKt.endsWith$default((String)it, (String)".exe", (boolean)false, (int)2, null) ? it + ".exe" : it;
                            Path targetPath = this.$targetDir.resolve(binaryName);
                            Files.deleteIfExists(targetPath);
                            object = Files.copy(this.$archivePath, targetPath, new CopyOption[0]);
                        }
                        return object;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Path resolveExecutablePath(Path baseDir, String cmd) {
        String cleanCmd = StringsKt.removePrefix((String)cmd, (CharSequence)"./");
        Path path = baseDir.resolve(cleanCmd);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Object makeExecutable(Path path, Continuation<? super Unit> $completion) {
        if (OS.CURRENT == OS.Windows) {
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(path, null){
            int label;
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object;
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            Set<PosixFilePermission> set = Files.getPosixFilePermissions(this.$path, new LinkOption[0]);
                            Intrinsics.checkNotNullExpressionValue(set, (String)"getPosixFilePermissions(...)");
                            Set permissions = CollectionsKt.toMutableSet((Iterable)set);
                            PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE};
                            permissions.addAll(SetsKt.setOf((Object[])posixFilePermissionArray));
                            object = Files.setPosixFilePermissions(this.$path, permissions);
                        }
                        catch (Exception e) {
                            AcpBinaryManagerKt.access$getLogger$p().warn("Failed to set executable permissions on " + this.$path, (Throwable)e);
                            object = Unit.INSTANCE;
                        }
                        return object;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object removeMacOSQuarantineAttribute(Path path, Continuation<? super Unit> $completion) {
        if (OS.CURRENT != OS.macOS) {
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path, null){
            int label;
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            String[] stringArray = new String[]{"xattr", "-d", "com.apple.quarantine", ((Object)this.$path).toString()};
                            GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
                            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
                            if (output.getExitCode() != 0) {
                                AcpBinaryManagerKt.access$getLogger$p().debug("Could not remove quarantine attribute for " + this.$path + " (may not exist): " + output.getStderr());
                            }
                        }
                        catch (Exception e) {
                            AcpBinaryManagerKt.access$getLogger$p().debug("Failed to remove quarantine attribute for " + this.$path, (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object deleteCachedAgent(@NotNull AcpAgentId agentId, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(agentId, null){
            int label;
            final /* synthetic */ AcpAgentId $agentId;
            {
                this.$agentId = $agentId;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        boolean $i$f$service = false;
                        Class<AcpPaths> serviceClass$iv = AcpPaths.class;
                        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        Path agentBaseDir = ((AcpPaths)object).getAgentDir(this.$agentId);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(agentBaseDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            try {
                                NioFiles.deleteRecursively((Path)agentBaseDir);
                                AcpBinaryManagerKt.access$getLogger$p().info("Deleted cached agent binaries: " + this.$agentId);
                            }
                            catch (Exception e) {
                                AcpBinaryManagerKt.access$getLogger$p().warn("Failed to delete cached agent binaries: " + this.$agentId, (Throwable)e);
                            }
                        }
                        boolean $i$f$service2 = false;
                        Class<AcpPaths> serviceClass$iv2 = AcpPaths.class;
                        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
                        if (object2 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        Path downloadsDir = ((AcpPaths)object2).getDownloadsDir().resolve(this.$agentId.getRawId());
                        Intrinsics.checkNotNull((Object)downloadsDir);
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        if (Files.exists(downloadsDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                            try {
                                NioFiles.deleteRecursively((Path)downloadsDir);
                                AcpBinaryManagerKt.access$getLogger$p().info("Deleted cached agent downloads: " + this.$agentId);
                            }
                            catch (Exception e) {
                                AcpBinaryManagerKt.access$getLogger$p().warn("Failed to delete cached agent downloads: " + this.$agentId, (Throwable)e);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Mutex downloadAndExtract$lambda$0(AcpAgentId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    private static final Mutex downloadAndExtract$lambda$1(Function1 $tmp0, Object p0) {
        return (Mutex)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setDownloading(AcpBinaryManager $this, AcpAgentId agentId, boolean downloading) {
        $this.setDownloading(agentId, downloading);
    }

    public static final /* synthetic */ Object access$downloadArchive(AcpBinaryManager $this, String url, Path targetDir, ProgressIndicator indicator, Continuation $completion) {
        return $this.downloadArchive(url, targetDir, indicator, (Continuation<? super Path>)$completion);
    }

    public static final /* synthetic */ Object access$extractArchive(AcpBinaryManager $this, Path archivePath, Path targetDir, String expectedCmd, Continuation $completion) {
        return $this.extractArchive(archivePath, targetDir, expectedCmd, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$makeExecutable(AcpBinaryManager $this, Path path, Continuation $completion) {
        return $this.makeExecutable(path, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$removeMacOSQuarantineAttribute(AcpBinaryManager $this, Path path, Continuation $completion) {
        return $this.removeMacOSQuarantineAttribute(path, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Path access$resolveExecutablePath(AcpBinaryManager $this, Path baseDir, String cmd) {
        return $this.resolveExecutablePath(baseDir, cmd);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpBinaryManager$Companion;", "", "<init>", "()V", "LAZY_BINARY_PREFIX", "", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

