/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.ml.llm.agents.acp.config.AcpAgentStartConfig;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpDistributionResolverKt;
import com.intellij.ml.llm.agents.acp.registry.BinaryTarget;
import com.intellij.ml.llm.agents.acp.registry.Distribution;
import com.intellij.ml.llm.agents.acp.registry.ExternalAgent;
import com.intellij.ml.llm.agents.acp.registry.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver;", "", "<init>", "()V", "resolve", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution;", "agent", "Lcom/intellij/ml/llm/agents/acp/registry/ExternalAgent;", "toAgentStartConfig", "Lcom/intellij/ml/llm/agents/acp/config/AcpAgentStartConfig;", "resolved", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution$Package;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution$Binary;", "extractedPath", "", "ResolvedDistribution", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpDistributionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpDistributionResolver.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1563#2:171\n1634#2,3:172\n*S KotlinDebug\n*F\n+ 1 AcpDistributionResolver.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver\n*L\n152#1:171\n152#1:172,3\n*E\n"})
public final class AcpDistributionResolver {
    @NotNull
    public static final AcpDistributionResolver INSTANCE = new AcpDistributionResolver();

    private AcpDistributionResolver() {
    }

    @NotNull
    public final ResolvedDistribution resolve(@NotNull ExternalAgent agent2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
        Distribution distribution = agent2.getDistribution();
        String platform = Platform.INSTANCE.current();
        Map<String, BinaryTarget> map2 = distribution.getBinary();
        if (map2 != null && (map2 = map2.get(platform)) != null) {
            boolean isLocalCommand;
            Map<String, BinaryTarget> target = map2;
            boolean bl = false;
            String cmd = ((BinaryTarget)((Object)target)).getCmd();
            boolean bl2 = isLocalCommand = StringsKt.startsWith$default((String)cmd, (String)"./", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)cmd, (String)"/", (boolean)false, (int)2, null);
            if (isLocalCommand) {
                AcpDistributionResolverKt.access$getLogger$p().info("Selected binary distribution for " + agent2.getId() + " on " + platform);
                return new ResolvedDistribution.Binary(agent2.getId(), agent2.getVersion(), (BinaryTarget)((Object)target));
            }
            AcpDistributionResolverKt.access$getLogger$p().info("Binary distribution for " + agent2.getId() + " uses '" + cmd + "' which is not a local executable, trying alternatives");
        }
        if (distribution.getNpx() != null) {
            AcpDistributionResolverKt.access$getLogger$p().info("Selected npx distribution for " + agent2.getId());
            return new ResolvedDistribution.Package("npx", distribution.getNpx().getPackageName(), distribution.getNpx().getArgs(), distribution.getNpx().getEnv());
        }
        if (distribution.getUvx() != null) {
            AcpDistributionResolverKt.access$getLogger$p().info("Selected uvx distribution for " + agent2.getId());
            return new ResolvedDistribution.Package("uvx", distribution.getUvx().getPackageName(), distribution.getUvx().getArgs(), distribution.getUvx().getEnv());
        }
        List $this$resolve_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (distribution.getBinary() != null) {
            BinaryTarget target = distribution.getBinary().get(platform);
            boolean bl3 = target != null ? $this$resolve_u24lambda_u241.add("binary uses '" + target.getCmd() + "' which is not a local executable") : $this$resolve_u24lambda_u241.add("binary not available for " + platform + " (available: " + CollectionsKt.joinToString$default((Iterable)distribution.getBinary().keySet(), null, null, null, (int)0, null, null, (int)63, null) + ")");
        }
        List reasons = CollectionsKt.build((List)list);
        String reason = reasons.isEmpty() ? "no distribution methods defined" : CollectionsKt.joinToString$default((Iterable)reasons, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
        AcpDistributionResolverKt.access$getLogger$p().warn("No suitable distribution for " + agent2.getId() + ": " + reason);
        return new ResolvedDistribution.Unavailable(reason);
    }

    @NotNull
    public final AcpAgentStartConfig toAgentStartConfig(@NotNull ResolvedDistribution.Package resolved) {
        List list;
        Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
        if (Intrinsics.areEqual((Object)resolved.getRunner(), (Object)"npx")) {
            Object[] objectArray = new String[]{"-y", resolved.getPackageName()};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)resolved.getPackageName());
        }
        List args = list;
        return new AcpAgentStartConfig(resolved.getRunner(), args, resolved.getArgs(), resolved.getEnv(), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AcpAgentStartConfig toAgentStartConfig(@NotNull ResolvedDistribution.Binary resolved, @NotNull String extractedPath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
        Intrinsics.checkNotNullParameter((Object)extractedPath, (String)"extractedPath");
        String cmd = resolved.getTarget().getCmd();
        String command = StringsKt.startsWith$default((String)cmd, (String)"./", (boolean)false, (int)2, null) ? extractedPath + "/" + StringsKt.removePrefix((String)cmd, (CharSequence)"./") : cmd;
        Iterable $this$map$iv = resolved.getTarget().getArgs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void arg;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.startsWith$default((String)arg, (String)"./", (boolean)false, (int)2, null) ? extractedPath + "/" + StringsKt.removePrefix((String)arg, (CharSequence)"./") : arg);
        }
        List resolvedArgs = (List)destination$iv$iv;
        return new AcpAgentStartConfig(command, CollectionsKt.emptyList(), resolvedArgs, resolved.getTarget().getEnv(), null, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution;", "", "<init>", "()V", "Binary", "Package", "Unavailable", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution$Binary;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution$Package;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution$Unavailable;", "intellij.ml.llm.agents.acp"})
    public static abstract sealed class ResolvedDistribution {
        private ResolvedDistribution() {
        }

        public /* synthetic */ ResolvedDistribution(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution$Binary;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution;", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "version", "", "target", "Lcom/intellij/ml/llm/agents/acp/registry/BinaryTarget;", "<init>", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Ljava/lang/String;Lcom/intellij/ml/llm/agents/acp/registry/BinaryTarget;)V", "getAgentId", "()Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "getVersion", "()Ljava/lang/String;", "getTarget", "()Lcom/intellij/ml/llm/agents/acp/registry/BinaryTarget;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
        public static final class Binary
        extends ResolvedDistribution {
            @NotNull
            private final AcpAgentId agentId;
            @NotNull
            private final String version;
            @NotNull
            private final BinaryTarget target;

            public Binary(@NotNull AcpAgentId agentId, @NotNull String version, @NotNull BinaryTarget target) {
                Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(null);
                this.agentId = agentId;
                this.version = version;
                this.target = target;
            }

            @NotNull
            public final AcpAgentId getAgentId() {
                return this.agentId;
            }

            @NotNull
            public final String getVersion() {
                return this.version;
            }

            @NotNull
            public final BinaryTarget getTarget() {
                return this.target;
            }

            @NotNull
            public final AcpAgentId component1() {
                return this.agentId;
            }

            @NotNull
            public final String component2() {
                return this.version;
            }

            @NotNull
            public final BinaryTarget component3() {
                return this.target;
            }

            @NotNull
            public final Binary copy(@NotNull AcpAgentId agentId, @NotNull String version, @NotNull BinaryTarget target) {
                Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return new Binary(agentId, version, target);
            }

            public static /* synthetic */ Binary copy$default(Binary binary, AcpAgentId acpAgentId, String string, BinaryTarget binaryTarget, int n, Object object) {
                if ((n & 1) != 0) {
                    acpAgentId = binary.agentId;
                }
                if ((n & 2) != 0) {
                    string = binary.version;
                }
                if ((n & 4) != 0) {
                    binaryTarget = binary.target;
                }
                return binary.copy(acpAgentId, string, binaryTarget);
            }

            @NotNull
            public String toString() {
                return "Binary(agentId=" + this.agentId + ", version=" + this.version + ", target=" + this.target + ")";
            }

            public int hashCode() {
                int result2 = this.agentId.hashCode();
                result2 = result2 * 31 + this.version.hashCode();
                result2 = result2 * 31 + this.target.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Binary)) {
                    return false;
                }
                Binary binary = (Binary)other;
                if (!Intrinsics.areEqual((Object)this.agentId, (Object)binary.agentId)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.version, (Object)binary.version)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.target, (Object)binary.target);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003JC\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution$Package;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution;", "runner", "", "packageName", "args", "", "env", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;)V", "getRunner", "()Ljava/lang/String;", "getPackageName", "getArgs", "()Ljava/util/List;", "getEnv", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
        public static final class Package
        extends ResolvedDistribution {
            @NotNull
            private final String runner;
            @NotNull
            private final String packageName;
            @NotNull
            private final List<String> args;
            @NotNull
            private final Map<String, String> env;

            public Package(@NotNull String runner, @NotNull String packageName2, @NotNull List<String> args, @NotNull Map<String, String> env) {
                Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
                Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Intrinsics.checkNotNullParameter(env, (String)"env");
                super(null);
                this.runner = runner;
                this.packageName = packageName2;
                this.args = args;
                this.env = env;
            }

            @NotNull
            public final String getRunner() {
                return this.runner;
            }

            @NotNull
            public final String getPackageName() {
                return this.packageName;
            }

            @NotNull
            public final List<String> getArgs() {
                return this.args;
            }

            @NotNull
            public final Map<String, String> getEnv() {
                return this.env;
            }

            @NotNull
            public final String component1() {
                return this.runner;
            }

            @NotNull
            public final String component2() {
                return this.packageName;
            }

            @NotNull
            public final List<String> component3() {
                return this.args;
            }

            @NotNull
            public final Map<String, String> component4() {
                return this.env;
            }

            @NotNull
            public final Package copy(@NotNull String runner, @NotNull String packageName2, @NotNull List<String> args, @NotNull Map<String, String> env) {
                Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
                Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Intrinsics.checkNotNullParameter(env, (String)"env");
                return new Package(runner, packageName2, args, env);
            }

            public static /* synthetic */ Package copy$default(Package package_, String string, String string2, List list, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = package_.runner;
                }
                if ((n & 2) != 0) {
                    string2 = package_.packageName;
                }
                if ((n & 4) != 0) {
                    list = package_.args;
                }
                if ((n & 8) != 0) {
                    map2 = package_.env;
                }
                return package_.copy(string, string2, list, map2);
            }

            @NotNull
            public String toString() {
                return "Package(runner=" + this.runner + ", packageName=" + this.packageName + ", args=" + this.args + ", env=" + this.env + ")";
            }

            public int hashCode() {
                int result2 = this.runner.hashCode();
                result2 = result2 * 31 + this.packageName.hashCode();
                result2 = result2 * 31 + ((Object)this.args).hashCode();
                result2 = result2 * 31 + ((Object)this.env).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Package)) {
                    return false;
                }
                Package package_ = (Package)other;
                if (!Intrinsics.areEqual((Object)this.runner, (Object)package_.runner)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.packageName, (Object)package_.packageName)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.args, package_.args)) {
                    return false;
                }
                return Intrinsics.areEqual(this.env, package_.env);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution$Unavailable;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpDistributionResolver$ResolvedDistribution;", "reason", "", "<init>", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
        public static final class Unavailable
        extends ResolvedDistribution {
            @NotNull
            private final String reason;

            public Unavailable(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final Unavailable copy(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                return new Unavailable(reason);
            }

            public static /* synthetic */ Unavailable copy$default(Unavailable unavailable, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unavailable.reason;
                }
                return unavailable.copy(string);
            }

            @NotNull
            public String toString() {
                return "Unavailable(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unavailable)) {
                    return false;
                }
                Unavailable unavailable = (Unavailable)other;
                return Intrinsics.areEqual((Object)this.reason, (Object)unavailable.reason);
            }
        }
    }
}

